/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectID;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.MissingProviderException;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

public abstract class BaseObjectID
extends AbstractDBObjectID {
    private String m_dbName;
    private String m_schemaName;
    private String m_name;
    private transient AbstractDBObjectProvider m_pro;
    private transient String m_toString;
    private static Map<String, Class> ID_TYPE_MAP = new HashMap<String, Class>();
    private static Map<String, Class> ID_LEGACY_TYPE_MAP;
    public static final String SEP = ":";
    private static final String AT = "@";

    protected BaseObjectID() {
    }

    protected BaseObjectID(String type, DBObjectID parent) {
        super(type, parent);
    }

    protected BaseObjectID(String type, AbstractDBObjectProvider provider) {
        super(type);
        this.m_pro = provider;
    }

    protected BaseObjectID(DBObject obj, DBObjectID parent) {
        this(obj, null, parent);
    }

    protected BaseObjectID(DBObject obj, AbstractDBObjectProvider provider) {
        this(obj, provider, null);
    }

    private BaseObjectID(DBObject obj, AbstractDBObjectProvider provider, DBObjectID parent) {
        super(obj.getType());
        DBObject objPar;
        this.setName(obj.getName());
        this.setProviderImpl(provider);
        Schema s = DBUtil.getSchema(obj);
        this.setSchemaName(s == null ? null : s.getName());
        if (parent == null && (objPar = obj.getParent()) != null) {
            parent = objPar.getID();
        }
        this.setParent(parent);
    }

    protected void copyToImpl(BaseObjectID target) {
        super.copyToImpl(target);
        target.m_dbName = this.m_dbName;
        target.m_schemaName = this.m_schemaName;
        target.m_name = this.m_name;
        target.m_pro = this.m_pro;
    }

    @Override
    public final synchronized String toString() {
        if (this.m_toString == null) {
            String prefix = BaseObjectID.getPrefix(this.getClass());
            StringBuilder builder = new StringBuilder();
            if (ModelUtil.hasLength((String)prefix)) {
                builder.append(prefix).append(SEP);
            }
            if (ModelUtil.hasLength((String)this.m_dbName)) {
                builder.append(this.m_dbName).append(AT);
            }
            builder.append(this.toStringImpl());
            this.m_toString = builder.toString();
        }
        return this.m_toString;
    }

    protected abstract String toStringImpl();

    public abstract void construct(String var1);

    protected synchronized void clearToString() {
        this.m_toString = null;
    }

    @Override
    public DBObject resolveID() throws DBException {
        DBObject retval = null;
        DBObjectID parentID = this.getParent();
        retval = parentID != null ? this.resolveFromParent() : this.resolveFromProvider();
        return retval;
    }

    @Override
    public DBObject resolveInParentObject(DBObject parent) throws DBException {
        DBObject retval;
        if (parent instanceof Schema) {
            BaseObjectID copy = (BaseObjectID)this.copyTo(null);
            copy.setParent(null);
            copy.setSchemaName(parent.getName());
            retval = copy.resolveID();
        } else {
            retval = super.resolveInParentObject(parent);
        }
        return retval;
    }

    protected final DBObject resolveFromProvider() throws DBException {
        if (this.m_pro == null) {
            throw new MissingProviderException();
        }
        return this.m_pro.resolveID(this);
    }

    @Internal
    public final DBObjectProvider getProvider() {
        DBObjectID par;
        if (this.m_pro == null && (par = this.getParent()) instanceof BaseObjectID) {
            return ((BaseObjectID)par).m_pro;
        }
        return this.m_pro;
    }

    public final void setProvider(DBObjectProvider pro) {
        if (pro instanceof AbstractDBObjectProvider) {
            if (this.m_pro != null && this.m_pro != pro) {
                this.getLogger().log(Level.WARNING, "changing the provider of id {0} from {1} to {2}", new Object[]{this.toString(), this.m_pro.getName(), pro == null ? "null" : ((AbstractDBObjectProvider)pro).getName()});
            }
            this.setProviderImpl((AbstractDBObjectProvider)pro);
        }
    }

    protected void setProviderImpl(AbstractDBObjectProvider pro) {
        this.m_pro = pro;
        DBObjectID par = this.getParent();
        if (par instanceof BaseObjectID) {
            ((BaseObjectID)par).setProviderImpl(pro);
        }
    }

    protected boolean hasSameProvider(BaseObjectID other) {
        return other.getProvider() == this.getProvider();
    }

    @Override
    public final void setParent(DBObjectID parent) {
        AbstractDBObjectProvider otherPro;
        super.setParent(parent);
        if (parent instanceof BaseObjectID && (otherPro = ((BaseObjectID)parent).m_pro) != null) {
            if (this.m_pro != null && otherPro != this.m_pro) {
                throw new IllegalStateException("Parent ID is from a different DBObjectProvider.");
            }
            this.m_pro = otherPro;
        }
    }

    public final String getSchemaName() {
        return this.m_schemaName;
    }

    public final void setSchemaName(String name) {
        this.m_schemaName = name;
        this.clearToString();
    }

    public final void setSchema(Schema schema) {
        this.m_schemaName = schema == null ? null : schema.getName();
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setName(String name) {
        this.m_name = ModelUtil.hasLength((String)name) ? name : null;
        this.clearToString();
    }

    public final String getDatabaseName() {
        return this.m_dbName;
    }

    public final void setDatabaseName(String linkName) {
        this.m_dbName = linkName;
        this.clearToString();
    }

    protected boolean equalsImpl(BaseObjectID target) {
        boolean same;
        boolean bl = same = super.equalsImpl(target) && ModelUtil.areEqual((Object)this.m_name, (Object)target.m_name);
        if (same && this.getParent() == null && target.getParent() == null) {
            same = ModelUtil.areEqual((Object)this.m_schemaName, (Object)target.m_schemaName) && ModelUtil.areEqual((Object)this.m_dbName, (Object)target.m_dbName);
        }
        return same;
    }

    private DBObject resolveIDWithoutType(String schemaName) throws DBException {
        SystemObject retval = null;
        String name = this.getName();
        DBObjectProvider pro = this.getProvider();
        String dbName = this.getDatabaseName();
        if (pro != null && ModelUtil.hasLength((String)schemaName) && ModelUtil.hasLength((String)name)) {
            String type;
            DBObjectCriteria<SystemObject> crit;
            String[] types = pro.listObjectTypes();
            Arrays.sort(types, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    String s1 = "1";
                    String s2 = "1";
                    if ("TABLE".equals(o1)) {
                        s1 = "0";
                    } else if (!Metadata.getInstance().isSchemaObject(o1)) {
                        s1 = "2";
                    }
                    if ("TABLE".equals(o2)) {
                        s2 = "0";
                    } else if (!Metadata.getInstance().isSchemaObject(o2)) {
                        s2 = "2";
                    }
                    return (s1 + o1).compareTo(s2 + o2);
                }
            });
            String[] stringArray = types;
            int n = stringArray.length;
            for (int i = 0; i < n && (retval = pro.getObject(crit = DBObjectCriteria.createSingleObjectCriteria(type = stringArray[i], dbName, schemaName, name))) == null; ++i) {
            }
            if (retval == null && name.indexOf("(") > -1) {
                DBObjectCriteria<SystemObject> crit2;
                String baseName = name.substring(0, name.indexOf("("));
                for (int i = 0; i < types.length && retval == null && (!types[i].equals("PROCEDURE") && !types[i].equals("FUNCTION") || (retval = pro.getObject(crit2 = DBObjectCriteria.createSingleObjectCriteria(types[i], dbName, schemaName, baseName))) == null); ++i) {
                }
            }
        }
        return retval;
    }

    protected boolean hasSameObjectName(BaseObjectID target) {
        if (this.m_name == null || target.m_name == null) {
            return false;
        }
        return this.equalsImpl(target);
    }

    private static final String getPrefix(Class clazz) {
        String prefix = "";
        if (ID_TYPE_MAP.containsValue(clazz)) {
            for (String idType : ID_TYPE_MAP.keySet()) {
                if (!ID_TYPE_MAP.get(idType).equals(clazz)) continue;
                prefix = idType;
                break;
            }
        } else if (clazz.getSuperclass() != null) {
            prefix = BaseObjectID.getPrefix(clazz.getSuperclass());
        }
        return prefix;
    }

    public static <T extends BaseObjectID> T copyWithNewProvider(T id, AbstractDBObjectProvider pro) {
        BaseObjectID copy = (BaseObjectID)id.copyTo(null);
        copy.setProviderImpl(pro);
        return (T)copy;
    }

    public static BaseObjectID createFromString(String idString) {
        String payload;
        BaseObjectID id = null;
        if (idString == null || idString.indexOf(SEP) == -1) {
            return null;
        }
        if (BaseObjectID.isRecognizedType(idString)) {
            String idType = idString.substring(0, idString.indexOf(SEP));
            Class idClass = ID_TYPE_MAP.get(idType);
            if (idClass == null) {
                idClass = ID_LEGACY_TYPE_MAP.get(idType);
            }
            if (idClass != null) {
                try {
                    id = (BaseObjectID)idClass.newInstance();
                }
                catch (Exception e) {
                    DBLog.logStackTrace(e);
                }
            } else {
                DBLog.getLogger(BaseObjectID.class).warning("Cannot instantiate ID");
            }
        }
        if (id == null) {
            id = new IdentifierBasedID();
        }
        if (BaseObjectID.isRecognizedType(idString)) {
            int sep1Pos = idString.indexOf(SEP);
            int sep2Pos = idString.indexOf(SEP, sep1Pos + SEP.length());
            int at1Pos = idString.indexOf(AT);
            if (sep1Pos > 0 && at1Pos > sep1Pos && sep2Pos > at1Pos) {
                String dbName = idString.substring(sep1Pos + SEP.length(), at1Pos - 1);
                id.setDatabaseName(dbName);
                payload = idString.substring(at1Pos + AT.length());
            } else {
                payload = idString.substring(sep1Pos + SEP.length());
            }
        } else {
            payload = idString;
        }
        id.construct(payload);
        return id;
    }

    public static final boolean isRecognizedType(String id) {
        return BaseObjectID.isInTypeMap(ID_TYPE_MAP, id) || BaseObjectID.isInTypeMap(ID_LEGACY_TYPE_MAP, id);
    }

    private static final boolean isInTypeMap(Map<String, Class> map, String id) {
        if (!ModelUtil.hasLength((String)id)) {
            return false;
        }
        int sepIndex = id.indexOf(SEP);
        if (sepIndex < 1) {
            return false;
        }
        String startsWith = id.substring(0, sepIndex);
        return map.containsKey(startsWith);
    }

    static {
        ID_TYPE_MAP.put("N", NameBasedID.class);
        ID_TYPE_MAP.put("I", IdentifierBasedID.class);
        ID_TYPE_MAP.put("R", ReferenceID.class);
        ID_LEGACY_TYPE_MAP = new HashMap<String, Class>();
        ID_LEGACY_TYPE_MAP.put("S", IdentifierBasedID.class);
    }
}

