/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.math.BigInteger;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.property.NumberProperty;

public class AutoExtendProperties
extends AbstractChildDBObject {
    public static final String TYPE = "AutoExtendProperties";

    public AutoExtendProperties() {
        this((BigInteger)null, (BigInteger)null);
    }

    public AutoExtendProperties(BigInteger nextSize, BigInteger maxSize) {
        this.setAutoExtendOn(true);
        this.setNextSize(nextSize);
        this.setMaxSize(maxSize);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setAutoExtendOn(boolean autoExtendOn) {
        this.setProperty("autoExtendOn", autoExtendOn);
    }

    public boolean isAutoExtendOn() {
        return (Boolean)this.getProperty("autoExtendOn", true);
    }

    public void setNextSize(BigInteger nextSize) {
        this.setProperty("nextSize", nextSize);
    }

    @NumberProperty(physicalSize=true)
    public BigInteger getNextSize() {
        return (BigInteger)this.getProperty("nextSize");
    }

    public void setMaxSize(BigInteger maxSize) {
        this.setProperty("maxSize", maxSize);
    }

    @NumberProperty(physicalSize=true, unlimited=true)
    public BigInteger getMaxSize() {
        return (BigInteger)this.getProperty("maxSize");
    }
}

