/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.vm;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import oracle.aurora.vm.CachedLocales;
import oracle.aurora.vm.EnvironmentSpecific;
import oracle.aurora.vm.HotLoader;

public final class CachedLocaleData
implements CachedLocales {
    private String name;
    private CLDSharedID sharedID;
    private static Locale cachedLocale;
    private static CLDSharedID cachedSharedID;
    private static Hashtable cachedLocaleObjects;
    private static Hashtable cachedLocaleHashtables;
    private static Hashtable allSharedIDs;

    public CachedLocaleData() {
        Class cl = CachedLocaleData.getCallerClass();
        this.name = cl.getName();
        int ownerID = EnvironmentSpecific.ownerID(cl);
        this.sharedID = new CLDSharedID(ownerID).intern(allSharedIDs);
    }

    public CachedLocaleData(String prefix) {
        Class cl = CachedLocaleData.getCallerClass();
        this.name = cl.getName();
        int ownerID = EnvironmentSpecific.ownerID(cl);
        this.sharedID = new CLDSharedID(ownerID, prefix).intern(allSharedIDs);
    }

    public CachedLocaleData(String prefix, String name) {
        Class cl = CachedLocaleData.getCallerClass();
        this.name = name;
        int ownerID = EnvironmentSpecific.ownerID(cl);
        this.sharedID = new CLDSharedID(ownerID, prefix).intern(allSharedIDs);
    }

    private Hashtable getLocaleHashtable(Locale loc, boolean create) {
        Hashtable hash = this.sharedID.getRoot(loc, create, cachedLocaleHashtables);
        if (hash != null) {
            cachedLocale = loc;
            cachedSharedID = this.sharedID;
            cachedLocaleObjects = hash;
        }
        return hash;
    }

    public Object get(Locale loc) {
        Hashtable hash = !(loc != cachedLocale && !loc.equals(cachedLocale) || this.sharedID != cachedSharedID && !this.sharedID.fastEquals(cachedSharedID)) ? cachedLocaleObjects : this.getLocaleHashtable(loc, false);
        return hash == null ? null : hash.get(this.name);
    }

    public Object put(Locale loc, Object obj) {
        Hashtable hash = !(loc != cachedLocale && !loc.equals(cachedLocale) || this.sharedID != cachedSharedID && !this.sharedID.fastEquals(cachedSharedID)) ? cachedLocaleObjects : this.getLocaleHashtable(loc, true);
        return hash.put(this.name, obj);
    }

    private static void clearCache() {
        cachedLocale = null;
        cachedSharedID = null;
        cachedLocaleObjects = null;
    }

    public static boolean saveAll(Locale loc) {
        boolean success = true;
        Enumeration keys = allSharedIDs.keys();
        while (keys.hasMoreElements()) {
            CLDSharedID key = (CLDSharedID)keys.nextElement();
            if (key.save(loc, cachedLocaleHashtables)) continue;
            success = false;
        }
        CachedLocaleData.clearCache();
        return success;
    }

    public static boolean removeAll(Locale loc) {
        boolean success = true;
        Enumeration keys = allSharedIDs.keys();
        while (keys.hasMoreElements()) {
            CLDSharedID key = (CLDSharedID)keys.nextElement();
            if (key.remove(loc, cachedLocaleHashtables)) continue;
            success = false;
        }
        CachedLocaleData.clearCache();
        return success;
    }

    static native Class getCallerClass();

    static {
        cachedLocaleHashtables = new Hashtable(3);
        allSharedIDs = new Hashtable();
    }

    private static class CLDSharedID {
        String prefix;
        int ownerID;

        CLDSharedID(int ownerID, String prefix) {
            this.ownerID = ownerID;
            this.prefix = prefix;
        }

        CLDSharedID(int ownerID) {
            this.ownerID = ownerID;
        }

        public int hashCode() {
            return this.prefix == null ? this.ownerID : this.prefix.hashCode() ^ this.ownerID;
        }

        public boolean fastEquals(CLDSharedID obj) {
            if (this == obj) {
                return true;
            }
            if (this.ownerID != obj.ownerID) {
                return false;
            }
            if (this.prefix == null && obj.prefix == null) {
                return true;
            }
            if (this.prefix == null || obj.prefix == null) {
                return false;
            }
            return this.prefix.equals(obj.prefix);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CLDSharedID)) {
                return false;
            }
            return this.fastEquals((CLDSharedID)obj);
        }

        public CLDSharedID intern(Hashtable tab) {
            CLDSharedID entry = (CLDSharedID)tab.get(this);
            if (entry != null) {
                return entry;
            }
            tab.put(this, this);
            return this;
        }

        public Hashtable getRoot(Locale loc, boolean create, Hashtable cache) {
            return new CLDKey(this, loc).getRoot(create, cache);
        }

        public boolean save(Locale loc, Hashtable cache) {
            return new CLDKey(this, loc).save(cache);
        }

        public boolean remove(Locale loc, Hashtable cache) {
            return new CLDKey(this, loc).remove(cache);
        }

        private static class CLDKey {
            CLDSharedID sharedID;
            Locale loc;

            CLDKey(CLDSharedID sharedID, Locale loc) {
                this.sharedID = sharedID;
                this.loc = loc;
            }

            public int hashCode() {
                return this.sharedID.hashCode() ^ this.loc.hashCode();
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof CLDKey)) {
                    return false;
                }
                CLDKey other = (CLDKey)obj;
                if (!this.sharedID.fastEquals(other.sharedID)) {
                    return false;
                }
                return this.loc.equals(other.loc);
            }

            private String sharedDataName(Locale loc) {
                String prefix = this.sharedID.prefix == null ? "" : this.sharedID.prefix + "_";
                return "LocaleData_" + prefix + loc.toString();
            }

            public Hashtable getRoot(boolean create, Hashtable cache) {
                Hashtable hash = (Hashtable)cache.get(this);
                if (hash == null) {
                    if (!HotLoader.isIniting()) {
                        hash = EnvironmentSpecific.CLDKeyGetRoot(this.sharedDataName(this.loc), this.sharedID.ownerID);
                    }
                    if (hash == null && create) {
                        hash = new Hashtable(7);
                    }
                    if (hash != null) {
                        cache.put(this, hash);
                    }
                }
                return hash;
            }

            public boolean save(Hashtable cache) {
                boolean success = false;
                Hashtable hash = (Hashtable)cache.get(this);
                if (hash != null && (success = EnvironmentSpecific.CLDKeySave(this.sharedDataName(this.loc), this.sharedID.ownerID, hash))) {
                    cache.remove(this);
                }
                return success;
            }

            public boolean remove(Hashtable cache) {
                boolean success = EnvironmentSpecific.CLDKeyRemove(this.sharedDataName(this.loc), this.sharedID.ownerID);
                if (success) {
                    cache.remove(this.loc);
                }
                return success;
            }
        }
    }
}

