/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.classfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import oracle.aurora.util.IOCopy;
import oracle.aurora.util.tools.ToolError;
import oracle.aurora.util.tools.ToolException;

public class Raw {
    public static void dump(InputStream in, PrintStream pout, OutputStream bout) {
        block6: {
            try {
                Raw r = new Raw();
                DataInputStream din = new DataInputStream(in);
                Class cl = new Class(din);
                if (pout != null) {
                    cl.output(pout);
                }
                if (bout != null) {
                    DataOutputStream dout = new DataOutputStream(bout);
                    cl.output(dout);
                    dout.flush();
                }
            }
            catch (IOException ex) {
                if (pout != null) {
                    ex.printStackTrace(pout);
                }
            }
            catch (ToolException ex) {
                if (pout == null) break block6;
                ex.printStackTrace(pout);
            }
        }
    }

    public static void main(String[] argv) {
        try {
            File inArg = new File(argv[0]);
            FileInputStream fin = new FileInputStream(inArg);
            FileOutputStream fout = null;
            if (argv.length > 1) {
                fout = new FileOutputStream(new File(argv[1]));
            }
            Raw.dump(fin, System.out, fout);
            fin.close();
            if (fout != null) {
                fout.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static interface JavaConstants {
        public static final int CONSTANT_ERROR = 0;
        public static final int CONSTANT_UTF8 = 1;
        public static final int CONSTANT_INTEGER = 3;
        public static final int CONSTANT_FLOAT = 4;
        public static final int CONSTANT_LONG = 5;
        public static final int CONSTANT_DOUBLE = 6;
        public static final int CONSTANT_CLASS = 7;
        public static final int CONSTANT_STRING = 8;
        public static final int CONSTANT_FIELD = 9;
        public static final int CONSTANT_METHOD = 10;
        public static final int CONSTANT_INTERFACEMETHOD = 11;
        public static final int CONSTANT_NAMEANDTYPE = 12;
        public static final int ACC_PUBLIC = 1;
        public static final int ACC_PRIVATE = 2;
        public static final int ACC_PROTECTED = 4;
        public static final int ACC_STATIC = 8;
        public static final int ACC_FINAL = 16;
        public static final int ACC_SYNCHRONIZED = 32;
        public static final int ACC_SUPER = 32;
        public static final int ACC_VOLATILE = 64;
        public static final int ACC_TRANSIENT = 128;
        public static final int ACC_NATIVE = 256;
        public static final int ACC_INTERFACE = 512;
        public static final int ACC_ABSTRACT = 1024;
        public static final int M_PUBLIC = 1;
        public static final int M_PRIVATE = 2;
        public static final int M_PROTECTED = 4;
        public static final int M_STATIC = 8;
        public static final int M_TRANSIENT = 128;
        public static final int M_SYNCHRONIZED = 32;
        public static final int M_ABSTRACT = 1024;
        public static final int M_NATIVE = 256;
        public static final int M_FINAL = 16;
        public static final int M_VOLATILE = 64;
        public static final int M_INTERFACE = 512;
        public static final int M_SUPER = 32;
        public static final int M_ANONYMOUS = 65536;
        public static final int M_LOCAL = 131072;
        public static final int M_DEPRECATED = 262144;
        public static final int M_SYNTHETIC = 524288;
        public static final int M_INLINEABLE = 0x100000;
        public static final int MM_CLASS = 1585;
        public static final int MM_MEMBER = 31;
        public static final int MM_FIELD = 223;
        public static final int MM_METHOD = 1343;
        public static final int MM_INNERCLASS = 198207;
        public static final String cPrefix = "aurora.";
    }

    public static interface Write {
        public void write(RawOutput var1) throws IOException;
    }

    public static class RawOutput {
        DataOutputStream dout;

        public RawOutput(DataOutputStream dout) {
            this.dout = dout;
        }

        public DataOutputStream stream() {
            return this.dout;
        }

        public void u1(int n) throws IOException {
            this.dout.writeByte(n);
        }

        public void u2(int n) throws IOException {
            this.dout.writeShort(n);
        }

        public void u4(int n) throws IOException {
            this.dout.writeInt(n);
        }

        public void write(Write v) throws IOException {
            v.write(this);
        }

        public void write(byte[] bytes) throws IOException {
            this.dout.write(bytes);
        }
    }

    static interface Fmt {
        public void output(String var1, FmtOutput var2);
    }

    public static class FmtOutput {
        PrintStream writer;
        int level = 0;

        public FmtOutput(PrintStream writer) {
            this.writer = writer;
        }

        void push() {
            ++this.level;
        }

        void pop() {
            --this.level;
        }

        void indent() {
            for (int x = 0; x < this.level; ++x) {
                this.writer.print("  ");
            }
        }

        void out(String name) {
            this.indent();
            this.writer.println(name);
        }

        void out(String name, String value) {
            this.indent();
            StringBuffer buf = new StringBuffer();
            for (int xChar = 0; xChar < value.length(); ++xChar) {
                char c = value.charAt(xChar);
                if (c == '\\') {
                    buf.append('\\').append('\\');
                    continue;
                }
                if (c <= '\u00ff') {
                    buf.append(c);
                    continue;
                }
                buf.append("\\u");
                String hex = Integer.toHexString(c);
                if (hex.length() == 3) {
                    hex = "0" + hex;
                }
                buf.append(hex);
            }
            this.writer.println(name + " = " + buf);
        }

        void outHex(String name, int x) {
            this.out(name, Integer.toHexString(x));
        }

        void out(String name, int x) {
            this.out(name, Integer.toString(x));
        }

        void out(String name, Fmt f) {
            f.output(name, this);
        }

        void outObject(String name, Object obj) {
            if (obj instanceof byte[]) {
                this.out(name, (byte[])obj);
            } else {
                this.out(name, obj.toString());
            }
        }

        void out(String name, byte[] bytes) {
            this.out(name, "");
            this.push();
            StringBuffer accum = new StringBuffer();
            for (int x = 0; x < bytes.length; ++x) {
                accum.append(Integer.toHexString(bytes[x] & 0xFF));
                accum.append(" ");
                if (x % 32 != 31) continue;
                this.indent();
                this.writer.println(accum.toString());
                accum = new StringBuffer();
            }
            if (bytes.length % 32 != 0) {
                this.indent();
                this.writer.println(accum.toString());
            }
            this.pop();
        }
    }

    public static class RawInput {
        DataInputStream din;
        InputStream name;

        public RawInput(DataInputStream din) {
            this.din = din;
            this.name = din;
        }

        public RawInput(InputStream in) {
            this(new DataInputStream(new IOCopy().toBuffered(in)));
            this.name = in;
        }

        public RawInput(byte[] bytes) {
            this(new ByteArrayInputStream(bytes));
        }

        public int u4() throws IOException {
            int x = this.din.readInt();
            return x;
        }

        public int u2() throws IOException {
            int x = this.din.readUnsignedShort();
            return x;
        }

        public int u1() throws IOException {
            int x = this.din.readUnsignedByte();
            return x;
        }

        public String toString() {
            return "RawInput(" + this.name + ")";
        }

        public byte[] bytes(int length) throws IOException, ToolException {
            try {
                byte[] array = new byte[length];
                this.din.readFully(array);
                return array;
            }
            catch (OutOfMemoryError ex) {
                throw new ToolException("could not allocate " + length + " bytes ");
            }
        }
    }

    public static class ExceptionTableEntry
    implements Fmt,
    Write,
    Cloneable {
        public int startPc;
        public int endPc;
        public int handlerPc;
        public int catchType;

        public ExceptionTableEntry() {
        }

        public ExceptionTableEntry(RawInput rin) throws IOException {
            this.startPc = rin.u2();
            this.endPc = rin.u2();
            this.handlerPc = rin.u2();
            this.catchType = rin.u2();
        }

        public void output(String name, FmtOutput fout) {
            fout.out(name);
            fout.out("start PC", this.startPc);
            fout.out("end PC", this.endPc);
            fout.out("handler PC", this.handlerPc);
            fout.out("catch type", this.catchType);
        }

        public void write(RawOutput rout) throws IOException {
            rout.u2(this.startPc);
            rout.u2(this.endPc);
            rout.u2(this.handlerPc);
            rout.u2(this.catchType);
        }

        public Object clone() throws CloneNotSupportedException {
            ExceptionTableEntry copy = (ExceptionTableEntry)super.clone();
            return copy;
        }
    }

    public static class Code
    implements Fmt,
    Write,
    Cloneable {
        int maxStack;
        int maxLocals;
        int codeLength;
        byte[] code;
        int exceptionTableLength;
        ExceptionTableEntry[] exceptionTable;
        int attributeCount;
        Attribute[] attributes;

        public Code() {
        }

        public Code(int maxStack, int maxLocals, byte[] code, ExceptionTableEntry[] exceptions, Attribute[] attributes) {
            this.maxStack = maxStack;
            this.maxLocals = maxLocals;
            this.codeLength = code.length;
            this.code = code;
            if (exceptions != null) {
                this.exceptionTableLength = exceptions.length;
                this.exceptionTable = exceptions;
            }
            if (attributes != null) {
                this.attributeCount = attributes.length;
                this.attributes = attributes;
            }
        }

        public Code(RawInput rin) throws IOException, ToolException {
            int x;
            this.maxStack = rin.u2();
            this.maxLocals = rin.u2();
            this.codeLength = rin.u4();
            this.code = rin.bytes(this.codeLength);
            this.exceptionTableLength = rin.u2();
            this.exceptionTable = new ExceptionTableEntry[this.exceptionTableLength];
            for (x = 0; x < this.exceptionTableLength; ++x) {
                this.exceptionTable[x] = new ExceptionTableEntry(rin);
            }
            this.attributeCount = rin.u2();
            this.attributes = new Attribute[this.attributeCount];
            for (x = 0; x < this.attributeCount; ++x) {
                this.attributes[x] = new Attribute(rin);
            }
        }

        public void output(String name, FmtOutput fout) {
            int x;
            fout.out(name);
            fout.push();
            fout.out("max Stack", this.maxStack);
            fout.out("max Locals", this.maxLocals);
            fout.out("code Length", this.codeLength);
            fout.out("codebytes", this.code);
            fout.out("exceptionTableLength", this.exceptionTableLength);
            for (x = 0; x < this.exceptionTableLength; ++x) {
                fout.out("handler " + x, this.exceptionTable[x]);
            }
            fout.out("attribute count", this.attributeCount);
            for (x = 0; x < this.attributeCount; ++x) {
                fout.out("attribute " + x, this.attributes[x]);
            }
            fout.pop();
        }

        public void write(RawOutput rout) throws IOException {
            int x;
            rout.u2(this.maxStack);
            rout.u2(this.maxLocals);
            rout.u4(this.codeLength);
            rout.write(this.code);
            rout.u2(this.exceptionTableLength);
            for (x = 0; x < this.exceptionTableLength; ++x) {
                rout.write(this.exceptionTable[x]);
            }
            rout.u2(this.attributeCount);
            for (x = 0; x < this.attributeCount; ++x) {
                rout.write(this.attributes[x]);
            }
        }

        public Object clone() throws CloneNotSupportedException {
            int x;
            Code copy = (Code)super.clone();
            copy.exceptionTable = new ExceptionTableEntry[this.exceptionTable.length];
            for (x = 0; x < this.exceptionTable.length; ++x) {
                copy.exceptionTable[x] = (ExceptionTableEntry)this.exceptionTable[x].clone();
            }
            copy.attributes = new Attribute[this.attributes.length];
            for (x = 0; x < this.attributes.length; ++x) {
                copy.attributes[x] = (Attribute)this.attributes[x].clone();
            }
            return copy;
        }
    }

    public static class Attribute
    implements Fmt,
    Write,
    Cloneable {
        public int nameIndex;
        public int length;
        public byte[] data;

        public Attribute() {
        }

        public Attribute(int nameIndex, byte[] data) {
            this.nameIndex = nameIndex;
            this.length = data.length;
            this.data = data;
        }

        public Attribute(RawInput rin) throws ToolException, IOException {
            this.nameIndex = rin.u2();
            this.length = rin.u4();
            this.data = rin.bytes(this.length);
        }

        public void write(RawOutput rout) throws IOException {
            rout.u2(this.nameIndex);
            rout.u4(this.length);
            rout.write(this.data);
        }

        public void output(String name, FmtOutput fout) {
            fout.out(name, "");
            fout.push();
            fout.out("name", this.nameIndex);
            fout.out("length", this.length);
            fout.out("data", this.data);
            fout.pop();
        }

        public Object clone() throws CloneNotSupportedException {
            Attribute copy = (Attribute)super.clone();
            return copy;
        }
    }

    public static class Member
    implements Fmt,
    Write,
    Cloneable {
        public int accessFlags;
        public int nameIndex;
        public int descriptorIndex;
        public int attributeCount;
        public Attribute[] attributes;

        public Member() {
        }

        public Member(int accessFlags, int nameIndex, int descriptorIndex, Attribute[] attributes) {
            this.accessFlags = accessFlags;
            this.nameIndex = nameIndex;
            this.descriptorIndex = descriptorIndex;
            this.attributeCount = attributes.length;
            this.attributes = attributes;
        }

        public Member(RawInput rin) throws IOException, ToolException {
            this.accessFlags = rin.u2();
            this.nameIndex = rin.u2();
            this.descriptorIndex = rin.u2();
            this.attributeCount = rin.u2();
            this.attributes = new Attribute[this.attributeCount];
            for (int x = 0; x < this.attributeCount; ++x) {
                this.attributes[x] = new Attribute(rin);
            }
        }

        public void write(RawOutput rout) throws IOException {
            rout.u2(this.accessFlags);
            rout.u2(this.nameIndex);
            rout.u2(this.descriptorIndex);
            rout.u2(this.attributeCount);
            for (int x = 0; x < this.attributeCount; ++x) {
                rout.write(this.attributes[x]);
            }
        }

        public void output(String name, FmtOutput fout) {
            fout.out(name, "");
            fout.push();
            fout.outHex("accessFlags", this.accessFlags);
            fout.out("name", this.nameIndex);
            fout.out("descriptor", this.descriptorIndex);
            fout.out("attribute count", this.attributeCount);
            for (int x = 0; x < this.attributeCount; ++x) {
                fout.out("attribute " + x, this.attributes[x]);
            }
            fout.pop();
        }

        public Object clone() throws CloneNotSupportedException {
            Member copy = (Member)super.clone();
            for (int x = 0; x < this.attributes.length; ++x) {
                copy.attributes[x] = (Attribute)this.attributes[x].clone();
            }
            return copy;
        }
    }

    public static class Pair
    implements Fmt,
    Write {
        public int first;
        public int second;

        public Pair() {
        }

        public Pair(int first, int second) {
            this.first = first;
            this.second = second;
        }

        public void output(String name, FmtOutput fout) {
            fout.out(name, this.toString());
        }

        public void write(RawOutput rout) throws IOException {
            rout.u2(this.first);
            rout.u2(this.second);
        }

        public String toString() {
            return "[" + this.first + "," + this.second + "]";
        }

        public int hashCode() {
            return this.first + (this.second << 8);
        }

        public boolean equals(Object other) {
            return other instanceof Pair && this.first == ((Pair)other).first && this.second == ((Pair)other).second;
        }
    }

    public static class Constant
    implements JavaConstants,
    Fmt,
    Write,
    Cloneable {
        public int tag;
        public Object info;

        public Constant() {
        }

        public Constant(RawInput rin) throws IOException, ToolException {
            this.tag = rin.u1();
            DataInputStream in = rin.din;
            switch (this.tag) {
                case 1: {
                    this.info = in.readUTF();
                    break;
                }
                case 3: {
                    this.info = new Integer(in.readInt());
                    break;
                }
                case 4: {
                    this.info = new Float(in.readFloat());
                    break;
                }
                case 5: {
                    this.info = new Long(in.readLong());
                    break;
                }
                case 6: {
                    this.info = new Double(in.readDouble());
                    break;
                }
                case 7: 
                case 8: {
                    this.info = new Integer(rin.u2());
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    int first = rin.u2();
                    int second = rin.u2();
                    this.info = new Pair(first, second);
                    break;
                }
                default: {
                    throw new ToolException("unrecognized tag " + this.tag + " in " + rin);
                }
            }
        }

        public void output(String name, FmtOutput fout) {
            fout.out(name, this.toString());
        }

        public void write(RawOutput rout) throws IOException {
            rout.u1(this.tag);
            switch (this.tag) {
                case 1: {
                    rout.stream().writeUTF((String)this.info);
                    break;
                }
                case 3: {
                    rout.stream().writeInt((Integer)this.info);
                    break;
                }
                case 4: {
                    rout.stream().writeFloat(((Float)this.info).floatValue());
                    break;
                }
                case 5: {
                    rout.stream().writeLong((Long)this.info);
                    break;
                }
                case 6: {
                    rout.stream().writeDouble((Double)this.info);
                    break;
                }
                case 7: 
                case 8: {
                    rout.u2((Integer)this.info);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    ((Pair)this.info).write(rout);
                }
            }
        }

        public String toString() {
            return "tag " + this.tag + " " + this.info;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public boolean equals(Object other) {
            if (!(other instanceof Constant)) {
                return false;
            }
            Constant oConstant = (Constant)other;
            return this.tag == oConstant.tag && this.info.equals(oConstant.info);
        }

        public int hashCode() {
            return (this.tag << 8) + this.info.hashCode();
        }

        public static int constantTypeSize(int tag) {
            int result = 1;
            switch (tag) {
                case 5: 
                case 6: {
                    result = 2;
                }
            }
            return result;
        }
    }

    public static class Class
    implements Fmt,
    Cloneable {
        public int magic;
        public int minorVersion;
        public int majorVersion;
        public int poolCount;
        public Constant[] constantPool;
        public int accessFlags;
        public int thisClass;
        public int superClass;
        public int interfaceCount;
        public int[] interfaces;
        public int fieldCount;
        public Member[] fields;
        public int methodCount;
        public Member[] methods;
        public int attributeCount;
        public Attribute[] attributes;
        public byte[] trailing;

        public Class() {
        }

        public Class(InputStream in) throws IOException, ToolException {
            this(new RawInput(in));
        }

        public Class(DataInputStream in) throws IOException, ToolException {
            this(new RawInput(in));
        }

        public Class(RawInput rin) throws IOException, ToolException {
            int x;
            this.magic = rin.u4();
            this.minorVersion = rin.u2();
            this.majorVersion = rin.u2();
            this.poolCount = rin.u2();
            this.constantPool = new Constant[this.poolCount];
            for (x = 1; x < this.poolCount; x += Constant.constantTypeSize(this.constantPool[x].tag)) {
                try {
                    this.constantPool[x] = new Constant(rin);
                    continue;
                }
                catch (IOException ex) {
                    throw new ToolException("bad constant at index " + x + ": " + ex.getMessage());
                }
            }
            this.accessFlags = rin.u2();
            this.thisClass = rin.u2();
            this.superClass = rin.u2();
            this.interfaceCount = rin.u2();
            this.interfaces = new int[this.interfaceCount];
            for (x = 0; x < this.interfaceCount; ++x) {
                this.interfaces[x] = rin.u2();
            }
            this.fieldCount = rin.u2();
            this.fields = new Member[this.fieldCount];
            for (x = 0; x < this.fieldCount; ++x) {
                this.fields[x] = new Member(rin);
            }
            this.methodCount = rin.u2();
            this.methods = new Member[this.methodCount];
            for (x = 0; x < this.methodCount; ++x) {
                this.methods[x] = new Member(rin);
            }
            this.attributeCount = rin.u2();
            this.attributes = new Attribute[this.attributeCount];
            for (x = 0; x < this.attributeCount; ++x) {
                this.attributes[x] = new Attribute(rin);
            }
            int a = rin.din.available();
            this.trailing = null;
            if (a > 0) {
                try {
                    this.trailing = rin.bytes(rin.din.available());
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
        }

        public void output(String name, FmtOutput fout) {
            int x;
            fout.out("class " + name);
            fout.outHex("magic", this.magic);
            fout.out("minor version", this.minorVersion);
            fout.out("major version", this.majorVersion);
            fout.out("pool count", this.poolCount);
            for (x = 1; x < this.poolCount; ++x) {
                if (this.constantPool[x] == null) continue;
                fout.out("constant " + x, this.constantPool[x]);
            }
            fout.outHex("accessFlags", this.accessFlags);
            fout.out("this class", this.thisClass);
            fout.out("super class", this.superClass);
            fout.out("interface count", this.interfaceCount);
            for (x = 0; x < this.interfaceCount; ++x) {
                fout.out("interface " + x, this.interfaces[x]);
            }
            fout.out("fieldCount", this.fieldCount);
            for (x = 0; x < this.fieldCount; ++x) {
                fout.out("field " + x, this.fields[x]);
            }
            fout.out("method count", this.methodCount);
            for (x = 0; x < this.methodCount; ++x) {
                fout.out("method " + x, this.methods[x]);
            }
            fout.out("attribute count", this.attributeCount);
            for (x = 0; x < this.attributeCount; ++x) {
                fout.out("attribute " + x, this.attributes[x]);
            }
        }

        public void write(RawOutput rout) throws IOException {
            int x;
            rout.u4(this.magic);
            rout.u2(this.minorVersion);
            rout.u2(this.majorVersion);
            rout.u2(this.poolCount);
            for (x = 1; x < this.poolCount; ++x) {
                if (this.constantPool[x] == null) continue;
                rout.write(this.constantPool[x]);
            }
            rout.u2(this.accessFlags);
            rout.u2(this.thisClass);
            rout.u2(this.superClass);
            rout.u2(this.interfaceCount);
            for (x = 0; x < this.interfaceCount; ++x) {
                rout.u2(this.interfaces[x]);
            }
            rout.u2(this.fieldCount);
            for (x = 0; x < this.fieldCount; ++x) {
                rout.write(this.fields[x]);
            }
            rout.u2(this.methodCount);
            for (x = 0; x < this.methodCount; ++x) {
                rout.write(this.methods[x]);
            }
            rout.u2(this.attributeCount);
            for (x = 0; x < this.attributeCount; ++x) {
                rout.write(this.attributes[x]);
            }
        }

        public void output(PrintStream out) {
            FmtOutput fout = new FmtOutput(out);
            this.output("", fout);
        }

        public void output(DataOutputStream dout) throws IOException {
            RawOutput rout = new RawOutput(dout);
            this.write(rout);
        }

        public byte[] classfile() {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            try {
                this.output(dout);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bout.toByteArray();
        }

        public Object clone() throws CloneNotSupportedException {
            int x;
            Class copy = (Class)super.clone();
            copy.constantPool = new Constant[this.constantPool.length];
            for (x = 0; x < this.constantPool.length; ++x) {
                copy.constantPool[x] = (Constant)this.constantPool[x].clone();
            }
            copy.interfaces = (int[])this.interfaces.clone();
            copy.fields = new Member[this.fields.length];
            for (x = 0; x < this.fields.length; ++x) {
                copy.fields[x] = (Member)this.fields[x].clone();
            }
            copy.methods = new Member[this.methods.length];
            for (x = 0; x < this.methods.length; ++x) {
                copy.methods[x] = (Member)this.methods[x].clone();
            }
            copy.attributes = new Attribute[this.attributes.length];
            for (x = 0; x < this.attributes.length; ++x) {
                copy.attributes[x] = (Attribute)this.attributes[x].clone();
            }
            return copy;
        }

        Class copy() {
            try {
                Class c = (Class)this.clone();
                return c;
            }
            catch (CloneNotSupportedException ex) {
                throw new ToolError(ex, "internal error");
            }
        }
    }
}

