/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.classfile;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import oracle.aurora.notinserver.FileLnkdFinder;
import oracle.aurora.util.classfile.Dig;
import oracle.aurora.util.classfile.LnkdX;
import oracle.aurora.util.classfile.Raw;
import oracle.aurora.util.classfile.Type;
import oracle.aurora.util.classfile.TypeFactory;
import oracle.aurora.util.tools.ToolError;
import oracle.aurora.util.tools.ToolException;
import oracle.aurora.util.xclass.NotKnownException;
import oracle.aurora.util.xclass.XClass;
import sun.tools.java.ClassPath;

public class Lnkd
implements Raw.JavaConstants,
Raw.Fmt {
    public static Object noPackageDomain = new Object();
    Object identification;
    Object packageDomain;
    InputStream in;
    Finder finder;
    TypeFactory factory;
    Dig.Class digClass;
    Dig.ConstantPool digConstants;
    Class clazz;
    String name;
    LnkdX xLnkd;

    public Lnkd(String name, InputStream in, Finder finder, Object identification, Object packageDomain) {
        if (packageDomain == null) {
            packageDomain = noPackageDomain;
        }
        this.finder = finder;
        this.factory = new TypeFactory(finder);
        this.identification = identification;
        this.packageDomain = packageDomain;
        this.in = in;
        this.name = name;
    }

    public Lnkd(Dig.Class digClass, Finder finder, Object identification, Object packageDomain) {
        if (packageDomain == null) {
            packageDomain = noPackageDomain;
        }
        this.finder = finder;
        this.factory = new TypeFactory(finder);
        this.identification = identification;
        this.packageDomain = packageDomain;
        this.digClass = digClass;
        this.name = digClass.getName();
    }

    public Lnkd(String name, InputStream in, Finder finder) {
        this(name, in, finder, in, noPackageDomain);
    }

    public Lnkd(Dig.Class digClass, Finder finder) {
        this(digClass, finder, digClass, noPackageDomain);
    }

    public Finder getFinder() {
        return this.finder;
    }

    public TypeFactory getTypeFactory() {
        return this.factory;
    }

    public String getPath() {
        return this.identification.toString();
    }

    public String getName() {
        if (this.name == null) {
            try {
                this.name = this.getClazz().getName();
            }
            catch (ToolException ex) {
                this.name = "***BadClass***";
            }
        }
        return this.name;
    }

    public Dig.Class getDigClass() throws ToolException {
        if (this.digClass == null && this.in != null) {
            try {
                Raw.Class rawClass = new Raw.Class(this.in);
                Dig dig = new Dig(rawClass);
                this.digClass = dig.getClazz();
            }
            catch (IOException ex) {
                throw new ToolException("reading " + this.in, ex);
            }
        }
        return this.digClass;
    }

    public Class getClazz() throws ToolException {
        if (this.clazz == null) {
            this.getDigClass();
            this.clazz = new Class();
        }
        return this.clazz;
    }

    LnkdX getX() {
        if (this.xLnkd == null) {
            try {
                this.xLnkd = new LnkdX(this.getClazz());
            }
            catch (ToolException toolException) {
                // empty catch block
            }
        }
        return this.xLnkd;
    }

    XClass getXClass() {
        LnkdX.Class xClass = null;
        LnkdX x = this.getX();
        if (x != null) {
            xClass = x.getXClass();
        }
        return xClass;
    }

    Class getClazzOrNotKnown() throws NotKnownException {
        Class cl;
        try {
            cl = this.getClazz();
        }
        catch (ToolException tex) {
            throw new NotKnownException("caught " + tex);
        }
        return cl;
    }

    public Lnkd find(String name) {
        if (name == null) {
            return null;
        }
        return this.finder.find(name);
    }

    public String toString() {
        return "Lnkd " + this.getPath();
    }

    public static Finder nullFinder() {
        return new Finder(){

            public Lnkd find(String name) {
                return null;
            }
        };
    }

    public void output(String name, Raw.FmtOutput fout) {
        fout.out(name, this.toString());
    }

    public int hashCode() {
        int h = this.identification == null ? System.identityHashCode(this) : this.identification.hashCode();
        return h;
    }

    public boolean equals(Object rhs) {
        boolean ok = false;
        if (this.identification == null) {
            ok = super.equals(rhs);
        } else if (rhs instanceof Lnkd) {
            ok = this.identification.equals(((Lnkd)rhs).identification);
        } else if (rhs instanceof Class) {
            ok = this.identification.equals(((Class)rhs).getLnkd().identification);
        }
        return ok;
    }

    public static void main(String[] argv) {
        try {
            FileLnkdFinder finder = new FileLnkdFinder(new ClassPath(argv[0]));
            Lnkd app = finder.find(argv[1]);
            if (app == null) {
                System.out.println("class " + argv[1] + " not found ");
            } else {
                app.getClazz().output("Class", new Raw.FmtOutput(System.out));
            }
        }
        catch (ToolException ex) {
            ex.printStackTrace();
        }
    }

    public class Member {
        Dig.Member digMember;
        Type type;

        Member(Dig.Member digMember) {
            this.digMember = digMember;
        }

        public Class getDeclaring() {
            return Lnkd.this.clazz;
        }

        public Class getDeclaringClass() {
            return this.getDeclaring();
        }

        public Class containingClass() {
            return this.getDeclaring();
        }

        public Type getType() {
            if (this.type == null) {
                this.type = Lnkd.this.factory.construct(this.digMember.getDescriptor());
            }
            return this.type;
        }

        public Dig.Member getDig() {
            return this.digMember;
        }

        public String toString() {
            return Lnkd.this.clazz.getName() + "." + this.digMember.getName();
        }

        public Dig.Attributes getAttributes() {
            return this.digMember.getAttributes();
        }

        public int getModifiers() {
            return this.digMember.getModifiers();
        }

        public String getName() {
            return this.digMember.getName();
        }

        public boolean isAbstract() {
            return this.digMember.isAbstract();
        }

        public boolean isConstructor() {
            return this.digMember.isConstructor();
        }

        public boolean isMethod() {
            return this.digMember.isMethod();
        }

        public boolean isNative() {
            return this.digMember.isNative();
        }

        public boolean isProtected() {
            return this.digMember.isProtected();
        }

        public boolean isStatic() {
            return this.digMember.isStatic();
        }
    }

    public class Fields
    implements Raw.Fmt {
        Dig.Fields digFields;

        Fields(Dig.Fields digFields) {
            this.digFields = digFields;
        }

        public int count() {
            return this.digFields.count();
        }

        public Member get(int x) {
            return new Member(this.digFields.get(x));
        }

        public Member lookup(String name, String descriptor) {
            Dig.Member digField = this.digFields.lookup(name, descriptor);
            Member field = digField != null ? new Member(digField) : null;
            return field;
        }

        public void output(String name, Raw.FmtOutput fout) {
            fout.out(name);
            fout.push();
            for (int x = 0; x < this.count(); ++x) {
                fout.out("field " + x, this.get(x).toString());
            }
            fout.pop();
        }
    }

    public class Methods
    implements Raw.Fmt {
        Dig.Methods digMethods;

        Methods(Dig.Methods digMethods) {
            this.digMethods = digMethods;
        }

        public int count() {
            return this.digMethods.count();
        }

        public Member get(int x) {
            return new Member(this.digMethods.get(x));
        }

        public Member lookup(String name, String descriptor) {
            Dig.Member digMethod = this.digMethods.lookup(name, descriptor);
            Member method = digMethod != null ? new Member(digMethod) : null;
            return method;
        }

        public void output(String name, Raw.FmtOutput fout) {
            fout.out(name);
            fout.push();
            for (int x = 0; x < this.count(); ++x) {
                fout.out("method " + x, this.get(x).toString());
            }
            fout.pop();
        }
    }

    public class Constant {
        int kind;
        LinkageError error;
        Class resolvedClass;
        Type resolvedType;
        Member member;
        boolean resolvedUsingJVMS;

        Constant(LinkageError error, int kind) {
            this.kind = kind;
            this.error = error;
        }

        Constant(Type type) {
            this.kind = 7;
            this.resolvedType = type;
            if (type.isError()) {
                this.error = type.error();
            }
            if (type.isClass()) {
                try {
                    this.resolvedClass = type.lnkd().getClazz();
                }
                catch (ToolException ex) {
                    this.error = new ClassFormatError("reading " + type.lnkd().getName() + " threw " + ex);
                }
            }
            Type t = type;
            while (t.isArray()) {
                t = t.elem();
            }
            if (t != null && t.isError()) {
                this.error = t.error();
            } else if (t != null && t.isClass()) {
                try {
                    Class elemClass = t.lnkd().getClazz();
                    if (Lnkd.this.clazz.canAccess(elemClass)) {
                        this.resolvedType = type;
                        if (type.isClass()) {
                            this.resolvedClass = elemClass;
                        }
                    } else {
                        this.error = new IllegalAccessError(Lnkd.this.clazz + " cannot Access " + elemClass);
                    }
                }
                catch (ToolException ex) {
                    this.error = new ClassFormatError("reading " + t.lnkd().getName() + " threw " + ex);
                }
            }
            if (this.error != null) {
                this.resolvedType = null;
                this.resolvedClass = null;
            }
        }

        Constant(Member member, int kind, boolean usedJVMS) {
            this.kind = kind;
            this.resolvedUsingJVMS = usedJVMS;
            if (member == null) {
                throw new NullPointerException();
            }
            if (!Lnkd.this.clazz.canAccess(member)) {
                this.error = new IllegalAccessError(this + " cannot Access " + member);
            } else {
                this.member = member;
            }
        }

        public boolean ok() {
            return this.error == null && (Lnkd.this.clazz != null || this.member != null);
        }

        public LinkageError getError() {
            return this.error;
        }

        public Class getResolvedClass() {
            return this.resolvedClass;
        }

        public Member getMember() {
            return this.member;
        }

        public boolean getResolvedUsingJVMS() {
            return this.resolvedUsingJVMS;
        }

        public Type getResolvedType() {
            if (this.resolvedType == null && this.resolvedClass != null) {
                this.resolvedType = new Type.User(this.resolvedClass.getLnkd());
            }
            return this.resolvedType;
        }

        public String toString() {
            String kindString;
            switch (this.kind) {
                case 7: {
                    kindString = "CLASS";
                    break;
                }
                case 9: {
                    kindString = "FIELD";
                    break;
                }
                case 10: {
                    kindString = "METHOD";
                    break;
                }
                case 11: {
                    kindString = "INTERFACEMETHOD";
                    break;
                }
                default: {
                    kindString = "" + this.kind;
                }
            }
            Object value = this.error != null ? this.error : (this.resolvedClass != null ? this.resolvedClass : (this.resolvedType != null ? this.resolvedType : (this.member != null ? this.member : "null")));
            return "resolved " + kindString + "<" + value.toString() + ">" + (this.resolvedUsingJVMS ? " (JVMS resolved)" : "");
        }
    }

    public class ConstantPool
    implements Raw.Fmt {
        Constant[] resolved;

        ConstantPool() {
            if (Lnkd.this.digConstants == null) {
                throw new ToolError("digConstants should have been initialized");
            }
            this.resolved = new Constant[Lnkd.this.digConstants.size()];
        }

        Dig.ConstantPool getDig() {
            return Lnkd.this.digConstants;
        }

        public int size() {
            return this.resolved.length;
        }

        public Constant get(int x) {
            if (x < 0 || x > this.resolved.length) {
                ClassFormatError err = new ClassFormatError("index into constant pool out of bounds: " + x);
                return new Constant(err, 0);
            }
            if (this.resolved[x] == null) {
                switch (Lnkd.this.digConstants.getConstantType(x)) {
                    case 7: {
                        String name = Lnkd.this.digConstants.getClass(x);
                        this.resolved[x] = this.resolveClass(name);
                        break;
                    }
                    case 9: {
                        int xClass = Lnkd.this.digConstants.getFirst(x);
                        this.resolved[x] = this.resolveField(this.get(xClass), Lnkd.this.digConstants.getNameOfRef(x), Lnkd.this.digConstants.getDescriptorOfRef(x));
                        break;
                    }
                    case 10: {
                        int xClass = Lnkd.this.digConstants.getFirst(x);
                        this.resolved[x] = this.resolveMethod(this.get(xClass), Lnkd.this.digConstants.getNameOfRef(x), Lnkd.this.digConstants.getDescriptorOfRef(x));
                        break;
                    }
                    case 11: {
                        int xClass = Lnkd.this.digConstants.getFirst(x);
                        this.resolved[x] = this.resolveInterfaceMethod(this.get(xClass), Lnkd.this.digConstants.getNameOfRef(x), Lnkd.this.digConstants.getDescriptorOfRef(x));
                        break;
                    }
                    default: {
                        this.resolved[x] = new Constant(new ClassFormatError("constant of wrong kind"), Lnkd.this.digConstants.getConstantType(x));
                    }
                }
            }
            return this.resolved[x];
        }

        Constant resolveClass(String classDescriptor) {
            Constant c;
            if (classDescriptor == null || classDescriptor.length() == 0) {
                c = new Constant(new ClassFormatError(), 7);
            } else {
                String typeDescriptor = classDescriptor.charAt(0) == '[' ? classDescriptor : 'L' + classDescriptor + ';';
                Type t = Lnkd.this.factory.construct(typeDescriptor);
                c = new Constant(t);
            }
            return c;
        }

        Constant classOrError(Constant c, int kind) {
            Constant result;
            if (!c.ok()) {
                result = new Constant(c.getError(), kind);
            } else if (c.getResolvedClass() == null) {
                ClassFormatError e = new ClassFormatError(c + " is not a class ");
                result = new Constant(e, kind);
            } else {
                result = c;
            }
            return result;
        }

        Constant resolveField(Constant cc, String name, String descriptor) {
            Constant result;
            Constant clazz = this.classOrError(cc, 9);
            if (!clazz.ok()) {
                result = clazz;
            } else {
                Class container = clazz.getResolvedClass();
                Member field = null;
                try {
                    field = this.resolveField(container, name, descriptor);
                }
                catch (ToolException ex) {
                    // empty catch block
                }
                if (field != null) {
                    result = new Constant(field, 9, container != field.getDeclaring());
                } else {
                    NoSuchFieldError err = new NoSuchFieldError(clazz + "." + name + "/" + descriptor);
                    result = new Constant(err, 9);
                }
            }
            return result;
        }

        Member resolveField(Class clazz, String name, String descriptor) throws ToolException {
            Member field = null;
            field = clazz.getFields().lookup(name, descriptor);
            if (field == null) {
                Lnkd sLnkd = clazz.getSuperClass();
                try {
                    if (sLnkd != null) {
                        field = this.resolveField(sLnkd.getClazz(), name, descriptor);
                    }
                }
                catch (ToolException ex) {
                    // empty catch block
                }
            }
            return field;
        }

        Constant resolveMethod(boolean isInterface, Constant cc, String name, String descriptor) {
            Constant result;
            Constant clazz = this.classOrError(cc, 10);
            if (!clazz.ok()) {
                result = clazz;
            } else {
                Class lnkdClass = clazz.getResolvedClass();
                boolean refIsInterface = lnkdClass.isInterface();
                if (refIsInterface != isInterface) {
                    IncompatibleClassChangeError err = new IncompatibleClassChangeError(clazz + "." + name + ":" + descriptor);
                    result = new Constant(err, 10);
                } else {
                    try {
                        Member method = this.resolveMethod(lnkdClass, name, descriptor);
                        if (method != null) {
                            result = new Constant(method, 10, method.getDeclaring() != lnkdClass);
                        } else {
                            NoSuchMethodError err = new NoSuchMethodError(clazz + "." + name + ":" + descriptor);
                            result = new Constant(err, 10);
                        }
                    }
                    catch (ToolException ex) {
                        NoSuchMethodError err = new NoSuchMethodError(ex.toString());
                        result = new Constant(err, 10);
                    }
                }
            }
            return result;
        }

        Constant resolveMethod(Constant clazz, String name, String descriptor) {
            return this.resolveMethod(false, clazz, name, descriptor);
        }

        Constant resolveInterfaceMethod(Constant clazz, String name, String descriptor) {
            return this.resolveMethod(true, clazz, name, descriptor);
        }

        Member resolveMethod(Class clazz, String name, String descriptor) throws ToolException {
            Member method = clazz.getMethods().lookup(name, descriptor);
            if (method == null) {
                Lnkd sLnkd = clazz.getSuperClass();
                if (sLnkd != null) {
                    method = this.resolveMethod(sLnkd.getClazz(), name, descriptor);
                }
                if (method == null) {
                    Lnkd[] interfaces = clazz.getInterfaces();
                    for (int xInterface = 0; xInterface < interfaces.length && method == null; ++xInterface) {
                        Lnkd i = interfaces[xInterface];
                        method = this.resolveMethod(i, name, descriptor);
                    }
                }
            }
            return method;
        }

        Member resolveMethod(Lnkd lnkd, String name, String descriptor) throws ToolException {
            return this.resolveMethod(lnkd.getClazz(), name, descriptor);
        }

        public void output(String name, Raw.FmtOutput fout) {
            fout.out(name);
            fout.push();
            block3: for (int xConstant = 0; xConstant < this.resolved.length; ++xConstant) {
                String cname = "constant " + xConstant;
                String d = Lnkd.this.digConstants.toString(xConstant);
                switch (Lnkd.this.digConstants.getConstantType(xConstant)) {
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: {
                        Constant c = this.get(xConstant);
                        if (c.ok()) {
                            fout.out(cname, c.toString());
                            continue block3;
                        }
                        fout.out(cname, "unresolved " + d);
                        fout.push();
                        fout.out("error", this.get(xConstant).getError().toString());
                        fout.pop();
                        continue block3;
                    }
                    default: {
                        fout.out(cname, d);
                    }
                }
            }
            fout.pop();
        }
    }

    public class Class {
        Type self;
        Lnkd superClass;
        boolean superClassKnown;
        Lnkd[] interfaces;
        ConstantPool constants;

        Class() {
            if (Lnkd.this.digClass == null) {
                throw new ToolError("digClass should have been initialized");
            }
        }

        public Lnkd getLnkd() {
            return Lnkd.this;
        }

        public String getName() {
            return Lnkd.this.digClass.getName();
        }

        public Type getType() {
            if (this.self == null) {
                this.self = new Type.User(this.getLnkd());
            }
            return this.self;
        }

        public int getModifiers() {
            return Lnkd.this.digClass.getModifiers();
        }

        public Lnkd getSuperClass() {
            if (this.superClass == null && !this.superClassKnown) {
                this.superClass = Lnkd.this.find(Lnkd.this.digClass.getSuperClass());
                this.superClassKnown = true;
            }
            return this.superClass;
        }

        public boolean isInterface() {
            return Lnkd.this.digClass.is(512);
        }

        public boolean isFinal() {
            return Lnkd.this.digClass.is(16);
        }

        public boolean isAbstract() {
            return Lnkd.this.digClass.is(1024);
        }

        public boolean isProtected() {
            return Lnkd.this.digClass.is(4);
        }

        public ConstantPool getConstants() {
            if (this.constants == null) {
                if (Lnkd.this.digConstants == null) {
                    Lnkd.this.digConstants = Lnkd.this.digClass.getConstants();
                }
                this.constants = new ConstantPool();
            }
            return this.constants;
        }

        public Methods getMethods() {
            return new Methods(this.getDig().getMethods());
        }

        public Fields getFields() {
            return new Fields(this.getDig().getFields());
        }

        public Lnkd[] getInterfaces() {
            if (this.interfaces == null) {
                int count = Lnkd.this.digClass.getInterfaceCount();
                this.interfaces = new Lnkd[count];
                for (int xInterface = 0; xInterface < count; ++xInterface) {
                    this.interfaces[xInterface] = Lnkd.this.find(Lnkd.this.digClass.getInterface(xInterface));
                }
            }
            return this.interfaces;
        }

        public Dig.Attributes getAttributes() {
            return Lnkd.this.digClass.getAttributes();
        }

        public Raw.Class getRaw() {
            return Lnkd.this.digClass.getRaw();
        }

        public Dig.Class getDig() {
            return Lnkd.this.digClass;
        }

        public String toString() {
            return this.getName() + "[" + Lnkd.this.getPath() + "]";
        }

        public int hashCode() {
            return this.getLnkd().hashCode();
        }

        public boolean equals(Object rhs) {
            return this.getLnkd().equals(rhs);
        }

        private String packagePart(String name) {
            String pkg = name.lastIndexOf(46) > 0 ? name.substring(0, name.lastIndexOf(46)) : "";
            return pkg;
        }

        public boolean samePackage(Lnkd classRef) {
            String myPkg = this.packagePart(this.getName());
            String refPkg = this.packagePart(classRef.getName());
            Object myDomain = this.getLnkd().packageDomain;
            Object refDomain = classRef.packageDomain;
            return myPkg.equals(refPkg) && myDomain.equals(refDomain);
        }

        public boolean canAccess(Class classRef, int modifiers, Class actual) {
            boolean ok;
            if (Modifier.isPublic(modifiers)) {
                ok = true;
            } else if (Modifier.isPrivate(modifiers)) {
                ok = this.equals(classRef);
            } else if (Modifier.isProtected(modifiers)) {
                boolean same = this.samePackage(classRef.getLnkd());
                boolean bl = ok = same || this.extend(classRef);
                if (ok && !same && actual != null) {
                    ok = actual.extend(this);
                }
            } else {
                ok = this.samePackage(classRef.getLnkd());
            }
            return ok;
        }

        public boolean canAccess(Class classRef) {
            return this.canAccess(classRef, classRef.getDig().getModifiers(), null);
        }

        public boolean canAccess(Type type) {
            boolean ok;
            if (type.isClass()) {
                try {
                    ok = this.canAccess(type.lnkd().getClazz());
                }
                catch (ToolException ex) {
                    ok = false;
                }
            } else {
                ok = type.isArray() ? this.canAccess(type.elem()) : true;
            }
            return ok;
        }

        public boolean canAccess(Member member) {
            int modifiers = member.getDig().getModifiers();
            Class classRef = member.getDeclaring();
            return this.canAccess(classRef, modifiers, null);
        }

        public boolean extend(Lnkd base) {
            try {
                boolean found = false;
                Lnkd app = this.getLnkd();
                while (app != null && !app.equals(base)) {
                    app = app.getClazz().getSuperClass();
                }
                return app != null;
            }
            catch (ToolException ex) {
                return false;
            }
        }

        public boolean isBaseOf(Lnkd subClass) {
            try {
                return subClass.getClazz().extend(this);
            }
            catch (ToolException ex) {
                return false;
            }
        }

        public boolean extend(Class base) {
            return this.extend(base.getLnkd());
        }

        public boolean isBaseOf(Class subClass) {
            return subClass.extend(this);
        }

        public boolean implement(Lnkd iface) {
            try {
                Lnkd[] interfaces = this.getInterfaces();
                boolean found = false;
                for (int xInterface = 0; xInterface < interfaces.length && !found; ++xInterface) {
                    if (interfaces[xInterface] == null) continue;
                    found = interfaces[xInterface].equals(iface) || interfaces[xInterface].getClazz().implement(iface);
                }
                if (!found && this.getSuperClass() != null) {
                    Class sClass = this.getSuperClass().getClazz();
                    found = sClass.implement(iface);
                }
                return found;
            }
            catch (ToolException ex) {
                return false;
            }
        }

        public boolean implement(Class iface) {
            return this.implement(iface.getLnkd());
        }

        public void output(String name, Raw.FmtOutput fout) {
            fout.out("class " + this.getName());
            fout.out("path " + Lnkd.this.getPath());
            fout.out("constants", this.getConstants());
            fout.out("accessFlags", Modifier.toString(this.getModifiers()));
            Lnkd superClass = this.getSuperClass();
            if (superClass == null) {
                fout.out("super class", Lnkd.this.digClass.getSuperClass());
            } else {
                fout.out("super class", superClass);
            }
            fout.out("Interfaces");
            fout.push();
            Lnkd[] interfaces = this.getInterfaces();
            for (int xInterface = 0; xInterface < interfaces.length; ++xInterface) {
                fout.out("interface " + xInterface, interfaces[xInterface]);
            }
            fout.pop();
            fout.out("Fields", this.getFields());
            fout.out("Methods", this.getMethods());
            fout.out("Attributes", this.getDig().getAttributes());
        }
    }

    public static interface Finder {
        public Lnkd find(String var1);
    }
}

