/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.util.StringTokenizer;
import java.util.Vector;

public class TypeUtil {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final byte[] charval = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    public static String addCommas(float f) {
        String floatStr = TypeUtil.truncateFloat(f, 0);
        return TypeUtil.addCommas(floatStr);
    }

    public static String addCommas(String numStr) {
        String n;
        int dotIndex = numStr.lastIndexOf(46);
        String fraction = "";
        if (dotIndex >= 0) {
            fraction = numStr.substring(dotIndex);
            n = numStr.substring(0, dotIndex);
        } else {
            n = numStr;
        }
        String val = "";
        int lastIndex = 0;
        for (int i = n.length(); i > 0; i -= 3) {
            String comma = i > 3 ? "," : "";
            int start = Math.max(i - 3, 0);
            val = comma + n.substring(start, i) + val;
            lastIndex = start;
        }
        val = n.substring(0, lastIndex) + val + fraction;
        return val;
    }

    public static String arrayToString(String[] from, String separator) {
        StringBuffer sb = new StringBuffer(100);
        String sep = "";
        for (int i = 0; i < from.length; ++i) {
            sb.append(sep);
            sb.append(from[i]);
            sep = separator;
        }
        return sb.toString();
    }

    public static String extensionOf(String filename) {
        if (filename == null) {
            return null;
        }
        int i = filename.lastIndexOf(46);
        if (i != -1 && i < filename.length() - 1) {
            return filename.substring(i + 1);
        }
        return null;
    }

    public static int hashCode(String s) {
        int length = s.length();
        int h = 1;
        for (int i = 0; i < length; ++i) {
            h = h * 37 + s.charAt(i);
        }
        return h;
    }

    public static int intGetBytes(int src, byte[] buf, int offset) {
        int power = 1000000000;
        boolean have_emitted = false;
        int init_offset = offset;
        if (src == 0) {
            buf[offset] = charval[0];
            return 1;
        }
        if (src < 0) {
            if (src == Integer.MIN_VALUE) {
                throw new IllegalArgumentException();
            }
            buf[offset++] = 45;
            src = Math.abs(src);
        }
        while (power > 0) {
            int this_digit = src / power;
            if (this_digit != 0 || have_emitted) {
                have_emitted = true;
                buf[offset++] = charval[this_digit];
            }
            src %= power;
            power /= 10;
        }
        return offset - init_offset;
    }

    public static int intGetChars(int src, char[] buf, int offset) {
        int power = 1000000000;
        boolean have_emitted = false;
        int init_offset = offset;
        if (src == 0) {
            buf[offset] = digits[0];
            return 1;
        }
        if (src < 0) {
            if (src == Integer.MIN_VALUE) {
                throw new IllegalArgumentException();
            }
            buf[offset++] = 45;
            src = Math.abs(src);
        }
        while (power > 0) {
            int this_digit = src / power;
            if (this_digit != 0 || have_emitted) {
                have_emitted = true;
                buf[offset++] = digits[this_digit];
            }
            src %= power;
            power /= 10;
        }
        return offset - init_offset;
    }

    public static boolean isSubclassOf(Class sub, Class sup) {
        Class superclass;
        if (sub == sup) {
            return true;
        }
        for (superclass = sub.getSuperclass(); superclass != null && superclass != sup; superclass = superclass.getSuperclass()) {
        }
        return superclass != null;
    }

    public static String[] stringToArray(String from, String separator) {
        if (from == null) {
            return null;
        }
        if (separator == null) {
            separator = " ";
        }
        StringTokenizer toks = new StringTokenizer(from, separator);
        String[] result = new String[toks.countTokens()];
        int i = 0;
        while (toks.hasMoreTokens()) {
            result[i++] = toks.nextToken().trim();
        }
        return result;
    }

    public static String truncateFloat(float f, int digits) {
        double factor = Math.pow(10.0, digits);
        f = (float)((double)Math.round((double)f * factor) / factor);
        return Float.toString(f);
    }

    public static String[] wordWrap(String msg, int widthInChars) {
        int length;
        int width = widthInChars;
        int nextBreak = 0;
        int lastBreak = 0;
        int lengthLeft = length = msg.length();
        boolean breakFound = true;
        Vector<String> v = new Vector<String>();
        int nextNewline = msg.indexOf("\n");
        while (lengthLeft > width || nextNewline != -1) {
            nextBreak = nextNewline;
            if (nextBreak == -1 || nextBreak <= lastBreak || nextBreak > lastBreak + width) {
                nextBreak = msg.lastIndexOf(" ", lastBreak + width);
            }
            if (nextBreak == -1 || nextBreak <= lastBreak) {
                nextBreak = lastBreak + width - 1;
                breakFound = false;
                if (nextBreak > length) break;
            }
            String substr = msg.substring(lastBreak, nextBreak);
            v.addElement(substr);
            lengthLeft -= substr.length();
            lastBreak = nextBreak;
            if (breakFound) {
                ++lastBreak;
            }
            breakFound = true;
            nextNewline = msg.indexOf("\n", lastBreak);
        }
        v.addElement(msg.substring(lastBreak));
        Object[] lines = new String[v.size()];
        v.copyInto(lines);
        return lines;
    }
}

