/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.util.Observable;
import oracle.aurora.util.ErrorFormatter;
import oracle.aurora.util.TracerManager;

public class Tracer
extends Observable {
    private String name = "";
    private boolean tracing = false;

    public Tracer(String name) {
        this.name = name;
        TracerManager.addTracer(this);
    }

    public String getName() {
        return this.name;
    }

    public boolean isTracing() {
        return this.tracing;
    }

    public void setName(String name) {
        TracerManager.removeTracer(this);
        this.name = name;
        TracerManager.addTracer(this);
    }

    public void setTracing(boolean flag) {
        this.tracing = flag;
        this.notifyObservers(this);
    }

    public String toString() {
        return "[name=" + this.name + ",tracing=" + this.tracing + "]";
    }

    public void trace(String msg) {
        this.trace(msg, null);
    }

    public void trace(String msg, Exception exc) {
        if (this.tracing) {
            Object[] args = new Object[]{msg, exc};
            this.notifyObservers(args);
            ErrorFormatter.printMessage(ErrorFormatter.formatMessage(null, this.name, msg));
            if (exc != null) {
                exc.printStackTrace();
            }
        }
    }
}

