/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.aurora.memoryManager.Callback;
import oracle.aurora.memoryManager.EndOfCallRegistry;
import oracle.jdbc.driver.OracleDriver;

public class TableWriter
extends Writer
implements Callback {
    private StringBuffer buffer = new StringBuffer();
    private int bufferLength;
    private int width = 30;
    private int lineNumber = 1;
    private Connection connection;
    private String tableName;
    private boolean closed;
    private long id = -1L;
    private PreparedStatement insertStatement;
    protected static int TABLE_WIDTH = 4000;

    public TableWriter(String tableName) throws IOException {
        this(null, tableName, 0);
    }

    public TableWriter(String tableName, int bufferLength) throws IOException {
        this(null, tableName, bufferLength);
    }

    public TableWriter(Connection connection, String tableName) throws IOException {
        try {
            this.init(connection, tableName);
        }
        catch (SQLException e) {
            throw TableWriter.convert(e);
        }
    }

    public TableWriter(Connection connection, String tableName, int bufferLength) throws IOException {
        try {
            this.init(connection, tableName, bufferLength);
        }
        catch (SQLException e) {
            throw TableWriter.convert(e);
        }
    }

    public void act(Object value) {
        if (this.insertStatement == null) {
            return;
        }
        try {
            this.insertStatement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.insertStatement = null;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("TableWriter(" + this.tableName + ") previously closed.");
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.flush();
            try {
                if (this.insertStatement != null) {
                    this.insertStatement.close();
                    this.insertStatement = null;
                }
                this.connection.commit();
            }
            catch (SQLException ex) {
                throw TableWriter.convert(ex);
            }
        }
        this.closed = true;
    }

    private static IOException convert(SQLException ex) {
        return new IOException("converted SQLException " + ex);
    }

    public static void create(String tableName) throws IOException {
        try {
            TableWriter.create(TableWriter.newConnection(), tableName);
        }
        catch (SQLException ex) {
            throw TableWriter.convert(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(Connection connection, String tableName) throws SQLException {
        Statement stmt = connection.createStatement();
        try {
            stmt.execute("create table " + tableName + " ( id number, line number, text varchar2(4000) )");
            stmt.execute("create sequence " + TableWriter.sequenceName(tableName));
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(Connection connection, String tableName) throws SQLException {
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            try {
                stmt.execute("drop table " + tableName);
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                stmt.execute("drop sequence " + TableWriter.sequenceName(tableName));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public static void delete(String tableName) throws IOException {
        try {
            TableWriter.delete(TableWriter.newConnection(), tableName);
        }
        catch (SQLException ex) {
            throw TableWriter.convert(ex);
        }
    }

    private void ensureInsertStatement() throws SQLException {
        if (this.insertStatement != null) {
            return;
        }
        String insertCommand = "insert into " + this.tableName + " ( id, line, text ) " + "values ( :1, :2, :3 ) ";
        this.insertStatement = this.connection.prepareStatement(insertCommand);
        this.insertStatement.setLong(1, this.id);
        try {
            EndOfCallRegistry.registerCallback(this);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public void flush() throws IOException {
        this.checkClosed();
        int pos = 0;
        int length = this.buffer.length();
        try {
            this.ensureInsertStatement();
            for (int line = 0; line < length / TABLE_WIDTH; ++line) {
                this.insertStatement.setInt(2, this.lineNumber);
                this.insertStatement.setString(3, this.buffer.substring(pos, pos + TABLE_WIDTH - 1));
                this.insertStatement.execute();
                pos += TABLE_WIDTH;
                ++this.lineNumber;
            }
            if (length % TABLE_WIDTH > 0) {
                this.insertStatement.setInt(2, this.lineNumber);
                this.insertStatement.setString(3, this.buffer.substring(pos));
                this.insertStatement.execute();
                ++this.lineNumber;
            }
            this.connection.commit();
            this.buffer.setLength(0);
        }
        catch (SQLException ex) {
            throw TableWriter.convert(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Connection connection, String tableName) throws SQLException {
        this.closed = false;
        this.tableName = tableName;
        if (connection == null) {
            connection = TableWriter.newConnection();
        }
        this.connection = connection;
        if (this.connection == null) {
            this.connection = TableWriter.newConnection();
        }
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            ResultSet r = stmt.executeQuery("select " + TableWriter.sequenceName(tableName) + ".nextval " + " from dual");
            r.next();
            this.id = r.getInt(1);
        }
        catch (SQLException ex) {
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Connection connection, String tableName, int bufferLength) throws SQLException {
        this.closed = false;
        this.tableName = tableName;
        this.bufferLength = bufferLength;
        if (connection == null) {
            connection = TableWriter.newConnection();
        }
        this.connection = connection;
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            ResultSet r = stmt.executeQuery("select " + TableWriter.sequenceName(tableName) + ".nextval " + " from dual");
            r.next();
            this.id = r.getInt(1);
        }
        catch (SQLException ex) {
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private static Connection newConnection() throws SQLException {
        DriverManager.registerDriver((Driver)new OracleDriver());
        return DriverManager.getConnection("jdbc:oracle:kprb:@");
    }

    private static String sequenceName(String tableName) {
        boolean quoted = tableName.length() > 0 && tableName.charAt(tableName.length() - 1) == '\"';
        String result = quoted ? tableName.substring(0, tableName.length() - 1) + "_ID\"" : tableName + "_ID";
        return result;
    }

    public String toString() {
        return super.toString() + '(' + this.tableName + ')';
    }

    public void write(char[] chars, int off, int len) throws IOException {
        this.checkClosed();
        this.buffer.append(chars, off, len);
        if (this.buffer.length() >= this.bufferLength) {
            this.flush();
        }
    }
}

