/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.io.StringBufferInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class TableReader
extends InputStreamReader {
    private String tableName;

    public TableReader(Connection connection, String tableName) throws IOException {
        super(TableReader.inputStreamFor(connection, tableName));
    }

    private static IOException convert(SQLException ex) {
        ex.printStackTrace();
        return new IOException("converted SQLException " + ex);
    }

    public static InputStream inputStreamFor(Connection connection, String tableName) throws IOException {
        String insertCommand = "select text from " + tableName + " order by id, line";
        ResultSet query = null;
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(insertCommand);
            query = stmt.executeQuery();
            Vector<StringBufferInputStream> rows = new Vector<StringBufferInputStream>();
            while (query.next()) {
                rows.add(new StringBufferInputStream(query.getString(1)));
            }
            SequenceInputStream sequenceInputStream = new SequenceInputStream(rows.elements());
            return sequenceInputStream;
        }
        catch (SQLException e) {
            throw TableReader.convert(e);
        }
        finally {
            if (query != null) {
                try {
                    query.close();
                }
                catch (SQLException e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
        }
    }
}

