/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamUtils {
    public static int BUFF_SIZE = 4096;
    public static final long DATA_ARRIVAL_WAIT_TIME = 25L;

    private StreamUtils() {
    }

    public static int copyStream(InputStream src, OutputStream dst, int num) throws IOException {
        int totalCount = 0;
        byte[] buf = new byte[BUFF_SIZE];
        while (totalCount < num) {
            int count = BUFF_SIZE < num ? BUFF_SIZE : num;
            int bytesRead = src.read(buf, 0, count);
            if (bytesRead == 0) {
                try {
                    Thread.currentThread();
                    Thread.sleep(25L, 0);
                }
                catch (InterruptedException ie) {}
                continue;
            }
            if (bytesRead == -1) {
                src.close();
                if (totalCount != 0) break;
                totalCount = -1;
                break;
            }
            dst.write(buf, 0, bytesRead);
            totalCount += bytesRead;
            num -= bytesRead;
        }
        return totalCount;
    }

    public static int copyStream(InputStream src, OutputStream dst, boolean complete) throws IOException {
        int count;
        int total = 0;
        byte[] buf = new byte[BUFF_SIZE];
        while ((count = src.read(buf)) != -1) {
            if (count == 0) {
                try {
                    Thread.currentThread();
                    Thread.sleep(25L, 0);
                }
                catch (InterruptedException ie) {}
                continue;
            }
            dst.write(buf, 0, count);
            total += count;
        }
        src.close();
        if (complete) {
            dst.close();
        }
        return total;
    }

    private static int copyStreamByteByByte(InputStream src, OutputStream dst, int num) throws IOException {
        int tmp;
        int count = 0;
        while (num > 0 && (tmp = src.read()) != -1) {
            dst.write(tmp);
            ++count;
            --num;
        }
        return count;
    }

    private static int copyStreamByteByByte(InputStream src, OutputStream dst, boolean complete) throws IOException {
        int tmp;
        int count = 0;
        while ((tmp = src.read()) != -1) {
            dst.write(tmp);
            ++count;
        }
        src.close();
        if (complete) {
            dst.close();
        }
        return count;
    }
}

