/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.util.Properties;
import oracle.aurora.security.JServerPermission;
import oracle.aurora.util.AuroraRuntimeExtensions;
import oracle.aurora.util.BogusInputStream;
import oracle.aurora.util.ClassDescription;
import oracle.aurora.util.MCacheEntry;
import oracle.aurora.util.MSpecMethod;
import oracle.aurora.util.NoUnambiguousMethodException;
import oracle.aurora.util.RuntimeExtensions;

public class JRIExtensions {
    protected static final int libstatUnknown = 0;
    protected static final int libstatOk = 1;
    protected static final int libstatBad = 2;
    protected static int libstat = 0;
    private static ReflectPermission reflectPermission;
    public static final int tgenLessThan = 0;
    public static final int tgenGreaterThan = 1;
    public static final int tgenEqualTo = 2;
    public static final int tgenIncomparable = 3;
    public static String[] tgenNames;
    protected static boolean mCacheEnabled;
    protected static final String libName = "OraJRIExtensions";

    public static final boolean canLoad() {
        if (libstat == 0) {
            JRIExtensions.load();
        }
        return libstat == 1;
    }

    protected static void load() {
        if (RuntimeExtensions.getExtensions() instanceof AuroraRuntimeExtensions) {
            libstat = 1;
        } else {
            try {
                System.loadLibrary(libName);
                libstat = 1;
            }
            catch (UnsatisfiedLinkError e) {
                libstat = 2;
            }
        }
    }

    public static Object getField(Object obj, Field fld) {
        SecurityManager sm;
        if (reflectPermission == null) {
            reflectPermission = new ReflectPermission("suppressAccessChecks");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(reflectPermission);
        }
        JRIExtensions.canLoad();
        return JRIExtensions._getField(obj, fld);
    }

    public static int getNLoadedClasses() {
        JServerPermission.check((String)"JRIExtensions");
        JRIExtensions.canLoad();
        return JRIExtensions._getNLoadedClasses();
    }

    public static Class getLoadedClass(int idx) {
        JServerPermission.check((String)"JRIExtensions");
        JRIExtensions.canLoad();
        return JRIExtensions._getLoadedClass(idx);
    }

    public static Class[] getLoadedClasses() {
        Class[] results = new Class[JRIExtensions.getNLoadedClasses()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = JRIExtensions.getLoadedClass(i);
        }
        return results;
    }

    public static int getFieldSize(Class cls) {
        RuntimeExtensions ext = RuntimeExtensions.getExtensions();
        if (cls.isArray() || !cls.isPrimitive()) {
            return ext.referenceSize;
        }
        if (cls == Byte.TYPE) {
            return ext.byteSize;
        }
        if (cls == Boolean.TYPE) {
            return ext.booleanSize;
        }
        if (cls == Short.TYPE) {
            return ext.shortSize;
        }
        if (cls == Character.TYPE) {
            return ext.charSize;
        }
        if (cls == Integer.TYPE) {
            return ext.intSize;
        }
        if (cls == Long.TYPE) {
            return ext.longSize;
        }
        if (cls == Float.TYPE) {
            return ext.floatSize;
        }
        if (cls == Double.TYPE) {
            return ext.doubleSize;
        }
        throw new RuntimeException("class: " + cls.toString() + " is not handled");
    }

    public static int getObjectSize(Object obj) {
        Class<?> cls = obj.getClass();
        if (!cls.isArray()) {
            return ClassDescription.describe(cls).instSize;
        }
        return JRIExtensions.getFieldSize(cls.getComponentType()) * JRIExtensions.getArrayLength(obj) + RuntimeExtensions.getExtensions().arrayTypeOverhead;
    }

    public static int getArrayLength(Object obj) {
        Class<?> cls = obj.getClass();
        if (!cls.isArray()) {
            throw new RuntimeException(obj.toString() + " is not an array");
        }
        Class<?> ccls = cls.getComponentType();
        if (!ccls.isPrimitive()) {
            return ((Object[])obj).length;
        }
        if (ccls == Byte.TYPE) {
            return ((byte[])obj).length;
        }
        if (ccls == Boolean.TYPE) {
            return ((boolean[])obj).length;
        }
        if (ccls == Short.TYPE) {
            return ((short[])obj).length;
        }
        if (ccls == Character.TYPE) {
            return ((char[])obj).length;
        }
        if (ccls == Integer.TYPE) {
            return ((int[])obj).length;
        }
        if (ccls == Float.TYPE) {
            return ((float[])obj).length;
        }
        if (ccls == Long.TYPE) {
            return ((long[])obj).length;
        }
        if (ccls == Double.TYPE) {
            return ((double[])obj).length;
        }
        throw new RuntimeException("Unhandled array primitive component type: " + ccls.toString());
    }

    public static boolean wideningPrimitiveConvertable(Class cls1, Class cls2) {
        if (cls1 == Byte.TYPE) {
            return cls2 == Short.TYPE || cls2 == Integer.TYPE || cls2 == Long.TYPE || cls2 == Float.TYPE || cls2 == Double.TYPE;
        }
        if (cls1 == Short.TYPE || cls1 == Character.TYPE) {
            return cls2 == Integer.TYPE || cls2 == Long.TYPE || cls2 == Float.TYPE || cls2 == Double.TYPE;
        }
        if (cls1 == Integer.TYPE) {
            return cls2 == Long.TYPE || cls2 == Float.TYPE || cls2 == Double.TYPE;
        }
        if (cls1 == Long.TYPE) {
            return cls2 == Float.TYPE || cls2 == Double.TYPE;
        }
        if (cls1 == Float.TYPE) {
            return cls2 == Double.TYPE;
        }
        return false;
    }

    public static int compareTypes(Class cls1, Class cls2) {
        if (cls1 == cls2) {
            return 2;
        }
        if (cls1.isPrimitive()) {
            if (!cls2.isPrimitive()) {
                return 3;
            }
            if (JRIExtensions.wideningPrimitiveConvertable(cls1, cls2)) {
                return 0;
            }
            if (JRIExtensions.wideningPrimitiveConvertable(cls2, cls1)) {
                return 1;
            }
            return 3;
        }
        if (cls1.isAssignableFrom(cls2)) {
            return 1;
        }
        if (cls2.isAssignableFrom(cls1)) {
            return 0;
        }
        return 3;
    }

    public static int compareMethods(Method m1, Method m2) {
        if (!m1.getName().equals(m2.getName())) {
            throw new IllegalArgumentException("Methods have different names");
        }
        if (m1.getParameterTypes().length != m2.getParameterTypes().length) {
            throw new IllegalArgumentException("Methods have different arities");
        }
        if (m1 == m2) {
            return 2;
        }
        return JRIExtensions._compareMethods(m1, m2);
    }

    protected static int _compareMethods(Method m1, Method m2) {
        boolean allLessThan = true;
        boolean allGreaterThan = true;
        Class<?> m1cls = m1.getDeclaringClass();
        Class<?>[] m1ptypes = m1.getParameterTypes();
        int arity = m1ptypes.length;
        Class<?> m2cls = m2.getDeclaringClass();
        Class<?>[] m2ptypes = m2.getParameterTypes();
        block5: for (int idx = -1; idx < arity; ++idx) {
            if (idx >= 0) {
                m1cls = m1ptypes[idx];
                m2cls = m2ptypes[idx];
            }
            switch (JRIExtensions.compareTypes(m1cls, m2cls)) {
                case 0: {
                    if (!allLessThan) {
                        return 3;
                    }
                    allGreaterThan = false;
                    continue block5;
                }
                case 1: {
                    if (!allGreaterThan) {
                        return 3;
                    }
                    allLessThan = false;
                    continue block5;
                }
                case 3: {
                    return 3;
                }
            }
        }
        return allLessThan ? 0 : 1;
    }

    public static Method getMaximallySpecificMethod(Class cls, String name, Class[] formalPTypes) throws NoSuchMethodException, NoUnambiguousMethodException {
        if (formalPTypes == null) {
            throw new NoSuchMethodException("No applicable method found");
        }
        int arity = formalPTypes.length;
        Method[] methods = cls.getMethods();
        MSpecMethod firstCandidate = null;
        int nCandidates = 0;
        block0: for (int i = 0; i < methods.length; ++i) {
            Class<?>[] mptypes;
            Method m = methods[i];
            if (!m.getName().equals(name) || arity != (mptypes = m.getParameterTypes()).length) continue;
            for (int arg = 0; arg < arity; ++arg) {
                Class<?> mpcls = mptypes[arg];
                Class pcls = formalPTypes[arg];
                int comp = JRIExtensions.compareTypes(mpcls, pcls);
                if (comp == 0 || comp == 3) continue block0;
            }
            ++nCandidates;
            MSpecMethod candidate = firstCandidate;
            MSpecMethod lastCandidate = null;
            while (candidate != null) {
                int comp = JRIExtensions._compareMethods(m, candidate.method);
                if (comp == 0) {
                    if (lastCandidate != null) {
                        lastCandidate.next = candidate.next;
                    } else {
                        firstCandidate = candidate.next;
                    }
                } else {
                    lastCandidate = candidate;
                    if (comp == 1) continue block0;
                }
                candidate = candidate.next;
            }
            firstCandidate = new MSpecMethod(m, firstCandidate);
        }
        if (firstCandidate == null) {
            throw new NoSuchMethodException("No applicable method found");
        }
        if (firstCandidate.next != null) {
            String msg = "Ambiguous method selection, alternatives:\n";
            MSpecMethod candidate = firstCandidate;
            while (candidate != null) {
                msg = msg + "  " + candidate.method.toString() + "\n";
                candidate = candidate.next;
            }
            throw new NoUnambiguousMethodException(msg);
        }
        return firstCandidate.method;
    }

    protected static native String convertMethodName(byte[] var0);

    protected static native Class[] convertSignature(Class var0, byte[] var1);

    protected static Method getMaximallySpecificMethod(Class cls, byte[] methodName, byte[] signature) throws ClassNotFoundException, NoSuchMethodException, NoUnambiguousMethodException {
        MCacheEntry entry = null;
        if (mCacheEnabled) {
            entry = MCacheEntry.intern(cls, methodName, signature);
            if (entry.method != null) {
                return entry.method;
            }
        }
        Method result = JRIExtensions.getMaximallySpecificMethod(cls, JRIExtensions.convertMethodName(methodName), JRIExtensions.convertSignature(cls, signature));
        if (entry != null) {
            entry.method = result;
        }
        return result;
    }

    public static boolean enableSQLCallInCache(boolean enable) {
        boolean result = mCacheEnabled;
        mCacheEnabled = enable;
        if (!mCacheEnabled) {
            JRIExtensions.flushSQLCallInCache();
        }
        return result;
    }

    public static void flushSQLCallInCache() {
        MCacheEntry.mCache = null;
    }

    public static Properties loadProperties(Class cls, String pname) {
        InputStream in = cls.getResourceAsStream(pname);
        if (in != null) {
            BogusInputStream bin = new BogusInputStream(in);
            Properties result = new Properties();
            try {
                result.load(bin);
                in.close();
            }
            catch (IOException e) {
                try {
                    bin.close();
                }
                catch (IOException ee) {
                    // empty catch block
                }
                return null;
            }
            return result;
        }
        return null;
    }

    protected static native Object _getField(Object var0, Field var1);

    protected static native int _getNLoadedClasses();

    protected static native Class _getLoadedClass(int var0);

    static {
        tgenNames = new String[]{"tgenLessThan", "tgenGreaterThan", "tgenEqualTo", "tgenIncomparable"};
        mCacheEnabled = true;
    }
}

