/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import oracle.aurora.util.Assertion;
import oracle.aurora.util.Cursor;
import oracle.aurora.util.DynaHashCursor;
import oracle.aurora.util.DynaHashStats;
import oracle.aurora.util.HashBucket;
import oracle.aurora.util.Identifier;
import oracle.aurora.util.Iterator;
import oracle.aurora.util.Statistics;

public class DynaHash {
    protected Identifier ident;
    protected int bPower;
    protected int bMask;
    protected int dPower;
    protected int dMask;
    protected float fillFactor;
    protected int fillLimit;
    protected int lowLimit;
    protected HashBucket[] buckets;
    protected HashBucket first;
    protected static Assertion oassert = new Assertion();
    public static final int DEF_BPOWER = 8;
    public static final int DEF_INIT_DPOWER = 3;
    public static final float DEF_FILL = 0.7f;
    public static final float DEF_LOW = 0.4f;
    protected static final float MIN_SPLIT_FRACTION = 0.1f;
    public static final Identifier DEF_IDENT = new Identifier(){

        public int hash(Object obj) {
            return System.identityHashCode(obj);
        }

        public int findHash(Object obj) {
            return System.identityHashCode(obj);
        }

        public boolean identify(Object obj1, Object obj2) {
            return obj1 == obj2;
        }

        public boolean findIdentify(Object obj1, Object obj2) {
            return obj1 == obj2;
        }
    };

    public DynaHash() {
        this(DEF_IDENT, 8, 3, 0.7f, 0.4f);
    }

    public DynaHash(Identifier ident) {
        this(ident, 8, 3, 0.7f, 0.4f);
    }

    public DynaHash(Identifier ident, int bPower) {
        this(ident, bPower, 3, 0.7f, 0.4f);
    }

    public DynaHash(Identifier ident, int bPower, int initDPower) {
        this(ident, bPower, initDPower, 0.7f, 0.4f);
    }

    public DynaHash(Identifier ident, int bPower, int initDPower, float fill) {
        this(ident, bPower, initDPower, fill, 0.4f);
    }

    public DynaHash(Identifier ident, int bPower, int initDPower, float fill, float low) {
        this.ident = ident;
        this.bPower = bPower;
        this.bMask = (1 << bPower) - 1;
        this.dPower = 0;
        this.dMask = 0;
        this.buckets = new HashBucket[1 << initDPower];
        this.buckets[0] = this.first = new HashBucket(null, bPower, 0);
        this.fillFactor = fill;
        this.fillLimit = (int)(this.fillFactor * (float)(1 << bPower));
        this.lowLimit = (int)(low * (float)(1 << bPower));
    }

    public static int getValueHash(byte[] vect) {
        int h = 97169;
        int q = 0;
        for (int i = 0; i < vect.length; ++i) {
            q = vect[i];
            h = ((q ^= h) << 4) + q;
        }
        return h;
    }

    public static int getValueHash(char[] vect) {
        int h = 97169;
        int q = 0;
        for (int i = 0; i < vect.length; ++i) {
            q = vect[i];
            h = ((q ^= h) << 8) + q;
        }
        return h;
    }

    public static int getValueHash(short[] vect) {
        int h = 97169;
        int q = 0;
        for (int i = 0; i < vect.length; ++i) {
            q = vect[i];
            h = ((q ^= h) << 8) + q;
        }
        return h;
    }

    public static int getValueHash(int[] vect) {
        int h = 97169;
        int q = 0;
        for (int i = 0; i < vect.length; ++i) {
            q = vect[i];
            h = ((q ^= h) << 16) + q;
        }
        return h;
    }

    public static int getValueHash(long[] vect) {
        int h = 97169;
        int q = 0;
        for (int i = 0; i < vect.length; ++i) {
            q = (int)vect[i];
            q ^= h;
            h = (q << 16) + q;
            q = (int)(vect[i] >> 16);
            q ^= h;
            h = (q << 16) + q;
        }
        return h;
    }

    public static int getValueHash(float[] vect) {
        int h = 97169;
        int q = 0;
        for (int i = 0; i < vect.length; ++i) {
            q = Float.floatToIntBits(vect[i]);
            h = ((q ^= h) << 16) + q;
        }
        return h;
    }

    public static int getValueHash(double[] vect) {
        int h = 97169;
        int q = 0;
        for (int i = 0; i < vect.length; ++i) {
            long bits = Double.doubleToLongBits(vect[i]);
            q = (int)bits;
            q ^= h;
            h = (q << 16) + q;
            q = (int)(bits >> 16);
            q ^= h;
            h = (q << 16) + q;
        }
        return h;
    }

    public static int getValueHash(Object[] vect) {
        int result = 0;
        for (int i = 0; i < vect.length; ++i) {
            if (vect[i] == null) continue;
            result ^= vect[i].hashCode();
        }
        return result;
    }

    public static boolean getValueEquality(byte[] vect1, byte[] vect2) {
        if (vect1.length != vect2.length) {
            return false;
        }
        for (int i = 0; i < vect1.length; ++i) {
            if (vect1[i] == vect2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean getValueEquality(char[] vect1, char[] vect2) {
        if (vect1.length != vect2.length) {
            return false;
        }
        for (int i = 0; i < vect1.length; ++i) {
            if (vect1[i] == vect2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean getValueEquality(short[] vect1, short[] vect2) {
        if (vect1.length != vect2.length) {
            return false;
        }
        for (int i = 0; i < vect1.length; ++i) {
            if (vect1[i] == vect2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean getValueEquality(int[] vect1, int[] vect2) {
        if (vect1.length != vect2.length) {
            return false;
        }
        for (int i = 0; i < vect1.length; ++i) {
            if (vect1[i] == vect2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean getValueEquality(long[] vect1, long[] vect2) {
        if (vect1.length != vect2.length) {
            return false;
        }
        for (int i = 0; i < vect1.length; ++i) {
            if (vect1[i] == vect2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean getValueEquality(float[] vect1, float[] vect2) {
        if (vect1.length != vect2.length) {
            return false;
        }
        for (int i = 0; i < vect1.length; ++i) {
            if (vect1[i] == vect2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean getValueEquality(double[] vect1, double[] vect2) {
        if (vect1.length != vect2.length) {
            return false;
        }
        for (int i = 0; i < vect1.length; ++i) {
            if (vect1[i] == vect2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean getValueEquality(Object[] vect1, Object[] vect2) {
        if (vect1.length != vect2.length) {
            return false;
        }
        for (int i = 0; i < vect1.length; ++i) {
            if (!vect1[i].equals(vect2[i])) continue;
            return false;
        }
        return true;
    }

    public Identifier getIdentifier() {
        return this.ident;
    }

    public boolean contains(Object obj) {
        int hash = this.ident == null ? obj.hashCode() : this.ident.hash(obj);
        HashBucket hb = this.buckets[hash & this.dMask];
        return hb.probe(this, obj, hash, false) != -1;
    }

    public Object find(Object obj) {
        int hash = this.ident == null ? obj.hashCode() : this.ident.findHash(obj);
        HashBucket hb = this.buckets[hash & this.dMask];
        int idx = hb.probe(this, obj, hash, false);
        return idx == -1 ? null : hb.tab[idx];
    }

    public Object insert(Object obj) {
        int hash = this.ident == null ? obj.hashCode() : this.ident.hash(obj);
        HashBucket hb = this.buckets[hash & this.dMask];
        int idx = hb.probe(this, obj, hash, true);
        if (hb.tab[idx] != null && hb.tab[idx] != HashBucket.deleted) {
            return hb.tab[idx];
        }
        if (hb.tab[idx] == HashBucket.deleted) {
            --hb.removed;
        }
        hb.tab[idx] = obj;
        ++hb.size;
        this.checkIfFull(hb);
        return null;
    }

    protected void reinsert(Object obj) {
        int hash = this.ident == null ? obj.hashCode() : this.ident.hash(obj);
        HashBucket hb = this.buckets[hash & this.dMask];
        hb.tab[hb.probe((DynaHash)this, (Object)obj, (int)hash, (boolean)true)] = obj;
        ++hb.size;
    }

    public Object replace(Object obj) {
        int hash = this.ident == null ? obj.hashCode() : this.ident.hash(obj);
        HashBucket hb = this.buckets[hash & this.dMask];
        int idx = hb.probe(this, obj, hash, true);
        if (hb.tab[idx] != null && hb.tab[idx] != HashBucket.deleted) {
            Object old = hb.tab[idx];
            hb.tab[idx] = obj;
            return old;
        }
        if (hb.tab[idx] == HashBucket.deleted) {
            --hb.removed;
        }
        hb.tab[idx] = obj;
        ++hb.size;
        this.checkIfFull(hb);
        return null;
    }

    public Object remove(Object obj) {
        int hash = this.ident == null ? obj.hashCode() : this.ident.findHash(obj);
        HashBucket hb = this.buckets[hash & this.dMask];
        int idx = hb.probe(this, obj, hash, false);
        if (idx == -1) {
            return null;
        }
        Object old = hb.tab[idx];
        hb.tab[idx] = HashBucket.deleted;
        --hb.size;
        ++hb.removed;
        this.checkIfLow(hb);
        return old;
    }

    public Cursor enumerate() {
        return new DynaHashCursor(this);
    }

    public void iterate(Iterator itr) {
        DynaHashCursor curs = new DynaHashCursor(this);
        while (curs.next()) {
            itr.eval(curs.get());
        }
    }

    public int dirSize() {
        return this.buckets.length;
    }

    public int buckets() {
        int result = 0;
        HashBucket hb = this.first;
        while (hb != null) {
            ++result;
            hb = hb.next;
        }
        return result;
    }

    public int bucketSize() {
        return 1 << this.bPower;
    }

    public int bucketCapacity() {
        return this.fillLimit;
    }

    public int size() {
        int result = 0;
        HashBucket hb = this.first;
        while (hb != null) {
            result += hb.size;
            hb = hb.next;
        }
        return result;
    }

    public int capacity() {
        return this.buckets() * this.fillLimit;
    }

    public boolean isFixed(HashBucket hb) {
        return hb.tab.length == 1 << this.bPower;
    }

    public DynaHashStats getStats() {
        DynaHashStats st = new DynaHashStats();
        st.dirSize = this.dirSize();
        st.fixedBucketSize = 1 << this.bPower;
        Statistics overflowBucketSize = new Statistics();
        st.fixedBucketCapacity = this.bucketCapacity();
        Statistics overflowBucketCapacity = new Statistics();
        Statistics totalSize = new Statistics();
        Statistics fixedSize = new Statistics();
        Statistics overflowSize = new Statistics();
        Statistics utilization = new Statistics();
        Statistics fixedUtilization = new Statistics();
        Statistics overflowUtilization = new Statistics();
        Statistics deleted = new Statistics();
        Statistics succ = new Statistics();
        Statistics fail = new Statistics();
        HashBucket hb = this.first;
        while (hb != null) {
            totalSize.sample(hb.size);
            float util = (float)hb.size / ((float)hb.tab.length * this.fillFactor);
            utilization.sample(util);
            if (hb.tab.length == 1 << this.bPower) {
                fixedSize.sample(hb.size);
                fixedUtilization.sample(util);
            } else {
                overflowBucketSize.sample(hb.tab.length);
                overflowBucketCapacity.sample((float)hb.tab.length * this.fillFactor);
                overflowSize.sample(hb.size);
                overflowUtilization.sample(util);
            }
            deleted.sample((float)hb.removed / (float)hb.tab.length);
            for (int i = 0; i < hb.tab.length; ++i) {
                if (hb.tab[i] == null) continue;
                if (hb.tab[i] == HashBucket.deleted) continue;
                int hash = this.ident == null ? hb.tab[i].hashCode() : this.ident.hash(hb.tab[i]);
                succ.sample(hb.succProbeLength(this, hb.tab[i], hash));
                fail.sample(hb.failProbeLength(this, hash));
            }
            hb = hb.next;
        }
        st.buckets = totalSize.nSamples();
        st.fixedBuckets = fixedSize.nSamples();
        st.overflowBuckets = overflowSize.nSamples();
        st.meanOverflowBucketSize = (float)overflowBucketSize.mean();
        st.sigmaOverflowBucketSize = (float)overflowBucketSize.stdDev();
        st.meanOverflowBucketCapacity = (float)overflowBucketCapacity.mean();
        st.sigmaOverflowBucketCapacity = (float)overflowBucketCapacity.stdDev();
        st.totalSize = (int)totalSize.total();
        st.fixedSize = (int)fixedSize.total();
        st.overflowSize = (int)overflowSize.total();
        st.fixedCapacity = st.fixedBuckets * st.fixedBucketCapacity;
        st.overflowCapacity = (int)overflowBucketCapacity.total();
        st.capacity = st.fixedCapacity + st.overflowCapacity;
        st.dirUtilization = (float)st.buckets / (float)st.dirSize;
        st.meanUtilization = (float)utilization.mean();
        st.meanFixedUtilization = (float)fixedUtilization.mean();
        st.meanOverflowUtilization = (float)overflowUtilization.mean();
        st.sigmaUtilization = (float)utilization.stdDev();
        st.sigmaFixedUtilization = (float)fixedUtilization.stdDev();
        st.sigmaOverflowUtilization = (float)overflowUtilization.stdDev();
        st.meanDeleted = (float)deleted.mean();
        st.sigmaDeleted = (float)deleted.stdDev();
        st.meanSuccProbeLength = (float)succ.mean();
        st.sigmaSuccProbeLength = (float)succ.stdDev();
        st.meanFailProbeLength = (float)fail.mean();
        st.sigmaFailProbeLength = (float)fail.stdDev();
        return st;
    }

    protected final void checkIfFull(HashBucket hb) {
        if (hb.tab.length == 1 << this.bPower) {
            if (hb.size > this.fillLimit) {
                this.split(hb);
            }
        } else if (hb.size > (int)(this.fillFactor * (float)hb.tab.length)) {
            hb.grow(this);
        }
    }

    protected HashBucket prev(HashBucket hb) {
        if (this.first == hb) {
            return null;
        }
        HashBucket prev = this.first;
        while (prev != null) {
            if (prev.next == hb) {
                return prev;
            }
            prev = prev.next;
        }
        Assertion.oassert(false);
        return null;
    }

    protected void unlink(HashBucket hb) {
        if (this.first == hb) {
            this.first = hb.next;
            hb.next = null;
            return;
        }
        HashBucket prev = this.prev(hb);
        prev.next = hb.next;
        hb.next = null;
    }

    protected void split(HashBucket hb) {
        float fraction;
        int wild = ~hb.select & this.dMask;
        if (wild == 0) {
            this.grow();
            wild = ~hb.select & this.dMask;
        }
        int pMask = 1;
        while ((wild & pMask) == 0) {
            pMask <<= 1;
        }
        this.unlink(hb);
        HashBucket hb0 = this.first = new HashBucket(this.first, this.bPower, hb.select | pMask);
        HashBucket hb1 = this.first = new HashBucket(this.first, this.bPower, hb.select | pMask);
        for (int i = 0; i < 1 << this.dPower; ++i) {
            if (this.buckets[i] != hb) continue;
            this.buckets[i] = (i & pMask) == 0 ? hb0 : hb1;
        }
        hb.reinsert(this, false);
        float f = fraction = hb0.size <= hb1.size ? (float)hb0.size / (float)(hb0.size + hb1.size) : (float)hb1.size / (float)(hb0.size + hb1.size);
        if (fraction >= 0.1f) {
            return;
        }
        this.unlink(hb1);
        this.unlink(hb0);
        hb.next = this.first;
        this.first = hb;
        for (int i = 0; i < 1 << this.dPower; ++i) {
            if (this.buckets[i] != hb0 && this.buckets[i] != hb1) continue;
            this.buckets[i] = hb;
        }
        hb.grow(this);
    }

    protected void grow() {
        if (this.buckets.length < 1 << this.dPower + 1) {
            HashBucket[] ob = this.buckets;
            this.buckets = new HashBucket[1 << this.dPower + 1];
            for (int i = 0; i < ob.length; ++i) {
                this.buckets[i] = ob[i];
            }
        }
        for (int i = 0; i < 1 << this.dPower; ++i) {
            this.buckets[i + (1 << this.dPower)] = this.buckets[i];
        }
        ++this.dPower;
        this.dMask = (1 << this.dPower) - 1;
    }

    protected final void checkIfLow(HashBucket hb) {
        if (hb.size == 0 || hb.removed > this.lowLimit && hb.size < this.fillLimit / 2) {
            this.merge(hb);
        }
    }

    protected void merge(HashBucket hb) {
        if (hb.select == 0) {
            return;
        }
        int pMask = 1 << this.dPower - 1;
        while ((hb.select & pMask) == 0) {
            pMask >>= 1;
        }
        for (int i = 0; i < 1 << this.dPower; ++i) {
            if (this.buckets[i] != hb) continue;
            int alt = (i & pMask) == 0 ? i | pMask : i & ~pMask;
            this.buckets[alt].select &= ~pMask;
            this.buckets[i] = this.buckets[alt];
        }
        this.unlink(hb);
        hb.reinsert(this, true);
    }

    protected void checkIntegrity() {
        Assertion.oassert(this.bMask == (1 << this.bPower) - 1);
        for (int i = 0; i < 1 << this.dPower; ++i) {
            Assertion.oassert(this.buckets[i] != null);
            this.buckets[i].checkIntegrity(this, i);
        }
    }
}

