/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.shell;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import oracle.aurora.rdbms.ExecutePermissionException;
import oracle.aurora.server.tools.shell.ToolImpl;
import oracle.aurora.util.tools.ToolException;
import oracle.aurora.vm.ClassNotResolvedException;
import oracle.aurora.vm.EnvironmentSpecific;

public class Java
extends ToolImpl {
    public String className;
    public String schema;
    public static String setschema;
    public String[] args = new String[0];
    static final String MAIN = "main";

    public void invoke() throws ToolException {
        String classNameAndSchema = this.schema == null ? this.className : this.schema + ":" + this.className;
        Class cls = null;
        try {
            cls = this.schema == null ? EnvironmentSpecific.classForNameAndSchema(this.className, -2, 1) : EnvironmentSpecific.classForNameAndSchema(this.className, this.schema);
        }
        catch (IllegalArgumentException e) {
            this.error("Schema doesn't exist: " + this.schema);
        }
        catch (ExecutePermissionException ep) {
            this.fail1("NO_PERMISSION", ep.toString());
        }
        catch (ClassNotResolvedException ep) {
            this.error("Class cannot be resolved: " + ep.toString());
        }
        catch (ClassNotFoundException cnf) {
            this.fail1("CLASS_NOT_FOUND", this.schema == null ? this.className : this.schema + ":" + this.className);
        }
        final ClassLoader loader = cls.getClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(loader);
                return null;
            }
        });
        Method method = null;
        try {
            method = cls.getMethod(MAIN, this.args.getClass());
        }
        catch (NoSuchMethodException nsm) {
            this.fail1("NOT_FOUND", (this.schema == null ? this.className : this.schema + ":" + this.className) + "." + MAIN);
        }
        catch (IllegalArgumentException iar) {
            iar.printStackTrace();
        }
        try {
            method.invoke(null, new Object[]{this.args});
        }
        catch (InvocationTargetException it) {
            Throwable t = it.getTargetException();
            StackTraceElement[] ste = t.getStackTrace();
            int nf = ste.length;
            int ntos = 0;
            for (int i = nf - 1; i >= 0; --i) {
                if (ste[i].getMethodName().indexOf(MAIN) == -1) continue;
                ntos = i;
                break;
            }
            StackTraceElement[] nste = new StackTraceElement[ntos + 1];
            System.arraycopy(ste, 0, nste, 0, ntos + 1);
            t.setStackTrace(nste);
            t.printStackTrace();
        }
        catch (ExceptionInInitializerError e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException iac) {
            this.error("Class is not public: " + (this.schema == null ? this.className : this.schema + ":" + this.className));
        }
    }

    protected void parseArgs(String[] argv) throws ToolException {
        if (argv.length == 0) {
            this.error(this.usage());
        }
        if (argv[0].equals("-schema")) {
            if (argv.length == 1) {
                this.error(this.usage());
            }
            this.schema = argv[1];
            String[] newArgs = new String[argv.length - 2];
            System.arraycopy(argv, 2, newArgs, 0, argv.length - 2);
            argv = newArgs;
        }
        if (argv[0].equals("setschema")) {
            setschema = argv[1];
            return;
        }
        if (this.schema == null && argv[0].indexOf(58) == -1) {
            this.schema = setschema;
        }
        if (argv.length == 0) {
            this.error(this.usage());
        }
        this.className = argv[0];
        if (argv.length == 1) {
            return;
        }
        this.args = new String[argv.length - 1];
        System.arraycopy(argv, 1, this.args, 0, argv.length - 1);
        if (this.schema != null && this.className.indexOf(58) != -1) {
            this.fail0("CONFLICTING_SCHEMA");
        }
    }
}

