/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Vector;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.InvalidResolverPatternException;
import oracle.aurora.rdbms.KGEException;
import oracle.aurora.rdbms.ModifyPermissionException;
import oracle.aurora.rdbms.NameInUseException;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.Resolver;
import oracle.aurora.rdbms.ResourceHandle;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.SchemaNotFoundException;
import oracle.aurora.rdbms.SourceHandle;
import oracle.aurora.rdbms.WouldReplaceException;
import oracle.aurora.security.JServerPermission;
import oracle.aurora.server.tools.loadjava.CommonClassObject;
import oracle.aurora.server.tools.loadjava.CommonSourceObject;
import oracle.aurora.server.tools.loadjava.Deploy;
import oracle.aurora.server.tools.loadjava.LoadJavaOptions;
import oracle.aurora.server.tools.loadjava.LoadJavaState;
import oracle.aurora.server.tools.loadjava.MkMsg;
import oracle.aurora.server.tools.loadjava.SchemaObject;
import oracle.aurora.util.IOCopy;
import oracle.aurora.util.msg.Msg;
import oracle.aurora.vm.OracleRuntime;
import sqlj.framework.ide.aurora.AuroraCustomizer;

class ServerSchemaObject
extends SchemaObject {
    private Msg mkMsg = MkMsg.mkMsg;
    Schema serverSchema;
    CommonClassObject class_helper = null;
    CommonSourceObject source_helper = null;
    String name = null;
    protected String shortname = null;
    protected Handle h_;

    ServerSchemaObject(LoadJavaState state, LoadJavaOptions opt, int type, InputStream in, String externalName) {
        super(state, opt, type, in, externalName);
        switch (type) {
            case 29: {
                if (in != null) break;
                this.name = externalName;
                break;
            }
            case 1002: {
                this.path = externalName;
                this.fullJarname = this.getExternalName();
                if (!this.fullJarname.startsWith("/")) break;
                this.fullJarname = "ROOT" + this.fullJarname;
                break;
            }
            case 1001: {
                this.name = externalName;
                break;
            }
        }
    }

    CommonSourceObject getSourceHelper() {
        if (this.source_helper == null) {
            this.source_helper = new CommonSourceObject(this);
        }
        return this.source_helper;
    }

    CommonClassObject getClassHelper() {
        if (this.class_helper == null) {
            this.class_helper = new CommonClassObject(this);
        }
        return this.class_helper;
    }

    Schema getServerSchema() {
        if (this.serverSchema == null) {
            String schemaName = this.getSchema();
            this.serverSchema = schemaName == null ? Schema.currentSchema() : Schema.lookup(schemaName);
            if (this.serverSchema == null) {
                this.err(this.mkMsg.m("there is no schema named {0}", schemaName));
                this.serverSchema = Schema.noSchema;
            }
        }
        return this.serverSchema;
    }

    String getName() {
        if (this.name == null) {
            switch (this.type) {
                case 29: {
                    this.name = this.getClassHelper().getClassName();
                    if (this.name != null) break;
                    this.name = this.getExternalName();
                    break;
                }
                case 28: {
                    String externalName = this.getExternalName();
                    String encoding = this.getOptsForName(externalName).getEncoding();
                    this.name = this.getSourceHelper().getSourceName(externalName, this.getRepeatableInputStream(), encoding);
                    break;
                }
                case 1002: {
                    this.name = this.fullJarname;
                    break;
                }
                default: {
                    this.name = this.getExternalName();
                }
            }
        }
        return this.name;
    }

    Handle getHandle() {
        if (this.h_ == null) {
            String lookupname = this.getPerhapsJarQualifiedName();
            this.h_ = Handle.lookup(lookupname, this.getServerSchema(), this.type);
        }
        return this.h_;
    }

    byte[] getMD5() {
        byte[] md5Bytes = null;
        Handle h = this.getHandle();
        if (h != null) {
            try {
                md5Bytes = h.getMD5();
            }
            catch (ObjectTypeChangedException ex) {
                this.err(ex, this.mkMsg.m("getting MD5 of {0}", this.toString()));
            }
        }
        return md5Bytes;
    }

    boolean deleteMD5() {
        return this.type != 1002;
    }

    byte[] getNewMD5() {
        return OracleRuntime.computeMD5(this.getBytes());
    }

    boolean updateMD5(boolean ok) {
        if (this.type == 1002) {
            return ok;
        }
        return true;
    }

    boolean create() {
        if (this.type == 29 || this.type == 30 || this.type == 28) {
            try {
                byte[] bytes = this.getBytes();
                String name = this.getName();
                if (name == null) {
                    return false;
                }
                Schema schema = this.getServerSchema();
                boolean definers = this.getOpts().getDefiners();
                boolean replaceOnlyIfChanged = !this.getOpts().getForce();
                boolean andResolve = this.getOpts().getAndResolve();
                String resolverSpec = this.getOpts().getResolver();
                Resolver resolver = resolverSpec != null ? new Resolver(resolverSpec) : null;
                switch (this.type) {
                    case 29: {
                        if (bytes == null || bytes.length == 0) {
                            this.err(name + " class has zero length");
                            return false;
                        }
                        JServerPermission.check((String)("LoadClassInPackage." + name.replace('/', '.')));
                        this.h_ = ClassHandle.create(bytes, schema, resolver, definers, true, replaceOnlyIfChanged, andResolve);
                        break;
                    }
                    case 28: {
                        if (this.getOpts().getEncoding() != null) {
                            try {
                                String encoding = this.getOpts().getEncoding();
                                IOCopy encCopy = new IOCopy(encoding);
                                Reader r = encCopy.toReader(bytes, name);
                                IOCopy utf8Copy = new IOCopy("UTF8");
                                bytes = utf8Copy.toEncoded(r);
                            }
                            catch (IOException ioex) {
                                this.err(ioex, this.mkMsg.m("converting {0} to UTF8 ", this.toString()));
                            }
                        }
                        this.h_ = SourceHandle.create(bytes, name, schema, resolver, definers, replaceOnlyIfChanged, andResolve);
                        break;
                    }
                    case 30: {
                        if (name.endsWith(".ser") && name.lastIndexOf("_SJProfile") >= 0) {
                            bytes = AuroraCustomizer.customize((String)name.replace('/', '.').replace(File.separatorChar, '.'), (byte[])bytes, (int)schema.ownerNumber());
                        }
                        this.h_ = ResourceHandle.create(bytes, name, schema, true);
                    }
                }
                if (this.h_ != null) {
                    return true;
                }
            }
            catch (SchemaNotFoundException ex) {
                this.err(ex, this.mkMsg.m("creating {0}", this.toString()));
            }
            catch (InvalidResolverPatternException ex) {
                this.err(ex, this.mkMsg.m("creating {0}", this.toString()));
            }
            catch (ModifyPermissionException ex) {
                this.err(ex, this.mkMsg.m("creating {0}", this.toString()));
            }
            catch (WouldReplaceException ex) {
                this.err(ex, this.mkMsg.m("creating {0}", this.toString()));
            }
            catch (NameInUseException ex) {
                this.err(ex, this.mkMsg.m("creating {0}", this.toString()));
            }
            catch (IOException ex) {
                this.err(ex, this.mkMsg.m("creating {0}", this.toString()));
            }
            return false;
        }
        if (this.type == 1002) {
            int status = DbmsJava.startLoadingJar(this.fullJarname, this.getServerSchema(), this.path, 1 | (this.prependName ? 4 : 0) | (this.nested ? 8 : 0), this.getRepeatableInputStream());
            return this.checkStartLoadingStatus(status, this.getServerSchema().toString(), DbmsJava.jarLoadingRdbmsErrorMessage);
        }
        if (this.type == 1001) {
            Deploy.checkPermission();
            final String filename = this.getName();
            final InputStream input = this.getInputStream();
            boolean done = false;
            if (input == null) {
                this.err(this.mkMsg.m("cannot determine input stream"));
            } else {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            FileOutputStream fileOut = new FileOutputStream(ServerSchemaObject.this.mkFile(filename));
                            new IOCopy().copy(fileOut, input);
                            return null;
                        }
                    });
                    done = true;
                }
                catch (PrivilegedActionException ex) {
                    this.err(ex.getException(), this.mkMsg.m("deploying {0}", filename));
                }
            }
            return done;
        }
        return false;
    }

    int status() {
        switch (this.type) {
            case 28: 
            case 29: 
            case 30: {
                Handle h = this.getHandle();
                int serverStatus = 5;
                int result = h != null ? (h.type() == 30 ? 1 : (h.status() == 1 ? 1 : 0)) : 3;
                return result;
            }
            case 1002: {
                int status = DbmsJava.jarStatus(this.fullJarname, this.getServerSchema());
                return this.checkStatusStatus(status, "rdbms error");
            }
            case 1001: {
                boolean ok = this.mkFile(this.getName()).exists();
                return ok ? 1 : 3;
            }
        }
        return 3;
    }

    boolean resolve() {
        if (this.type == 29 || this.type == 30 || this.type == 28) {
            Handle h = this.getHandle();
            boolean done = false;
            if (h != null) {
                try {
                    if (h.type() == 30) {
                        done = true;
                    } else {
                        int serverStatus = h.resolve();
                        if (serverStatus == 1) {
                            done = true;
                        }
                    }
                }
                catch (ModifyPermissionException ex) {
                    this.err(ex, this.mkMsg.m("resolving {0}", this.toString()));
                }
                catch (ObjectTypeChangedException ex) {
                    this.err(ex, this.mkMsg.m("resolving {0}", this.toString()));
                }
            }
            return done;
        }
        return true;
    }

    boolean drop() {
        switch (this.type) {
            case 28: 
            case 29: 
            case 30: {
                Handle h = this.getHandle();
                boolean done = false;
                if (h != null) {
                    try {
                        h.drop();
                        done = true;
                    }
                    catch (KGEException ignore) {
                        this.err(ignore, this.mkMsg.m("dropping {0}", this.toString()));
                    }
                }
                return done;
            }
            case 1002: {
                if (this.nested) {
                    return true;
                }
                int status = DbmsJava.dropJar(this.fullJarname, this.getServerSchema());
                return this.checkDropStatus(status, DbmsJava.jarLoadingRdbmsErrorMessage);
            }
        }
        return true;
    }

    boolean grant(String grantees) {
        if (this.type == 29 || this.type == 30 || this.type == 28) {
            String[] targets = this.getOpts().getGrantNamesAsStrings(this.getLog());
            boolean ok = true;
            for (int xTarget = 0; xTarget < targets.length; ++xTarget) {
                ok = this.grantOne(targets[xTarget]) && ok;
            }
            return ok;
        }
        return true;
    }

    Schema lookup(String userOrRole) {
        Schema userSchema = Schema.lookup(userOrRole);
        if (userSchema == null) {
            userSchema = Schema.lookupRole(userOrRole);
        }
        if (userSchema == null) {
            this.err(this.mkMsg.m("user {0} does not exist ", userOrRole));
        }
        return userSchema;
    }

    boolean grantOne(String user) {
        boolean ok = false;
        Schema s = this.lookup(user);
        Handle h = this.getHandle();
        if (h == null) {
            this.err(this.mkMsg.m("could not find {0}", this.toString()));
        }
        if (h != null && s != null) {
            try {
                h.grantExecutePrivilege(s);
                ok = true;
            }
            catch (ModifyPermissionException ex) {
                this.err(ex, this.mkMsg.m(" granting execute on {0} to {1}", this.toString(), user));
            }
            catch (ObjectTypeChangedException ex) {
                this.err(ex, this.mkMsg.m(" granting execute on {0} to {1}", this.toString(), user));
            }
        }
        if (this.type == 28) {
            Enumeration dependents = this.getSourceHelper().getDependentClasses().elements();
            while (dependents.hasMoreElements()) {
                SchemaObject dependent = (SchemaObject)dependents.nextElement();
                this.msg(this.mkMsg.m("granting : execute on {0} to {1}", dependent.toString(), user));
                ok = dependent.grant(user) && ok;
            }
        }
        return ok;
    }

    boolean revoke(String grantee) {
        if (this.type == 1002 || this.type == 1001) {
            return true;
        }
        boolean ok = false;
        Schema s = this.lookup(grantee);
        Handle h = this.getHandle();
        if (h == null) {
            this.err(this.mkMsg.m("could not find {0}", this.toString()));
        }
        if (h != null && s != null) {
            try {
                h.revokeExecutePrivilege(s);
                ok = true;
            }
            catch (ModifyPermissionException ex) {
                this.err(ex, this.mkMsg.m(" granting execute on {0} to {1}", this.toString(), grantee));
            }
            catch (ObjectTypeChangedException ex) {
                this.err(ex, this.mkMsg.m(" granting execute on {0} to {1}", this.toString(), grantee));
            }
        }
        if (this.type == 28) {
            ok = this.getSourceHelper().depend_revoke(grantee) && ok;
        }
        return ok;
    }

    boolean synonym() {
        switch (this.type) {
            case 29: {
                return this.getState().getJdbc().synonym(this);
            }
            case 28: {
                Vector dependents = this.getSourceHelper().getDependentClasses();
                Enumeration classes = dependents.elements();
                boolean ok = true;
                while (classes.hasMoreElements()) {
                    SchemaObject classObject = (SchemaObject)classes.nextElement();
                    if (classObject.synonym()) continue;
                    ok = false;
                }
                return ok;
            }
            case 30: {
                return this.grant("PUBLIC");
            }
        }
        return true;
    }

    boolean dropSynonym() {
        if (this.type == 29 || this.type == 30 || this.type == 28) {
            return this.getState().getJdbc().dropSynonym(this);
        }
        return true;
    }

    Enumeration allGrants() {
        if (this.type == 29 || this.type == 30 || this.type == 28) {
            return this.getState().getJdbc().allGrantees(this);
        }
        return null;
    }

    boolean shortnameKnown() {
        return this.shortname != null;
    }

    String getShortname() {
        if (this.shortname == null) {
            switch (this.type) {
                case 28: 
                case 29: 
                case 30: {
                    this.shortname = DbmsJava.shortName(this.getPerhapsJarQualifiedName());
                    break;
                }
                case 1002: {
                    this.shortname = DbmsJava.shortName(this.fullJarname);
                }
                default: {
                    this.shortname = this.getName();
                }
            }
        }
        return this.shortname;
    }

    byte[] getOldMD5() {
        if (this.type == 29 || this.type == 30 || this.type == 28) {
            return this.getMD5();
        }
        return null;
    }

    boolean invoke() {
        boolean ok = false;
        try {
            ok = Deploy.invoke(this.getSchema(), this.getName().replace('/', '.')) == null;
        }
        catch (Exception e) {
            this.err(e, "Deploy invocation failed");
        }
        return ok;
    }

    boolean definer(boolean flag) {
        if (this.type == 29 || this.type == 30 || this.type == 28) {
            boolean result;
            try {
                Handle h = this.getHandle();
                if (h != null) {
                    h.setDefiners(flag);
                }
                result = true;
            }
            catch (KGEException kge) {
                result = false;
            }
            return result;
        }
        return true;
    }

    boolean resolver(String spec) {
        if (this.type == 29 || this.type == 28) {
            boolean result;
            try {
                Handle h = this.getHandle();
                if (h != null) {
                    h.setResolver(new Resolver(spec));
                }
                result = true;
            }
            catch (InvalidResolverPatternException ex) {
                result = false;
            }
            catch (SchemaNotFoundException ex) {
                result = false;
            }
            catch (KGEException kge) {
                result = false;
            }
            return result;
        }
        return true;
    }

    boolean useEbcdicShortening() {
        if (this.type == 29 || this.type == 30 || this.type == 28) {
            return !"java/lang/Object".equals(DbmsJava.shortName("java/lang/Object"));
        }
        return this.type != 1002;
    }

    boolean isSysObj() {
        if (this.type == 29 || this.type == 30) {
            boolean result = false;
            Handle h = this.getHandle();
            if (h != null) {
                try {
                    result = h.classesBinP();
                }
                catch (ObjectTypeChangedException ex) {
                    this.err(ex, this.mkMsg.m("getting classes.bin status of {0}", this.toString()));
                }
            }
            return result;
        }
        return false;
    }

    File mkFile(final String filename) {
        File destination = (File)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File oracleHome = new File(System.getProperty("oracle.aurora.rdbms.oracle_home"));
                File deploy = new File(oracleHome, "javavm");
                deploy = new File(deploy, "deploy");
                deploy.mkdir();
                return new File(deploy, filename);
            }
        });
        return destination;
    }

    boolean genMissing() {
        if (this.type == 28) {
            return this.getSourceHelper().genMissing();
        }
        if (this.type == 29) {
            return this.getClassHelper().genMissing();
        }
        return true;
    }

    boolean addPublish() {
        if (this.type == 28) {
            return this.getSourceHelper().addPublish();
        }
        if (this.type == 29) {
            return this.getClassHelper().addPublish();
        }
        return true;
    }

    void endLoading() {
        if (this.type != 1002) {
            return;
        }
        int status = DbmsJava.finishLoadingJar(0);
        this.checkEndLoadingStatus(status, DbmsJava.jarLoadingRdbmsErrorMessage);
    }

    void resumeLoading() {
        if (this.type != 1002) {
            return;
        }
        int status = DbmsJava.startLoadingJar(this.fullJarname, this.getServerSchema(), this.path, 2, null);
        this.checkStartLoadingStatus(status, this.getServerSchema().toString(), DbmsJava.jarLoadingRdbmsErrorMessage);
    }
}

