/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import oracle.aurora.server.tools.loadjava.LoadJavaOptions;
import oracle.aurora.server.tools.loadjava.MkMsg;
import oracle.aurora.server.tools.loadjava.Options;
import oracle.aurora.util.msg.Msg;

public class DropJavaOptions
extends Options {
    public static Msg mkMsg = MkMsg.mkMsg;
    LoadJavaOptions lj = new LoadJavaOptions();
    private static final String[] oneList = new String[]{"-help", "-synonym", "-nousage", "-noserverside", "-recursivejars", "-jarasresource", "-debug", "-jdkready", "-nowarn", "-compat817", "-install", "-jarsasdbobject", "-list", null};
    private static final String[] twoList = new String[]{"-localpathprefix", "-encoding", "-edition", "-schema", "-tableschema", "-optionfile", "-optiontable", "-publish", "-listfile", "-proxy", null};
    private static final String[] substList = new String[]{"-h", "-help", "-s", "-synonym", "-e", "-encoding", "-l", "-list", null};
    private static final Object[] expandList = new Object[]{"-noschema", "-schema", null, "-nosynonym", "-synonym", Boolean.FALSE, null};

    public DropJavaOptions(DropJavaOptions defaultOpt) {
        super(oneList, twoList, substList, expandList, defaultOpt);
    }

    public DropJavaOptions() {
        this(null);
    }

    public void parseArgs(Options.Args args) {
        super.parseArgs(args);
        this.lj.parseArgs(args);
    }

    static String usageMessage() {
        return "Usage: dropjava [-encoding encoding] [-help] [-oci8] [-schema schema] [-edition edition] [-synonym] [-thin] [-user user/password@database] [-verbose] [-install] classes..jars..resources..properties...";
    }

    static String helpMessage() {
        return mkMsg.k("dropjava.help", "Drop classes, jars, resources or properties files for Oracle.\nNormally these are classes previously loaded with loadjava.\nUsage: dropjava [options] classes..jars..resources..properties...\nOptions:\n  -encoding <encoding>     the encoding to be used to read .java files \n  -h, -help                print out this message.\n  -o, -oci8                use JDBC OCI8.  The database must be an entry\n                           from TNSNAMES.ORA file or a Net8 Name-Value list.\n  -schema <schema>         drops from <schema> rather than schema of user\n  -s, -synonym             drop the public synonym. \n  -t, -thin                use JDBC THIN.  The database must be of the form\n                           <host>:<port>:<sid> or a Net8 Name-Value list.\n  -user user/password@database   account and database where to load the\n                           classes and resources.\n  -v, -verbose             print some information as it loads the files.\n  -proxy host:port         Proxy for url support. Host is hostname or\n                           internet address. Port is the proxy\n                           port number.\n  -edition <edition name>  The application edition from which to drop objects\n  <any loadjava option>    will be ignored.\n");
    }
}

