/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.sql.SQLException;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.HandleHolder;
import oracle.aurora.rdbms.KGEException;
import oracle.aurora.rdbms.ModifyPermissionException;
import oracle.aurora.rdbms.NameInUseException;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.WouldReplaceException;
import oracle.sql.CHAR;

public final class SynonymHandle
extends Handle {
    private CHAR targetAsCHAR;
    private String target;
    private Schema targetSchema;

    SynonymHandle(String name, Schema schema, long index, byte[] timestamp) {
        super(name, schema, index, timestamp);
    }

    public int type() {
        return 5;
    }

    private static native void create(String var0, int var1, CHAR var2, int var3, boolean var4, HandleHolder var5, String var6) throws NameInUseException, WouldReplaceException, ModifyPermissionException;

    public static SynonymHandle create(String name, Schema schema, CHAR target, Schema targetSchema, boolean replace) throws NameInUseException, WouldReplaceException, ModifyPermissionException {
        if (schema == null) {
            schema = Schema.currentSchema();
        }
        int ownerNumber = schema.ownerNumber();
        if (targetSchema == null) {
            targetSchema = Schema.currentSchema();
        }
        int targetOwnerNumber = targetSchema.ownerNumber();
        HandleHolder holder = new HandleHolder();
        String nm = name;
        int onum = ownerNumber;
        CHAR tar = target;
        int tarnum = targetOwnerNumber;
        boolean rpl = replace;
        HandleHolder hd = holder;
        try {
            SynonymHandle.create(name, ownerNumber, target, targetOwnerNumber, replace, holder, null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow("SynonymHandle.create for " + schema.toString() + "." + name);
        }
        SynonymHandle h = (SynonymHandle)holder.handle;
        if (h == null) {
            h = new SynonymHandle(holder.name, schema, holder.index, holder.timestamp);
        }
        h.targetAsCHAR = target;
        h.targetSchema = targetSchema;
        return h;
    }

    public static SynonymHandle create(String name, Schema schema, String target, Schema targetSchema, boolean replace) throws NameInUseException, WouldReplaceException, ModifyPermissionException {
        CHAR targetAsCHAR = null;
        try {
            targetAsCHAR = new CHAR(target, CHAR.DEFAULT_CHARSET);
        }
        catch (SQLException e) {
            return null;
        }
        SynonymHandle h = SynonymHandle.create(name, schema, targetAsCHAR, targetSchema, replace);
        if (h != null) {
            h.target = target;
        }
        return h;
    }

    private native int lookupTarget(String var1) throws ObjectTypeChangedException;

    private void lookupTarget() throws ObjectTypeChangedException {
        int ownerNumber = 0;
        try {
            ownerNumber = this.lookupTarget(null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".lookupTarget");
        }
        if (ownerNumber >= 0) {
            this.targetSchema = Schema.lookup(ownerNumber);
        } else {
            this.targetSchema = null;
            this.targetAsCHAR = null;
        }
    }

    public CHAR targetAsCHAR() throws ObjectTypeChangedException {
        if (this.targetAsCHAR == null) {
            this.lookupTarget();
        }
        return this.targetAsCHAR;
    }

    public String target() throws ObjectTypeChangedException {
        if (this.target == null) {
            this.targetAsCHAR();
            if (this.targetAsCHAR != null) {
                this.target = this.targetAsCHAR.toString();
            }
        }
        return this.target;
    }

    public Schema targetSchema() throws ObjectTypeChangedException {
        if (this.targetSchema == null) {
            this.lookupTarget();
        }
        return this.targetSchema;
    }
}

