/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Locale;
import oracle.OracleRaw;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.ExecutePermissionException;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.KGEException;
import oracle.aurora.rdbms.NoSchema;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.Resolver;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.SharedDataHandle;
import oracle.aurora.vm.ClassNotResolvedException;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class DbmsJava {
    private static CHAR ieName = null;
    private static CHAR ieSchema;
    private static int ieFlags;
    private static int ieType;
    private static int ieProperties;
    private static byte[][] ieRawChunks;
    private static CHAR[] ieTextChunks;
    private static int ieNextRawChunk;
    private static int ieNextTextChunk;
    private static int ieRawByteCount;
    private static int ieTextByteCount;
    private static boolean ieExporting;
    private static final int ieStatusNoError = 0;
    private static final int ieStatusDont = 1;
    private static final int ieErrorAlreadyExporting = 2;
    private static final int ieErrorAlreadyImporting = 3;
    private static final int ieErrorTooManyCalls = 4;
    private static final int ieErrorTooFewCalls = 5;
    private static final int ieErrorNotInProgress = 6;
    private static final int ieErrorRawCountMismatch = 7;
    private static final int ieErrorTextCountMismatch = 8;
    private static final int getDatabaseCharSetID = 1;
    private static final int getNCharSetID = 2;
    private static final int getNamedCharSetID = 3;
    private static ByteToCharConverter sourceChunkBTC;
    private static InputStream sourceChunkStream;
    private static final int sourceChunkMaxSize = 1000;
    private static byte[] sourceChunkByteBuffer;
    private static char[] sourceChunkCharBuffer;
    public static final int KPRB_STATEMENTS_USE_UGA = 0;
    public static final int KPRB_STATEMENTS_USE_CGA = 1;
    public static final int NEXT_KPRB_STATEMENT_USES_CGA = 2;
    public static final int JAR_LOADING_FLAG_ALLOW_REPLACE = 1;
    public static final int JAR_LOADING_FLAG_RESUMING = 2;
    public static final int JAR_LOADING_FLAG_PREPEND = 4;
    public static final int JAR_LOADING_FLAG_ALLOW_NESTED = 8;
    public static final int JAR_LOADING_RETURN_STATUS_SUCCESS = 0;
    public static final int JAR_LOADING_RETURN_STATUS_WOULD_REPLACE = 1;
    public static final int JAR_LOADING_RETURN_STATUS_INVALID_SCHEMA = 2;
    public static final int JAR_LOADING_RETURN_STATUS_ALREADY_LOADING = 3;
    public static final int JAR_LOADING_RETURN_STATUS_RDBMS_ERROR = 4;
    public static final int JAR_LOADING_RETURN_STATUS_NOT_LOADING = 5;
    public static final int JAR_LOADING_RETURN_STATUS_UNKNOWN_JAR = 6;
    public static final int JAR_LOADING_RETURN_STATUS_JARLESS_CLASS = 7;
    private static String loadingJarName;
    private static int loadingJarFlags;
    public static int jarLoadingRdbmsErrorNumber;
    public static String jarLoadingRdbmsErrorMessage;
    private static final int[] jarLoadingRdbmsErrorNumberHolder;
    private static final String[] jarLoadingRdbmsErrorMessageHolder;
    private static int locatorSize;
    private static final int[] cursorHolder;
    private static final int[] errHolder;
    private static Hashtable outputSpecIdToStream;

    private static native CHAR NameFromLastDDL_(boolean var0);

    public static CHAR NameFromLastDDL() {
        return DbmsJava.NameFromLastDDL_(false);
    }

    public static CHAR NameFromLastDDL(boolean longp) {
        return DbmsJava.NameFromLastDDL_(longp);
    }

    private static native String shortName_(String var0, boolean var1);

    public static String shortName(String longName) {
        return DbmsJava.shortName_(longName, false);
    }

    private static native String longName_(String var0);

    public static String longName(String shortName) {
        return DbmsJava.longName_(shortName);
    }

    private static native String uEscapeName_(String var0);

    public static String uEscapeName(String name) {
        return DbmsJava.uEscapeName_(name);
    }

    public static String longNameForSQL(String shortName) {
        return DbmsJava.uEscapeName(DbmsJava.longName(shortName));
    }

    private static native int startExport_(CHAR var0, CHAR var1, int var2, int var3, int[] var4, byte[][][] var5, CHAR[][] var6);

    private static native int startImport_(CHAR var0, int var1, int var2, int var3);

    private static native int endImport_(CHAR var0, int var1, int var2, int var3, byte[][] var4, CHAR[] var5);

    public static int startExport(CHAR shortenedName, CHAR schemaName, int flags, int type, int[] properties, int[] rawChunkCount, int[] rawByteCount, int[] textChunkCount, int[] textByteCount) {
        int i;
        if (ieName != null) {
            return ieExporting ? 2 : 3;
        }
        byte[][][] rawChunksHolder = new byte[1][][];
        CHAR[][] textChunksHolder = new CHAR[1][];
        int status = DbmsJava.startExport_(shortenedName, schemaName, flags, type, properties, rawChunksHolder, textChunksHolder);
        if (status != 0) {
            return status;
        }
        ieExporting = true;
        ieName = shortenedName;
        ieSchema = schemaName;
        ieFlags = flags;
        ieType = type;
        ieProperties = properties[0];
        ieRawChunks = rawChunksHolder[0];
        ieTextChunks = textChunksHolder[0];
        ieNextRawChunk = 0;
        ieNextTextChunk = 0;
        rawChunkCount[0] = ieRawChunks.length;
        textChunkCount[0] = ieTextChunks.length;
        rawByteCount[0] = 0;
        textByteCount[0] = 0;
        for (i = 0; i < ieRawChunks.length; ++i) {
            rawByteCount[0] = rawByteCount[0] + ieRawChunks[i].length;
        }
        for (i = 0; i < ieTextChunks.length; ++i) {
            textByteCount[0] = textByteCount[0] + (int)ieTextChunks[i].getLength();
        }
        return 0;
    }

    public static int exportRawChunk(byte[][] chunk, int[] length) {
        if (ieName == null) {
            return 6;
        }
        if (!ieExporting) {
            return 3;
        }
        if (ieNextRawChunk >= ieRawChunks.length) {
            return 4;
        }
        chunk[0] = ieRawChunks[ieNextRawChunk];
        length[0] = chunk[0].length;
        ++ieNextRawChunk;
        return 0;
    }

    public static int exportTextChunk(CHAR[] chunk, int[] length) {
        if (ieName == null) {
            return 6;
        }
        if (!ieExporting) {
            return 3;
        }
        if (ieNextTextChunk >= ieTextChunks.length) {
            return 4;
        }
        chunk[0] = ieTextChunks[ieNextTextChunk];
        length[0] = (int)chunk[0].getLength();
        ++ieNextTextChunk;
        return 0;
    }

    public static int endExport() {
        if (ieName == null) {
            return 6;
        }
        if (!ieExporting) {
            return 3;
        }
        int status = 0;
        if (ieNextRawChunk != ieRawChunks.length || ieNextTextChunk != ieTextChunks.length) {
            status = 5;
        }
        ieName = null;
        ieSchema = null;
        ieRawChunks = null;
        ieTextChunks = null;
        return status;
    }

    public static int startImport(CHAR fullName, int flags, int type, int properties, int rawChunkCount, int rawByteCount, int textChunkCount) {
        if (ieName != null) {
            return ieExporting ? 2 : 3;
        }
        if (rawChunkCount < 2) {
            return 7;
        }
        int status = DbmsJava.startImport_(fullName, flags, type, properties);
        if (status != 0) {
            return status;
        }
        ieExporting = false;
        ieName = fullName;
        ieFlags = flags;
        ieType = type;
        ieProperties = properties;
        ieRawChunks = new byte[rawChunkCount][];
        ieTextChunks = new CHAR[textChunkCount];
        ieNextRawChunk = 0;
        ieNextTextChunk = 0;
        ieRawByteCount = rawByteCount;
        return 0;
    }

    public static int importRawChunk(byte[] chunk, int length) {
        if (ieName == null) {
            return 6;
        }
        if (ieExporting) {
            return 2;
        }
        if (ieNextRawChunk >= ieRawChunks.length) {
            return 4;
        }
        DbmsJava.ieRawChunks[DbmsJava.ieNextRawChunk] = chunk;
        ++ieNextRawChunk;
        if (chunk.length != length) {
            return 7;
        }
        ieRawByteCount -= length;
        return 0;
    }

    public static int importTextChunk(CHAR chunk, int length) {
        if (ieName == null) {
            return 6;
        }
        if (ieExporting) {
            return 2;
        }
        if (ieNextTextChunk >= ieTextChunks.length) {
            return 4;
        }
        DbmsJava.ieTextChunks[DbmsJava.ieNextTextChunk] = chunk;
        ++ieNextTextChunk;
        if (chunk.getLength() != (long)length) {
            return 8;
        }
        return 0;
    }

    public static int endImport() {
        if (ieName == null) {
            return 6;
        }
        if (ieExporting) {
            return 2;
        }
        int status = ieNextRawChunk != ieRawChunks.length || ieNextTextChunk != ieTextChunks.length ? 5 : DbmsJava.endImport_(ieName, ieFlags, ieType, ieProperties, ieRawChunks, ieTextChunks);
        ieName = null;
        ieRawChunks = null;
        ieTextChunks = null;
        return status;
    }

    private static native int getCharSetID(int var0, String var1);

    public static int databaseCharSetID() {
        return DbmsJava.getCharSetID(1, null);
    }

    public static int nCharSetID() {
        return DbmsJava.getCharSetID(2, null);
    }

    public static int namedCharSetID(String name) {
        return DbmsJava.getCharSetID(3, name);
    }

    private static native byte[] convertCharSetsBytes(byte[] var0, int var1, int[] var2, int var3, int var4);

    public static byte[] convertBetweenCharSetsBytes(byte[] inputChars, int inputCharSetID, int outputCharSetID) {
        return DbmsJava.convertCharSetsBytes(inputChars, 0, null, inputCharSetID, outputCharSetID);
    }

    public static byte[] convertBetweenCharSetsBytes(byte[] inputChars, int offset, int[] len, int inputCharSetID, int outputCharSetID) {
        return DbmsJava.convertCharSetsBytes(inputChars, offset, len, inputCharSetID, outputCharSetID);
    }

    public static native int convertCharBytesInToCharArray(byte[] var0, int var1, int[] var2, char[] var3, int var4, int var5, int var6);

    private static native OracleRaw convertCharSets(OracleRaw var0, int var1, int var2);

    public static OracleRaw convertBetweenCharSets(OracleRaw inputChars, int inputCharSetID, int outputCharSetID) {
        return DbmsJava.convertCharSets(inputChars, inputCharSetID, outputCharSetID);
    }

    public static OracleRaw convertToUtf8(OracleRaw inputChars, int inputCharSetID) {
        return DbmsJava.convertCharSets(inputChars, inputCharSetID, -3);
    }

    public static OracleRaw convertDatabaseCharsToUtf8(OracleRaw inputChars) {
        return DbmsJava.convertCharSets(inputChars, -1, -3);
    }

    public static OracleRaw convertNCharsToUtf8(OracleRaw inputChars) {
        return DbmsJava.convertCharSets(inputChars, -2, -3);
    }

    private static native String convertCharBytesToString(byte[] var0, int var1);

    public static String convertToString(byte[] inputChars, int inputCharSetID) {
        return DbmsJava.convertCharBytesToString(inputChars, inputCharSetID);
    }

    private static native byte[] convertStringToCharBytes(String var0, int var1);

    public static byte[] convertToCharBytes(String inputString, int outputCharSetID) {
        return DbmsJava.convertStringToCharBytes(inputString, outputCharSetID);
    }

    public static int ownerID(Class c) {
        ClassHandle h = ClassHandle.lookup(c);
        return h.schema().ownerNumber();
    }

    public static Class classForNameAndSchema(String name, String schema) throws ClassNotFoundException {
        return DbmsJava.classForNameAndSchema(name, Schema.lookup(schema));
    }

    public static Class classForNameAndSchema(String name, CHAR schema) throws ClassNotFoundException {
        return DbmsJava.classForNameAndSchema(name, Schema.lookup(schema));
    }

    public static Class classForNameAndSchema(String name, Schema schema) throws ClassNotFoundException {
        Class c;
        if (schema == null) {
            throw new IllegalArgumentException("Null schema supplied");
        }
        if (schema instanceof NoSchema) {
            throw new IllegalArgumentException("Schema instanceof NoSchema");
        }
        ClassHandle h = Handle.lookupClass(name, schema);
        if (h == null) {
            throw new ClassNotFoundException(name + " in <" + schema + ">");
        }
        try {
            c = h.loadClass();
        }
        catch (ObjectTypeChangedException e) {
            e.printStackTrace();
            throw new InternalError(h + " changed type in DbmsJava.classForNameAndSchema");
        }
        boolean hasExecPriv = true;
        try {
            hasExecPriv = h.hasExecutePrivilege(Schema.currentSchema());
        }
        catch (ObjectTypeChangedException ehe) {
            ehe.printStackTrace();
            System.err.println(ehe.getMessage());
            return null;
        }
        if (hasExecPriv && c == null) {
            throw new ClassNotResolvedException(name + " in <" + schema + ">");
        }
        if (!hasExecPriv) {
            throw new ExecutePermissionException(name + " in <" + schema + ">");
        }
        return c;
    }

    public static Class classForNameInSystemSchema(String name) throws ClassNotFoundException {
        return DbmsJava.classForNameAndSchema(name, Schema.systemSchema);
    }

    static native boolean hasRole_(int var0, int var1);

    public static boolean hasRole(int userid, int roleid) {
        return Schema.lookup(userid).hasRole(roleid);
    }

    public static int initGetSourceChunks(String shortName, CHAR schemaName, String typeName) {
        Handle h = Handle.lookup(shortName, schemaName, typeName);
        if (h == null || h.type() != 28 && h.type() != 29) {
            return -1;
        }
        if (h.type() == 29) {
            try {
                h = h.derivedFrom();
            }
            catch (ObjectTypeChangedException ehe) {
                h = null;
            }
            if (h == null) {
                return -1;
            }
        }
        try {
            sourceChunkStream = h.inputStream();
            if (sourceChunkBTC == null) {
                sourceChunkBTC = ByteToCharConverter.getConverter((String)"UTF8");
            }
            sourceChunkByteBuffer = new byte[1000];
            sourceChunkCharBuffer = new char[sourceChunkBTC.getMaxCharsPerByte() * 1000];
            return sourceChunkStream.available();
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static CHAR getSourceChunk() {
        if (sourceChunkStream == null) {
            return null;
        }
        try {
            int nBytesRead = sourceChunkStream.read(sourceChunkByteBuffer, 0, 1000);
            if (nBytesRead > 0) {
                try {
                    sourceChunkBTC.convert(sourceChunkByteBuffer, 0, nBytesRead, sourceChunkCharBuffer, 0, sourceChunkCharBuffer.length);
                }
                catch (ConversionBufferFullException x) {
                }
                catch (UnknownCharacterException x) {
                }
                catch (MalformedInputException x) {
                    int gotToByte = sourceChunkBTC.nextByteIndex();
                    sourceChunkStream.skip(gotToByte - nBytesRead);
                    nBytesRead = gotToByte;
                }
            }
            if (nBytesRead > 0) {
                byte[] b = sourceChunkByteBuffer;
                if (b.length != nBytesRead) {
                    b = new byte[nBytesRead];
                    System.arraycopy(sourceChunkByteBuffer, 0, b, 0, nBytesRead);
                }
                OracleRaw dbCharBytes = DbmsJava.convertCharSets(new OracleRaw(b), -3, -4);
                return new CHAR(dbCharBytes.getOracleBytes(), null);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            sourceChunkStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sourceChunkStream = null;
        sourceChunkByteBuffer = null;
        sourceChunkCharBuffer = null;
        return null;
    }

    public static String derivedFrom(String shortName, CHAR schemaName, String typeName) {
        Handle h = Handle.lookup(shortName, schemaName, typeName);
        if (h == null || h.type() != 30 && h.type() != 29) {
            return null;
        }
        try {
            h = h.derivedFrom();
        }
        catch (ObjectTypeChangedException ehe) {
            h = null;
        }
        if (h == null) {
            return null;
        }
        return DbmsJava.shortName(h.name());
    }

    public static CHAR resolver(String shortName, CHAR schemaName, String typeName) {
        Handle h = Handle.lookup(shortName, schemaName, typeName);
        Resolver r = null;
        if (h == null || h.type() != 28 && h.type() != 29) {
            return null;
        }
        try {
            r = h.resolver();
        }
        catch (ObjectTypeChangedException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
        try {
            return new CHAR(r == null ? "default" : r.toString().substring(8), null);
        }
        catch (SQLException e) {
            return null;
        }
    }

    private static boolean fixedInInstanceImpl(String shortName, CHAR schemaName, String typeName, boolean setting, boolean value) {
        Handle h = Handle.lookup(shortName, schemaName, typeName);
        boolean result = false;
        if (h != null) {
            try {
                if (setting) {
                    h.setFixedInInstance(value);
                } else {
                    result = h.fixedInInstance();
                }
            }
            catch (KGEException e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        }
        return result;
    }

    public static boolean fixedInInstance(String shortName, CHAR schemaName, String typeName) {
        return DbmsJava.fixedInInstanceImpl(shortName, schemaName, typeName, false, false);
    }

    public static void setFixedInInstance(String shortName, CHAR schemaName, String typeName, boolean value) {
        DbmsJava.fixedInInstanceImpl(shortName, schemaName, typeName, true, value);
    }

    private static boolean predigestedImpl(String shortName, CHAR schemaName, boolean setting) {
        Handle h = Handle.lookup(shortName, schemaName, "CLASS");
        boolean result = false;
        if (h != null) {
            try {
                if (setting) {
                    h.setPredigestionOff();
                } else {
                    result = h.predigested();
                }
            }
            catch (KGEException e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        }
        return result;
    }

    public static boolean predigested(String shortName, CHAR schemaName) {
        return DbmsJava.predigestedImpl(shortName, schemaName, false);
    }

    public static void setPredigestionOff(String shortName, CHAR schemaName) {
        DbmsJava.predigestedImpl(shortName, schemaName, true);
    }

    public static void setExecutePrivilege(String objectName, CHAR schemaName, String typeName, CHAR granteeSchemaName, boolean grant) {
        Handle h = Handle.lookup(objectName, schemaName, typeName);
        Schema grantee = Schema.lookup(granteeSchemaName);
        if (h != null && grantee != null) {
            try {
                if (grant) {
                    h.grantExecutePrivilege(grantee);
                } else {
                    h.revokeExecutePrivilege(grantee);
                }
            }
            catch (KGEException e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static String sharedPrivateClassName(String kglName) {
        SharedDataHandle h;
        String result = null;
        if (kglName != null && (h = Handle.lookupSharedData(kglName, Schema.systemSchema)) != null) {
            result = h.sharedPrivateClassName();
        }
        return result;
    }

    private static native void langAndTerr(String[] var0);

    public static void getLangAndTerr(String[] results) {
        DbmsJava.langAndTerr(results);
    }

    public static native int[] grantedRoles(int var0, boolean var1);

    public static native int getKPRBStatementAllocationMode();

    public static native void setKPRBStatementAllocationMode(int var0);

    public static String ncompEnabledMsg() {
        ClassHandle h = Handle.lookupClass("java/util/Locale");
        if (!h.getNcompIsEnabled()) {
            return "NComp status: NOT IMPLEMENTED";
        }
        Object y = null;
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        String s = "";
        String msg = "";
        try {
            Locale.setDefault(null);
            msg = "NComp test failed.";
        }
        catch (Exception e) {
            e.printStackTrace(out);
            out.flush();
            s = sw.toString();
            s = s.substring(s.indexOf("("), s.indexOf(")"));
            int i = s.indexOf(":");
            msg = i > 0 ? "NComp status: DISABLED" : "NComp status: ENABLED";
            out.close();
        }
        return msg;
    }

    public static String loadingJar() {
        return loadingJarName;
    }

    public static String jarNameToPrepend() {
        return (loadingJarFlags & 4) != 0 ? loadingJarName : null;
    }

    private static native int startJarLoad(String var0, int var1, String var2, int var3, InputStream var4, int[] var5, String[] var6);

    private static native int endJarLoad(int var0);

    private static native int jarStatus(String var0, int var1, int var2, int[] var3, String[] var4);

    private static native int dropJar(String var0, int var1, int var2, int[] var3, String[] var4);

    private static native int getLocatorSize();

    private static native int jarOpen(String var0, int var1, int var2, byte[] var3, int[] var4, int[] var5, String[] var6);

    private static native int jarClose(byte[] var0, int var1, int var2, int[] var3, String[] var4);

    public static int startLoadingJar(String name, Schema schema, String path, int flags, InputStream bits) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (bits == null && (flags & 2) == 0) {
            throw new IllegalArgumentException("stream is null");
        }
        int ownerNumber = schema.ownerNumber();
        jarLoadingRdbmsErrorNumber = 0;
        jarLoadingRdbmsErrorMessage = null;
        if (ownerNumber < 0 || Schema.lookupOwnerName(ownerNumber, false, true, false, null) == null) {
            return 2;
        }
        DbmsJava.jarLoadingRdbmsErrorNumberHolder[0] = 0;
        DbmsJava.jarLoadingRdbmsErrorMessageHolder[0] = null;
        int result = DbmsJava.startJarLoad(name, ownerNumber, path, flags, bits, jarLoadingRdbmsErrorNumberHolder, jarLoadingRdbmsErrorMessageHolder);
        jarLoadingRdbmsErrorNumber = jarLoadingRdbmsErrorNumberHolder[0];
        jarLoadingRdbmsErrorMessage = jarLoadingRdbmsErrorMessageHolder[0];
        if (result == 0) {
            loadingJarName = name;
            loadingJarFlags = flags;
        }
        return result;
    }

    public static int startLoadingJar(String name, int ownerNumber, String path, int flags, InputStream bits) {
        Schema s = Schema.lookup(ownerNumber);
        if (s == null) {
            return 2;
        }
        return DbmsJava.startLoadingJar(name, s, path, flags, bits);
    }

    public static int startLoadingJar(String name, CHAR schema, String path, int flags, InputStream bits) {
        Schema s;
        Schema schema2 = s = schema == null ? Schema.currentSchema() : Schema.lookup(schema);
        if (s == null) {
            return 2;
        }
        return DbmsJava.startLoadingJar(name, s, path, flags, bits);
    }

    public static int startLoadingJar(String name, String schema, String path, int flags, InputStream bits) {
        Schema s;
        Schema schema2 = s = schema == null ? Schema.currentSchema() : Schema.lookup(schema);
        if (s == null) {
            return 2;
        }
        return DbmsJava.startLoadingJar(name, s, path, flags, bits);
    }

    public static int startLoadingJar(String name, String schema, String path, int flags, BLOB bits, String[] msg) {
        int status = 4;
        try {
            InputStream stream = bits == null ? null : bits.getBinaryStream();
            status = DbmsJava.startLoadingJar(name, schema, path, flags, stream);
            if (stream != null) {
                stream.close();
            }
            msg[0] = jarLoadingRdbmsErrorMessage;
        }
        catch (Exception e) {
            e.printStackTrace();
            msg[0] = e + " " + e.toString();
        }
        return status;
    }

    public static int finishLoadingJar(int flags) {
        loadingJarName = null;
        loadingJarFlags = 0;
        DbmsJava.jarLoadingRdbmsErrorNumberHolder[0] = 0;
        DbmsJava.jarLoadingRdbmsErrorMessageHolder[0] = null;
        int result = DbmsJava.endJarLoad(flags);
        jarLoadingRdbmsErrorNumber = jarLoadingRdbmsErrorNumberHolder[0];
        jarLoadingRdbmsErrorMessage = jarLoadingRdbmsErrorMessageHolder[0];
        return result;
    }

    public static int finishLoadingJar(int flags, String[] msg) {
        int result = DbmsJava.finishLoadingJar(flags);
        msg[0] = jarLoadingRdbmsErrorMessage;
        return result;
    }

    public static int jarStatus(String name, Schema schema) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        int ownerNumber = schema.ownerNumber();
        jarLoadingRdbmsErrorNumber = 0;
        jarLoadingRdbmsErrorMessage = null;
        if (ownerNumber < 0 || Schema.lookupOwnerName(ownerNumber, false, true, false, null) == null) {
            return 2;
        }
        DbmsJava.jarLoadingRdbmsErrorNumberHolder[0] = 0;
        DbmsJava.jarLoadingRdbmsErrorMessageHolder[0] = null;
        int result = DbmsJava.jarStatus(name, ownerNumber, 0, jarLoadingRdbmsErrorNumberHolder, jarLoadingRdbmsErrorMessageHolder);
        jarLoadingRdbmsErrorNumber = jarLoadingRdbmsErrorNumberHolder[0];
        jarLoadingRdbmsErrorMessage = jarLoadingRdbmsErrorMessageHolder[0];
        return result;
    }

    public static int jarStatus(String name, String schema, String[] msg) {
        Schema s = schema == null ? Schema.currentSchema() : Schema.lookup(schema);
        int result = DbmsJava.jarStatus(name, s);
        msg[0] = jarLoadingRdbmsErrorMessage;
        return result;
    }

    public static int dropJar(String name, Schema schema) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        int ownerNumber = schema.ownerNumber();
        jarLoadingRdbmsErrorNumber = 0;
        jarLoadingRdbmsErrorMessage = null;
        if (ownerNumber < 0 || Schema.lookupOwnerName(ownerNumber, false, true, false, null) == null) {
            return 2;
        }
        DbmsJava.jarLoadingRdbmsErrorNumberHolder[0] = 0;
        DbmsJava.jarLoadingRdbmsErrorMessageHolder[0] = null;
        int result = DbmsJava.dropJar(name, ownerNumber, 0, jarLoadingRdbmsErrorNumberHolder, jarLoadingRdbmsErrorMessageHolder);
        jarLoadingRdbmsErrorNumber = jarLoadingRdbmsErrorNumberHolder[0];
        jarLoadingRdbmsErrorMessage = jarLoadingRdbmsErrorMessageHolder[0];
        return result;
    }

    public static int dropJar(String name, String schema, String[] msg) {
        Schema s = schema == null ? Schema.currentSchema() : Schema.lookup(schema);
        int result = DbmsJava.dropJar(name, s);
        msg[0] = jarLoadingRdbmsErrorMessage;
        return result;
    }

    private static synchronized InputStream getJarStream(String name, Schema schema, int[] errorStatusHolder) throws SQLException {
        int ownerNumber;
        if (name == null) {
            throw new NullPointerException("name in DbmsJava.getJarStream");
        }
        boolean rjbc = schema == null;
        int n = ownerNumber = rjbc ? 0 : schema.ownerNumber();
        if (locatorSize == 0) {
            locatorSize = DbmsJava.getLocatorSize();
        }
        byte[] locator = new byte[locatorSize];
        jarLoadingRdbmsErrorNumber = 0;
        jarLoadingRdbmsErrorMessage = null;
        if (errorStatusHolder != null) {
            errorStatusHolder[0] = 0;
        }
        if (!(rjbc || ownerNumber >= 0 && Schema.lookupOwnerName(ownerNumber, false, true, false, null) != null)) {
            if (errorStatusHolder != null) {
                errorStatusHolder[0] = 2;
            }
            return null;
        }
        DbmsJava.jarLoadingRdbmsErrorNumberHolder[0] = 0;
        DbmsJava.jarLoadingRdbmsErrorMessageHolder[0] = null;
        int result = DbmsJava.jarOpen(name, ownerNumber, rjbc ? 1 : 0, locator, cursorHolder, jarLoadingRdbmsErrorNumberHolder, jarLoadingRdbmsErrorMessageHolder);
        jarLoadingRdbmsErrorNumber = jarLoadingRdbmsErrorNumberHolder[0];
        jarLoadingRdbmsErrorMessage = jarLoadingRdbmsErrorMessageHolder[0];
        if (result == 0) {
            int cursor = cursorHolder[0];
            return new JarStream(cursor, locator, JarStream.getBLOB(cursor, locator));
        }
        if (errorStatusHolder != null) {
            errorStatusHolder[0] = result;
        }
        return null;
    }

    private static void statusToSQLException(int status) throws SQLException {
        if (status == 4) {
            throw new SQLException(jarLoadingRdbmsErrorMessage);
        }
        if (status != 0) {
            throw new SQLException("jar close error status = " + status);
        }
    }

    public static synchronized InputStream getJarStream(String name, Schema schema) throws SQLException {
        if (schema == null) {
            throw new NullPointerException("schema in DbmsJava.getJarStream");
        }
        InputStream s = DbmsJava.getJarStream(name, schema, errHolder);
        if (s == null) {
            DbmsJava.statusToSQLException(errHolder[0]);
        }
        return s;
    }

    private static native int jarNameFromClass(Class var0, int[] var1, String[] var2);

    public static String jarName(Class cl) {
        jarLoadingRdbmsErrorNumber = 0;
        jarLoadingRdbmsErrorMessage = null;
        DbmsJava.jarLoadingRdbmsErrorNumberHolder[0] = 0;
        DbmsJava.jarLoadingRdbmsErrorMessageHolder[0] = null;
        int status = DbmsJava.jarNameFromClass(cl, jarLoadingRdbmsErrorNumberHolder, jarLoadingRdbmsErrorMessageHolder);
        jarLoadingRdbmsErrorNumber = jarLoadingRdbmsErrorNumberHolder[0];
        jarLoadingRdbmsErrorMessage = jarLoadingRdbmsErrorMessageHolder[0];
        if (status == 0) {
            return jarLoadingRdbmsErrorMessage;
        }
        if (status == 4) {
            throw new InternalError(jarLoadingRdbmsErrorMessage);
        }
        throw new InternalError("jar name error status = " + status);
    }

    public static void initializeOutputToFile(String id, String fname) throws Exception {
        FileWriter fw = new FileWriter(fname, true);
        outputSpecIdToStream.put(id, fw);
    }

    public static void finalizeOutputToFile(String id) throws Exception {
        FileWriter fw = (FileWriter)outputSpecIdToStream.get(id);
        outputSpecIdToStream.remove(id);
        fw.flush();
        fw.close();
    }

    public static void writeOutputToFile(String id, String text) throws Exception {
        FileWriter fw = (FileWriter)outputSpecIdToStream.get(id);
        fw.write(text);
        fw.flush();
    }

    public static synchronized InputStream getRJBCStream(String name) throws SQLException {
        InputStream s = DbmsJava.getJarStream(name, null, errHolder);
        if (s == null) {
            DbmsJava.statusToSQLException(errHolder[0]);
        }
        return s;
    }

    static String rjbcNormalize(String p) {
        jarLoadingRdbmsErrorNumber = 0;
        jarLoadingRdbmsErrorMessage = null;
        DbmsJava.jarLoadingRdbmsErrorNumberHolder[0] = 0;
        DbmsJava.jarLoadingRdbmsErrorMessageHolder[0] = null;
        int result = DbmsJava.jarStatus(p, 0, 1, jarLoadingRdbmsErrorNumberHolder, jarLoadingRdbmsErrorMessageHolder);
        jarLoadingRdbmsErrorNumber = jarLoadingRdbmsErrorNumberHolder[0];
        jarLoadingRdbmsErrorMessage = jarLoadingRdbmsErrorMessageHolder[0];
        return jarLoadingRdbmsErrorMessage;
    }

    public static void pighead() throws Exception {
        Statement s = new OracleDriver().defaultConnection().createStatement();
        s.execute("begin dbms_java.pighead;end;");
        s.close();
    }

    static {
        jarLoadingRdbmsErrorNumberHolder = new int[1];
        jarLoadingRdbmsErrorMessageHolder = new String[1];
        cursorHolder = new int[1];
        errHolder = new int[1];
        outputSpecIdToStream = new Hashtable();
    }

    private static class JarStream
    extends FilterInputStream {
        private static OracleConnection conn;
        private BLOB lob;
        private byte[] locator;
        private int cursor;

        private static BLOB getBLOB(int cursor, byte[] locator) throws SQLException {
            if (conn == null) {
                conn = (OracleConnection)new OracleDriver().defaultConnection();
            }
            return new BLOB((oracle.jdbc.OracleConnection)conn, locator);
        }

        private JarStream(int cursor, byte[] locator, BLOB lob) throws SQLException {
            super(lob.getBinaryStream());
            this.cursor = cursor;
            this.locator = locator;
            this.lob = lob;
        }

        public void close() throws IOException {
            super.close();
            jarLoadingRdbmsErrorNumber = 0;
            jarLoadingRdbmsErrorMessage = null;
            jarLoadingRdbmsErrorNumberHolder[0] = 0;
            jarLoadingRdbmsErrorMessageHolder[0] = null;
            int result = DbmsJava.jarClose(this.locator, this.cursor, 0, jarLoadingRdbmsErrorNumberHolder, jarLoadingRdbmsErrorMessageHolder);
            jarLoadingRdbmsErrorNumber = jarLoadingRdbmsErrorNumberHolder[0];
            jarLoadingRdbmsErrorMessage = jarLoadingRdbmsErrorMessageHolder[0];
            if (result == 4) {
                throw new IOException(jarLoadingRdbmsErrorMessage);
            }
            if (result != 0) {
                throw new IOException("jar close error status = " + result);
            }
        }
    }
}

