/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import oracle.aurora.compiler.Db;

class TreeWalker
implements Enumeration {
    TreeNode node;
    Enumeration descendants;
    TreeWalker remaining;

    public TreeWalker(TreeNode node) {
        this.node = node;
        if (node != null) {
            this.descendants = node.getChildren();
        }
    }

    TreeWalker() {
    }

    void copy(TreeWalker rhs) {
        this.node = rhs.node;
        this.descendants = rhs.descendants;
        this.remaining = rhs.remaining;
    }

    void dump() {
        Db.output("node", this.node);
        Db.output("descendants", this.descendants == null ? "null" : "non-null");
        if (this.remaining != null) {
            Db.push();
            Db.output("remaining");
            this.remaining.dump();
            Db.pop();
        }
    }

    void fillNode() {
        if (this.node != null) {
            return;
        }
        if (this.descendants != null && this.descendants.hasMoreElements()) {
            TreeNode newNode = (TreeNode)this.descendants.nextElement();
            TreeWalker newLevel = new TreeWalker();
            newLevel.copy(this);
            this.node = newNode;
            this.descendants = newNode.getChildren();
            this.remaining = newLevel;
        } else if (this.remaining != null) {
            this.copy(this.remaining);
            this.fillNode();
        }
    }

    public boolean hasMoreElements() {
        this.fillNode();
        return this.node != null;
    }

    public Object nextElement() throws NoSuchElementException {
        this.fillNode();
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        TreeNode next = this.node;
        this.node = null;
        return next;
    }

    static interface TreeNode {
        public Enumeration getChildren();
    }
}

