/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import oracle.aurora.compiler.ErrorPosition;
import oracle.aurora.compiler.ErrorReporter;
import oracle.aurora.compiler.MessageGetter;
import oracle.aurora.compiler.TooManyErrorsException;

public class CountingErrorReporter
implements ErrorReporter {
    ErrorReporter far;
    int limit;
    int warningCount = 0;
    int errorCount = 0;
    MessageGetter msgs;
    boolean closed = false;

    public CountingErrorReporter(ErrorReporter far, int limit, MessageGetter msgs) {
        this.far = far;
        this.limit = limit;
        this.msgs = msgs;
    }

    public void report(ErrorPosition position, int level, String message) throws TooManyErrorsException {
        if (level == 2) {
            ++this.errorCount;
        } else if (level == 1) {
            ++this.warningCount;
        }
        if (this.errorCount == this.limit) {
            this.far.report(ErrorPosition.none(), 2, this.msgs.getText("too.many.errors", this.limit));
        }
        if (level == 2 && this.errorCount >= this.limit) {
            throw new TooManyErrorsException();
        }
        this.far.report(position, level, message);
    }

    public void close() {
        if (!this.closed) {
            try {
                String warnMsg = "";
                String errMsg = "";
                String sep = "";
                if (this.warningCount > 0) {
                    warnMsg = this.msgs.getText("main.warnings", this.warningCount);
                }
                if (this.errorCount > 0) {
                    errMsg = this.msgs.getText("main.errors", this.errorCount);
                }
                if (this.errorCount > 0 && this.warningCount > 0) {
                    sep = ", ";
                }
                if (this.errorCount > 0 || this.warningCount > 0) {
                    this.far.report(ErrorPosition.none(), 0, errMsg + sep + warnMsg);
                }
            }
            catch (TooManyErrorsException tooManyErrorsException) {
                // empty catch block
            }
            this.far.close();
        }
        this.closed = true;
    }

    public int getErrorCount() {
        return this.far.getErrorCount();
    }

    public int getWarningCount() {
        return this.far.getWarningCount();
    }
}

