/*
 * Decompiled with CFR 0.152.
 */
package oracle;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

abstract class OracleDatum {
    private byte[] data;

    protected OracleDatum(byte[] newData) {
        this.data = newData;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof OracleDatum)) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            OracleDatum od = (OracleDatum)obj;
            if (this.data.length != od.data.length) {
                return false;
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == od.data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected byte[] shareOracleBytes() {
        return this.data;
    }

    public long getOracleLength() {
        if (null == this.data) {
            return 0L;
        }
        return this.data.length;
    }

    public byte[] getOracleBytes() {
        return (byte[])this.data.clone();
    }

    public InputStream getOracleStream() {
        return new ByteArrayInputStream(this.data);
    }
}

