/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.types;

import oracle.charts.internal.Errorfcn;
import oracle.charts.internal.MsgUtil;
import oracle.charts.types.AxisDesc;
import oracle.charts.types.ChartException;

public class TimeAxisDesc
extends AxisDesc {
    int firstLevelField = -1;
    int lastLevelField = -1;
    int firstLevelFieldExtended = -1;
    public static final int DERIVED = -1;
    public static final int SECOND = 0;
    public static final int MINUTE = 1;
    public static final int HOUR = 2;
    public static final int DAY = 3;
    public static final int MONTH = 4;
    public static final int YEAR = 5;
    boolean extendedLabels = false;
    public static final int ALIGN_AXIS_TOP = 0;
    public static final int ALIGN_AXIS_BOTTOM = 1;
    int axisAlignment = 1;
    public static int HOUR_FIELD = -1;
    boolean dayOfWeek = false;
    boolean dayOfWeekOnly = false;
    int numLabelingLines = -1;
    boolean alignLabelsPoint = false;
    public static final int LABEL_ALIGNMENT_DEFAULT = 0;
    public static final int LABEL_ALIGNMENT_FORCE_TO_POINT = 1;
    int labelAlignment = 0;

    public void setAxisAlignment(int alignment) throws ChartException {
        switch (alignment) {
            case 0: 
            case 1: {
                this.axisAlignment = alignment;
                break;
            }
            default: {
                Errorfcn.chartError("setMaxDimension()", MsgUtil.getMsg("CHT-606"));
            }
        }
    }

    public void setMinDimension(int timeDimension) throws ChartException {
        switch (timeDimension) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (timeDimension > this.lastLevelField && this.lastLevelField != -1) break;
                this.firstLevelField = timeDimension;
                break;
            }
            default: {
                Errorfcn.chartError("setMinDimension()", MsgUtil.getMsg("CHT-605"));
            }
        }
    }

    public void setMaxDimension(int timeDimension) throws ChartException {
        switch (timeDimension) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (timeDimension < this.firstLevelField && this.firstLevelField != -1) break;
                this.lastLevelField = timeDimension;
                break;
            }
            default: {
                Errorfcn.chartError("setMaxDimension()", MsgUtil.getMsg("CHT-605"));
            }
        }
    }

    public void setExtendedDimension(int timeDimension) throws ChartException {
        switch (timeDimension) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (timeDimension > this.lastLevelField && this.lastLevelField != -1) break;
                this.firstLevelFieldExtended = timeDimension;
                break;
            }
            default: {
                Errorfcn.chartError("setMinDimension()", MsgUtil.getMsg("CHT-605"));
            }
        }
    }

    public void setField(int timeDimension, int field) throws ChartException {
        switch (timeDimension) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                switch (field) {
                    case 10: 
                    case 11: {
                        HOUR_FIELD = field;
                    }
                }
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                Errorfcn.chartError("setField()", MsgUtil.getMsg("CHT-605"));
            }
        }
    }

    public int getField(int timeDimension) throws ChartException {
        switch (timeDimension) {
            case 0: 
            case 1: {
                return timeDimension;
            }
            case 2: {
                return HOUR_FIELD;
            }
            case 3: 
            case 4: 
            case 5: {
                return timeDimension;
            }
        }
        Errorfcn.chartError("getField()", MsgUtil.getMsg("CHT-605"));
        return -1;
    }

    public void setDayOfWeek(boolean enableDayOfWeek) {
        this.dayOfWeek = enableDayOfWeek;
    }

    public void setDayOfWeekOnly(boolean enableDayOfWeekOnly) {
        this.dayOfWeekOnly = enableDayOfWeekOnly;
    }

    public int getAxisAlignment() {
        return this.axisAlignment;
    }

    public int getMinDimension() {
        return this.firstLevelField;
    }

    public int getExtendedDimension() {
        return this.firstLevelFieldExtended;
    }

    public int getMaxDimension() {
        return this.lastLevelField;
    }

    public void setMinLabelingLines(int numLabelingLines) {
        if (numLabelingLines < 6 && numLabelingLines > -1) {
            this.numLabelingLines = numLabelingLines;
        }
    }

    public int getMinLabelingLines() {
        return this.numLabelingLines;
    }

    public boolean getDayOfWeek() {
        return this.dayOfWeek;
    }

    public boolean getDayOfWeekOnly() {
        return this.dayOfWeekOnly;
    }

    public void setLabelAlignment(int alignment) {
        switch (alignment) {
            case 0: 
            case 1: {
                this.labelAlignment = alignment;
            }
        }
    }

    public int getLabelAlignment() {
        return this.labelAlignment;
    }
}

