/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.types;

import java.awt.Color;
import java.awt.Font;
import oracle.charts.internal.Errorfcn;
import oracle.charts.internal.MsgUtil;
import oracle.charts.types.ChartException;

public class BarDesc {
    public static final int STYLE_BASIC = 0;
    public static final int STYLE_DROP_SHADOW = 1;
    public static final int STYLE_EFFECT3D = 2;
    double barWidth = 0.0;
    int barStyle = 0;
    double barWidthFraction = 0.75;
    Color barColor = Color.black;
    Color negativeBarColor = new Color(200, 0, 0);
    Color pointLabelColor = this.barColor;
    boolean pointLabelsInterior = false;
    Font pointLabelFont = new Font("sansserif", 0, 11);
    Color shadowColor = Color.gray;
    boolean shadowColorDerived = true;
    double barWidthMax = -1.0;

    public void setBarColor(Color barColor) {
        if (barColor != null) {
            this.barColor = barColor;
        }
    }

    public void setNegativeBarColor(Color negativeBarColor) {
        if (negativeBarColor != null) {
            this.negativeBarColor = negativeBarColor;
        }
    }

    public void setPointLabelsInterior() {
        this.pointLabelsInterior = true;
    }

    public void setPointLabelColor(Color pointLabelColor) {
        if (pointLabelColor != null) {
            this.pointLabelColor = pointLabelColor;
        }
    }

    public void setPointLabelFont(Font f) {
        this.pointLabelFont = f;
    }

    public void setBarWidth(double barWidth) {
        if (barWidth > 0.0) {
            this.barWidth = barWidth;
        }
    }

    public void setBarWidthFraction(double barWidthFraction) {
        if (barWidthFraction > 0.0 && barWidthFraction <= 1.0) {
            this.barWidthFraction = barWidthFraction;
        }
    }

    public void setBarWidthMax(double barWidthMax) {
        this.barWidthMax = barWidthMax;
    }

    public void setBarShadowColor(Color shadowColor) {
        this.shadowColor = shadowColor;
        this.shadowColorDerived = false;
    }

    public void setBarShadowColorDerived() {
        this.shadowColorDerived = true;
    }

    public void setBarStyle(int barStyle) throws ChartException {
        switch (barStyle) {
            case 0: 
            case 1: 
            case 2: {
                this.barStyle = barStyle;
                break;
            }
            default: {
                Errorfcn.chartError("setBarStyle()", MsgUtil.getMsg("CHT-602"));
            }
        }
    }

    public Color getBarColor() {
        return this.barColor;
    }

    public Color getNegativeBarColor() {
        return this.negativeBarColor;
    }

    public Color getPointLabelColor() {
        return this.pointLabelColor;
    }

    public Color getBarShadowColor() {
        return this.shadowColor;
    }

    public double getBarWidth() {
        return this.barWidth;
    }

    public double getBarWidthFraction() {
        return this.barWidthFraction;
    }

    public double getBarWidthMax() {
        return this.barWidthMax;
    }

    public Font getPointLabelFont() {
        return this.pointLabelFont;
    }

    public boolean getPointLabelsInterior() {
        return this.pointLabelsInterior;
    }

    public int getBarStyle() {
        return this.barStyle;
    }

    public boolean getBarShadowColorDerived() {
        return this.shadowColorDerived;
    }
}

