/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.piechart;

import java.awt.Color;
import oracle.charts.internal.Errorfcn;
import oracle.charts.internal.MsgUtil;
import oracle.charts.piechart.PieChart;
import oracle.charts.types.ChartException;
import oracle.charts.types.GaugeStyleDesc;

public class Gauge
extends PieChart {
    private double gaugeLevel = 0.0;
    private double gaugeSpan = 120.0;
    Color gaugeNeedleColor = Color.black;

    public Gauge() {
        super.initGauge(this.gaugeSpan, this.gaugeLevel, this.gaugeNeedleColor);
    }

    public void setGaugeSpan(double degrees) throws ChartException {
        if (degrees < 0.0 || degrees > 360.0) {
            Errorfcn.chartError("setGaugeSpan", MsgUtil.getMsg("CHT-081"));
        }
        this.gaugeSpan = degrees;
        super.setGaugeSpanPrivate(degrees);
    }

    public double getGaugeLevel() {
        return this.gaugeLevel;
    }

    public void setGaugeLevel(double level) throws ChartException {
        String fcn = "setGaugeLevel()";
        if (this.gaugeLevel < 0.0 || this.gaugeLevel > 100.0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-080"));
        }
        this.gaugeLevel = level;
        super.setGaugeLevelPrivate(100.0 - this.gaugeLevel);
    }

    public void setGaugeNeedleColor(Color c) throws ChartException {
        if (c == null) {
            Errorfcn.chartError("setGaugeNeedleColor()", MsgUtil.getMsg("CHT-099"));
        }
        if (this.gaugeNeedleColor != null) {
            this.gaugeNeedleColor = c;
        }
        super.setGaugeNeedleColorPrivate(c);
    }

    public Color getGaugeNeedleColor() {
        return this.gaugeNeedleColor;
    }

    public void setGaugeAttributes(GaugeStyleDesc styleDesc) throws ChartException {
        super.setGaugeAttributes(styleDesc);
    }
}

