/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.internal;

import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import oracle.charts.types.LabelDesc;

public final class LabelUtil2 {
    public static AttributedString getLabelAttributedString(LabelDesc lDesc) {
        AttributedString attrStr = null;
        if (lDesc.getTextAttributes() != null) {
            attrStr = new AttributedString(lDesc.getText(), lDesc.getTextAttributes());
        }
        return attrStr;
    }

    public static int getLabelWidth(LabelDesc lDesc, FontRenderContext frc) {
        int currentLabelWidth = 0;
        if (lDesc.getText() != null) {
            AttributedString attrStr = LabelUtil2.getLabelAttributedString(lDesc);
            if (attrStr == null) {
                currentLabelWidth = lDesc.fontmet.stringWidth(lDesc.getText());
            } else {
                TextLayout layout = new TextLayout(attrStr.getIterator(), frc);
                currentLabelWidth = (int)Math.round(layout.getBounds().getWidth());
            }
        }
        return currentLabelWidth;
    }

    public static int getLabelHeight(LabelDesc lDesc, FontRenderContext frc) {
        int currentLabelHeight = 0;
        if (lDesc.getText() != null) {
            AttributedString attrStr = LabelUtil2.getLabelAttributedString(lDesc);
            if (attrStr == null) {
                currentLabelHeight = lDesc.fontmet.getHeight();
            } else {
                TextLayout layout = new TextLayout(attrStr.getIterator(), frc);
                currentLabelHeight = Math.round(layout.getAscent() + layout.getDescent());
            }
        }
        return currentLabelHeight;
    }
}

