/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.codec;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class Quantizer {
    private static final int RGB_HIST_DEPTH = 5;
    private static final int ARGB_HIST_DEPTH = 4;

    public static RenderedImage rgb24to8(RenderedImage input) {
        return Quantizer.rgb24to8(input, false, 1, null);
    }

    public static RenderedImage rgb24to8(RenderedImage input, Color pinColor) {
        return Quantizer.rgb24to8(input, false, 1, pinColor);
    }

    private static RenderedImage rgb24to8(RenderedImage input, boolean accurate, int sampling, Color pinColor) {
        Object[] sindx = null;
        if (!accurate) {
            sindx = new Object[1];
        }
        byte[][] byteLUT = Quantizer.computeRGBLUTMedian(input, sampling, 256, sindx, pinColor);
        byte[][][] spatialIndex = null;
        if (!accurate) {
            spatialIndex = (byte[][][])sindx[0];
        }
        IndexColorModel icm = new IndexColorModel(8, byteLUT[0].length, byteLUT[0], byteLUT[1], byteLUT[2]);
        BufferedImage output = new BufferedImage(input.getWidth(), input.getHeight(), 13, icm);
        Quantizer.quantize24Bits(input, output, byteLUT, spatialIndex);
        return output;
    }

    public static RenderedImage rgb24to4(RenderedImage input) {
        return Quantizer.rgb24to4(input, false, 1, null);
    }

    private static RenderedImage rgb24to4(RenderedImage input, boolean accurate, int sampling, Color pinColor) {
        Object[] sindx = null;
        if (!accurate) {
            sindx = new Object[1];
        }
        byte[][] byteLUT = Quantizer.computeRGBLUTMedian(input, sampling, 16, sindx, pinColor);
        byte[][][] spatialIndex = null;
        if (!accurate) {
            spatialIndex = (byte[][][])sindx[0];
        }
        IndexColorModel icm = new IndexColorModel(4, byteLUT[0].length, byteLUT[0], byteLUT[1], byteLUT[2]);
        BufferedImage output = new BufferedImage(input.getWidth(), input.getHeight(), 13, icm);
        Quantizer.quantize24Bits(input, output, byteLUT, spatialIndex);
        return output;
    }

    private static byte[][] computeRGBLUTMedian(RenderedImage img, int sampling, int maxColors, Object[] indexOut, Color pinColor) {
        int histDim = 32;
        int[][][] hist = new int[32][32][32];
        Quantizer.fillRGBHistogram(img, hist, sampling);
        Cube[] cubes = new Cube[maxColors];
        cubes[0] = new Cube(0, 0, 0, 31, 31, 31, hist);
        int numCubes = 1;
        while (numCubes < maxColors) {
            int toSplit = -1;
            int minGeneration = Integer.MAX_VALUE;
            int i = 0;
            while (i < numCubes) {
                if (cubes[i].generation < minGeneration && cubes[i].canSplit()) {
                    toSplit = i;
                    minGeneration = cubes[toSplit].generation;
                }
                ++i;
            }
            if (toSplit < 0) break;
            int splitDim = cubes[toSplit].findSplit();
            if (splitDim == 0) {
                throw new RuntimeException("Cube split inconsistency");
            }
            switch (splitDim) {
                case 1: {
                    cubes[numCubes++] = cubes[toSplit].splitRed(hist);
                    break;
                }
                case 2: {
                    cubes[numCubes++] = cubes[toSplit].splitGreen(hist);
                    break;
                }
                case 3: {
                    cubes[numCubes++] = cubes[toSplit].splitBlue(hist);
                }
            }
        }
        byte[][] tableData = new byte[3][maxColors];
        int i = 0;
        while (i < numCubes) {
            int color = cubes[i].color(hist);
            tableData[0][i] = (byte)(color >> 16 & 0xFF);
            tableData[1][i] = (byte)(color >> 8 & 0xFF);
            tableData[2][i] = (byte)(color & 0xFF);
            ++i;
        }
        if (pinColor != null) {
            int shift = 8 - Quantizer.numColorsToBits(hist.length);
            int r = pinColor.getRed();
            int g = pinColor.getGreen();
            int b = pinColor.getBlue();
            int rShift = r >> shift;
            int gShift = g >> shift;
            int bShift = b >> shift;
            int i2 = 0;
            while (i2 < numCubes) {
                if (cubes[i2].inCube(rShift, gShift, bShift)) {
                    tableData[0][i2] = (byte)r;
                    tableData[1][i2] = (byte)g;
                    tableData[2][i2] = (byte)b;
                    break;
                }
                ++i2;
            }
        }
        if (indexOut != null) {
            byte[][][] index = new byte[32][32][32];
            int i3 = 0;
            while (i3 < numCubes) {
                int r = cubes[i3].rmin;
                while (r <= cubes[i3].rmax) {
                    int g = cubes[i3].gmin;
                    while (g <= cubes[i3].gmax) {
                        int b = cubes[i3].bmin;
                        while (b <= cubes[i3].bmax) {
                            index[r][g][b] = (byte)i3;
                            ++b;
                        }
                        ++g;
                    }
                    ++r;
                }
                ++i3;
            }
            indexOut[0] = index;
        }
        return tableData;
    }

    private static void fillRGBHistogram(RenderedImage img, int[][][] hist, int sampling) {
        int minX = img.getMinX();
        int minY = img.getMinY();
        int width = img.getWidth();
        int height = img.getHeight();
        int numBands = img.getSampleModel().getNumBands();
        if (numBands < 3) {
            throw new RuntimeException("Insufficient bit depth in fillRGBHistogram input image");
        }
        int[] pixels = new int[width * numBands];
        int shift = 8 - Quantizer.numColorsToBits(hist.length);
        int rowStride = sampling;
        int colStride = numBands * sampling;
        int row = minY;
        while (row < minY + height) {
            Raster src = img.getData(new Rectangle(minX, row, width, 1));
            src.getPixels(minX, row, width, 1, pixels);
            int col = 0;
            while (col < numBands * width) {
                int r = pixels[col] >> shift;
                int g = pixels[col + 1] >> shift;
                int b = pixels[col + 2] >> shift;
                int[] nArray = hist[r][g];
                int n = b;
                nArray[n] = nArray[n] + 1;
                col += colStride;
            }
            row += rowStride;
        }
    }

    private static void quantize24Bits(RenderedImage input, BufferedImage output, byte[][] lut, byte[][][] spatialIndex) {
        int numBands;
        int shift = 0;
        if (spatialIndex != null) {
            shift = 8 - Quantizer.numColorsToBits(spatialIndex.length);
        }
        Hashtable rgbToLUT = null;
        if (spatialIndex == null) {
            rgbToLUT = new Hashtable();
        }
        if ((numBands = input.getSampleModel().getNumBands()) < 3) {
            throw new RuntimeException("Insufficient bit depth in quantize24Bits input image");
        }
        int minX = input.getMinX();
        int minY = input.getMinY();
        int width = input.getWidth();
        int height = input.getHeight();
        int[] pixels = new int[width * numBands];
        WritableRaster dest = output.getRaster();
        int y = 0;
        int row = minY;
        while (row < minY + height) {
            int index;
            int col;
            Raster src = input.getData(new Rectangle(minX, row, width, 1));
            src.getPixels(minX, row, width, 1, pixels);
            int x = 0;
            if (spatialIndex != null) {
                col = 0;
                while (col < numBands * width) {
                    index = spatialIndex[pixels[col] >> shift][pixels[col + 1] >> shift][pixels[col + 2] >> shift];
                    dest.setSample(x++, y, 0, index);
                    col += numBands;
                }
            } else {
                col = 0;
                while (col < numBands * width) {
                    index = Quantizer.findNearestRGBIndex(pixels[col], pixels[col + 1], pixels[col + 2], lut, rgbToLUT);
                    dest.setSample(x++, y, 0, index);
                    col += numBands;
                }
            }
            ++y;
            ++row;
        }
    }

    private static int findNearestRGBIndex(int r, int g, int b, byte[][] lut, Hashtable rgbToLUT) {
        Integer rgb = null;
        rgb = new Integer(r << 16 | g << 8 | b);
        Integer mapIndex = (Integer)rgbToLUT.get(rgb);
        if (mapIndex != null) {
            return mapIndex;
        }
        int bestDist = 196608;
        int bestIndex = 0;
        int i = 0;
        while (i < lut[0].length) {
            int dist = (r - (lut[0][i] & 0xFF)) * (r - (lut[0][i] & 0xFF)) + (g - (lut[1][i] & 0xFF)) * (g - (lut[1][i] & 0xFF)) + (b - (lut[2][i] & 0xFF)) * (b - (lut[2][i] & 0xFF));
            if (dist == 0) {
                bestIndex = i;
                break;
            }
            if (dist < bestDist) {
                bestIndex = i;
                bestDist = dist;
            }
            ++i;
        }
        rgbToLUT.put(rgb, new Integer(bestIndex));
        return bestIndex;
    }

    private static int findNearestRGBIndex(int r, int g, int b, byte[][] lut) {
        int bestDist = 196608;
        int bestIndex = 0;
        int i = 0;
        while (i < lut[0].length) {
            int dist = (r - (lut[0][i] & 0xFF)) * (r - (lut[0][i] & 0xFF)) + (g - (lut[1][i] & 0xFF)) * (g - (lut[1][i] & 0xFF)) + (b - (lut[2][i] & 0xFF)) * (b - (lut[2][i] & 0xFF));
            if (dist == 0) {
                return i;
            }
            if (dist < bestDist) {
                bestIndex = i;
                bestDist = dist;
            }
            ++i;
        }
        return bestIndex;
    }

    private static int numColorsToBits(int value) {
        int result = 0;
        --value;
        while (value > 0) {
            value = (value & Integer.MAX_VALUE) >> 1;
            ++result;
        }
        return result;
    }

    static class Cube {
        int rmin;
        int rmax;
        int gmin;
        int gmax;
        int bmin;
        int bmax;
        int generation = 0;
        int population = 0;

        boolean inCube(Color color, int shift) {
            int red = color.getRed();
            int green = color.getGreen();
            int blue = color.getBlue();
            return (red >>= shift) >= this.rmin && red <= this.rmax && (green >>= shift) >= this.gmin && green <= this.gmax && (blue >>= shift) >= this.bmin && blue <= this.bmax;
        }

        boolean inCube(int red, int green, int blue) {
            return red >= this.rmin && red <= this.rmax && green >= this.gmin && green <= this.gmax && blue >= this.bmin && blue <= this.bmax;
        }

        Cube(int rn, int gn, int bn, int rm, int gm, int bm, int[][][] hist) {
            this.rmin = rn;
            this.rmax = rm;
            this.gmin = gn;
            this.gmax = gm;
            this.bmin = bn;
            this.bmax = bm;
            this.shrink(hist);
        }

        int color(int[][][] hist) {
            int factor = 256 / hist.length;
            long rsum = 0L;
            long gsum = 0L;
            long bsum = 0L;
            long sum = 0L;
            int r = this.rmin;
            while (r <= this.rmax) {
                int g = this.gmin;
                while (g <= this.gmax) {
                    int b = this.bmin;
                    while (b <= this.bmax) {
                        if (hist[r][g][b] != 0) {
                            rsum += (long)(r * hist[r][g][b]);
                            gsum += (long)(g * hist[r][g][b]);
                            bsum += (long)(b * hist[r][g][b]);
                            sum += (long)hist[r][g][b];
                        }
                        ++b;
                    }
                    ++g;
                }
                ++r;
            }
            int red = (int)(rsum * (long)factor / sum);
            int green = (int)(gsum * (long)factor / sum);
            int blue = (int)(bsum * (long)factor / sum);
            int max = (hist.length - 1) * factor;
            if (red == max) {
                red = 255;
            }
            if (green == max) {
                green = 255;
            }
            if (blue == max) {
                blue = 255;
            }
            return red << 16 | green << 8 | blue;
        }

        void shrink(int[][][] hist) {
            int newRmin = this.rmax;
            int newRmax = this.rmin;
            int newGmin = this.gmax;
            int newGmax = this.gmin;
            int newBmin = this.bmax;
            int newBmax = this.bmin;
            int r = this.rmin;
            while (r <= this.rmax) {
                int g = this.gmin;
                while (g <= this.gmax) {
                    int b = this.bmin;
                    while (b <= this.bmax) {
                        if (hist[r][g][b] != 0) {
                            if (r < newRmin) {
                                newRmin = r;
                            }
                            if (g < newGmin) {
                                newGmin = g;
                            }
                            if (b < newBmin) {
                                newBmin = b;
                            }
                            if (r > newRmax) {
                                newRmax = r;
                            }
                            if (g > newGmax) {
                                newGmax = g;
                            }
                            if (b > newBmax) {
                                newBmax = b;
                            }
                            this.population += hist[r][g][b];
                        }
                        ++b;
                    }
                    ++g;
                }
                ++r;
            }
            this.rmin = newRmin;
            this.rmax = newRmax;
            this.gmin = newGmin;
            this.gmax = newGmax;
            this.bmin = newBmin;
            this.bmax = newBmax;
        }

        boolean canSplit() {
            if (this.rmax - this.rmin == 0 && this.gmax - this.gmin == 0 && this.bmax - this.bmin == 0) {
                return false;
            }
            return this.population >= 2;
        }

        int findSplit() {
            int rLen = this.rmax - this.rmin;
            int gLen = this.gmax - this.gmin;
            int bLen = this.bmax - this.bmin;
            if (!this.canSplit()) {
                return 0;
            }
            if (gLen >= rLen && gLen >= bLen) {
                return 2;
            }
            if (rLen >= bLen) {
                return 1;
            }
            return 3;
        }

        Cube splitRed(int[][][] hist) {
            int split;
            if (this.rmax - this.rmin == 1) {
                split = this.rmax;
            } else {
                int pop = 0;
                int half = this.population / 2;
                split = this.rmin;
                while (split < this.rmax && pop < half) {
                    int g = this.gmin;
                    while (g <= this.gmax && pop < half) {
                        int b = this.bmin;
                        while (b <= this.bmax && pop < half) {
                            pop += hist[split][g][b];
                            ++b;
                        }
                        ++g;
                    }
                    ++split;
                }
            }
            if (split == this.rmin) {
                ++split;
            }
            Cube cube = new Cube(split, this.gmin, this.bmin, this.rmax, this.gmax, this.bmax, hist);
            cube.generation = this.generation + 1;
            ++this.generation;
            this.population = 0;
            this.rmax = split - 1;
            this.shrink(hist);
            return cube;
        }

        Cube splitGreen(int[][][] hist) {
            int split;
            if (this.gmax - this.gmin == 1) {
                split = this.gmax;
            } else {
                int pop = 0;
                int half = this.population / 2;
                split = this.gmin;
                while (split < this.gmax && pop < half) {
                    int r = this.rmin;
                    while (r <= this.rmax && pop < half) {
                        int b = this.bmin;
                        while (b <= this.bmax && pop < half) {
                            pop += hist[r][split][b];
                            ++b;
                        }
                        ++r;
                    }
                    ++split;
                }
            }
            if (split == this.gmin) {
                ++split;
            }
            Cube cube = new Cube(this.rmin, split, this.bmin, this.rmax, this.gmax, this.bmax, hist);
            cube.generation = this.generation + 1;
            ++this.generation;
            this.population = 0;
            this.gmax = split - 1;
            this.shrink(hist);
            return cube;
        }

        Cube splitBlue(int[][][] hist) {
            int split;
            if (this.bmax - this.bmin == 1) {
                split = this.bmax;
            } else {
                int pop = 0;
                int half = this.population / 2;
                split = this.bmin;
                while (split < this.bmax && pop < half) {
                    int r = this.rmin;
                    while (r <= this.rmax && pop < half) {
                        int g = this.gmin;
                        while (g <= this.gmax && pop < half) {
                            pop += hist[r][g][split];
                            ++g;
                        }
                        ++r;
                    }
                    ++split;
                }
            }
            if (split == this.bmin) {
                ++split;
            }
            Cube cube = new Cube(this.rmin, this.gmin, split, this.rmax, this.gmax, this.bmax, hist);
            cube.generation = this.generation + 1;
            ++this.generation;
            this.population = 0;
            this.bmax = split - 1;
            this.shrink(hist);
            return cube;
        }

        public String toString() {
            String s = "(" + this.rmin + ", " + this.gmin + ", " + this.bmin + ") (" + this.rmax + ", " + this.gmax + ", " + this.bmax + "); gen = " + this.generation + "; pop = " + this.population;
            return s;
        }
    }
}

