/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.axischart.internal;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.image.BufferedImage;
import java.util.Date;
import oracle.charts.axischart.internal.MillisecondsCalendar;
import oracle.charts.internal.Errorfcn;
import oracle.charts.internal.MsgUtil;
import oracle.charts.svg.SVGXLinkArrayDesc;
import oracle.charts.svg.SVGXLinkDesc;
import oracle.charts.types.ChartException;

public class LineDescription {
    public static final int POINT = 0;
    public static final int LINE = 1;
    public static final int AREA = 2;
    public static final int AREA_CUMULATIVE = 3;
    public static final int BAR = 4;
    public static final int BAR_STACKED = 5;
    public static final int HILOCLOSE = 7;
    public static final int OPENHILOCLOSE = 8;
    public static final int CANDLESTICK = 9;
    public String seriesName;
    public SVGXLinkArrayDesc svgSeriesD = null;
    public SVGXLinkDesc svgSeriesNameD = null;
    public String svgSeriesScript = null;
    public int lineType = 1;
    public int markerType = 0;
    public double markerScale = 1.0;
    public boolean axisPrimary = true;
    public Color color = Color.black;
    public Color[] multiColor = null;
    public int barStyle = 0;
    public boolean barShadowColorDerived = true;
    public Color barShadowColor = Color.gray;
    public boolean userDefinedDescriptorSet = false;
    public boolean colorSelectivelySet = false;
    public boolean widthSelectivelySet = false;
    public Color color2 = new Color(0.4f, 0.4f, 0.4f);
    public float alphaArea = 1.0f;
    public Color color3 = new Color(0.7f, 0.7f, 0.7f);
    public boolean negativeColor = true;
    public int lineStyle = 1;
    public BasicStroke lineStroke = new BasicStroke(2.5f, 0, 2);
    public double width = 3.0;
    public double widthMax = -1.0;
    public int width2 = 3;
    public int length = 0;
    public boolean userDefinedThickness = false;
    public double BarThicknessPct = 0.75;
    public int num_points;
    public double ymin = Double.MAX_VALUE;
    public double ymax = Double.NEGATIVE_INFINITY;
    public int[][] imageMapCoords;
    public int imageMapShape = 0;
    public int[][] imageMapCoordsBarIcon;
    public int imageMapShapeBarIcon = 0;
    public int[][] imageMapCoordsAreaC;
    public int imageMapShapeAreaC = 2;
    public double[] yval;
    public int[] yval_int;
    public double[] yval_dbl;
    public double[] yopen;
    public int[] yopen_int;
    public double[] yhigh;
    public int[] yhigh_int;
    public double[] ylow;
    public int[] ylow_int;
    public double[] yclose;
    public int[] yclose_int;
    Date startDate;
    public int startDateIndex = 0;
    public boolean containsAllZero = false;
    public boolean containsNaN = false;
    public boolean containsAllNaN = false;
    public String[] pointLabels;
    public boolean pointLabelsOn = false;
    public BufferedImage[] barIcons;
    public boolean containsBarIcons = false;
    public boolean pointLabelsInterior = false;
    public Color pointLabelColor = Color.black;
    public Font pointLabelFont = new Font("sansserif", 0, 11);
    public FontMetrics fontmet;
    public boolean includeInLegend = true;
    public int[] timestampIndex;
    public int[] xval_int;
    public double[] xval_dbl;
    public boolean subFrequency = false;
    public double[] xval_orig;
    public double[] xval_cont;
    public double[] xval_cont_dbl;
    public int[] xval_cont_int;
    public Date[] contDates;
    public double minXInterval = 1.0;
    public double barAdjustFactor = 1.0;
    public Color hilightColor;
    public int hilightIndex = -1;
    public int popupIndex = -1;
    public int[] mapTimebandIndexes;

    public int getFontHeight() {
        int labelHeight = this.fontmet.getHeight();
        return labelHeight;
    }

    public boolean isFirstTimestampTimebandIndex() {
        if (this.mapTimebandIndexes == null) {
            return false;
        }
        return this.timestampIndex == null ? this.mapTimebandIndexes[0] == 0 : this.timestampIndex[this.mapTimebandIndexes[0]] == 0;
    }

    public boolean isLastTimestampTimebandIndex(int compareIndex) {
        if (this.mapTimebandIndexes == null) {
            return false;
        }
        int lastTimebandIndex = this.mapTimebandIndexes.length - 1;
        return this.timestampIndex == null ? this.mapTimebandIndexes[lastTimebandIndex] == compareIndex : this.timestampIndex[this.mapTimebandIndexes[lastTimebandIndex]] == compareIndex;
    }

    public int getSparseIndex(int tstampIndex) {
        int i = 0;
        while (i < this.timestampIndex.length) {
            if (this.timestampIndex[i] == tstampIndex) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void dumpSparseIndex(int tstampIndex) {
        int i = 0;
        while (i < this.timestampIndex.length) {
            System.out.println(this.timestampIndex[i] + " " + tstampIndex);
            ++i;
        }
    }

    public LineDescription() {
    }

    public LineDescription(String name, boolean genImageMapCoords) throws ChartException {
        this.seriesName = name;
        this.yval = new double[0];
        this.yval_int = new int[0];
        this.yval_dbl = new double[0];
        this.num_points = 0;
        if (genImageMapCoords) {
            this.imageMapCoords = new int[0][0];
            this.imageMapCoordsBarIcon = new int[0][0];
        }
    }

    public LineDescription(String name, Date[] TStamps, boolean genImageMapCoords, double[] y, Date startDate, int length) throws ChartException {
        this.seriesName = name;
        this.yval = new double[length];
        this.yval_int = new int[length];
        this.yval_dbl = new double[length];
        if (genImageMapCoords) {
            this.imageMapCoords = new int[length][0];
            this.imageMapCoordsBarIcon = new int[length][0];
        }
        int i = 0;
        while (i < length) {
            this.yval[i] = y[i];
            ++i;
        }
        this.num_points = length;
        i = 0;
        while (TStamps[i].before(startDate) && i < TStamps.length - 1) {
            ++i;
        }
        this.startDateIndex = i;
        this.internalCheckLength(TStamps.length, this.startDateIndex, length);
    }

    public LineDescription(String name, boolean genImageMapCoords, double[] y, int length) throws ChartException {
        this.seriesName = name;
        this.yval_int = new int[length];
        this.yval_dbl = new double[length];
        if (genImageMapCoords) {
            this.imageMapCoords = new int[length][0];
            this.imageMapCoordsBarIcon = new int[length][0];
        }
        this.yval = y;
        this.num_points = length;
    }

    public void appendSeries(boolean genImageMapCoords, double[] yappend) throws ChartException {
        int appendLength = yappend.length;
        int oldLength = this.num_points;
        int newLength = oldLength + appendLength;
        double[] yvalTemp = new double[oldLength];
        int i = 0;
        while (i < oldLength) {
            yvalTemp[i] = this.yval[i];
            ++i;
        }
        this.yval_int = new int[newLength];
        this.yval = new double[newLength];
        this.yval_dbl = new double[newLength];
        i = 0;
        while (i < oldLength) {
            this.yval[i] = yvalTemp[i];
            ++i;
        }
        int k = 0;
        i = oldLength;
        while (i < newLength) {
            this.yval[i] = yappend[k++];
            ++i;
        }
        this.num_points = newLength;
        if (genImageMapCoords) {
            this.imageMapCoords = new int[this.length][0];
            this.imageMapCoordsBarIcon = new int[this.length][0];
        }
    }

    public void shiftSeries(boolean genImageMapCoords, int numElements) throws ChartException {
        int oldLength = this.num_points;
        int newLength = this.num_points - numElements;
        double[] yvalTemp = new double[newLength];
        int i = 0;
        while (i < newLength) {
            yvalTemp[i] = this.yval[i + numElements];
            ++i;
        }
        this.yval = new double[newLength];
        this.yval_int = new int[newLength];
        this.yval_dbl = new double[newLength];
        i = 0;
        while (i < newLength) {
            this.yval[i] = yvalTemp[i];
            ++i;
        }
        this.num_points = newLength;
        if (genImageMapCoords) {
            this.imageMapCoords = new int[this.length][0];
            this.imageMapCoordsBarIcon = new int[this.length][0];
        }
    }

    public LineDescription(String name, int labelXCount, boolean genImageMapCoords, double[] y, int startDateIndex, int length) throws ChartException {
        this.seriesName = name;
        this.yval_int = new int[length];
        this.yval_dbl = new double[length];
        if (genImageMapCoords) {
            this.imageMapCoords = new int[length][0];
            this.imageMapCoordsBarIcon = new int[length][0];
        }
        this.yval = y;
        this.num_points = length;
        this.internalCheckLength(labelXCount, startDateIndex, length);
    }

    public LineDescription(String name, Date[] TStamps, boolean genImageMapCoords, double[] yopen, double[] yhigh, double[] ylow, double[] yclose, Date startDate, int length) throws ChartException {
        this.seriesName = name;
        this.yopen_int = new int[length];
        this.yhigh_int = new int[length];
        this.ylow_int = new int[length];
        this.yclose_int = new int[length];
        if (genImageMapCoords) {
            this.imageMapCoords = new int[length][0];
            this.imageMapCoordsBarIcon = new int[length][0];
        }
        this.yopen = yopen;
        this.yhigh = yhigh;
        this.ylow = ylow;
        this.yclose = yclose;
        this.num_points = length;
        int i = 0;
        while (TStamps[i].before(startDate)) {
            ++i;
        }
        this.startDateIndex = i;
        this.internalCheckLength(TStamps.length, this.startDateIndex, length);
    }

    public LineDescription(String name, boolean genImageMapCoords, double[] yopen, double[] yhigh, double[] ylow, double[] yclose, int length) throws ChartException {
        this.seriesName = name;
        this.yopen_int = new int[length];
        this.yhigh_int = new int[length];
        this.ylow_int = new int[length];
        this.yclose_int = new int[length];
        if (genImageMapCoords) {
            this.imageMapCoords = new int[length][0];
            this.imageMapCoordsBarIcon = new int[length][0];
        }
        this.yopen = yopen;
        this.yhigh = yhigh;
        this.ylow = ylow;
        this.yclose = yclose;
        this.num_points = length;
    }

    public LineDescription(String name, int labelXCount, boolean genImageMapCoords, double[] yopen, double[] yhigh, double[] ylow, double[] yclose, int startDateIndex, int length) throws ChartException {
        this.seriesName = name;
        this.yopen_int = new int[length];
        this.yhigh_int = new int[length];
        this.ylow_int = new int[length];
        this.yclose_int = new int[length];
        if (genImageMapCoords) {
            this.imageMapCoords = new int[length][0];
            this.imageMapCoordsBarIcon = new int[length][0];
        }
        this.yopen = yopen;
        this.yhigh = yhigh;
        this.ylow = ylow;
        this.yclose = yclose;
        this.num_points = length;
        this.internalCheckLength(labelXCount, startDateIndex, length);
    }

    public void appendSeries(boolean genImageMapCoords, double[] yopenAppend, double[] yhighAppend, double[] ylowAppend, double[] ycloseAppend) throws ChartException {
        int appendLength = yopenAppend.length;
        int oldLength = this.num_points;
        int newLength = oldLength + appendLength;
        double[] yopenTemp = new double[oldLength];
        double[] yhighTemp = new double[oldLength];
        double[] ylowTemp = new double[oldLength];
        double[] ycloseTemp = new double[oldLength];
        int i = 0;
        while (i < oldLength) {
            yopenTemp[i] = yopenAppend[i];
            yhighTemp[i] = yhighAppend[i];
            ylowTemp[i] = ylowAppend[i];
            ycloseTemp[i] = ycloseAppend[i];
            ++i;
        }
        this.yopen = new double[newLength];
        this.yhigh = new double[newLength];
        this.ylow = new double[newLength];
        this.yclose = new double[newLength];
        this.yopen_int = new int[newLength];
        this.yhigh_int = new int[newLength];
        this.ylow_int = new int[newLength];
        this.yclose_int = new int[newLength];
        i = 0;
        while (i < oldLength) {
            this.yopen[i] = yopenTemp[i];
            this.yhigh[i] = yhighTemp[i];
            this.ylow[i] = ylowTemp[i];
            this.yclose[i] = ycloseTemp[i];
            ++i;
        }
        int k = 0;
        i = oldLength;
        while (i < newLength) {
            this.yopen[i] = yopenAppend[k];
            this.yhigh[i] = yhighAppend[k];
            this.ylow[i] = ylowAppend[k];
            this.yclose[i] = ycloseAppend[k];
            ++k;
            ++i;
        }
        this.num_points = newLength;
        if (genImageMapCoords) {
            this.imageMapCoords = new int[this.length][0];
            this.imageMapCoordsBarIcon = new int[this.length][0];
        }
    }

    public void appendSeries(boolean genImageMapCoords, double[] yhighAppend, double[] ylowAppend, double[] ycloseAppend) throws ChartException {
        int appendLength = yhighAppend.length;
        int oldLength = this.num_points;
        int newLength = oldLength + appendLength;
        double[] yhighTemp = new double[oldLength];
        double[] ylowTemp = new double[oldLength];
        double[] ycloseTemp = new double[oldLength];
        int i = 0;
        while (i < oldLength) {
            yhighTemp[i] = yhighAppend[i];
            ylowTemp[i] = ylowAppend[i];
            ycloseTemp[i] = ycloseAppend[i];
            ++i;
        }
        this.yhigh = new double[newLength];
        this.ylow = new double[newLength];
        this.yclose = new double[newLength];
        this.yhigh_int = new int[newLength];
        this.ylow_int = new int[newLength];
        this.yclose_int = new int[newLength];
        i = 0;
        while (i < oldLength) {
            this.yhigh[i] = yhighTemp[i];
            this.ylow[i] = ylowTemp[i];
            this.yclose[i] = ycloseTemp[i];
            ++i;
        }
        int k = 0;
        i = oldLength;
        while (i < newLength) {
            this.yhigh[i] = yhighAppend[k];
            this.ylow[i] = ylowAppend[k];
            this.yclose[i] = ycloseAppend[k];
            ++k;
            ++i;
        }
        this.num_points = newLength;
        if (genImageMapCoords) {
            this.imageMapCoords = new int[this.length][0];
            this.imageMapCoordsBarIcon = new int[this.length][0];
        }
    }

    public LineDescription(String name, Date[] TStamps, boolean genImageMapCoords, double[] yhigh, double[] ylow, double[] yclose, Date startDate, int length) throws ChartException {
        this.seriesName = name;
        this.yhigh_int = new int[length];
        this.ylow_int = new int[length];
        this.yclose_int = new int[length];
        if (genImageMapCoords) {
            this.imageMapCoords = new int[length][0];
            this.imageMapCoordsBarIcon = new int[length][0];
        }
        this.yhigh = yhigh;
        this.ylow = ylow;
        this.yclose = yclose;
        this.num_points = length;
        int i = 0;
        while (TStamps[i].before(startDate)) {
            ++i;
        }
        this.startDateIndex = i;
        this.internalCheckLength(TStamps.length, this.startDateIndex, length);
    }

    public LineDescription(String name, boolean genImageMapCoords, double[] yhigh, double[] ylow, double[] yclose, int length) throws ChartException {
        this.seriesName = name;
        this.yhigh_int = new int[length];
        this.ylow_int = new int[length];
        this.yclose_int = new int[length];
        if (genImageMapCoords) {
            this.imageMapCoords = new int[length][0];
            this.imageMapCoordsBarIcon = new int[length][0];
        }
        this.yhigh = yhigh;
        this.ylow = ylow;
        this.yclose = yclose;
        this.num_points = length;
    }

    public LineDescription(String name, Date[] TStamps, boolean genImageMapCoords, double[] yhigh, double[] ylow, double[] yclose, int startDateIndex, int length) throws ChartException {
        this.seriesName = name;
        this.yhigh_int = new int[length];
        this.ylow_int = new int[length];
        this.yclose_int = new int[length];
        if (genImageMapCoords) {
            this.imageMapCoords = new int[length][0];
            this.imageMapCoordsBarIcon = new int[length][0];
        }
        this.yhigh = yhigh;
        this.ylow = ylow;
        this.yclose = yclose;
        this.num_points = length;
        this.internalCheckLength(TStamps.length, startDateIndex, length);
    }

    public void createSparse(Date[] TStamps, Date[] tstamps) throws ChartException {
        int sparseIndex = 0;
        int length = tstamps.length;
        this.timestampIndex = new int[length];
        this.xval_int = new int[length];
        this.xval_dbl = new double[length];
        this.subFrequency = true;
        this.contDates = tstamps;
        int i = 0;
        while (i < TStamps.length) {
            if (!tstamps[sparseIndex].after(TStamps[i])) {
                this.timestampIndex[sparseIndex] = i;
                ++sparseIndex;
            }
            if (sparseIndex >= length) break;
            ++i;
        }
        if (sparseIndex < length) {
            System.out.println("Warning: sparseIndex < length " + sparseIndex);
        }
    }

    protected void dumpContinuous() {
        int i = 0;
        while (i < this.xval_cont.length) {
            System.out.print(this.xval_cont[i] + " ");
            ++i;
        }
        System.out.println();
    }

    protected void dumpContinuousInt() {
        int i = 0;
        while (i < this.xval_cont_int.length) {
            System.out.print(this.xval_cont_int[i] + " ");
            ++i;
        }
        System.out.println();
    }

    protected void dumpContinuousDates() {
        int i = 0;
        while (i < this.contDates.length) {
            System.out.print(this.contDates[i] + " ");
            ++i;
        }
        System.out.println();
    }

    public void createContinuous(Date[] tstamps, double xAxisStartMillis, double xAxisSpanMillis, MillisecondsCalendar tempCal) throws ChartException {
        this.xval_cont_int = new int[tstamps.length];
        this.xval_cont = new double[tstamps.length];
        this.xval_cont_dbl = new double[tstamps.length];
        this.contDates = tstamps;
        double startMillis = xAxisStartMillis;
        double spanMillis = xAxisSpanMillis;
        double indexMillis = 0.0;
        double minInterval = 1.0;
        double currentInterval = 0.0;
        if (tstamps.length > 0) {
            tempCal.setTime(tstamps[0]);
            indexMillis = tempCal.getTimeInMillis();
            this.xval_cont[0] = (indexMillis - startMillis) / spanMillis;
            this.xval_cont_dbl[0] = this.xval_cont[0];
        }
        int i = 1;
        while (i < tstamps.length) {
            tempCal.setTime(tstamps[i]);
            indexMillis = tempCal.getTimeInMillis();
            this.xval_cont[i] = (indexMillis - startMillis) / spanMillis;
            this.xval_cont_dbl[i] = this.xval_cont[i];
            currentInterval = this.xval_cont[i] - this.xval_cont[i - 1];
            if (currentInterval < minInterval) {
                minInterval = currentInterval;
            }
            ++i;
        }
        this.minXInterval = minInterval;
        this.barAdjustFactor = 1.0 / minInterval / (1.0 / minInterval + 1.0);
    }

    public void createContinuousNumerical(double[] xvals, double xAxisStartVal, double xAxisSpanVal) throws ChartException {
        this.xval_cont_int = new int[xvals.length];
        this.xval_cont = new double[xvals.length];
        this.xval_cont_dbl = new double[xvals.length];
        this.xval_orig = xvals;
        double minInterval = 1.0;
        double currentInterval = 0.0;
        if (xvals.length > 0) {
            this.xval_cont[0] = (xvals[0] - xAxisStartVal) / xAxisSpanVal;
            this.xval_cont_dbl[0] = this.xval_cont[0];
        }
        int i = 1;
        while (i < xvals.length) {
            this.xval_cont[i] = (xvals[i] - xAxisStartVal) / xAxisSpanVal;
            this.xval_cont_dbl[i] = this.xval_cont[i];
            currentInterval = this.xval_cont[i] - this.xval_cont[i - 1];
            if (currentInterval < minInterval) {
                minInterval = currentInterval;
            }
            ++i;
        }
        this.minXInterval = minInterval;
        this.barAdjustFactor = 1.0 / minInterval / (1.0 / minInterval + 1.0);
    }

    public void appendSparse(Date[] TStamps, Date[] tstamps, double[] yvalues) {
        int oldLength = this.timestampIndex.length;
        int appendLength = yvalues.length;
        int newLength = appendLength + oldLength;
        int[] timestampIndexTemp = new int[oldLength];
        int[] xval_intTemp = new int[oldLength];
        double[] xval_dblTemp = new double[oldLength];
        int i = 0;
        while (i < oldLength) {
            timestampIndexTemp[i] = this.timestampIndex[i];
            xval_intTemp[i] = this.xval_int[i];
            xval_dblTemp[i] = this.xval_dbl[i];
            ++i;
        }
        this.timestampIndex = new int[newLength];
        this.xval_int = new int[newLength];
        this.xval_dbl = new double[newLength];
        i = 0;
        while (i < oldLength) {
            this.timestampIndex[i] = timestampIndexTemp[i];
            this.xval_int[i] = xval_intTemp[i];
            this.xval_dbl[i] = xval_dblTemp[i];
            ++i;
        }
        int sparseIndex = oldLength;
        int k = 0;
        i = this.timestampIndex[oldLength - 1];
        while (i < TStamps.length) {
            if (!tstamps[k].after(TStamps[i])) {
                this.timestampIndex[sparseIndex] = i;
                ++sparseIndex;
                ++k;
            }
            if (sparseIndex >= newLength) break;
            ++i;
        }
        if (sparseIndex < newLength) {
            System.out.println("Warning: sparseIndex < length " + sparseIndex);
        }
    }

    private void internalCheckLength(int TStampsLengthOrLabelXCount, int startDateIndex, int yarray_length) throws ChartException {
        int labelCount = TStampsLengthOrLabelXCount - startDateIndex;
        if (labelCount < yarray_length) {
            Errorfcn.chartError("setYSeries()", MsgUtil.getMsg("CHT-100") + " \"" + this.seriesName + "\" " + MsgUtil.getMsg("CHT-230") + " (" + yarray_length + " > " + TStampsLengthOrLabelXCount + ")");
        }
    }

    private void setMinMax(double[] y, boolean init) {
        if (y.length < 1) {
            return;
        }
        int i = 0;
        if (init) {
            this.containsAllZero = false;
            this.containsNaN = false;
            this.containsAllNaN = false;
            this.ymin = Double.MAX_VALUE;
            this.ymax = Double.MIN_VALUE;
        }
        while (i < this.num_points && Double.isNaN(y[i])) {
            ++i;
            this.containsNaN = true;
        }
        if (i < this.num_points) {
            this.ymin = y[i];
            this.ymax = y[i];
            ++i;
            while (i < this.num_points) {
                if (!Double.isNaN(y[i])) {
                    if (y[i] < this.ymin) {
                        this.ymin = y[i];
                    } else if (y[i] > this.ymax) {
                        this.ymax = y[i];
                    }
                } else {
                    this.containsNaN = true;
                }
                ++i;
            }
        } else {
            this.ymin = 0.0;
            this.ymax = 0.0;
            this.containsAllNaN = true;
            this.containsAllZero = true;
        }
        if (this.ymin == 0.0 && this.ymax == 0.0) {
            this.containsAllZero = true;
        }
    }

    public int countNaNSegments(boolean mapTimeband, int[] mapCount) {
        if (mapTimeband) {
            this.mapTimebandIndexes = new int[mapCount[0]];
        }
        mapCount[0] = 0;
        if (this.yval.length < 1) {
            return 0;
        }
        int i = 0;
        boolean lastPointIsNaN = false;
        int count = 0;
        if (this.yval.length > 0 && Double.isNaN(this.yval[0])) {
            lastPointIsNaN = true;
            if (mapTimeband) {
                this.mapTimebandIndexes[mapCount[0]] = i;
            }
            mapCount[0] = mapCount[0] + 1;
        }
        if (i < this.num_points) {
            ++i;
            while (i < this.num_points) {
                if (!lastPointIsNaN && Double.isNaN(this.yval[i])) {
                    if (mapTimeband) {
                        this.mapTimebandIndexes[mapCount[0]] = i - 1;
                    }
                    ++count;
                    mapCount[0] = mapCount[0] + 1;
                } else if (lastPointIsNaN && !Double.isNaN(this.yval[i])) {
                    if (mapTimeband) {
                        this.mapTimebandIndexes[mapCount[0]] = i;
                    }
                    ++count;
                    mapCount[0] = mapCount[0] + 1;
                }
                lastPointIsNaN = Double.isNaN(this.yval[i]);
                ++i;
            }
            if (lastPointIsNaN) {
                if (mapTimeband) {
                    this.mapTimebandIndexes[mapCount[0]] = i - 1;
                }
                mapCount[0] = mapCount[0] + 1;
            }
        }
        return count;
    }

    public void MinMax() throws ChartException {
        if (this.yval.length < 1) {
            return;
        }
        this.setMinMax(this.yval, true);
        if (this.ymin == Double.POSITIVE_INFINITY || this.ymax == Double.POSITIVE_INFINITY) {
            Errorfcn.chartError("setYSeries()", MsgUtil.getMsg("CHT-155"));
        }
        if (this.ymin == Double.NEGATIVE_INFINITY || this.ymax == Double.NEGATIVE_INFINITY) {
            Errorfcn.chartError("setYSeries()", MsgUtil.getMsg("CHT-156"));
        }
    }

    public void MinMaxStock() throws ChartException {
        if (this.ylow.length < 1) {
            return;
        }
        this.setMinMax(this.ylow, true);
        this.setMinMax(this.yhigh, false);
        if (this.ymin == Double.POSITIVE_INFINITY || this.ymax == Double.POSITIVE_INFINITY) {
            Errorfcn.chartError("setYSeries()", MsgUtil.getMsg("CHT-155"));
        }
        if (this.ymin == Double.NEGATIVE_INFINITY || this.ymax == Double.NEGATIVE_INFINITY) {
            Errorfcn.chartError("setYSeries()", MsgUtil.getMsg("CHT-156"));
        }
    }

    public void unsetNegativeColor() {
        this.negativeColor = false;
    }
}

