/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.axischart;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.sql.Timestamp;
import java.text.AttributedString;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import oracle.charts.Chart;
import oracle.charts.annotation.Annotation;
import oracle.charts.axischart.internal.AnnotationPlacement;
import oracle.charts.axischart.internal.AxisTitle;
import oracle.charts.axischart.internal.ChartDescription;
import oracle.charts.axischart.internal.DimensionElement;
import oracle.charts.axischart.internal.DropShadow;
import oracle.charts.axischart.internal.Effect3D;
import oracle.charts.axischart.internal.HorizontalLayout;
import oracle.charts.axischart.internal.LabelUtil;
import oracle.charts.axischart.internal.LineDescription;
import oracle.charts.axischart.internal.MathUtil;
import oracle.charts.axischart.internal.MillisecondsCalendar;
import oracle.charts.axischart.internal.NumAxisLabel;
import oracle.charts.axischart.internal.NumAxisRenderer;
import oracle.charts.axischart.internal.NumAxisStretch;
import oracle.charts.axischart.internal.NumericalFormat;
import oracle.charts.axischart.internal.StringLabel;
import oracle.charts.axischart.internal.SvgUtil2;
import oracle.charts.axischart.internal.TimeAxisContinuous;
import oracle.charts.axischart.internal.TimeBand;
import oracle.charts.axischart.internal.TimeUtil;
import oracle.charts.axischart.internal.XLabel;
import oracle.charts.internal.Errorfcn;
import oracle.charts.internal.LineMarker;
import oracle.charts.internal.MsgUtil;
import oracle.charts.internal.Precision;
import oracle.charts.internal.SvgUtil;
import oracle.charts.legend.Legend2;
import oracle.charts.svg.SVGXLinkArrayDesc;
import oracle.charts.types.AnnotationDesc;
import oracle.charts.types.AreaDesc;
import oracle.charts.types.AxisDesc;
import oracle.charts.types.AxisTitleDesc;
import oracle.charts.types.BarDesc;
import oracle.charts.types.BevelDesc;
import oracle.charts.types.BevelRectIconDesc;
import oracle.charts.types.ChartException;
import oracle.charts.types.FillEdgeDesc;
import oracle.charts.types.GridDesc;
import oracle.charts.types.HiLoCloseDesc;
import oracle.charts.types.LegendDesc;
import oracle.charts.types.LineDesc;
import oracle.charts.types.MarkerDesc;
import oracle.charts.types.NumAxisDesc;
import oracle.charts.types.NumBandDesc;
import oracle.charts.types.NumThresholdDesc;
import oracle.charts.types.SideIconDesc;
import oracle.charts.types.StringAxisDesc;
import oracle.charts.types.SubChartSeparatorStyleDesc;
import oracle.charts.types.TimeAxisDesc;
import oracle.charts.types.TimeBandDesc;
import oracle.charts.types.TimeIntervalDesc;
import oracle.charts.types.TimeIntervalVisualDesc;
import oracle.viz.util.svg.SVGGraphics;

public abstract class AxisCore
extends Chart {
    Color PlotBackground = new Color(240, 240, 240);
    Color PlotEdgeColor = Color.black;
    Color PlotAxisLineColor = Color.black;
    Color SubChartBoundaryColor = Color.gray;
    boolean subChartBoundaryColorSet = false;
    Color SubChartBoundaryEdgeColor = Color.gray;
    boolean subChartBoundaryEdgeColorSet = false;
    final boolean testfreqDim = false;
    final boolean test = false;
    final boolean testYAxis = false;
    final boolean testXLabel = false;
    BufferedImage BI = null;
    XLabel xl = new XLabel(this.ChartLocale);
    boolean reverseStackOrder = false;
    public static final int XAXIS = 1;
    public static final int YAXIS = 2;
    public static final int XYAXIS = 3;
    public static final int YAXIS_LEFT = 4;
    public static final int YAXIS_RIGHT = 5;
    protected static final int POINT = 0;
    protected static final int LINE = 1;
    protected static final int AREA = 2;
    protected static final int AREA_CUMULATIVE = 3;
    protected static final int BAR = 4;
    protected static final int BAR_STACKED = 5;
    protected static final int HILOCLOSE = 7;
    protected static final int OPENHILOCLOSE = 8;
    protected static final int CANDLESTICK = 9;
    protected int SCIndex = 0;
    private boolean fontMetricsGot = false;
    MillisecondsCalendar C = new MillisecondsCalendar();
    private int graphType = 1;
    private double BarWidth = 10.0;
    double[] xval;
    int[] xval_int;
    double[] xval_dbl;
    int[] xval_int_temp;
    double[] xval_dbl_temp;
    int minorTickHeight = 3;
    Dimension d;
    Color Grey8 = new Color(0.8f, 0.8f, 0.8f);
    Color Grey3 = new Color(0.3f, 0.3f, 0.3f);
    Color foreground = Color.black;
    Color background = this.Grey8;
    Color GridColor = this.Grey3;
    protected final MediaTracker sTracker = new MediaTracker(this);
    TimeAxisContinuous TimeAxisCont = null;
    protected TimeBand AxisTimeBandHolder = new TimeBand();
    boolean PlotBackgroundSet = false;
    boolean PlotEdgeColorSet = false;
    AxisTitle AxisT = new AxisTitle();
    boolean ExtendedLabels = false;
    protected TimeBandDesc UserTimeBand = new TimeBandDesc();
    protected boolean UserTimeBandNeedsToBeCopied = true;
    protected GridDesc UserXGrid = new GridDesc();
    protected boolean UserXGridNeedsToBeCopied = true;
    boolean testPerSubchart = false;
    boolean SizeChanged = false;
    AnnotationDesc AnnoDesc = new AnnotationDesc();
    boolean AnnoDescFetched = false;
    RenderingHints RHLine = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    boolean colorBands = true;
    BasicStroke Stroke2f = new BasicStroke(2.0f, 0, 2);
    BasicStroke Stroke3f = new BasicStroke(3.0f, 0, 2);
    static final int NO_EXTEND = 0;
    static final int EXTEND_LEFT = 1;
    int LeftExtendAmount = 0;
    static final int EXTEND_RIGHT = 2;
    int RightExtendAmount = 0;
    static final int EXTEND_BOTH = 3;
    int InvPad = 0;
    SubChartSeparatorStyleDesc subChartSeparatorStyleDesc = null;
    boolean DrawBufferCalled = false;
    boolean DrawOutsideLegend = false;
    int lineYMax = Integer.MIN_VALUE;
    int lineYMin = Integer.MAX_VALUE;
    Vector AnnoV = new Vector();
    AnnoElement[] Anno;
    boolean AnnoExist = false;
    int IntervalWidth = 0;
    BasicStroke LineStroke = new BasicStroke(2.5f, 0, 2);
    LineMarker LM = new LineMarker(this.LineStroke);
    BasicStroke EmptyStroke = new BasicStroke(0.0f, 0, 2);
    BasicStroke DefaultStroke = new BasicStroke(1.0f, 0, 2);
    BasicStroke DashedStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f, 1.0f}, 0.0f);
    BasicStroke DashedStroke2 = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{2.0f, 1.0f}, 0.0f);
    boolean AlignClusterBarLineGraph = false;
    int LineDelta = this.LM.getLineDelta();
    static final boolean debug99 = false;
    StringAxisDesc stringAxisD = new StringAxisDesc();
    StringLabelInternal sl = new StringLabelInternal();
    DropShadow DropShade = new DropShadow();
    double[] BarAdjustSaveForLine = new double[30];
    int PlotBarWidth = 1;
    PopUpData PopDat = new PopUpData();
    myfcn m = new myfcn();
    SubChartDescription SubCh;
    SubChartDescription SubChZero;
    ChartDescription Ch = new ChartDescription();
    boolean minLabelDimensionSet = false;
    boolean maxLabelDimensionSet = false;
    Vector FreqDim = new Vector();
    static final int CALCULATE_BOTH = 0;
    static final int CALCULATE_RIGHT = 1;
    static final int CALCULATE_LEFT = 2;

    public AxisCore() {
        this.Ch.displayHeight = AxisCore.super.getHeight();
        this.Ch.displayWidth = AxisCore.super.getWidth();
        this.Ch.border_left = AxisCore.super.getBorderLeft();
        this.Ch.border_right = AxisCore.super.getBorderRight();
        this.Ch.border_top = AxisCore.super.getBorderTop();
        this.Ch.border_bottom = AxisCore.super.getBorderBottom();
        SubChartDescription sc = new SubChartDescription();
        this.Ch.SC.addElement(sc);
        this.SCIndex = 0;
        sc.subchart_name = "";
        this.SubCh = (SubChartDescription)this.Ch.SC.elementAt(this.SCIndex);
        this.SubChZero = (SubChartDescription)this.Ch.SC.elementAt(0);
        try {
            this.SubChZero.L2.getLegendDesc().setLegendAlignment(4);
            this.SubChZero.L2.resetLegendAlignment();
            this.SubChZero.L2.setPieChartType(false);
            this.SubChZero.L2.setMaximumSize(this.Ch.displayWidth, this.Ch.displayHeight);
            this.SubChZero.L2.setBorders(this.Ch.border_left, this.Ch.border_right, this.Ch.border_top, this.Ch.border_bottom);
            this.SubChZero.L2.setYBaseline(this.Ch.displayHeight - this.Ch.border_bottom);
        }
        catch (ChartException e) {
            // empty catch block
        }
        this.RHLine.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        this.InitFreqDimPre();
    }

    private boolean isMonths(int monthConstant) {
        return monthConstant == 6 || monthConstant == 62 || monthConstant == 61;
    }

    protected final boolean isBasicLineType(int lineType) {
        return lineType == 1 || lineType == 2 || lineType == 3 || lineType == 4 || lineType == 5;
    }

    protected final boolean isOHLCLineType(int lineType) {
        return lineType == 8 || lineType == 9;
    }

    protected final boolean isHLCLineType(int lineType) {
        return lineType == 7;
    }

    protected final boolean isBarType(int lineType) {
        return lineType == 4 || lineType == 5;
    }

    protected final boolean isIntervalGraphic(int lineType) {
        return lineType == 4 || lineType == 5 || lineType == 9 || lineType == 7 || lineType == 8;
    }

    protected final boolean isStockType(int lineType) {
        return lineType == 9 || lineType == 7 || lineType == 8;
    }

    boolean isNotNumerical(char[] str) {
        if (str.length > 0) {
            switch (str[0]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return false;
                }
            }
        }
        return true;
    }

    protected void setXSeriesFrequency(int frequency, Date startDate, Date endDate, int units) throws ChartException {
        this.setXSeriesFrequency(frequency, startDate, endDate, null, units);
    }

    private void setXSeriesFrequency(int frequency, Date startDate, Date endDate, Date[] preDates, int units) throws ChartException {
        String fcn = "setXSeries()";
        if (frequency == 10 && units == 1) {
            this.Ch.dls = true;
        }
        this.Ch.frequency = frequency;
        this.Ch.units = units;
        if (!this.Ch.vertical) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-162"));
        }
        if (units <= 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-152"));
        }
        Calendar Cstep = Calendar.getInstance();
        Cstep.setTime(startDate);
        if (!startDate.before(endDate)) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-120"));
        }
        Date currentDate = startDate;
        switch (frequency) {
            case 1: 
            case 2: 
            case 5: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-154"));
            }
        }
        switch (frequency) {
            case 1: 
            case 2: 
            case 5: 
            case 10: 
            case 12: 
            case 13: {
                int count = 0;
                while (currentDate.before(endDate)) {
                    Cstep.add(frequency, units);
                    currentDate = Cstep.getTime();
                    ++count;
                }
                ++count;
                int preDatesLength = 0;
                if (preDates != null) {
                    preDatesLength = preDates.length;
                }
                this.Ch.TStamps = new Date[preDatesLength + count];
                Cstep.setTime(startDate);
                currentDate = startDate;
                int i = 0;
                while (i < preDatesLength) {
                    this.Ch.TStamps[i] = preDates[i];
                    ++i;
                }
                int i2 = preDatesLength;
                while (i2 < count + preDatesLength) {
                    this.Ch.TStamps[i2] = Cstep.getTime();
                    Cstep.add(frequency, units);
                    ++i2;
                }
                this.Ch.TStampsCount = this.Ch.TStamps.length;
                this.Ch.containsTStamps = true;
                if (this.Ch.XAxisCount == 0 || this.Ch.XAxisCount < count) {
                    this.Ch.XAxisCount = count;
                }
                this.initChartX();
                break;
            }
        }
    }

    protected void initChartX() {
        this.InitFreqDim();
        this.xval = new double[this.Ch.TStampsCount];
        int i = 0;
        while (i < this.Ch.TStampsCount) {
            this.xval[i] = i;
            ++i;
        }
        this.xval_int = new int[this.Ch.TStampsCount];
        this.xval_dbl = new double[this.Ch.TStampsCount];
        this.xval_dbl_temp = new double[this.Ch.TStampsCount];
        this.xval_int_temp = new int[this.Ch.TStampsCount];
        this.copyDefaultDesc(this.SubCh);
    }

    protected void copyDefaultDesc(SubChartDescription subch) {
        NumAxisRenderer yAxis = subch.YAxis1;
        if (!this.SubCh.YAxis1.userDefinedDescriptorSet) {
            yAxis.yl.numAxisD.setColor(this.getForeground());
        }
        this.copyNumAxisDescToGrid(yAxis, yAxis.yl.numAxisD);
    }

    protected void copyNumAxisDesc(NumAxisRenderer yAxis, NumAxisDesc userNumAxis) {
        double ymin;
        double ymax;
        yAxis.yl.numAxisD = userNumAxis;
        if (!userNumAxis.getAutoExtentMax() && (ymax = userNumAxis.getExtentMax()) >= yAxis.yAxisMet.Ymax_non_adjusted) {
            yAxis.yAxisMet.Ymax_non_adjusted = ymax;
            yAxis.yAxisMet.Ymax = ymax;
            yAxis.yAxisMet.AutoExtentMax = false;
        }
        if (!userNumAxis.getAutoExtentMin() && (ymin = userNumAxis.getExtentMin()) <= yAxis.yAxisMet.Ymin_non_adjusted) {
            yAxis.yAxisMet.Ymin_non_adjusted = ymin;
            yAxis.yAxisMet.Ymin = ymin;
            yAxis.yAxisMet.AutoExtentMin = false;
        }
        this.copyNumAxisDescToGrid(yAxis, userNumAxis);
    }

    protected void copyNumAxisDescToGrid(NumAxisRenderer yAxis, NumAxisDesc userNumAxis) {
        yAxis.yg.autoSpacing = userNumAxis.getAutoSpacing();
        if (yAxis.yg.autoSpacing) {
            yAxis.yg.numYLabels = userNumAxis.getNumLabels();
            if (yAxis.yg.numYLabels != 0) {
                yAxis.yg.userDefinedNumYLabels = true;
            }
        } else {
            yAxis.yg.spacing = userNumAxis.getLabelIncrement();
        }
    }

    protected void loadAxisTimeBandsVector() {
        boolean isSingleSeriesNoData = false;
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        if (sc.plotLineDes.size() == 1) {
            LineDescription line = (LineDescription)sc.plotLineDes.elementAt(0);
            if (line.containsNaN) {
                isSingleSeriesNoData = true;
            }
        }
        this.AxisTimeBandHolder.AxisTimebands = new TimeUtil(this.TimeAxisCont);
        if (this.UserTimeBand.getTimeBandIntervals() != null) {
            this.AxisTimeBandHolder.AxisTimebands_v = this.AxisTimeBandHolder.AxisTimebands.convertTimeBandsToDoubles(this.Ch, this.UserTimeBand.getTimeBandIntervals());
        } else if (this.UserTimeBand.getTimeBandIntervalsVisual() != null) {
            this.AxisTimeBandHolder.AxisTimebands_v = this.AxisTimeBandHolder.AxisTimebands.convertTimeBandsToDoubles(this.Ch, this.UserTimeBand.getTimeBandIntervalsVisual());
            int trackerIDBase = 1000;
            TimeIntervalVisualDesc[] bandVisual = this.UserTimeBand.getTimeBandIntervalsVisual();
            int i = 0;
            while (i < bandVisual.length) {
                if (bandVisual[i] != null && bandVisual[i].getBevelRectIconDesc().getIcon() != null) {
                    this.sTracker.addImage(bandVisual[i].getBevelRectIconDesc().getIcon(), i + trackerIDBase);
                }
                ++i;
            }
            try {
                this.sTracker.waitForAll();
            }
            catch (InterruptedException ie) {}
        } else if (!(this.UserTimeBand.getGenerateNoDataTimeBand() && isSingleSeriesNoData || !this.xl.timeAxisD.getDayOfWeek() && !this.xl.timeAxisD.getDayOfWeekOnly())) {
            this.AxisTimeBandHolder.AxisTimebands_v = this.AxisTimeBandHolder.AxisTimebands.deriveWeekendIntervals(this.Ch);
        }
        if (this.AxisTimeBandHolder.AxisTimebands_v != null) {
            this.AxisTimeBandHolder.AxisTimebands_int = new int[this.AxisTimeBandHolder.AxisTimebands_v.size()];
            this.AxisTimeBandHolder.allocImageMap(this.AxisTimeBandHolder.AxisTimebands_v.size() / 2);
            this.AxisTimeBandHolder.allocImageMapSide();
        }
    }

    long getSpanSeconds() {
        return this.TimeAxisCont.xAxisSpanMillis / 1000L;
    }

    long getSpanMinutes() {
        return this.TimeAxisCont.xAxisSpanMillis / 60000L;
    }

    long getSpanHours() {
        return this.TimeAxisCont.xAxisSpanMillis / 3600000L;
    }

    public void setChartAttributes(LegendDesc userLegendDesc) throws ChartException {
        this.SubChZero.L2.setLegendDesc(userLegendDesc);
    }

    public LegendDesc getLegendDesc() {
        return this.SubChZero.L2.getLegendDesc();
    }

    protected void setXSeriesContinuous(Date startDate, Date endDate, boolean gantt) throws ChartException {
        String fcn = "setXSeries()";
        if (gantt) {
            fcn = "setTimeLine()";
        }
        if (!this.Ch.vertical) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-162"));
        }
        if (this.Ch.continuousTimeXAxis) {
            if (gantt) {
                Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-401"));
            } else {
                Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-149"));
            }
        }
        if (!startDate.before(endDate)) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-120"));
        }
        this.Ch.continuousTimeXAxis = true;
        this.TimeAxisCont = new TimeAxisContinuous(startDate, endDate);
        long spanMillis = this.TimeAxisCont.xAxisSpanMillis;
        this.loadAxisTimeBandsVector();
        Date[] extraDates = new Date[1];
        AdjustTime at = new AdjustTime(startDate);
        boolean extra = at.adjustTime();
        if (extra) {
            startDate = at.getStartDate();
            extraDates = at.getExtraDates();
        }
        int frequency = 1;
        int units = 1;
        long spanSeconds = this.getSpanSeconds();
        long spanMinutes = this.getSpanMinutes();
        long spanHours = this.getSpanHours();
        if (spanMinutes < 10L) {
            frequency = 13;
            if (spanMinutes > 5L) {
                units = 10;
            } else if (spanMinutes > 3L) {
                units = 5;
            }
        } else if (spanHours < 10L) {
            frequency = 12;
            if (spanHours > 5L) {
                units = 10;
            } else if (spanHours > 3L) {
                units = 5;
            }
        } else {
            long spanDays = spanHours / 24L;
            if (spanDays < 20L) {
                frequency = 10;
                if (spanDays > 10L) {
                    units = 8;
                } else if (spanDays > 5L) {
                    units = 12;
                }
            } else {
                long spanMonths = spanDays / 30L;
                if (spanMonths < 5L) {
                    frequency = 5;
                } else {
                    long spanYears = spanDays / 365L;
                    if (spanYears < 8L) {
                        frequency = 2;
                    }
                }
            }
        }
        if (!extra) {
            this.setXSeriesFrequency(frequency, startDate, endDate, null, units);
        } else {
            this.setXSeriesFrequency(frequency, startDate, endDate, extraDates, units);
        }
    }

    protected void checkAscendingDatesAndCopy(String fcn, Date[] tstamps, int length) throws ChartException {
        int i = 1;
        while (i < length) {
            if (tstamps[i] == null) {
                Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-146"));
            }
            if (tstamps[i].before(tstamps[i - 1])) {
                Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-148") + " #" + (i + 1) + " " + " (" + tstamps[i - 1] + ", " + tstamps[i] + ")");
            }
            this.Ch.TStamps[i] = tstamps[i];
            ++i;
        }
    }

    protected void checkAscendingDates(String fcn, Date[] tstamps, int length) throws ChartException {
        int i = 1;
        while (i < length) {
            if (tstamps[i] == null) {
                Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-146"));
                return;
            }
            if (tstamps[i].before(tstamps[i - 1])) {
                Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-148") + " #" + (i + 1) + " " + " (" + tstamps[i - 1] + ", " + tstamps[i] + ")");
                return;
            }
            ++i;
        }
    }

    public void setForeground(Color c) {
        this.foreground = c;
        super.setTitlesForeground(c);
        int k = 0;
        while (k < this.Ch.SC.size()) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(k);
            NumAxisRenderer yAxis1 = sc.YAxis1;
            NumAxisRenderer yAxis2 = sc.YAxis2;
            yAxis1.yl.numAxisD.setColor(this.foreground);
            yAxis2.yl.numAxisD.setColor(this.foreground);
            ++k;
        }
        this.xl.timeAxisD.setColor(this.foreground);
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setPlotBackground(Color c) {
        this.PlotBackground = c;
        this.PlotBackgroundSet = true;
    }

    public Color getPlotBackground() {
        return this.PlotBackground;
    }

    public void setPlotEdgeColor(Color c) {
        this.PlotEdgeColor = c;
        this.PlotEdgeColorSet = true;
    }

    public Color getPlotEdgeColor() {
        return this.PlotEdgeColor;
    }

    public void setPlotAxisLineColor(Color c) {
        this.PlotAxisLineColor = c;
    }

    public Color getPlotAxisLineColor() {
        return this.PlotAxisLineColor;
    }

    protected void deriveThickness() {
        int k = 0;
        while (k < this.Ch.SC.size()) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(k);
            int s = 0;
            while (s < sc.plotLineDes.size()) {
                LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
                if (!line.userDefinedThickness) {
                    switch (line.lineType) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        case 4: 
                        case 5: {
                            this.deriveBARWidth(line);
                            break;
                        }
                        case 9: {
                            this.deriveBARWidth(line);
                        }
                    }
                }
                ++s;
            }
            ++k;
        }
    }

    void copyBarDesc(LineDescription line, BarDesc desc) {
        line.barStyle = desc.getBarStyle();
        if (line.barStyle == 2) {
            this.SubCh.containsBarType3D = true;
            this.Ch.containsBarType3D = true;
        } else if (line.barStyle == 1) {
            this.SubCh.containsBarTypeDropShadow = true;
            this.Ch.containsBarTypeDropShadow = true;
        }
        if (!desc.getBarShadowColorDerived()) {
            line.barShadowColorDerived = false;
            line.barShadowColor = desc.getBarShadowColor();
        }
        if (!line.colorSelectivelySet) {
            line.color = desc.getBarColor();
        }
        line.color2 = desc.getNegativeBarColor();
        if (!line.widthSelectivelySet) {
            line.width = desc.getBarWidth();
        }
        if (line.width == 0.0) {
            line.userDefinedThickness = false;
            line.BarThicknessPct = desc.getBarWidthFraction();
        } else {
            line.userDefinedThickness = true;
        }
        line.widthMax = desc.getBarWidthMax();
        line.pointLabelsInterior = desc.getPointLabelsInterior();
        line.pointLabelColor = desc.getPointLabelColor();
        line.pointLabelFont = desc.getPointLabelFont();
    }

    void copyBackBarDesc(BarDesc desc, LineDescription line) {
        try {
            desc.setBarStyle(line.barStyle);
        }
        catch (ChartException e) {
            // empty catch block
        }
        if (!line.barShadowColorDerived) {
            desc.setBarShadowColor(line.barShadowColor);
        } else {
            desc.setBarShadowColorDerived();
        }
        desc.setBarColor(line.color);
        desc.setNegativeBarColor(line.color2);
        if (line.userDefinedThickness) {
            desc.setBarWidth(line.width);
        } else {
            desc.setBarWidthFraction(line.BarThicknessPct);
        }
        desc.setBarWidthMax(line.widthMax);
        if (line.pointLabelsInterior) {
            desc.setPointLabelsInterior();
        }
        desc.setPointLabelColor(line.pointLabelColor);
        desc.setPointLabelFont(line.pointLabelFont);
    }

    void copyLineDesc(LineDescription line, LineDesc desc) {
        if (!line.colorSelectivelySet) {
            line.color = desc.getLineColor();
        }
        if (!line.widthSelectivelySet) {
            line.width = desc.getLineWidth();
        }
        line.lineStyle = desc.getLineStyle();
        LineMarker LM = new LineMarker();
        line.lineStroke = LM.getLineStroke(line.lineStyle, (float)line.width);
        this.copyMarkerDesc(line, desc);
    }

    void copyMarkerDesc(LineDescription line, MarkerDesc desc) {
        line.color3 = desc.getMarkerColor();
        line.markerType = desc.getMarkerType();
        line.markerScale = desc.getMarkerScale();
    }

    void copyBackLineDesc(LineDesc desc, LineDescription line) {
        desc.setLineColor(line.color);
        desc.setLineWidth(line.width);
        try {
            desc.setLineStyle(line.lineStyle);
            desc.setMarkerType(line.markerType);
        }
        catch (ChartException e) {
            // empty catch block
        }
        desc.setMarkerColor(line.color3);
        this.copyBackMarkerDesc(desc, line);
    }

    void copyBackMarkerDesc(MarkerDesc desc, LineDescription line) {
        try {
            desc.setMarkerType(line.markerType);
            desc.setMarkerScale(line.markerScale);
        }
        catch (ChartException e) {
            // empty catch block
        }
        desc.setMarkerColor(line.color3);
    }

    void copyAreaDesc(LineDescription line, AreaDesc desc) {
        if (!line.colorSelectivelySet) {
            line.color = desc.getLineColor();
        }
        line.color2 = desc.getAreaColor();
        line.alphaArea = desc.getAreaTransparency();
        if (!line.widthSelectivelySet) {
            line.width = desc.getLineWidth();
            line.lineStroke = new BasicStroke((float)line.width, 0, 2);
        }
    }

    protected void copyBackAreaDesc(AreaDesc desc, LineDescription line) {
        desc.setLineColor(line.color);
        desc.setAreaColor(line.color2);
        desc.setAreaTransparency(line.alphaArea);
        desc.setLineWidth(line.width);
    }

    protected void copyAxisDesc(NumAxisRenderer yAxis, AxisDesc userAxis) {
        boolean drawLabel = userAxis.getDrawLabel();
        if (drawLabel) {
            yAxis.yl.numAxisD.setDrawLabelEnable(true);
            yAxis.yl.numAxisD.setFont(userAxis.getFont());
            yAxis.yl.numAxisD.setColor(userAxis.getColor());
        }
    }

    protected void copyBackAxisDesc(AxisDesc userAxis, NumAxisRenderer yAxis) {
        if (!yAxis.yl.numAxisD.getDrawLabel()) {
            userAxis.setDrawLabelOff();
        }
        userAxis.setFont(yAxis.yl.numAxisD.getFont());
        userAxis.setColor(yAxis.yl.numAxisD.getColor());
    }

    void copyHiLoCloseDesc(LineDescription line, HiLoCloseDesc desc) {
        if (!line.colorSelectivelySet) {
            line.color = desc.getMarkerColor();
        }
        if (!line.widthSelectivelySet) {
            line.width = desc.getMarkerWidth();
        }
        line.length = desc.getMarkerLength();
    }

    void copyBackHiLoCloseDesc(HiLoCloseDesc desc, LineDescription line) {
        desc.setMarkerColor(line.color);
        desc.setMarkerWidth((int)line.width);
        desc.setMarkerLength(line.length);
    }

    protected void chartErrorSubchartNotFound(String functionName, String subchartName) throws ChartException {
        throw new ChartException(MsgUtil.getMsg("CHT-500") + functionName + ": " + MsgUtil.getMsg("CHT-102") + " \"" + subchartName + "\" " + MsgUtil.getMsg("CHT-103"));
    }

    public void setChartAttributes(int XYAxis, AxisTitleDesc titleDesc) throws ChartException {
        if (this.Ch.SC.size() < 1) {
            this.chartErrorSubchartNotFound("setChartAttributes()", "");
        }
        switch (XYAxis) {
            case 1: {
                this.AxisT.titleDescX = titleDesc;
                break;
            }
            case 2: {
                this.AxisT.titleDescY = titleDesc;
            }
        }
    }

    public void setChartAttributes(int XYAxis, AxisDesc userAxis) throws ChartException {
        if (this.Ch.SC.size() < 1) {
            this.chartErrorSubchartNotFound("setChartAttributes()", "");
        }
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        switch (XYAxis) {
            case 1: {
                this.xl.userDefinedDescriptorSet = true;
                this.copyAxisDesc(userAxis);
                break;
            }
            case 2: {
                NumAxisRenderer yAxis = sc.YAxis1;
                yAxis.userDefinedDescriptorSet = true;
                this.copyAxisDesc(yAxis, userAxis);
                yAxis = sc.YAxis2;
                yAxis.userDefinedDescriptorSet = true;
                this.copyAxisDesc(yAxis, userAxis);
                break;
            }
            case 4: {
                NumAxisRenderer yAxis = sc.YAxis1;
                yAxis.userDefinedDescriptorSet = true;
                this.copyAxisDesc(yAxis, userAxis);
                break;
            }
            case 5: {
                NumAxisRenderer yAxis = sc.YAxis2;
                yAxis.userDefinedDescriptorSet = true;
                this.copyAxisDesc(yAxis, userAxis);
                break;
            }
            case 3: {
                this.xl.userDefinedDescriptorSet = true;
                this.copyAxisDesc(userAxis);
                NumAxisRenderer yAxis = sc.YAxis1;
                yAxis.userDefinedDescriptorSet = true;
                this.copyAxisDesc(yAxis, userAxis);
                yAxis = sc.YAxis2;
                yAxis.userDefinedDescriptorSet = true;
                this.copyAxisDesc(yAxis, userAxis);
                break;
            }
            default: {
                Errorfcn.chartError("setChartAttributes()", MsgUtil.getMsg("CHT-210") + " (" + XYAxis + ")");
            }
        }
    }

    public AxisDesc getAxisDesc(int XYAxis) throws ChartException {
        AxisDesc userAxis = null;
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        switch (XYAxis) {
            case 1: 
            case 2: {
                userAxis = new AxisDesc();
                NumAxisRenderer yAxis = sc.YAxis1;
                this.copyBackAxisDesc(userAxis, yAxis);
                break;
            }
            default: {
                Errorfcn.chartError("getAxisDesc()", MsgUtil.getMsg("CHT-210") + " (" + XYAxis + ")");
            }
        }
        return userAxis;
    }

    public void setChartAttributes(TimeAxisDesc userTimeAxis) throws ChartException {
        this.xl.userDefinedDescriptorSet = true;
        this.copyTimeAxisDesc(userTimeAxis);
    }

    public TimeAxisDesc getTimeAxisDesc() throws ChartException {
        return this.xl.timeAxisD;
    }

    protected void copyTimeAxisDesc(TimeAxisDesc userTimeAxis) {
        int tempMinNumLabelingLines;
        this.xl.timeAxisD = userTimeAxis;
        int tempMin = userTimeAxis.getMinDimension();
        int tempMax = userTimeAxis.getMaxDimension();
        if (tempMin != -1) {
            this.minLabelDimensionSet = true;
            this.xl.firstLevelField_default = tempMin;
        }
        this.xl.firstLevelField_extended = userTimeAxis.getExtendedDimension();
        if (this.xl.firstLevelField_extended != -1) {
            this.xl.extendedLabels = true;
            this.minLabelDimensionSet = true;
            this.xl.firstLevelField_default = this.xl.firstLevelField_extended;
        }
        if (tempMax != -1) {
            this.maxLabelDimensionSet = true;
            this.xl.lastLevelField_default = tempMax;
        }
        if ((tempMinNumLabelingLines = userTimeAxis.getMinLabelingLines()) != -1 || this.xl.firstLevelField_extended != -1) {
            this.xl.minNumLabelingLines = tempMinNumLabelingLines;
        }
        try {
            int field = userTimeAxis.getField(2);
            switch (field) {
                case 10: 
                case 11: {
                    this.setField("HOUR", field);
                    this.xl.hour_field = field;
                    break;
                }
            }
        }
        catch (ChartException e) {
            // empty catch block
        }
        this.Ch.enableInterval = this.xl.timeAxisD.getLabelAlignment() == 0;
    }

    protected void copyAxisDesc(AxisDesc userAxis) {
    }

    public void setChartAttributes(StringAxisDesc userStringAxis) throws ChartException {
        this.sl.stringAxisD = userStringAxis;
    }

    public StringAxisDesc getStringAxisDesc() throws ChartException {
        return this.sl.stringAxisD;
    }

    protected void copyTimeBandDesc(TimeBandDesc userTimeBand) {
        this.xl.timeBandDesc = userTimeBand;
        this.UserTimeBand = userTimeBand;
    }

    public void setChartAttributes(TimeBandDesc userTimeBand) throws ChartException {
        String fcn = "setChartAttributes()";
        this.UserTimeBandNeedsToBeCopied = false;
        this.copyTimeBandDesc(userTimeBand);
        if (this.Ch.TStampsCount != 0 || this.Ch.continuousTimeXAxis) {
            this.loadAxisTimeBandsVector();
        }
    }

    public void setChartAttributes(int XYAxis, GridDesc userGrid) throws ChartException {
        String fcn = "setChartAttributes()";
        int XYAxis_flipped = XYAxis;
        if (!this.Ch.vertical) {
            XYAxis_flipped = -1;
            if (XYAxis == 1) {
                XYAxis_flipped = 2;
            } else if (XYAxis == 2) {
                XYAxis_flipped = 1;
            }
        }
        switch (XYAxis_flipped) {
            case 1: 
            case 3: {
                this.UserXGridNeedsToBeCopied = false;
                this.copyXGridDesc(userGrid);
                break;
            }
            case 2: {
                break;
            }
            default: {
                Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-210") + " (" + XYAxis + ")");
            }
        }
        if (XYAxis_flipped == 2 || XYAxis_flipped == 2) {
            int k = 0;
            while (k < this.Ch.SC.size()) {
                SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(k);
                switch (XYAxis_flipped) {
                    case 2: 
                    case 3: {
                        this.copyYGridDesc(sc, userGrid);
                        break;
                    }
                    default: {
                        Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-210") + " (" + XYAxis + ")");
                    }
                }
                ++k;
            }
        }
    }

    protected void copyXGridDesc(GridDesc userGrid) {
        this.xl.drawGrid = userGrid.getDrawGrid();
        this.xl.gridColor = userGrid.getColor();
        this.UserXGrid = userGrid;
    }

    protected void copyYGridDesc(SubChartDescription sc, GridDesc userGrid) {
        sc.YAxis1.yg.gridD = userGrid;
    }

    public GridDesc getGridDesc(int XorYAxis) throws ChartException {
        int XorYAxis_flipped = XorYAxis;
        switch (XorYAxis) {
            case 1: {
                return this.UserXGrid;
            }
            case 2: {
                SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
                return sc.YAxis1.yg.gridD;
            }
        }
        Errorfcn.chartError("getGridDesc()", MsgUtil.getMsg("CHT-210") + " (" + XorYAxis + ")");
        return this.UserXGrid;
    }

    public void setChartBottomWhiteSpace(double fract) {
        if (fract >= 0.0 && fract <= 1.0) {
            this.SubCh.bottom_white_space_fract = fract;
        }
    }

    public void setChartTopWhiteSpace(double fract) {
        if (fract >= 0.0 && fract <= 1.0) {
            this.SubCh.top_white_space_fract = fract;
        }
    }

    protected void setSubChartLocation(int xorigin, int yorigin) {
        this.SubCh.XOrigin = xorigin;
        this.SubCh.YOrigin = yorigin;
    }

    protected void resetDisplaySize() {
        SubChartDescription sc;
        boolean test = false;
        this.Ch.displayWidth = super.getWidth();
        this.Ch.displayHeight = super.getHeight();
        if (super.isBorderLeftSet()) {
            this.Ch.border_left = super.getBorderLeft();
        }
        if (super.isBorderRightSet()) {
            this.Ch.border_right = super.getBorderRight();
        }
        if (super.isBorderTopSet()) {
            this.Ch.border_top = super.getBorderTop();
        }
        if (super.isBorderBottomSet()) {
            this.Ch.border_bottom = super.getBorderBottom();
        }
        this.SubChZero.L2.setMaximumSize(this.Ch.displayWidth, this.Ch.displayHeight);
        this.SubChZero.L2.setBorders(this.Ch.border_left, this.Ch.border_right, this.Ch.border_top, this.Ch.border_bottom);
        if (this.Ch.vertical) {
            int NextOrigin = 0;
            int separatorReduction = 0;
            if (this.Ch.SC.size() > 1) {
                int numSubCharts = this.Ch.SC.size();
                int totalSeparatorHeight = this.Ch.subchartSeparatorHeight * (numSubCharts - 1);
                separatorReduction = totalSeparatorHeight / numSubCharts;
            }
            int k = 0;
            while (k < this.Ch.SC.size()) {
                sc = (SubChartDescription)this.Ch.SC.elementAt(k);
                sc.Displayheight = sc.heightFraction * (double)(this.Ch.displayHeight - (this.Ch.border_bottom + this.Ch.border_top)) - (double)separatorReduction;
                sc.Displaywidth = this.Ch.displayWidth - (this.Ch.border_left + this.Ch.border_right);
                sc.displaywidth2 = this.Ch.displayWidth - (this.Ch.border_left + this.Ch.border_right);
                sc.xAxisWidth = this.Ch.continuousTimeXAxis ? sc.displaywidth2 - 2.0 * sc.halfBarPad : sc.displaywidth2;
                sc.YOrigin = NextOrigin;
                NextOrigin = (int)((double)NextOrigin + (sc.Displayheight + (double)this.Ch.subchartSeparatorHeight));
                if (this.Ch.perSubchartLegend && k >= 0) {
                    try {
                        sc.L2.getLegendDesc().setLegendAlignment(11);
                        sc.L2.resetLegendAlignment();
                        sc.L2.setPieChartType(false);
                        sc.L2.setMaximumSize(this.Ch.displayWidth, this.Ch.displayHeight);
                        sc.L2.setBorders(this.Ch.border_left, this.Ch.border_right, this.Ch.border_top, this.Ch.border_bottom);
                        int x = this.Ch.displayWidth - this.Ch.border_right;
                        int y = sc.YOrigin + this.Ch.border_top;
                        if (this.testPerSubchart) {
                            System.out.println("Subchart " + k + " x,y (" + x + "," + y + ")");
                        }
                        sc.L2.setLegendLocation(x, y);
                        sc.L2.setYBaseline(sc.YOrigin + (int)sc.Displayheight);
                    }
                    catch (ChartException e) {
                        // empty catch block
                    }
                }
                ++k;
            }
            if (this.Ch.SC.size() > 1) {
                sc = (SubChartDescription)this.Ch.SC.elementAt(this.Ch.SC.size() - 1);
                sc.YOrigin = this.Ch.displayHeight - (this.Ch.border_bottom + this.Ch.border_top) - (int)sc.Displayheight;
            }
        } else {
            sc = (SubChartDescription)this.Ch.SC.elementAt(0);
            sc.Displayheight = this.Ch.displayHeight - (this.Ch.border_bottom + this.Ch.border_top);
            sc.Displaywidth = this.Ch.displayWidth - (this.Ch.border_left + this.Ch.border_right);
            sc.xAxisWidth = sc.displaywidth2 = (double)(this.Ch.displayWidth - (this.Ch.border_left + this.Ch.border_right));
            sc.YOrigin = 0;
        }
        sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        this.xl.init_x_coordinate_spread(sc.x_coordinate_spread);
        this.xl.init_sc_widthheight(sc.xAxisWidth, sc.Displayheight);
    }

    public void setBounds(int x, int y, int w, int h) {
        if (w > 0 || h > 0) {
            this.setSize(w, h);
        }
        super.setBounds(x, y, w, h);
    }

    public void setBounds(Rectangle rect) {
        if (rect.width > 0 || rect.height > 0) {
            this.setSize(rect.width, rect.height);
        }
        super.setBounds(rect);
    }

    public void setSize(Dimension d) {
        if (d.width > 0 || d.height > 0) {
            this.setSize(d.width, d.height);
        }
    }

    public void setSize(int width, int height) {
        if (width <= 0 && height <= 0) {
            return;
        }
        this.SizeChanged = true;
        if (width == 0) {
            this.setHeightInternal(height);
        } else if (height == 0) {
            this.setWidthInternal(width);
        } else {
            super.setSizeInternal(width, height);
        }
        this.resetDisplaySize();
        int k = 0;
        while (k < this.Ch.SC.size()) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(k);
            sc.YAxis1.yAxisMet.last_y_coordinate_spread = 0.0;
            sc.YAxis2.yAxisMet.last_y_coordinate_spread = 0.0;
            sc.last_x_coordinate_spread = 0.0;
            sc.YAxis1.yAxisMet.init_yminmax();
            sc.YAxis2.yAxisMet.init_yminmax();
            ++k;
        }
    }

    public void setReverseStackBarOrder(boolean reverse) {
        this.reverseStackOrder = reverse;
    }

    public boolean getReverseStackBarOrder() {
        return this.reverseStackOrder;
    }

    protected AnnotationDesc getAnnotationDesc() {
        this.AnnoDescFetched = true;
        return this.AnnoDesc;
    }

    protected void setSeriesAnnotationsInternal(LineDescription line, Date[] tstamps, String[] yannotations) throws ChartException {
        int i;
        int length;
        String fcn = "setSeriesAnnotations()";
        if (tstamps == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-150"));
        }
        if ((length = tstamps.length) == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-150"));
        }
        if (this.Ch.TStampsCount == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-200"));
        }
        if (length > this.Ch.TStampsCount) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-201"));
        }
        if (length != yannotations.length) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-202"));
        }
        int j = 0;
        Date current_tstamp = tstamps[0];
        if (!this.Ch.continuousTimeXAxis) {
            i = 0;
            while (i < length) {
                current_tstamp = tstamps[i];
                while (this.Ch.TStamps[j].before(current_tstamp) && j < this.Ch.TStampsCount) {
                    ++j;
                }
                if (j >= this.Ch.TStampsCount) break;
                ++i;
            }
            if (i < length) {
                Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-133") + current_tstamp);
            }
        }
        this.AnnoExist = true;
        i = 0;
        while (i < length) {
            AnnoElement A = new AnnoElement();
            A.text = yannotations[i];
            A.tstamp = tstamps[i];
            A.lineD = line;
            this.AnnoV.addElement(A);
            ++i;
        }
    }

    protected void setSeriesAnnotationsInternal(LineDescription line, int[] indicies, String[] yannotations) throws ChartException {
        int length;
        String fcn = "setSeriesAnnotations()";
        if (this.Ch.labelXCount == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-115"));
        }
        if ((length = indicies.length) > this.Ch.labelXCount) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-203"));
        }
        if (length != yannotations.length) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-204"));
        }
        int i = 0;
        while (i < length) {
            if (indicies[i] < 0 || indicies[i] > this.Ch.labelXCount) {
                Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-221") + i);
            }
            ++i;
        }
        this.AnnoExist = true;
        i = 0;
        while (i < length) {
            AnnoElement A = new AnnoElement();
            A.text = yannotations[i];
            A.index = indicies[i];
            A.lineD = line;
            this.AnnoV.addElement(A);
            ++i;
        }
    }

    protected void setSeriesAnnotationsInternal(LineDescription line, double[] xvals, String[] yannotations) throws ChartException {
        int length;
        String fcn = "setSeriesAnnotations()";
        if (!this.Ch.continuousNumXAxis) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-205"));
        }
        if ((length = xvals.length) != yannotations.length) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-206"));
        }
        this.AnnoExist = true;
        int i = 0;
        while (i < length) {
            AnnoElement A = new AnnoElement();
            A.text = yannotations[i];
            A.xval = xvals[i];
            double difference = 1.0;
            if (line.xval_orig != null && line.xval_orig.length > 0) {
                difference = Math.abs(line.xval_orig[0] - A.xval);
                A.index = 0;
                if (difference != 0.0) {
                    int k = 1;
                    while (k < line.xval_orig.length) {
                        double current_diff = Math.abs(line.xval_orig[k] - A.xval);
                        if (current_diff < difference) {
                            difference = current_diff;
                            A.index = k;
                            if (difference == 0.0) break;
                        }
                        ++k;
                    }
                }
            }
            A.lineD = line;
            this.AnnoV.addElement(A);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private int drawAnnotations(Graphics2D g2, SubChartDescription sc, boolean draw) {
        block30: {
            if (!this.AnnoExist) break block30;
            ymaxWindow = -2147483648;
            yminWindow = 0x7FFFFFFF;
            t = 0;
            i = 0;
            while (i < this.AnnoV.size()) {
                block34: {
                    block32: {
                        block33: {
                            block31: {
                                t = 0;
                                A = (AnnoElement)this.AnnoV.elementAt(i);
                                if (!this.Ch.containsXLabels) break block31;
                                t = A.index;
                                break block32;
                            }
                            if (!this.Ch.continuousNumXAxis) break block33;
                            t = A.index;
                            break block32;
                        }
                        tempTstamp = A.tstamp;
                        if (this.Ch.continuousTimeXAxis) ** GOTO lbl24
                        while (this.Ch.TStamps[t].before(tempTstamp)) {
                            ++t;
                        }
                        break block32;
lbl-1000:
                        // 1 sources

                        {
                            ++t;
lbl24:
                            // 2 sources

                            ** while (t < A.lineD.contDates.length && A.lineD.contDates[t].before((Date)tempTstamp))
                        }
                    }
                    b = new Annotation();
                    b.setFont(this.AnnoDesc.getFont());
                    xdelta = 10;
                    ydelta = 15;
                    b.getFMetrics(g2);
                    t_start = t;
                    xStartPoint = false;
                    xCorner = false;
                    if (this.Ch.containsXLabels || this.Ch.continuousXAxis()) break block34;
                    reverse_barrier = 2 * this.Ch.TStampsCount / 3;
                    if (this.Ch.TStampsCount <= 0) break block34;
                    if (t_start >= reverse_barrier) ** GOTO lbl43
                    while (t_start < this.Ch.TStampsCount && this.xval_int[t_start] < this.xval_int[t] + xdelta) {
                        ++t_start;
                    }
                    break block34;
lbl-1000:
                    // 1 sources

                    {
                        --t_start;
lbl43:
                        // 2 sources

                        ** while (t_start > 0 && this.xval_int[t_start] > this.xval_int[t] - xdelta)
                    }
                }
                P1 = new AnnotationPlacement();
                P2 = new AnnotationPlacement();
                yPointStart = 0;
                yPoint = 0;
                switch (A.lineD.lineType) {
                    case 7: 
                    case 8: 
                    case 9: {
                        if (this.Ch.containsXLabels) {
                            yPointStart = yPoint = this.getYPointStock(A.lineD, t);
                            break;
                        }
                        if (this.Ch.continuousTimeXAxis || A.lineD.subFrequency) {
                            yPointStart = yPoint = this.getYPointStock(A.lineD, t);
                            break;
                        }
                        yPointStart = A.lineD.yhigh_int[t_start];
                        yPoint = A.lineD.yhigh_int[t];
                        break;
                    }
                    default: {
                        if (this.Ch.containsXLabels) {
                            yPointStart = yPoint = this.getYPoint(A.lineD, t);
                            break;
                        }
                        if (this.Ch.continuousXAxis() || A.lineD.subFrequency) {
                            yPointStart = yPoint = this.getYPoint(A.lineD, t);
                            break;
                        }
                        yPointStart = A.lineD.yval_int[t_start];
                        yPoint = A.lineD.yval_int[t];
                    }
                }
                if (this.Ch.continuousXAxis()) {
                    P1.setX(A.text, b, A.lineD.xval_cont_int[t], yPointStart, 1);
                } else if (!this.Ch.continuousTimeXAxis || this.Ch.containsXLabels) {
                    P1.setX(A.text, b, this.xval_int[t_start], yPointStart, 1);
                }
                adjusted_left_corner = this.Ch.border_left;
                if (this.Ch.continuousXAxis()) {
                    adjusted_left_corner = this.adjustToPlotWindow(sc, A.lineD.xval_cont_int[t], P1.width);
                } else if (!this.Ch.continuousTimeXAxis || this.Ch.containsXLabels) {
                    adjusted_left_corner = this.adjustToPlotWindow(sc, this.xval_int[t_start], P1.width);
                }
                xLoc = this.getXPoint(A.lineD, t);
                P1 = this.placeAnnotation(g2, sc, A.lineD, b, A.text, i, xLoc, yPoint, adjusted_left_corner, t);
                second = true;
                Pbest = new AnnotationPlacement();
                if (second) {
                    new_left_corner = !this.Ch.continuousXAxis() || this.Ch.containsXLabels ? this.getXPoint(A.lineD, t_start) - P1.width / 2 + b.getBStringWidth(1) : A.lineD.xval_cont_int[t] - P1.width / 2 + b.getBStringWidth(1);
                    adjusted_left_corner = this.adjustToPlotWindow(sc, new_left_corner, P1.width);
                    P2 = this.placeAnnotation(g2, sc, A.lineD, b, A.text, i, xLoc, yPoint, adjusted_left_corner, t);
                    Pbest = P1.adjusted && !P2.adjusted ? P2 : (!P1.adjusted && P2.adjusted ? P1 : (P1.distance < P2.distance ? P1 : P2));
                } else {
                    Pbest = P1;
                }
                A.rectXMin = Pbest.xmin;
                A.rectYMin = Pbest.ymin;
                A.rectXMax = Pbest.xmax;
                A.rectYMax = Pbest.ymax;
                if (yminWindow > Pbest.ymin) {
                    yminWindow = Pbest.ymin;
                }
                if (ymaxWindow < Pbest.ymax) {
                    ymaxWindow = Pbest.ymax;
                }
                A.xmouth = this.Ch.containsIntervalGraphic != false && A.lineD.subFrequency == false ? xLoc + (int)Math.round(this.getHalfIntervalDC(sc, A.lineD)) : xLoc;
                A.ymouth = yPoint;
                if (!this.Ch.continuousXAxis()) {
                    A.x = this.getXPoint(A.lineD, Pbest.t_index);
                }
                if (this.Ch.continuousXAxis()) {
                    A.x = Pbest.t_dc;
                }
                A.y = Pbest.yplacement;
                switch (A.lineD.lineType) {
                    case 7: 
                    case 8: 
                    case 9: {
                        A.ymouth = A.ymouth > A.y ? A.lineD.yhigh_int[t] : A.lineD.ylow_int[t];
                    }
                }
                ++i;
            }
            if (draw) {
                i = this.AnnoV.size() - 1;
                while (i >= 0) {
                    A = (AnnoElement)this.AnnoV.elementAt(i);
                    b = new Annotation();
                    b.setFont(this.AnnoDesc.getFont());
                    b.getFMetrics(g2);
                    b.drawballoon(g2, A.text, A.xmouth, A.ymouth, A.x, A.y, this.AnnoDesc.getForeground(), this.AnnoDesc.getBackground(), (short)1);
                    --i;
                }
            }
            if (!draw && yminWindow < this.Ch.border_top - this.Ch.border_top_extra) {
                return this.Ch.border_top - yminWindow;
            }
        }
        return 0;
    }

    private int adjustToPlotWindow(SubChartDescription sc, int new_left_corner, int rectwidth) {
        int x_edge_offset = 3;
        int rightPlotEdge = this.Ch.displayWidth;
        int leftPlotEdge = this.Ch.border_right;
        if (new_left_corner <= leftPlotEdge) {
            new_left_corner = leftPlotEdge + x_edge_offset;
        } else if (new_left_corner + rectwidth >= rightPlotEdge) {
            new_left_corner = rightPlotEdge - rectwidth - x_edge_offset;
        }
        return new_left_corner;
    }

    private int getYPoint(LineDescription line, int t) {
        if (line.subFrequency) {
            int index = line.getSparseIndex(t);
            return line.yval_int[index];
        }
        return line.yval_int[t];
    }

    private int getYPointStock(LineDescription line, int t) {
        if (line.subFrequency) {
            int index = line.getSparseIndex(t);
            return line.yhigh_int[index];
        }
        return line.yhigh_int[t];
    }

    private int getXPoint(LineDescription line, int t) {
        int x = !this.Ch.continuousXAxis() ? this.xval_int[t] : line.xval_cont_int[t];
        return x;
    }

    /*
     * Unable to fully structure code
     */
    private AnnotationPlacement placeAnnotation(Graphics2D g2, SubChartDescription sc, LineDescription line, Annotation b, String annotation, int number_placed, int xmouth, int ymouth, int x_left_corner, int t) {
        block50: {
            test = false;
            numXAxisPoints = this.Ch.containsXLabels != false ? this.Ch.labelXCount : this.Ch.TStampsCount;
            y_adjust = 5;
            P = new AnnotationPlacement();
            t_start = 0;
            if (!this.Ch.continuousXAxis()) ** GOTO lbl12
            while (line.xval_cont_int[t_start + 1] < x_left_corner && t_start + 1 < line.xval_cont_int.length - 1) {
                ++t_start;
            }
            break block50;
lbl-1000:
            // 1 sources

            {
                ++t_start;
lbl12:
                // 2 sources

                ** while (this.xval_int[t_start + 1] < x_left_corner && t_start + 1 < numXAxisPoints - 1)
            }
        }
        yPointStart = 0;
        yPoint = 0;
        switch (line.lineType) {
            case 7: 
            case 8: 
            case 9: {
                yPoint = this.getYPointStock(line, t);
                break;
            }
            default: {
                yPoint = this.getYPoint(line, t);
            }
        }
        yPointStart = this.Ch.continuousXAxis() != false || line.subFrequency != false ? yPoint : line.yval_int[t_start];
        if (!this.Ch.continuousXAxis()) {
            P.setX(annotation, b, this.xval_int[t_start], yPointStart, 1);
        } else {
            P.setX(annotation, b, line.xval_cont_int[t], yPointStart, 1);
        }
        yNorth = 0x7FFFFFFF;
        ySouth = -2147483648;
        block3 : switch (line.lineType) {
            case 7: 
            case 8: 
            case 9: {
                if (!this.Ch.continuousXAxis()) {
                    k = t_start;
                    while (this.xval_int[k] < this.xval_int[t_start] + P.width) {
                        if (k >= numXAxisPoints - 1 || k >= line.yclose_int.length - 1) break block3;
                        if (ySouth < line.ylow_int[k]) {
                            ySouth = line.ylow_int[k];
                        }
                        if (yNorth > line.yhigh_int[k]) {
                            yNorth = line.yhigh_int[k];
                        }
                        ++k;
                    }
                } else {
                    if (t_start >= line.xval_cont_int.length) break;
                    k = t_start;
                    while (line.xval_cont_int[k] < line.xval_cont_int[t_start] + P.width) {
                        if (k >= line.ylow_int.length - 1 || k >= line.xval_cont_int.length) break block3;
                        if (ySouth < line.ylow_int[k]) {
                            ySouth = line.ylow_int[k];
                        }
                        if (yNorth > line.yhigh_int[k]) {
                            yNorth = line.yhigh_int[k];
                        }
                        ++k;
                    }
                }
                break;
            }
            default: {
                if (!this.Ch.continuousXAxis()) {
                    k = t_start;
                    while (this.xval_int[k] < this.xval_int[t_start] + P.width) {
                        if (k >= line.yval_int.length - 1 || k >= numXAxisPoints) break block3;
                        if (ySouth < line.yval_int[k]) {
                            ySouth = line.yval_int[k];
                        }
                        if (yNorth > line.yval_int[k]) {
                            yNorth = line.yval_int[k];
                        }
                        ++k;
                    }
                } else {
                    k = t_start;
                    while (line.xval_cont_int[k] < line.xval_cont_int[t_start] + P.width) {
                        if (k >= line.yval_int.length - 1 || k >= line.xval_cont_int.length) break block3;
                        if (ySouth < line.yval_int[k]) {
                            ySouth = line.yval_int[k];
                        }
                        if (yNorth > line.yval_int[k]) {
                            yNorth = line.yval_int[k];
                        }
                        ++k;
                    }
                    break block3;
                }
            }
        }
        xStartPoint = this.getXPoint(line, t_start);
        if (this.Ch.continuousXAxis()) {
            xStartPoint = line.xval_cont_int[t];
        }
        if (yPoint + y_adjust < yNorth) {
            yNorth = yPoint;
        }
        if (yPoint + y_adjust > ySouth) {
            ySouth = yPoint;
        }
        min_stem = 10;
        ymaxDC = this.ScaleYToPlotWindow(sc, sc.YAxis1.yAxisMet.Ymin);
        yminDC = this.ScaleYToPlotWindow(sc, sc.YAxis1.yAxisMet.Ymax);
        temp_distance = ySouth - yPoint;
        if (temp_distance < min_stem) {
            ySouth += min_stem;
        }
        if ((temp_distance = yPoint - yNorth) < min_stem) {
            yNorth -= min_stem;
        }
        currentAnno = (AnnoElement)this.AnnoV.elementAt(number_placed);
        currentAnno.YAboveBelow = 2;
        j = 0;
        while (j < number_placed) {
            A = (AnnoElement)this.AnnoV.elementAt(j);
            if (P.xmin >= A.rectXMin && P.xmin <= A.rectXMax || P.xmax >= A.rectXMin && P.xmax <= A.rectXMax || A.rectXMin >= P.xmin && A.rectXMin <= P.xmax || A.rectXMax >= P.xmin && A.rectXMax <= P.xmax) {
                adjusted_ySouth = ySouth + y_adjust;
                adjusted_yNorth = yNorth - y_adjust;
                if (A.YAboveBelow == 1) {
                    P.setY(annotation, b, xmouth, ymouth, xStartPoint, adjusted_ySouth);
                    if (P.ymin >= A.rectYMin && P.ymin <= A.rectYMax || P.ymax >= A.rectYMin && P.ymax <= A.rectYMax) {
                        ySouth = A.rectYMax;
                        currentAnno.YAboveBelow = 1;
                        P.distance = ySouth - yPoint;
                        P.yplacement = ySouth + y_adjust;
                    }
                }
                if (A.YAboveBelow == 0) {
                    P.setY(annotation, b, xmouth, ymouth, xStartPoint, adjusted_yNorth);
                    if (P.ymin >= A.rectYMin && P.ymin <= A.rectYMax || P.ymax >= A.rectYMin && P.ymax <= A.rectYMax) {
                        yNorth = A.rectYMin;
                        currentAnno.YAboveBelow = 0;
                        P.distance = yPoint - yNorth;
                        P.yplacement = yNorth - y_adjust;
                    }
                }
            }
            ++j;
        }
        if (this.isStockType(line.lineType)) {
            P.distance = yPoint - yNorth;
            P.yplacement = yNorth - y_adjust;
        } else if (this.isBarType(line.lineType)) {
            if (yPoint <= 0) {
                P.distance = ySouth - yPoint;
                P.yplacement = ySouth + y_adjust;
                currentAnno.YAboveBelow = 1;
            } else {
                P.distance = yPoint - yNorth;
                P.yplacement = yNorth - y_adjust;
                currentAnno.YAboveBelow = 0;
            }
        } else if (Math.abs(ySouth - yPoint) < Math.abs(yPoint - yNorth)) {
            P.distance = ySouth - yPoint;
            P.yplacement = ySouth + y_adjust;
            currentAnno.YAboveBelow = 1;
        } else {
            P.distance = yPoint - yNorth;
            P.yplacement = yNorth - y_adjust;
            currentAnno.YAboveBelow = 0;
        }
        P.ymin = b.getYMin(annotation, xmouth, ymouth, xStartPoint, P.yplacement);
        P.ymax = b.getYMax(annotation, xmouth, ymouth, xStartPoint, P.yplacement);
        reAlign = true;
        if (reAlign && P.ymax > ymaxDC) {
            if (currentAnno.YAboveBelow == 1) {
                P.distance = yPoint - yNorth;
                P.yplacement = yNorth - y_adjust;
                currentAnno.YAboveBelow = 0;
            } else {
                P.distance = ySouth - yPoint;
                P.yplacement = ySouth + y_adjust;
                currentAnno.YAboveBelow = 1;
            }
            P.ymin = b.getYMin(annotation, xmouth, ymouth, xStartPoint, P.yplacement);
            P.ymax = b.getYMax(annotation, xmouth, ymouth, xStartPoint, P.yplacement);
            if (P.ymax > ymaxDC) {
                P.yplacement -= P.ymax - ymaxDC + 2;
                P.ymin = b.getYMin(annotation, xmouth, ymouth, xStartPoint, P.yplacement);
                P.ymax = b.getYMax(annotation, xmouth, ymouth, xStartPoint, P.yplacement);
                P.adjusted = true;
            }
        }
        P.t_index = t_start;
        if (this.Ch.continuousXAxis()) {
            P.t_index = t;
            P.t_dc = x_left_corner;
        }
        return P;
    }

    private void CountStackedBars() {
        if (this.Ch.containsStackedBar) {
            int k = 0;
            while (k < this.Ch.SC.size()) {
                SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(k);
                sc.stackedBarCount = 0;
                if (sc.containsStackedBar) {
                    int s = 0;
                    while (s < sc.plotLineDes.size()) {
                        LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
                        if (line.lineType == 5) {
                            ++sc.stackedBarCount;
                        }
                        ++s;
                    }
                }
                ++k;
            }
        }
    }

    private void CountAreaCume() {
        if (this.Ch.containsAreaCume) {
            int k = 0;
            while (k < this.Ch.SC.size()) {
                SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(k);
                sc.areaCumeCount = 0;
                if (sc.containsAreaCume) {
                    int s = 0;
                    while (s < sc.plotLineDes.size()) {
                        LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
                        if (line.lineType == 3) {
                            ++sc.areaCumeCount;
                        }
                        ++s;
                    }
                }
                ++k;
            }
        }
    }

    private void allocNaNTimebands() {
        if (this.UserTimeBand.getTimeBandIntervals() != null || this.UserTimeBand.getTimeBandIntervalsVisual() != null) {
            return;
        }
        int k = 0;
        while (k < this.Ch.SC.size()) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(k);
            sc.generateNaNTimebands = false;
            if (sc.plotLineDes.size() == 1) {
                LineDescription line = (LineDescription)sc.plotLineDes.elementAt(0);
                if (line.containsNaN) {
                    sc.generateNaNTimebands = true;
                    int[] mapCount = new int[]{0};
                    int segmentCountNaN = line.countNaNSegments(false, mapCount);
                    line.countNaNSegments(true, mapCount);
                }
                if (line.containsNaN) {
                    if (this.Ch.TStampsCount != 0) {
                        TimeIntervalVisualDesc[] tiGenerated = new TimeIntervalVisualDesc[line.mapTimebandIndexes.length / 2];
                        int j = 0;
                        while (j < line.mapTimebandIndexes.length) {
                            Date tEnd;
                            Date tStart;
                            if (this.Ch.continuousTimeXAxis) {
                                tStart = line.contDates[line.mapTimebandIndexes[j]];
                                tEnd = line.contDates[line.mapTimebandIndexes[j + 1]];
                            } else if (line.timestampIndex == null) {
                                tStart = this.Ch.TStamps[line.mapTimebandIndexes[j]];
                                tEnd = this.Ch.TStamps[line.mapTimebandIndexes[j + 1]];
                            } else {
                                tStart = this.Ch.TStamps[line.timestampIndex[line.mapTimebandIndexes[j]]];
                                tEnd = this.Ch.TStamps[line.timestampIndex[line.mapTimebandIndexes[j + 1]]];
                            }
                            tiGenerated[j / 2] = new TimeIntervalVisualDesc(new TimeIntervalDesc(tStart, tEnd));
                            j += 2;
                        }
                        this.AxisTimeBandHolder.AxisTimebands_v = this.AxisTimeBandHolder.AxisTimebands.convertTimeBandsToDoubles(this.Ch, tiGenerated);
                    } else if (this.Ch.continuousTimeXAxis) {
                        // empty if block
                    }
                    if (this.AxisTimeBandHolder.AxisTimebands_v != null) {
                        this.AxisTimeBandHolder.AxisTimebands_int = new int[this.AxisTimeBandHolder.AxisTimebands_v.size()];
                        this.AxisTimeBandHolder.allocImageMap(this.AxisTimeBandHolder.AxisTimebands_v.size() / 2);
                        this.AxisTimeBandHolder.allocImageMapSide();
                    }
                }
            }
            ++k;
        }
    }

    private void ComputeSpreads() throws ChartException {
        StackedBarExtents sbe;
        SubChartDescription sc;
        int k;
        this.Ch.containsIntervalGraphic = false;
        boolean isIntervalGraphic = false;
        if (this.Ch.containsStackedBar) {
            this.CountStackedBars();
            k = 0;
            while (k < this.Ch.SC.size()) {
                sc = (SubChartDescription)this.Ch.SC.elementAt(k);
                if (sc.emptyYSeries) break;
                if (sc.stackedBarCount > 0) {
                    sbe = new StackedBarExtents(5);
                    if (!this.Ch.continuousTimeXAxis) {
                        sbe.computeSpreads(sc);
                    } else {
                        sbe.computeSpreadsContinuous(sc);
                    }
                    if (sc.YAxis1.yAxisMet.AutoExtentMax) {
                        sc.YAxis1.yAxisMet.Ymax_non_adjusted = sc.YAxis1.yAxisMet.Ymax = sbe.ymax;
                    }
                    if (sc.YAxis1.yAxisMet.AutoExtentMin) {
                        sc.YAxis1.yAxisMet.Ymin_non_adjusted = sc.YAxis1.yAxisMet.Ymin = sbe.ymin;
                    }
                }
                ++k;
            }
        }
        if (this.Ch.containsAreaCume) {
            this.CountAreaCume();
            k = 0;
            while (k < this.Ch.SC.size()) {
                sc = (SubChartDescription)this.Ch.SC.elementAt(k);
                if (sc.emptyYSeries) break;
                if (sc.areaCumeCount > 0) {
                    sbe = new StackedBarExtents(3);
                    if (!this.Ch.continuousTimeXAxis) {
                        sbe.computeSpreads(sc);
                    } else {
                        sbe.computeSpreadsContinuous(sc);
                    }
                    if (sc.YAxis1.yAxisMet.AutoExtentMax) {
                        sc.YAxis1.yAxisMet.Ymax_non_adjusted = sc.YAxis1.yAxisMet.Ymax = sbe.ymax;
                    }
                    if (sc.YAxis1.yAxisMet.AutoExtentMin) {
                        sc.YAxis1.yAxisMet.Ymin_non_adjusted = sc.YAxis1.yAxisMet.Ymin = sbe.ymin;
                    }
                }
                ++k;
            }
        }
        k = 0;
        while (k < this.Ch.SC.size()) {
            sc = (SubChartDescription)this.Ch.SC.elementAt(k);
            if (!sc.emptyYSeries) {
                if (!this.Ch.vertical) {
                    boolean identical = false;
                    if (sc.YAxis1.yAxisMet.Ymax == sc.YAxis1.yAxisMet.Ymin) {
                        identical = true;
                    }
                    if (sc.YAxis1.yAxisMet.Ymax < 0.0) {
                        sc.YAxis1.yAxisMet.Ymax = 0.0;
                        if (identical) {
                            sc.YAxis1.yAxisMet.Ymax_non_adjusted = 0.0;
                        }
                    }
                    if (sc.YAxis1.yAxisMet.Ymin > 0.0) {
                        sc.YAxis1.yAxisMet.Ymin = 0.0;
                        if (identical) {
                            sc.YAxis1.yAxisMet.Ymin_non_adjusted = 0.0;
                        }
                    }
                    if (sc.YAxis1.yAxisMet.Ymax == sc.YAxis1.yAxisMet.Ymin) {
                        sc.YAxis1.yAxisMet.Ymax = 1.0;
                        if (identical) {
                            sc.YAxis1.yAxisMet.Ymax_non_adjusted = 1.0;
                        }
                    }
                    if (sc.dualAxis) {
                        boolean identical2 = false;
                        if (sc.YAxis2.yAxisMet.Ymax == sc.YAxis2.yAxisMet.Ymin) {
                            identical2 = true;
                        }
                        if (sc.YAxis2.yAxisMet.Ymax < 0.0) {
                            sc.YAxis2.yAxisMet.Ymax = 0.0;
                            if (identical2) {
                                sc.YAxis2.yAxisMet.Ymax_non_adjusted = 0.0;
                            }
                        }
                        if (sc.YAxis2.yAxisMet.Ymin > 0.0) {
                            sc.YAxis2.yAxisMet.Ymin = 0.0;
                            if (identical2) {
                                sc.YAxis2.yAxisMet.Ymin_non_adjusted = 0.0;
                            }
                        }
                        if (sc.YAxis2.yAxisMet.Ymax == sc.YAxis2.yAxisMet.Ymin) {
                            sc.YAxis2.yAxisMet.Ymax = 1.0;
                            if (identical) {
                                sc.YAxis2.yAxisMet.Ymax_non_adjusted = 1.0;
                            }
                        }
                    }
                }
                sc.YAxis1.yAxisMet.y_coordinate_spread = sc.YAxis1.yAxisMet.Ymax - sc.YAxis1.yAxisMet.Ymin;
                sc.YAxis1.yAxisMet.setLogCoordinateSpread();
                double zeroAxis = 1.0;
                if (sc.YAxis1.yAxisMet.y_coordinate_spread == 0.0) {
                    if (sc.YAxis1.yAxisMet.Ymax > 0.0) {
                        sc.YAxis1.yAxisMet.Ymin = 0.0;
                        sc.YAxis1.yAxisMet.Ymin_non_adjusted = 0.0;
                    } else if (sc.YAxis1.yAxisMet.Ymax < 0.0) {
                        sc.YAxis1.yAxisMet.Ymax = 0.0;
                        sc.YAxis1.yAxisMet.Ymax_non_adjusted = 0.0;
                    } else {
                        sc.YAxis1.yAxisMet.Ymax = zeroAxis;
                        sc.YAxis1.yAxisMet.Ymax_non_adjusted = zeroAxis;
                        sc.YAxis1.yAxisMet.AutoExtentMax = false;
                    }
                    sc.YAxis1.yAxisMet.y_coordinate_spread = zeroAxis;
                }
                if (sc.dualAxis) {
                    sc.YAxis2.yAxisMet.y_coordinate_spread = sc.YAxis2.yAxisMet.Ymax - sc.YAxis2.yAxisMet.Ymin;
                    if (sc.YAxis2.yAxisMet.y_coordinate_spread == 0.0) {
                        if (sc.YAxis2.yAxisMet.Ymax > 0.0) {
                            sc.YAxis2.yAxisMet.Ymin = 0.0;
                            sc.YAxis2.yAxisMet.Ymin_non_adjusted = 0.0;
                        } else if (sc.YAxis2.yAxisMet.Ymax < 0.0) {
                            sc.YAxis2.yAxisMet.Ymax = 0.0;
                            sc.YAxis2.yAxisMet.Ymax_non_adjusted = 0.0;
                        } else {
                            sc.YAxis2.yAxisMet.Ymax = zeroAxis;
                            sc.YAxis2.yAxisMet.Ymax_non_adjusted = zeroAxis;
                            sc.YAxis2.yAxisMet.AutoExtentMax = false;
                        }
                        sc.YAxis2.yAxisMet.y_coordinate_spread = zeroAxis;
                    }
                }
            }
            int s = 0;
            while (s < sc.plotLineDes.size()) {
                LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
                if (this.isIntervalGraphic(line.lineType)) {
                    isIntervalGraphic = true;
                    this.Ch.containsIntervalGraphic = true;
                }
                if (this.isStockType(line.lineType)) {
                    this.Ch.containsStockType = true;
                }
                ++s;
            }
            ++k;
        }
    }

    protected void checkExtents(Graphics2D g2) throws ChartException {
        boolean test = false;
        if (!(this.Ch.containsTStamps || this.Ch.containsXLabels || this.Ch.continuousNumXAxis)) {
            Errorfcn.chartError("drawBuffer()", MsgUtil.getMsg("CHT-145"));
        }
        if (this.Ch.TStampsCount != 0) {
            this.reInitFreqDim();
        }
        int k = 0;
        while (k < this.Ch.SC.size()) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(k);
            if (!sc.emptyYSeries && sc.YAxis1.yAxisMet.Ymin_non_adjusted == Double.MAX_VALUE) {
                Errorfcn.chartError("drawBuffer()", MsgUtil.getMsg("CHT-141"));
            }
            ++k;
        }
    }

    protected void ScaleAll1(Graphics2D g2) throws ChartException {
        int k = 0;
        while (k < this.Ch.SC.size()) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(k);
            sc.x_coordinate_spread = this.Ch.useIntervalMethod() ? (double)this.Ch.XAxisCount : (double)(this.Ch.XAxisCount - 1);
            ++k;
        }
    }

    protected void estimateLeftBorder(Graphics2D g2) {
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        int labelHeight = sc.YAxis1.yl.fontmet.getHeight();
        this.deriveBorderLeft(false, labelHeight);
        if (this.Ch.vertical) {
            if (sc.dualAxis) {
                int labelHeight2 = sc.YAxis2.yl.fontmet.getHeight();
                this.deriveBorderRight(g2, false, labelHeight2);
            } else {
                this.deriveBorderRight(g2, false, labelHeight);
            }
        } else {
            this.deriveBorderRightHorizontal(g2, sc, sc.YAxis1);
            this.deriveBorderLeftHorizontal(sc, sc.YAxis1);
        }
    }

    protected void generateXAxisLabels(Graphics2D g2) {
        if (this.Ch.TStampsCount != 0 && this.xl.timeAxisD.getDrawLabel()) {
            this.reInitFreqDim();
            this.freqDimHeuristics();
        }
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        if (!this.Ch.continuousXAxis()) {
            this.ScaleXAxisToPlotWindow(this.xval, this.xval_int.length, sc.x_coordinate_spread);
        } else {
            this.ScaleXAxisContinuousToPlotWindow();
        }
        if (this.Ch.TStampsCount != 0 && this.xl.timeAxisD.getDrawLabel()) {
            this.reInitFreqDim();
            this.xl.SmartLabel();
            int LineLevels = this.xl.lastLevelField - this.xl.getLastVariableLevel() + 1;
            if (LineLevels >= 2) {
                this.xl.ExtendFirstLabel(0);
            }
            if (LineLevels > 2) {
                int limit = LineLevels - 1;
                if (this.xl.prependHoursToMinutes) {
                    --limit;
                } else if (this.xl.prependHoursMinutesToSeconds) {
                    limit -= 2;
                }
                int Lindex = 1;
                while (Lindex < limit) {
                    this.xl.ExtendFirstLabel(Lindex);
                    ++Lindex;
                }
            }
            if (this.xl.prependHoursMinutesToSeconds) {
                this.xl.ExtendSeconds(0);
            } else if (this.xl.prependHoursToMinutes) {
                this.xl.ExtendMinutes(0);
            }
            this.xl.FoldLabels(this.UserXGrid);
            if (!this.Ch.containsBarType) {
                this.xl.SmartHashMarks();
            }
        }
    }

    public void deriveBorderTop(Graphics2D g2) {
        super.getTitle().setFontMetrics(g2);
        super.getSubtitle().setFontMetrics(g2);
        int tempBordertop = 0;
        if (this.xl.timeAxisD.getAxisAlignment() == 0) {
            int numLevels = this.getNumXLLevels();
            int labelHeight = this.xl.fontmet.getHeight();
            tempBordertop = numLevels * labelHeight;
        }
        if (super.getTitle().getText() != "") {
            tempBordertop += super.getTitle().getHeight();
            super.getTitle().setLocation(0, 0);
            super.getTitle().setWidth(this.Ch.displayWidth);
        }
        if (super.getSubtitle().getText() != "") {
            tempBordertop += super.getSubtitle().getHeight();
            if (super.getTitle().getText() != "") {
                super.getSubtitle().setLocation(0, super.getTitle().getHeight());
            } else {
                super.getSubtitle().setLocation(0, 0);
            }
            super.getSubtitle().setWidth(this.Ch.displayWidth);
        }
        if (!AxisCore.super.isBorderTopSet() && tempBordertop != 0) {
            this.Ch.border_top = tempBordertop + this.Ch.border_top_extra;
            this.setBorderTopInternal(this.Ch.border_top);
        }
    }

    protected void ScaleAll2(Graphics2D g2) {
        boolean test = false;
        super.getFootnote().setFontMetrics(g2);
        if (this.Ch.vertical && !AxisCore.super.isBorderBottomSet()) {
            this.deriveBorderBottomXL(g2, true);
        }
        this.deriveBorderTop(g2);
        this.resetDisplaySize();
        int footnoteHeight = 0;
        if (super.getFootnote().getText() != "") {
            Chart.ChartLabel footnote = super.getFootnote();
            footnoteHeight = footnote.getHeight();
            FontMetrics fontmet = footnote.getFontMetrics();
            int labelHeight = fontmet.getAscent();
            footnote.setLocation(0, this.Ch.displayHeight - footnoteHeight - labelHeight);
            footnote.setWidth(this.Ch.displayWidth);
        }
        if (this.Ch.TStampsCount != 0) {
            this.resetDisplaySize();
        }
    }

    protected void ScaleAll3(Graphics2D g2) throws ChartException {
        SubChartDescription sc;
        boolean test = false;
        int labelHeight = 0;
        int k = 0;
        while (k < this.Ch.SC.size()) {
            sc = (SubChartDescription)this.Ch.SC.elementAt(k);
            if (sc.emptyYSeries) break;
            sc.YAxis1.yAxisMet.last_y_coordinate_spread = sc.YAxis1.yAxisMet.y_coordinate_spread;
            sc.last_x_coordinate_spread = sc.x_coordinate_spread;
            if (sc.dualAxis) {
                sc.YAxis2.yAxisMet.last_y_coordinate_spread = sc.YAxis2.yAxisMet.y_coordinate_spread;
            }
            labelHeight = sc.YAxis1.yl.fontmet.getHeight();
            if (this.Ch.vertical) {
                sc.YAxis1.yg.setAutoSpacing(this.Ch.vertical, sc.xAxisWidth, sc.Displayheight, sc.containsPointLabels, sc.HLayout.labelXSpaceLeft, sc.HLayout.labelXSpaceRight, labelHeight, 0, sc.YAxis1.yAxisMet, sc.YAxis1.yl.numAxisD.getTimeIntervalFormat(), sc.YAxis1.yl.numAxisD.getLogScale(), sc.YAxis1.yl.numAxisD.getNumberFormat());
                if (sc.dualAxis) {
                    int labelHeight2 = sc.YAxis2.yl.fontmet.getHeight();
                    sc.YAxis2.yg.setAutoSpacing(this.Ch.vertical, sc.xAxisWidth, sc.Displayheight, sc.containsPointLabels, sc.HLayout.labelXSpaceLeft, sc.HLayout.labelXSpaceRight, labelHeight2, 0, sc.YAxis2.yAxisMet, sc.YAxis2.yl.numAxisD.getTimeIntervalFormat(), sc.YAxis2.yl.numAxisD.getLogScale(), sc.YAxis2.yl.numAxisD.getNumberFormat());
                }
                double plotWindowHeight = this.Ch.displayHeight - this.Ch.border_bottom - this.Ch.border_top;
                sc.YAxis1.StretchY.setChartLocale(this.ChartLocale);
                sc.YAxis1.StretchY.NumAxisStretch(sc.plotLineDes, sc.YAxis1.yAxisMet, sc.YAxis1.yg.spacing, sc.YAxis1.yg.autoSpacing, sc.YAxis1.yg.isIntegerLabels, sc.YAxis1.yl.numAxisD, null, plotWindowHeight, sc.Displayheight, sc.xAxisWidth, sc.containsPointLabels, sc.containsBarIcons, sc.HLayout, this.Ch.vertical);
                if (sc.dualAxis) {
                    sc.YAxis2.StretchY.setChartLocale(this.ChartLocale);
                    sc.YAxis2.StretchY.NumAxisStretch(sc.plotLineDes, sc.YAxis2.yAxisMet, sc.YAxis2.yg.spacing, sc.YAxis2.yg.autoSpacing, sc.YAxis2.yg.isIntegerLabels, sc.YAxis2.yl.numAxisD, null, plotWindowHeight, sc.Displayheight, sc.xAxisWidth, sc.containsPointLabels, sc.containsBarIcons, sc.HLayout, this.Ch.vertical);
                }
            } else {
                int maxLabelWidth = this.estimateMaxStringWidthHorizontalNumerical(sc.YAxis1, sc.YAxis1.yl.numAxisD, 0);
                sc.YAxis1.StretchY.setChartLocale(this.ChartLocale);
                sc.YAxis1.yg.setAutoSpacing(this.Ch.vertical, sc.xAxisWidth, sc.Displayheight, sc.containsPointLabels, sc.HLayout.labelXSpaceLeft, sc.HLayout.labelXSpaceRight, labelHeight, maxLabelWidth, sc.YAxis1.yAxisMet, sc.YAxis1.yl.numAxisD.getTimeIntervalFormat(), sc.YAxis1.yl.numAxisD.getLogScale(), sc.YAxis1.yl.numAxisD.getNumberFormat());
                double plotWindowHeight = sc.HLayout.plotWidth;
                sc.YAxis1.StretchY.NumAxisStretch(sc.plotLineDes, sc.YAxis1.yAxisMet, sc.YAxis1.yg.spacing, sc.YAxis1.yg.autoSpacing, sc.YAxis1.yg.isIntegerLabels, sc.YAxis1.yl.numAxisD, null, plotWindowHeight, sc.Displayheight, sc.xAxisWidth, sc.containsPointLabels, sc.containsBarIcons, sc.HLayout, this.Ch.vertical);
            }
            ++k;
        }
        sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        labelHeight = sc.YAxis1.yl.fontmet.getHeight();
        this.deriveBorderLeft(true, labelHeight);
        if (this.Ch.vertical) {
            if (sc.dualAxis) {
                int labelHeight2 = sc.YAxis2.yl.fontmet.getHeight();
                this.deriveBorderRight(g2, true, labelHeight2);
            } else {
                this.deriveBorderRight(g2, true, labelHeight);
            }
        }
        if (!this.Ch.vertical) {
            this.deriveBorderBottom(g2, labelHeight, sc.YAxis1.yl.numAxisD.getDrawLabel());
        }
        sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        LineDescription line0 = (LineDescription)sc.plotLineDes.elementAt(0);
        this.getExtraSpace(line0.barAdjustFactor);
        if (!this.Ch.continuousXAxis()) {
            this.ScaleXAxisToPlotWindow(this.xval, this.xval_int.length, sc.x_coordinate_spread);
        } else {
            this.ScaleXAxisContinuousToPlotWindow();
        }
        if (this.AxisTimeBandHolder.AxisTimebands_v != null) {
            this.ScaleXAxisShadeToPlotWindow(this.AxisTimeBandHolder.AxisTimebands_v);
        }
        if (this.Ch.continuousNumXAxis) {
            int maxLabelWidth = this.estimateMaxStringWidthHorizontalNumerical(this.Ch.NumXAxis, sc.YAxis1.yl.numAxisD, 0);
            this.Ch.NumXAxis.StretchY.setChartLocale(this.ChartLocale);
            this.Ch.NumXAxis.yg.setAutoSpacing(false, sc.xAxisWidth, sc.Displayheight, sc.containsPointLabels, sc.HLayout.labelXSpaceLeft, sc.HLayout.labelXSpaceRight, labelHeight, maxLabelWidth, this.Ch.NumXAxis.yAxisMet, false, false, sc.YAxis1.yl.numAxisD.getNumberFormat());
            this.setPlotWidthHBar(sc);
            double plotWindowWidth = sc.HLayout.plotWidth;
            this.Ch.NumXAxis.StretchY.NumAxisStretch(sc.plotLineDes, this.Ch.NumXAxis.yAxisMet, this.Ch.NumXAxis.yg.spacing, this.Ch.NumXAxis.yg.autoSpacing, this.Ch.NumXAxis.yg.isIntegerLabels, this.Ch.NumXAxis.yl.numAxisD, this.Ch.numXAxisNF, plotWindowWidth, sc.Displayheight, sc.xAxisWidth, sc.containsPointLabels, sc.containsBarIcons, sc.HLayout, false);
            this.ScaleNumXAxisToPlotWindow(sc, this.Ch.NumXAxis.StretchY.vgrid_y_raster, this.Ch.NumXAxis.StretchY.vgrid_y.size(), this.Ch.NumXAxis);
        }
        int k2 = 0;
        while (k2 < this.Ch.SC.size()) {
            sc = (SubChartDescription)this.Ch.SC.elementAt(k2);
            if (sc.emptyYSeries) break;
            int s = 0;
            while (s < sc.plotLineDes.size()) {
                double ySpread;
                LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
                if (this.Ch.continuousXAxis()) {
                    this.ScaleContinuousXAxisToPlotWindow(line);
                }
                if (line.axisPrimary) {
                    ySpread = sc.YAxis1.yAxisMet.getCoordinateSpread(this.isLogScale(sc));
                    this.ScaleYLineToPlotWindow(sc, line, ySpread, sc.YAxis1.yAxisMet.Ymax);
                } else {
                    ySpread = sc.YAxis2.yAxisMet.getCoordinateSpread(this.isLogScale(sc));
                    this.ScaleYLineToPlotWindow(sc, line, ySpread, sc.YAxis2.yAxisMet.Ymax);
                }
                if (line.subFrequency) {
                    this.ScaleXLineToPlotWindow(line, sc.x_coordinate_spread);
                }
                ++s;
            }
            if (this.Ch.vertical) {
                this.ScaleYToPlotWindow(sc, this.Ch.vertical, sc.YAxis1.StretchY.vgrid_y_raster, sc.YAxis1.StretchY.vgrid_y.size(), sc.YAxis1);
                if (sc.dualAxis) {
                    this.ScaleYToPlotWindow(sc, this.Ch.vertical, sc.YAxis2.StretchY.vgrid_y_raster, sc.YAxis2.StretchY.vgrid_y.size(), sc.YAxis2);
                }
            } else {
                this.ScaleYToPlotWindow(sc, this.Ch.vertical, sc.YAxis1.StretchY.vgrid_y_raster, sc.YAxis1.StretchY.vgrid_y.size(), sc.YAxis1);
            }
            ++k2;
        }
        this.deriveThickness();
    }

    protected int countLegendColumns(int width) {
        int maxCols;
        int legWidth = this.SubChZero.L2.getLegendColumnWidth();
        int numItems = this.SubChZero.L2.getLegendNumItems();
        if (numItems < (maxCols = width / legWidth)) {
            return numItems;
        }
        int numRows = Precision.IntCeil(numItems, maxCols);
        int numCols = Precision.IntCeil(numItems, numRows);
        return numCols;
    }

    private void drawBevel(Graphics2D g2, BevelDesc bevelD, int xCorner0, int yCorner0, int xCorner1, int yCorner1) {
        if (bevelD == null) {
            return;
        }
        int rectWidth = xCorner1 - xCorner0;
        int rectHeight = yCorner1 - yCorner0;
        switch (bevelD.getState()) {
            case 0: {
                g2.fillRect(xCorner0, yCorner0, rectWidth, rectHeight);
                break;
            }
            case 1: {
                g2.fillRect(xCorner0, yCorner0 + 1, rectWidth, rectHeight - 2);
            }
        }
        switch (bevelD.getState()) {
            case 0: {
                g2.setColor(bevelD.getEdgeColorBright());
                break;
            }
            case 1: {
                g2.setColor(bevelD.getEdgeColorDark());
            }
        }
        int xc0 = xCorner0;
        int yc0 = yCorner0;
        int xc1 = xCorner1 - 1;
        int yc1 = yCorner1 - 1;
        g2.setStroke(this.DefaultStroke);
        g2.drawLine(xc0, yc0, xc0, yc1);
        switch (bevelD.getState()) {
            case 0: {
                g2.setStroke(this.Stroke2f);
                g2.drawLine(xc0, yc0, xc1, yc0);
                break;
            }
            case 1: {
                g2.setStroke(this.Stroke2f);
                int k = 1;
                g2.drawLine(xc0, yc0 + k, xc1, yc0 + k);
            }
        }
        switch (bevelD.getState()) {
            case 0: {
                g2.setStroke(this.Stroke2f);
                break;
            }
            case 1: {
                g2.setStroke(this.Stroke2f);
            }
        }
        if (bevelD.getState() == 1) {
            g2.setColor(bevelD.getEdgeColorBright());
        } else {
            g2.setColor(bevelD.getEdgeColorDark());
        }
        g2.drawLine(xc1, yc1, xc1, yc0);
        g2.drawLine(xc0, yc1, xc1, yc1);
        g2.setStroke(this.DefaultStroke);
    }

    private void drawFilledEdge(Graphics2D g2, FillEdgeDesc fillEdgeD, int xCorner0, int yCorner0, int xCorner1, int yCorner1) {
        if (fillEdgeD == null) {
            return;
        }
        g2.setColor(fillEdgeD.getEdgeColor());
        int xc0 = xCorner0;
        int yc0 = yCorner0;
        int xc1 = xCorner1 - 1;
        int yc1 = yCorner1 - 1;
        g2.drawLine(xc0, yc0, xc0, yc1);
        g2.drawLine(xc0, yc0, xc1, yc0);
        g2.drawLine(xc1, yc1, xc1, yc0);
        g2.drawLine(xc1, yc1, xc0, yc1);
    }

    protected void drawChartBackground(Graphics2D g2, boolean justFill, boolean justOutline) {
        SubChartDescription sc;
        int all_subcharts_height = 0;
        int k = 0;
        while (k < this.Ch.SC.size()) {
            sc = (SubChartDescription)this.Ch.SC.elementAt(k);
            all_subcharts_height = (int)((double)all_subcharts_height + sc.Displayheight);
            ++k;
        }
        int totalSeparatorHeight = this.Ch.subchartSeparatorHeight * (this.Ch.SC.size() - 1);
        all_subcharts_height += totalSeparatorHeight;
        int chartLocationX = 0;
        int chartLocationY = 0;
        if (!this.Ch.vertical && !justOutline) {
            g2.setColor(super.getBackground());
            g2.fillRect(chartLocationX, chartLocationY, this.Ch.displayWidth, this.Ch.displayHeight);
        }
        sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        int plotHeight = this.Ch.displayHeight - this.Ch.border_bottom - this.Ch.border_top;
        if (!justOutline) {
            g2.setColor(this.getPlotBackground());
            if (this.Ch.vertical) {
                int i;
                int height;
                int width;
                int y;
                int x;
                g2.fillRect(this.Ch.border_left + chartLocationX, this.Ch.border_top + chartLocationY, (int)sc.displaywidth2 + 1, plotHeight + 1);
                SvgUtil2.writeSVGClipWindow(this.svgChartGraphics, this.Ch, "cb_plotWindowClip", this.Ch.border_left + chartLocationX, this.Ch.border_top + chartLocationY, (int)sc.displaywidth2 + 1, plotHeight + 1);
                if (!this.xl.timeBandDesc.getRenderInForeground()) {
                    this.renderTimeBands(g2);
                }
                if (this.colorBands) {
                    x = 0;
                    y = 0;
                    width = 0;
                    height = 0;
                    i = 0;
                    while (i < sc.plotNumBandDesc.size()) {
                        NumBandDesc band = (NumBandDesc)sc.plotNumBandDesc.elementAt(i);
                        g2.setColor(band.getColor());
                        switch (band.getBandType()) {
                            case 1: {
                                double high = band.getHigh();
                                int highInt = this.ScaleYToPlotWindow(sc, high);
                                x = this.Ch.border_left + chartLocationX;
                                y = this.Ch.border_top + chartLocationY;
                                width = (int)sc.displaywidth2 + 1;
                                height = highInt - this.Ch.border_top + chartLocationY;
                                g2.fillRect(x, y, width, height);
                                break;
                            }
                            case 2: {
                                double low = band.getLow();
                                int lowInt = this.ScaleYToPlotWindow(sc, low);
                                x = this.Ch.border_left + chartLocationX;
                                y = lowInt;
                                width = (int)sc.displaywidth2 + 1;
                                height = (int)sc.Displayheight + this.Ch.border_top - lowInt;
                                g2.fillRect(x, y, width, height);
                                break;
                            }
                            case 0: {
                                double low = band.getLow();
                                int lowInt = this.ScaleYToPlotWindow(sc, low);
                                double high = band.getHigh();
                                int highInt = this.ScaleYToPlotWindow(sc, high);
                                x = this.Ch.border_left + chartLocationX;
                                y = highInt;
                                width = (int)sc.displaywidth2 + 1;
                                height = lowInt - highInt;
                                g2.fillRect(x, y, width, height);
                            }
                        }
                        switch (band.getBandType()) {
                            case 0: 
                            case 1: 
                            case 2: {
                                if (band.getBorderWidth(0) > 0) {
                                    g2.setColor(band.getBorderColor(0));
                                    g2.fillRect(x, y, width, band.getBorderWidth(0));
                                }
                                if (band.getBorderWidth(1) <= 0) break;
                                int border_height = band.getBorderWidth(1);
                                g2.setColor(band.getBorderColor(1));
                                g2.fillRect(x, y + height - border_height, width, border_height);
                            }
                        }
                        ++i;
                    }
                }
                x = 0;
                y = 0;
                width = 0;
                height = 0;
                i = 0;
                while (i < sc.plotNumThresholdDesc.size()) {
                    NumThresholdDesc threshold = (NumThresholdDesc)sc.plotNumThresholdDesc.elementAt(i);
                    g2.setColor(threshold.getColor());
                    double yval = threshold.getY();
                    int lowInt = this.ScaleYToPlotWindow(sc, yval);
                    x = this.Ch.border_left + chartLocationX;
                    y = lowInt;
                    width = (int)sc.displaywidth2 + 1;
                    g2.fillRect(x, y, width, threshold.getWidth());
                    if (threshold.getLabelDesc() != null && threshold.getLabelDesc().getText() != null && threshold.getLabelDesc().getText() != "") {
                        int labelPad = threshold.getLabelDesc().fontmet.getHeight() / 3;
                        if (threshold.getLabelDesc().getTextAttributes() != null) {
                            AttributedString attrStr = new AttributedString(threshold.getLabelDesc().getText(), threshold.getLabelDesc().getTextAttributes());
                            TextLayout layout = new TextLayout(attrStr.getIterator(), g2.getFontRenderContext());
                            layout.draw(g2, x + labelPad, y);
                        } else {
                            g2.setColor(threshold.getLabelDesc().getColor());
                            g2.drawString(threshold.getLabelDesc().getText(), x + labelPad, y);
                        }
                    }
                    ++i;
                }
            } else {
                g2.setColor(this.getPlotBackground());
                g2.fillRect(sc.HLayout.labelXSpaceLeft + this.Ch.border_left - 1, this.Ch.border_top, (int)sc.HLayout.plotWidth + 1, plotHeight);
                SvgUtil2.writeSVGClipWindow(this.svgChartGraphics, this.Ch, "cb_plotWindowClip", sc.HLayout.labelXSpaceLeft + this.Ch.border_left - 1, this.Ch.border_top, (int)sc.HLayout.plotWidth + 1, plotHeight);
            }
        }
    }

    private void renderTimeBandSides(Graphics2D g2) {
        if (this.AxisTimeBandHolder.AxisTimebands_v != null) {
            SideIconDesc sideIcons = this.UserTimeBand.getSideIconDesc();
            g2.setColor(this.xl.timeBandDesc.getColor());
            if (sideIcons != null) {
                int diff;
                int interval;
                int yCorner1;
                int xCorner1;
                int yCorner0;
                int xCorner0;
                int plotHeight = this.Ch.displayHeight - this.Ch.border_bottom - this.Ch.border_top;
                BevelRectIconDesc bl = sideIcons.getLeftBevelRectIconDesc();
                BevelRectIconDesc br = sideIcons.getRightBevelRectIconDesc();
                int width = sideIcons.getWidth();
                if (bl != null) {
                    xCorner0 = 0;
                    yCorner0 = this.Ch.border_top;
                    xCorner1 = this.Ch.border_left - sideIcons.getPadding();
                    yCorner1 = yCorner0 + plotHeight + 1;
                    switch (sideIcons.getLeftBandAlignment()) {
                        case 0: 
                        case 2: {
                            if (xCorner1 - xCorner0 <= width) break;
                            xCorner0 = xCorner1 - width + this.LeftExtendAmount;
                            xCorner1 += this.LeftExtendAmount;
                            break;
                        }
                        case 3: {
                            xCorner0 = 0;
                            if (width >= this.Ch.border_left) break;
                            xCorner1 = width;
                            break;
                        }
                        case 1: {
                            if (xCorner1 - xCorner0 <= width) break;
                            interval = xCorner1 - xCorner0;
                            diff = interval - width;
                            xCorner0 = diff / 2;
                            xCorner1 = xCorner0 + width;
                        }
                    }
                    this.drawBevelRectIcon(g2, xCorner0, yCorner0, xCorner1, yCorner1, bl);
                    if (this.AxisTimeBandHolder.genImageMapCoords) {
                        this.AxisTimeBandHolder.copyImageMapRectSide(0, xCorner0, yCorner0, xCorner1, yCorner1);
                    }
                }
                if (br != null) {
                    xCorner0 = this.Ch.displayWidth - this.Ch.border_right + sideIcons.getPadding();
                    yCorner0 = this.Ch.border_top;
                    xCorner1 = this.Ch.displayWidth;
                    yCorner1 = yCorner0 + plotHeight + 1;
                    switch (sideIcons.getRightBandAlignment()) {
                        case 0: 
                        case 3: {
                            if (xCorner1 - xCorner0 <= width) break;
                            xCorner1 = xCorner0 + width + this.RightExtendAmount;
                            xCorner0 += this.RightExtendAmount;
                            break;
                        }
                        case 2: {
                            if (xCorner1 - xCorner0 <= width) break;
                            xCorner0 = xCorner1 - width;
                            break;
                        }
                        case 1: {
                            if (xCorner1 - xCorner0 <= width) break;
                            interval = xCorner1 - xCorner0;
                            diff = interval - width;
                            xCorner1 = this.Ch.displayWidth - diff / 2;
                            xCorner0 = xCorner1 - width;
                        }
                    }
                    this.drawBevelRectIcon(g2, xCorner0, yCorner0, xCorner1, yCorner1, br);
                    if (this.AxisTimeBandHolder.genImageMapCoords) {
                        this.AxisTimeBandHolder.copyImageMapRectSide(1, xCorner0, yCorner0, xCorner1, yCorner1);
                    }
                }
            }
        }
    }

    private void renderTimeBands(Graphics2D g2) {
        int plotHeight = this.Ch.displayHeight - this.Ch.border_bottom - this.Ch.border_top;
        if (this.AxisTimeBandHolder.AxisTimebands_v != null) {
            if (this.svgChartGraphics.getEnableSVG()) {
                this.svgChartGraphics.startGroup("cb_timeband");
            }
            TimeIntervalVisualDesc[] timeIVD = this.UserTimeBand.getTimeBandIntervalsVisual();
            g2.setColor(this.xl.timeBandDesc.getColor());
            int r = 0;
            while (r < this.AxisTimeBandHolder.AxisTimebands_int.length) {
                int xCorner0 = this.AxisTimeBandHolder.AxisTimebands_int[r];
                int yCorner0 = this.Ch.border_top;
                int xCorner1 = this.AxisTimeBandHolder.AxisTimebands_int[r + 1];
                int yCorner1 = yCorner0 + plotHeight + 1;
                g2.setColor(this.xl.timeBandDesc.getColor());
                BevelRectIconDesc brIcon = null;
                if (timeIVD != null && timeIVD[r / 2] != null) {
                    brIcon = timeIVD[r / 2].getBevelRectIconDesc();
                }
                this.drawBevelRectIcon(g2, xCorner0, yCorner0, xCorner1, yCorner1, brIcon);
                if (this.AxisTimeBandHolder.genImageMapCoords) {
                    this.AxisTimeBandHolder.copyImageMapRect(r / 2, xCorner0, yCorner0, xCorner1, yCorner1);
                }
                r += 2;
            }
            if (this.svgChartGraphics.getEnableSVG()) {
                this.svgChartGraphics.endGroup();
            }
        }
    }

    private void drawBevelRectIcon(Graphics2D g2, int xCorner0, int yCorner0, int xCorner1, int yCorner1, BevelRectIconDesc brIcon) {
        int imageWidth;
        BevelDesc bevelD = null;
        FillEdgeDesc fillEdgeD = null;
        BufferedImage icon = null;
        if (brIcon != null) {
            bevelD = brIcon.getBevelDesc();
            fillEdgeD = brIcon.getFillEdgeDesc();
            icon = brIcon.getIcon();
        }
        int xOffsetLeftEdge = 0;
        int xOffsetRightEdge = 0;
        if (icon != null) {
            imageWidth = icon.getWidth();
            switch (brIcon.getIconAlignment()) {
                case 4: {
                    this.LeftExtendAmount = xOffsetLeftEdge = -imageWidth / 2;
                    break;
                }
                case 5: {
                    this.RightExtendAmount = xOffsetRightEdge = imageWidth / 2;
                }
            }
        }
        if (bevelD == null) {
            if (fillEdgeD != null) {
                g2.setColor(fillEdgeD.getColor());
            }
            g2.fillRect(xCorner0 + xOffsetLeftEdge, yCorner0, xCorner1 - (xCorner0 + xOffsetLeftEdge) + xOffsetRightEdge, yCorner1 - yCorner0);
            if (fillEdgeD != null) {
                this.drawFilledEdge(g2, fillEdgeD, xCorner0 + xOffsetLeftEdge, yCorner0, xCorner1 + xOffsetRightEdge, yCorner1);
            }
        } else {
            g2.setColor(bevelD.getBaseColor());
            this.drawBevel(g2, bevelD, xCorner0 + xOffsetLeftEdge, yCorner0, xCorner1 + xOffsetRightEdge, yCorner1);
        }
        if (icon != null) {
            imageWidth = icon.getWidth();
            int imageHeight = icon.getHeight();
            int bandWidth = xCorner1 - xCorner0;
            int bandHeight = yCorner1 - yCorner0;
            int x = xCorner0;
            switch (brIcon.getIconAlignment()) {
                case 1: {
                    if (imageWidth >= bandWidth) break;
                    x += (bandWidth - imageWidth) / 2;
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    x = xCorner0 + xOffsetLeftEdge;
                    break;
                }
                case 5: {
                    x = xCorner1 - xOffsetRightEdge;
                    break;
                }
                case 3: {
                    x = xCorner1 - imageWidth;
                }
            }
            int y = yCorner0;
            if (imageHeight < bandHeight) {
                y += (bandHeight - imageHeight) / 2;
            }
            g2.drawImage(icon, null, x, y);
        }
    }

    protected void drawAxisLines(Graphics2D g2) {
        int xRight;
        int yBottom;
        int yTop;
        int xLeft;
        SubChartDescription sc;
        int plotHeight = this.Ch.displayHeight - this.Ch.border_bottom - this.Ch.border_top;
        int all_subcharts_height = 0;
        int k = 0;
        while (k < this.Ch.SC.size()) {
            sc = (SubChartDescription)this.Ch.SC.elementAt(k);
            all_subcharts_height = (int)((double)all_subcharts_height + sc.Displayheight);
            ++k;
        }
        int totalSeparatorHeight = this.Ch.subchartSeparatorHeight * (this.Ch.SC.size() - 1);
        all_subcharts_height += totalSeparatorHeight;
        g2.setStroke(this.DefaultStroke);
        g2.setColor(this.getPlotEdgeColor());
        sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        if (this.Ch.vertical) {
            xLeft = this.Ch.border_left - 1;
            yTop = this.Ch.border_top;
            yBottom = this.Ch.border_top + all_subcharts_height;
            xRight = xLeft + (int)sc.displaywidth2 + 2;
        } else {
            xLeft = sc.HLayout.labelXSpaceLeft + this.Ch.border_left;
            yTop = this.Ch.border_top;
            yBottom = this.Ch.border_top + plotHeight;
            xRight = xLeft + (int)sc.HLayout.plotWidth;
        }
        if (this.getPlotEdgeColor() != null && this.getPlotEdgeColor() != this.getBackground()) {
            if (this.svgChartGraphics.getEnableSVG()) {
                this.svgChartGraphics.startGroup("cb_plotedge");
            }
            g2.drawLine(xLeft, yBottom, xLeft, yTop);
            g2.drawLine(xLeft, yBottom, xRight, yBottom);
            g2.drawLine(xRight, yBottom, xRight, yTop);
            g2.drawLine(xLeft, yTop, xRight, yTop);
            if (this.svgChartGraphics.getEnableSVG()) {
                this.svgChartGraphics.endGroup();
            }
        }
        if (this.Ch.axisChartStyle.getEnableAxisLines()) {
            if (this.svgChartGraphics.getEnableSVG()) {
                this.svgChartGraphics.startGroup("cb_axisline");
            }
            g2.setColor(this.PlotAxisLineColor);
            g2.drawLine(xLeft, yBottom, xRight, yBottom);
            g2.drawLine(xLeft, yBottom, xLeft, yTop);
            if (this.svgChartGraphics.getEnableSVG()) {
                this.svgChartGraphics.endGroup();
            }
        }
        SvgUtil2.writeSVGClipWindow(this.svgChartGraphics, this.Ch, "cb_XAxisClip", 0, yBottom + this.Ch.border_xaxis_spacer, this.Ch.displayWidth, this.Ch.border_xaxis);
    }

    protected void alignLegendFootnote(Graphics2D g2) {
        if (!this.SubChZero.L2.getLegendDesc().getLegendInside()) {
            int alignment = this.SubChZero.L2.getLegendDesc().getLegendAlignment();
            switch (alignment) {
                case 3: 
                case 10: 
                case 11: {
                    this.SubChZero.L2.setLegendOffsetXInternal(-1);
                    break;
                }
                case 4: {
                    int footnoteWidth = 0;
                    if (super.getFootnote().getText() != "") {
                        this.getFootnote().setFontMetrics(g2);
                        int footnoteAlignment = super.getFootnote().getAlignment();
                        int footWidth = super.getFootnote().getStringWidth() + this.getFootnote().getFontMetrics().stringWidth("#");
                        switch (footnoteAlignment) {
                            case 0: {
                                footnoteWidth = footWidth;
                                break;
                            }
                            case 1: {
                                footnoteWidth = this.Ch.displayWidth / 2 + footWidth / 2;
                                break;
                            }
                            case 4: {
                                footnoteWidth = this.Ch.displayWidth / 2 + footWidth / 2;
                                break;
                            }
                            case 2: {
                                footnoteWidth = this.Ch.displayWidth;
                            }
                        }
                    }
                    int XPositionOfBottomInvariantLabel = this.xl.getLastLevelXPosition(g2, this.getXScaleConstant());
                    int xtemp = footnoteWidth;
                    if (this.AxisT.titleDescX.getTitle() == "" && XPositionOfBottomInvariantLabel > footnoteWidth) {
                        xtemp = XPositionOfBottomInvariantLabel;
                    }
                    int availableWidth = this.Ch.displayWidth - xtemp;
                    int numCols = this.countLegendColumns(availableWidth);
                    this.SubChZero.L2.setLegendColumns(numCols);
                    this.SubChZero.L2.setLegendOffsetYInternal(-1);
                    boolean placeAbove = false;
                    if (xtemp <= 0) break;
                    int legWidth = this.SubChZero.L2.getLegendWidth(g2);
                    int xLegendStart = this.Ch.displayWidth / 2 - legWidth / 2;
                    if (super.getFootnote().getText() != "") {
                        if (availableWidth <= legWidth) {
                            placeAbove = true;
                        }
                        int threshold = 0;
                        threshold = super.getFootnote().getLineCount();
                        if (XPositionOfBottomInvariantLabel > 0) {
                            ++threshold;
                        }
                        int currentRowCount = this.SubChZero.L2.getRowCeilProjected(numCols);
                        int columnWidth = this.SubChZero.L2.getLegendColumnWidth();
                        if (currentRowCount > threshold && columnWidth * 2 < this.Ch.displayWidth) {
                            placeAbove = true;
                        }
                        if (placeAbove) {
                            availableWidth = this.Ch.displayWidth - XPositionOfBottomInvariantLabel - this.InvPad;
                            numCols = this.countLegendColumns(availableWidth);
                            this.SubChZero.L2.setLegendColumns(numCols);
                            currentRowCount = this.SubChZero.L2.getRowCeilProjected(numCols);
                            legWidth = this.SubChZero.L2.getLegendWidth(g2);
                            xLegendStart = this.Ch.displayWidth / 2 - legWidth / 2;
                            this.Ch.southLegendRows = currentRowCount;
                            if (xLegendStart >= XPositionOfBottomInvariantLabel) break;
                            this.SubChZero.L2.setLegendOffsetXInternal(XPositionOfBottomInvariantLabel / 2);
                            break;
                        }
                        if (xLegendStart >= footnoteWidth) break;
                        this.SubChZero.L2.setLegendOffsetXInternal(footnoteWidth / 2);
                        break;
                    }
                    if (availableWidth < legWidth) {
                        availableWidth = this.Ch.displayWidth;
                        numCols = this.countLegendColumns(availableWidth);
                        this.SubChZero.L2.setLegendColumns(numCols);
                        int currentRowCount = this.SubChZero.L2.getRowCeilProjected(numCols);
                        this.SubChZero.L2.setLegendOffsetXInternal(0);
                        break;
                    }
                    if (this.AxisT.titleDescX.getTitle() != "" || xLegendStart >= XPositionOfBottomInvariantLabel) break;
                    this.SubChZero.L2.setLegendOffsetXInternal(XPositionOfBottomInvariantLabel / 2 - this.Ch.border_left / 2);
                }
            }
        }
    }

    protected void legendHeuristics(Graphics2D g2) {
        double actualLegendWidth = this.SubChZero.L2.getLegendWidth(g2);
        if (this.Ch.perSubchartLegend) {
            actualLegendWidth = this.getLegendWidthAllSubcharts(g2);
        }
        int alignment = this.SubChZero.L2.getLegendDesc().getLegendAlignment();
        if (!this.Ch.vertical && !this.Ch.containsStackedBar && this.Ch.containsBarType) {
            this.SubChZero.L2.setLegendOrderReverse();
        }
        if (this.Ch.vertical && (this.Ch.containsStackedBar || this.Ch.containsAreaCume) && (alignment == 4 && this.reverseStackOrder || alignment != 4)) {
            if (!this.SubChZero.L2.getLegendDesc().getLegendInside()) {
                this.SubChZero.L2.setLegendOrderReverse();
            } else {
                this.SubChZero.L2.setLegendOrderReverse();
            }
        }
        if (!this.SubChZero.L2.getLegendDesc().getLegendInside()) {
            double legendSpace;
            this.SubChZero.L2.resetLegendReduce();
            alignment = this.SubChZero.L2.getLegendDesc().getLegendAlignment();
            switch (alignment) {
                case 3: 
                case 10: 
                case 11: {
                    boolean reduce;
                    double availableWidth = this.Ch.displayWidth - (this.Ch.border_left + this.border_right_default);
                    actualLegendWidth = this.SubChZero.L2.getLegendWidth(g2);
                    legendSpace = availableWidth * this.SubChZero.L2.getLegendDesc().getLegendMaxWidthFraction();
                    if (!(actualLegendWidth > legendSpace) || (reduce = this.SubChZero.L2.setLegendReduceWidth((int)legendSpace))) break;
                    this.SubChZero.L2.setLegendDisableInternal();
                }
            }
            if (!this.SubChZero.L2.getLegendDisableInternal()) {
                switch (alignment) {
                    case 3: {
                        double availableWidth = this.Ch.displayWidth - (this.Ch.border_left + this.border_right_default);
                        actualLegendWidth = this.SubChZero.L2.getLegendWidth(g2);
                        legendSpace = availableWidth * this.SubChZero.L2.getLegendDesc().getLegendMaxWidthFraction();
                        if (actualLegendWidth > legendSpace) {
                            boolean reduce = this.SubChZero.L2.setLegendReduceWidth((int)legendSpace);
                            if (reduce) break;
                            this.SubChZero.L2.setLegendDisableInternal();
                            break;
                        }
                        int topSpace = 0;
                        super.getTitle().setFontMetrics(g2);
                        if (super.getTitle().getText() != "") {
                            super.getTitle().setFontMetrics(g2);
                            topSpace = super.getTitle().getHeight() + this.Ch.border_top_extra;
                        }
                        legendSpace = this.Ch.displayHeight - topSpace;
                        this.SubChZero.L2.setLegendMaxHeight((int)Math.round(legendSpace));
                        boolean reduced = this.SubChZero.L2.reduceLegendElements();
                        if (!reduced) break;
                        this.SubChZero.L2.setLegendOffsetYInternal(topSpace / 2);
                        break;
                    }
                    case 10: 
                    case 11: {
                        if (this.Ch.vertical && !AxisCore.super.isBorderBottomSet()) {
                            this.deriveBorderBottomXL(g2, false);
                        }
                        super.getTitle().setFontMetrics(g2);
                        int topSpace = 0;
                        if (super.getTitle().getText() != "") {
                            super.getTitle().setFontMetrics(g2);
                            topSpace = super.getTitle().getHeight() + this.Ch.border_top_extra;
                        }
                        legendSpace = this.Ch.displayHeight - this.Ch.border_bottom - topSpace;
                        this.SubChZero.L2.setLegendMaxHeight((int)Math.round(legendSpace));
                        this.SubChZero.L2.reduceLegendElements();
                        break;
                    }
                    case 4: {
                        if (this.Ch.vertical && !AxisCore.super.isBorderBottomSet()) {
                            this.deriveBorderBottomXL(g2, false);
                        }
                        int topSpace = 0;
                        if (super.getTitle().getText() != "") {
                            super.getTitle().setFontMetrics(g2);
                            topSpace = super.getTitle().getHeight() + this.Ch.border_top_extra;
                        }
                        if (super.getSubtitle().getText() != "") {
                            super.getSubtitle().setFontMetrics(g2);
                            topSpace += super.getSubtitle().getHeight();
                        }
                        double availableSpace = this.Ch.displayHeight - this.Ch.border_bottom - topSpace;
                        legendSpace = availableSpace * this.SubChZero.L2.getLegendDesc().getLegendMaxHeightFraction();
                        this.SubChZero.L2.setLegendMaxHeight((int)Math.round(legendSpace));
                        this.SubChZero.L2.reduceLegendElements();
                    }
                }
            }
        }
    }

    protected void initHBarLayout(Graphics2D g2) {
        if (!this.Ch.vertical) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
            if (sc.containsPointLabels) {
                int s = 0;
                while (s < sc.plotLineDes.size()) {
                    LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
                    if (line.pointLabelsOn) {
                        sc.HLayout.padCharWidthPointLabels = line.getFontHeight() / 3;
                        break;
                    }
                    ++s;
                }
            } else {
                sc.HLayout.padCharWidthPointLabels = 0;
            }
            this.computeMaxLabelWidthHBar(g2);
            this.assignLabelXSpaceLeftHBar();
            this.setPlotWidthHBar(sc);
        }
    }

    protected void adjustInsideLegendAlignment(Graphics2D g2) throws ChartException {
        int alignment = this.SubChZero.L2.getLegendDesc().getLegendAlignment();
        if (this.SubChZero.L2.getLegendDesc().getLegendInside()) {
            this.SubChZero.L2.resetLegendReduce();
            switch (alignment) {
                case 8: {
                    this.SubChZero.L2.setLegendOffsetXInternal(1);
                    break;
                }
                case 9: {
                    this.SubChZero.L2.setLegendOffsetXInternal(-1);
                    break;
                }
                case 7: {
                    break;
                }
                case 5: {
                    this.SubChZero.L2.setLegendOffsetXInternal(1);
                    break;
                }
                case 3: {
                    this.SubChZero.L2.setLegendOffsetXInternal(1);
                    break;
                }
                case 6: {
                    this.SubChZero.L2.setLegendOffsetXInternal(-1);
                    break;
                }
            }
            double legendSpace = this.SubCh.Displayheight * this.SubChZero.L2.getLegendDesc().getLegendMaxHeightFraction();
            this.SubChZero.L2.setLegendMaxHeight((int)Math.round(legendSpace));
            this.SubChZero.L2.reduceLegendElements();
        }
        this.SubChZero.L2.resetLegendAlignment(g2);
    }

    protected void createSpaceForAnnotations(Graphics2D g2) throws ChartException {
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        if (this.AnnoExist) {
            int extraSpace = 0;
            extraSpace = this.drawAnnotations(g2, sc, false);
            if (extraSpace != 0) {
                this.Ch.border_top_extra = extraSpace;
                this.ScaleAll2(g2);
                this.ScaleAll3(g2);
            }
        }
    }

    protected void drawSubchartSeparator(Graphics2D g2) {
        if (this.Ch.vertical) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
            int k = 1;
            while (k < this.Ch.SC.size()) {
                sc = (SubChartDescription)this.Ch.SC.elementAt(k);
                if (!this.subChartBoundaryColorSet) {
                    g2.setColor(super.getBackground());
                } else {
                    g2.setColor(this.SubChartBoundaryColor);
                }
                int x = sc.XOrigin + this.Ch.border_left;
                int y = this.Ch.border_top + sc.YOrigin - this.Ch.subchartSeparatorHeight;
                int width = (int)sc.displaywidth2 + 1;
                int height = this.Ch.subchartSeparatorHeight;
                boolean descEdgeColor = false;
                if (this.subChartSeparatorStyleDesc == null) {
                    g2.fillRect(x, y, width, height);
                } else {
                    if (this.subChartSeparatorStyleDesc.getBackgroundColor() != null) {
                        g2.setColor(this.subChartSeparatorStyleDesc.getBackgroundColor());
                    }
                    if (this.subChartSeparatorStyleDesc.getBackgroundFillMode() == 1) {
                        g2.fillRect(x - 1, y, width + 2, height);
                    } else {
                        g2.fillRect(x, y, width, height);
                    }
                    if (this.subChartSeparatorStyleDesc.getEdgeColor() != null) {
                        descEdgeColor = true;
                    }
                }
                if (this.subChartBoundaryEdgeColorSet) {
                    g2.setColor(this.SubChartBoundaryEdgeColor);
                }
                if (descEdgeColor) {
                    g2.setColor(this.subChartSeparatorStyleDesc.getEdgeColor());
                }
                if (this.subChartBoundaryEdgeColorSet || descEdgeColor) {
                    g2.drawLine(x, y - 1, x + width, y - 1);
                    g2.drawLine(x, y + height, x + width, y + height);
                }
                ++k;
            }
        }
    }

    protected void drawHorizontalGridLines(Graphics2D g2, boolean vertical) {
        SubChartDescription sc;
        if (vertical) {
            boolean firstSubChart = true;
            boolean lastSubChart = false;
            if (this.PlotEdgeColor == this.getBackground()) {
                firstSubChart = false;
            }
            int k = 0;
            while (k < this.Ch.SC.size()) {
                if (k > 0) {
                    firstSubChart = false;
                }
                if (k == this.Ch.SC.size() - 1) {
                    lastSubChart = true;
                }
                sc = (SubChartDescription)this.Ch.SC.elementAt(k);
                sc.YAxis1.yg.drawBuffer(g2, this.svgChartGraphics, this.Ch.border_left + sc.XOrigin, (int)sc.displaywidth2, this.Ch.border_top + sc.YOrigin, (int)sc.Displayheight, sc.YAxis1.StretchY.vgrid_y, sc.YAxis1.StretchY.vgrid_y_raster, this.DefaultStroke, this.DashedStroke, this.DashedStroke2, firstSubChart, lastSubChart);
                ++k;
            }
        } else {
            sc = (SubChartDescription)this.Ch.SC.elementAt(0);
            sc.YAxis1.yg.drawBufferHorizontal(g2, this.svgChartGraphics, this.Ch.border_top, (int)sc.Displayheight, sc.YAxis1.StretchY.vgrid_y, sc.YAxis1.StretchY.vgrid_y_raster, this.DefaultStroke, this.DashedStroke);
        }
        if (this.Ch.continuousNumXAxis) {
            sc = (SubChartDescription)this.Ch.SC.elementAt(0);
            this.Ch.NumXAxis.yg.drawBufferHorizontal(g2, this.svgChartGraphics, this.Ch.border_top, (int)sc.Displayheight, this.Ch.NumXAxis.StretchY.vgrid_y, this.Ch.NumXAxis.StretchY.vgrid_y_raster, this.DefaultStroke, this.DashedStroke);
        }
    }

    protected void initChartLayoutAttributes() {
        this.SubChZero.L2.setLegendEnableInternal();
        this.Ch.border_top_extra = 0;
        this.Ch.southLegendRows = 0;
        this.Ch.containsMultiplePosNegHBars = false;
    }

    protected void initXL() {
        this.xl.initChDesc(this.Ch);
        this.xl.initxval_int(this.xval_int);
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        this.xl.init_x_coordinate_spread(sc.x_coordinate_spread);
        this.xl.init_sc_widthheight(sc.xAxisWidth, sc.Displayheight);
        this.xl.init_FreqDim(this.FreqDim);
        this.xl.init_Cal(this.C);
    }

    protected void checkDrawBufferErrors(Graphics2D g2, String fcn) throws ChartException {
        if (g2 == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-105"));
        }
        if (this.getHeight() == 0 || this.getWidth() == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-104"));
            return;
        }
        if (!(this.Ch.containsTStamps || this.Ch.containsXLabels || this.Ch.continuousNumXAxis)) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-142"));
        }
    }

    public void drawBuffer(Graphics2D g2) throws ChartException {
        boolean debug = false;
        String fcn = "drawBuffer()";
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.setGraphicsBuffer(g2);
            g2 = this.svgChartGraphics;
        }
        this.initChartLayoutAttributes();
        this.SubChZero.L2.resetLegendAlignment(g2);
        this.checkDrawBufferErrors(g2, fcn);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.clearSVG();
        }
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        if (sc.plotLineDes.size() <= 0) {
            System.out.println("no y values!");
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-143"));
        }
        this.DrawBufferCalled = false;
        boolean test = false;
        this.allocNaNTimebands();
        this.getFMetrics(g2);
        if (this.Ch.seriesColors != null && this.Ch.seriesColors.length > 0) {
            this.assignSeriesColorPalette();
        }
        this.determineDrawOutsideLegend();
        this.setDefaultDescriptors();
        RenderingHints RHOriginal = null;
        if (this.isSetRenderingHintsChart()) {
            g2.setRenderingHints(super.getRenderingHintsChart());
        } else {
            RHOriginal = g2.getRenderingHints();
        }
        this.ComputeSpreads();
        this.initHBarLayout(g2);
        this.checkExtents(g2);
        this.ScaleAll1(g2);
        this.estimateLeftBorder(g2);
        this.initXL();
        this.generateXAxisLabels(g2);
        this.alignLegendFootnote(g2);
        this.legendHeuristics(g2);
        this.ScaleAll2(g2);
        this.ScaleAll3(g2);
        this.createSpaceForAnnotations(g2);
        if (this.svgChartGraphics.getEnableSVG() && this.svgChartGraphics.getInteractiveSVG()) {
            this.svgChartGraphics.startGroup("cb_chart");
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_background");
        }
        this.drawChartBackground(g2, false, false);
        this.adjustInsideLegendAlignment(g2);
        this.drawHorizontalGridLines(g2, this.Ch.vertical);
        if (this.Ch.vertical && this.Ch.TStampsCount != 0) {
            this.xl.drawBuffer(g2, this.svgChartGraphics, false, this.UserXGrid, this.DefaultStroke, this.DashedStroke, this.DashedStroke2);
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
        if (this.svgChartGraphics.getEnableSVG() && this.svgChartGraphics.getInteractiveSVG()) {
            this.svgChartGraphics.endGroup();
        }
        int maxLines = 0;
        maxLines = this.drawChartGraphics(g2, RHOriginal);
        this.drawInteriorLegend(g2, maxLines);
        g2.setStroke(this.DefaultStroke);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_frameoutline");
        }
        this.drawOutsideFrame(g2);
        if (this.xl.timeBandDesc.getRenderInForeground()) {
            this.renderTimeBands(g2);
        }
        this.renderTimeBandSides(g2);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_plotoutline");
        }
        this.drawPlotOutline(g2);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
        this.drawAxisLines(g2);
        this.drawSubchartSeparator(g2);
        g2.setColor(this.foreground);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_titles");
        }
        this.drawTitlesAndFootnotes(g2);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
        if (this.Ch.vertical && this.Ch.continuousNumXAxis) {
            this.drawNumXAxisLabels(g2);
        }
        this.drawXAxisLabels(g2, sc.x_coordinate_spread, (int)sc.xAxisWidth);
        if (this.Ch.vertical) {
            this.drawYAxisLabels(g2);
        } else {
            this.drawYAxisLabelsHorizontal(g2);
        }
        this.drawAxisTitles(g2);
        int extraSpace = this.drawAnnotations(g2, sc, true);
        this.drawPopups(g2);
        if (this.DrawOutsideLegend) {
            int k = 0;
            while (k < this.Ch.SC.size()) {
                sc = (SubChartDescription)this.Ch.SC.elementAt(k);
                if (!this.Ch.perSubchartLegend && k > 0) break;
                if (!sc.L2.getLegendDesc().getLegendDisable() && !sc.L2.getLegendDisableInternal()) {
                    sc.L2.drawLegendBuffer(g2, this.svgChartGraphics, this.Ch.genImageMapCoords);
                    if (this.testPerSubchart) {
                        switch (sc.L2.getLegendDesc().getLegendAlignment()) {
                            case 3: {
                                System.out.println("EAST");
                                break;
                            }
                            case 11: {
                                System.out.println("EASTPERSUBCHART");
                                break;
                            }
                            case 10: {
                                System.out.println("EASTBASELINE");
                                break;
                            }
                            case -1: {
                                System.out.println("DERIVED");
                                break;
                            }
                            default: {
                                System.out.println("DEFAULT");
                            }
                        }
                        this.printSub(sc);
                    }
                }
                ++k;
            }
        }
        if ((this.Ch.TStampsCount != 0 || this.Ch.continuousTimeXAxis) && this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.drawRectInvisible("timeaxisdimensions", 0, 0, this.TimeAxisCont.xAxisStartMillis, this.TimeAxisCont.xAxisEndMillis);
        }
    }

    public void drawPlotWindow(Graphics2D g2) throws ChartException {
        int maxLines = this.drawChartGraphics(g2, g2.getRenderingHints());
        this.drawInteriorLegend(g2, maxLines);
    }

    protected void drawXAxisLabels(Graphics2D g2, double x_coordinate_spread, int plotWidth) {
        if (!this.xl.timeAxisD.getDrawLabel()) {
            return;
        }
        if (this.Ch.vertical) {
            if (this.svgChartGraphics.getEnableSVG()) {
                this.svgChartGraphics.startGroup("cb_xaxis");
            }
            if (this.Ch.TStampsCount != 0) {
                this.xl.drawBuffer(g2, this.svgChartGraphics, true, this.UserXGrid, this.DefaultStroke, this.DashedStroke, this.DashedStroke2);
            } else if (this.Ch.labelXCount != 0) {
                StringLabel.paintXStringLabels(g2, this.svgChartGraphics, this.Ch, plotWidth, this.xval_int, this.sl.fontmet, this.sl.stringAxisD, x_coordinate_spread);
            }
            if (this.svgChartGraphics.getEnableSVG()) {
                this.svgChartGraphics.endGroup();
            }
        }
    }

    protected void drawPlotOutline(Graphics2D g2) {
        g2.setColor(super.getEdgeColor());
        if (super.getEdgeColor() != this.getBackground()) {
            int w = this.Ch.displayWidth - 1;
            int h = this.Ch.displayHeight - 1;
            g2.drawLine(0, 0, 0, h);
            g2.drawLine(0, 0, w, 0);
            g2.drawLine(0, h, w, h);
            g2.drawLine(w, 0, w, h);
        }
    }

    protected void drawAxisTitles(Graphics2D g2) {
        int x;
        int y;
        int titleWidth;
        g2.setColor(Color.black);
        if (this.AxisT.titleDescX.getTitle() != "") {
            titleWidth = this.AxisT.XAxisTitleFontmet.stringWidth(this.AxisT.titleDescX.getTitle());
            int legendWidth = 0;
            if (!this.SubChZero.L2.getLegendDesc().getLegendInside()) {
                int alignment = this.SubChZero.L2.getLegendDesc().getLegendAlignment();
                switch (alignment) {
                    case 3: 
                    case 10: 
                    case 11: {
                        legendWidth = this.SubChZero.L2.getLegendWidth(g2);
                    }
                }
            }
            y = this.Ch.displayHeight - this.Ch.border_bottom + this.AxisT.yOffset + this.AxisT.XAxisTitleFontmet.getHeight();
            x = this.Ch.border_left + (this.Ch.displayWidth - this.Ch.border_left - legendWidth - titleWidth) / 2;
            g2.setColor(this.AxisT.titleDescX.getColor());
            g2.setFont(this.AxisT.titleDescX.getFont());
            g2.drawString(this.AxisT.titleDescX.getTitle(), x, y);
        }
        if (this.AxisT.titleDescY.getTitle() != "") {
            int plotHeight;
            titleWidth = this.AxisT.YAxisTitleFontmet.stringWidth(this.AxisT.titleDescY.getTitle());
            y = titleWidth < (plotHeight = this.Ch.displayHeight - this.Ch.border_bottom - this.Ch.border_top) ? this.Ch.displayHeight - this.Ch.border_bottom - (plotHeight - titleWidth) / 2 : (titleWidth < this.Ch.displayHeight ? this.Ch.displayHeight - (this.Ch.displayHeight - titleWidth) / 2 : this.Ch.displayHeight);
            x = this.AxisT.YAxisTitleFontmet.getHeight();
            AffineTransform oldTransform = g2.getTransform();
            g2.transform(AffineTransform.getRotateInstance(-1.5707963267948966, x, y));
            RenderingHints RHOriginal = g2.getRenderingHints();
            g2.setRenderingHints(this.RHLine);
            g2.setColor(this.AxisT.titleDescY.getColor());
            g2.setFont(this.AxisT.titleDescY.getFont());
            g2.drawString(this.AxisT.titleDescY.getTitle(), x, y);
            g2.setRenderingHints(RHOriginal);
            g2.setTransform(oldTransform);
        }
    }

    protected void drawTitlesAndFootnotes(Graphics2D g2) {
        super.getTitle().drawBuffer(g2);
        super.getSubtitle().drawBuffer(g2);
        super.getFootnote().drawBuffer(g2);
    }

    protected void drawInteriorLegend(Graphics2D g2, int maxLines) {
        if (this.SubChZero.L2.getLegendDesc().getLegendInside() && (maxLines >= 2 || this.SubChZero.L2.getLegendDesc().getLegendDisplaySingleSeries()) && !this.SubChZero.L2.getLegendDesc().getLegendDisable() && !this.SubChZero.L2.getLegendDisableInternal()) {
            this.SubChZero.L2.drawLegendBuffer(g2, this.svgChartGraphics, this.Ch.genImageMapCoords);
        }
    }

    protected int drawChartGraphics(Graphics2D g2, RenderingHints RHOriginal) throws ChartException {
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_coords");
            this.svgChartGraphics.setSliderPosition(this.Ch.border_left, this.Ch.displayHeight - this.Ch.border_bottom, this.Ch.displayWidth - this.Ch.border_left - this.Ch.border_right);
        }
        int maxLines = 0;
        int k = 0;
        while (k < this.Ch.SC.size()) {
            block90: {
                boolean shadowOnly;
                int i;
                int delta;
                LineDescription[] stackedBarLineArray;
                LineDescription line;
                SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(k);
                if (sc.emptyYSeries) break block90;
                int numBars = 0;
                int numBarsStacked = 0;
                int numAreaCumulative = 0;
                int s = 0;
                while (s < sc.plotLineDes.size()) {
                    line = (LineDescription)sc.plotLineDes.elementAt(s);
                    switch (line.lineType) {
                        case 4: {
                            ++numBars;
                            break;
                        }
                        case 5: {
                            ++numBarsStacked;
                            break;
                        }
                        case 3: {
                            ++numAreaCumulative;
                        }
                    }
                    ++s;
                }
                if (numBarsStacked > 1) {
                    stackedBarLineArray = this.getStackedBars(sc, 5, true);
                    if (!this.Ch.continuousXAxis()) {
                        this.PlotStackedBAR(g2, sc, this.xval_int, stackedBarLineArray, 0, 0);
                    } else {
                        this.PlotStackedBARContinuous(g2, sc, stackedBarLineArray, 0, 0);
                    }
                }
                if (numAreaCumulative > 1) {
                    stackedBarLineArray = this.getStackedBars(sc, 3, true);
                    if (!this.Ch.continuousXAxis()) {
                        if (stackedBarLineArray[0].subFrequency) {
                            this.plotAreaCume(g2, sc, stackedBarLineArray[0].xval_int, stackedBarLineArray[0].xval_dbl, stackedBarLineArray);
                        } else {
                            this.plotAreaCume(g2, sc, this.xval_int, this.xval_dbl, stackedBarLineArray);
                        }
                    } else {
                        this.plotAreaCumeContinuous(g2, sc, stackedBarLineArray);
                    }
                }
                int BarIndex = 0;
                int LineIndex = 0;
                if (sc.plotLineDes.size() > maxLines) {
                    maxLines = sc.plotLineDes.size();
                }
                boolean line_rendering_hints_mode = false;
                s = 0;
                while (s < sc.plotLineDes.size()) {
                    block92: {
                        block91: {
                            line = (LineDescription)sc.plotLineDes.elementAt(s);
                            if (line.lineType != 5 && line.lineType != 3 && this.svgChartGraphics.getEnableSVG()) {
                                this.svgChartGraphics.startGroup("cb_series_" + line.seriesName);
                            }
                            g2.setColor(line.color);
                            delta = line.startDateIndex;
                            if (delta != 0) {
                                i = 0;
                                while (i < line.num_points) {
                                    this.xval_int_temp[i] = this.xval_int[i + delta];
                                    this.xval_dbl_temp[i] = this.xval_dbl[i + delta];
                                    ++i;
                                }
                            }
                            if (line.subFrequency) {
                                i = 0;
                                while (i < line.num_points) {
                                    this.xval_int_temp[i] = line.xval_int[i];
                                    this.xval_dbl_temp[i] = line.xval_dbl[i];
                                    ++i;
                                }
                            }
                            if (!this.Ch.vertical) break block91;
                            switch (line.lineType) {
                                case 4: 
                                case 5: 
                                case 7: 
                                case 8: 
                                case 9: {
                                    if (line_rendering_hints_mode) {
                                        if (this.isSetRenderingHintsChart()) {
                                            g2.setRenderingHints(super.getRenderingHintsChart());
                                        } else {
                                            g2.setRenderingHints(RHOriginal);
                                        }
                                    }
                                    line_rendering_hints_mode = false;
                                    break;
                                }
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: {
                                    if (line_rendering_hints_mode) break;
                                    line_rendering_hints_mode = true;
                                    g2.setRenderingHints(this.RHLine);
                                }
                            }
                            g2.setStroke(this.DefaultStroke);
                            switch (line.lineType) {
                                case 7: {
                                    if (!this.Ch.continuousXAxis()) {
                                        if (delta == 0 && !line.subFrequency) {
                                            this.PlotHILOCLOSE(g2, sc, this.xval_int, line.yhigh_int, line.ylow_int, line.yclose_int, line);
                                            break;
                                        }
                                        this.PlotHILOCLOSE(g2, sc, this.xval_int_temp, line.yhigh_int, line.ylow_int, line.yclose_int, line);
                                        break;
                                    }
                                    this.PlotHILOCLOSE(g2, sc, line.xval_cont_int, line.yhigh_int, line.ylow_int, line.yclose_int, line);
                                    break;
                                }
                                case 8: {
                                    if (!this.Ch.continuousXAxis()) {
                                        if (delta == 0 && !line.subFrequency) {
                                            this.PlotOPENHILOCLOSE(g2, sc, this.xval_int, line.yopen_int, line.yhigh_int, line.ylow_int, line.yclose_int, line);
                                            break;
                                        }
                                        this.PlotOPENHILOCLOSE(g2, sc, this.xval_int_temp, line.yopen_int, line.yhigh_int, line.ylow_int, line.yclose_int, line);
                                        break;
                                    }
                                    this.PlotOPENHILOCLOSE(g2, sc, line.xval_cont_int, line.yopen_int, line.yhigh_int, line.ylow_int, line.yclose_int, line);
                                    break;
                                }
                                case 9: {
                                    if (!this.Ch.continuousXAxis()) {
                                        if (delta == 0 && !line.subFrequency) {
                                            this.PlotCandleStick(g2, sc, this.xval_int, line.yopen_int, line.yhigh_int, line.ylow_int, line.yclose_int, line);
                                            break;
                                        }
                                        this.PlotCandleStick(g2, sc, this.xval_int_temp, line.yopen_int, line.yhigh_int, line.ylow_int, line.yclose_int, line);
                                        break;
                                    }
                                    this.PlotCandleStick(g2, sc, line.xval_cont_int, line.yopen_int, line.yhigh_int, line.ylow_int, line.yclose_int, line);
                                    break;
                                }
                                case 0: 
                                case 1: {
                                    if (!this.Ch.continuousXAxis()) {
                                        if (delta == 0 && !line.subFrequency) {
                                            this.PlotLine(g2, sc, this.xval_int, this.xval_dbl, line, LineIndex, numBars);
                                        } else {
                                            this.PlotLine(g2, sc, this.xval_int_temp, this.xval_dbl_temp, line, LineIndex, numBars);
                                        }
                                    } else {
                                        this.PlotLine(g2, sc, line.xval_cont_int, line.xval_cont_dbl, line, LineIndex, numBars);
                                    }
                                    ++LineIndex;
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    if (line.lineType != 3 || numAreaCumulative <= 1) {
                                        g2.setColor(line.color2);
                                        if (!this.Ch.continuousXAxis()) {
                                            if (delta == 0 && !line.subFrequency) {
                                                this.plotArea(g2, sc, line, this.xval_int, line.yval_int, line.num_points, line.alphaArea);
                                                break;
                                            }
                                            this.plotArea(g2, sc, line, this.xval_int_temp, line.yval_int, line.num_points, line.alphaArea);
                                            break;
                                        }
                                        this.plotArea(g2, sc, line, line.xval_cont_int, line.yval_int, line.num_points, line.alphaArea);
                                        break;
                                    }
                                    break block92;
                                }
                                case 4: {
                                    if (!this.Ch.continuousXAxis()) {
                                        if (delta == 0 && !line.subFrequency) {
                                            this.PlotBar(g2, sc, this.xval_int, this.xval_dbl, line, BarIndex, numBars);
                                        } else {
                                            this.PlotBar(g2, sc, this.xval_int_temp, this.xval_dbl_temp, line, BarIndex, numBars);
                                        }
                                    } else {
                                        this.PlotBar(g2, sc, line.xval_cont_int, line.xval_cont_dbl, line, BarIndex, numBars);
                                    }
                                    ++BarIndex;
                                    break;
                                }
                                case 5: {
                                    if (numBarsStacked <= 1) {
                                        if (!this.Ch.continuousXAxis()) {
                                            if (delta == 0 && !line.subFrequency) {
                                                this.PlotBar(g2, sc, this.xval_int, this.xval_dbl, line, BarIndex, 0);
                                                break;
                                            }
                                            this.PlotBar(g2, sc, this.xval_int_temp, this.xval_dbl_temp, line, BarIndex, 0);
                                            break;
                                        }
                                        this.PlotBar(g2, sc, line.xval_cont_int, line.xval_cont_dbl, line, BarIndex, numBars);
                                        break;
                                    }
                                    break block92;
                                }
                                default: {
                                    System.out.println(" Chart Error: lineType invalid " + line.lineType);
                                    break;
                                }
                            }
                            break block92;
                        }
                        shadowOnly = true;
                        switch (line.lineType) {
                            case 4: 
                            case 5: {
                                if (numBarsStacked > 1) break;
                                if (line.barStyle == 1) {
                                    if (delta == 0 && !line.subFrequency) {
                                        this.PlotBarHorizontal(g2, sc, this.xval_int, line, BarIndex, numBars, shadowOnly);
                                    } else {
                                        this.PlotBarHorizontal(g2, sc, this.xval_int_temp, line, BarIndex, numBars, shadowOnly);
                                    }
                                }
                                ++BarIndex;
                            }
                        }
                    }
                    if (line.lineType != 5 && line.lineType != 3 && this.svgChartGraphics.getEnableSVG()) {
                        this.svgChartGraphics.endGroup();
                    }
                    ++s;
                }
                BarIndex = 0;
                s = 0;
                while (s < sc.plotLineDes.size()) {
                    line = (LineDescription)sc.plotLineDes.elementAt(s);
                    delta = line.startDateIndex;
                    if (delta != 0) {
                        i = 0;
                        while (i < line.num_points) {
                            this.xval_int_temp[i] = this.xval_int[i + delta];
                            ++i;
                        }
                    }
                    if (line.subFrequency) {
                        i = 0;
                        while (i < line.num_points) {
                            this.xval_int_temp[i] = line.xval_int[i];
                            ++i;
                        }
                    }
                    if (this.Ch.vertical) {
                        if (line.lineType == 2 || line.lineType == 3 && numAreaCumulative == 1) {
                            if (!line_rendering_hints_mode) {
                                line_rendering_hints_mode = true;
                                g2.setRenderingHints(this.RHLine);
                            }
                            g2.setColor(line.color);
                            g2.setStroke(this.DefaultStroke);
                            switch (line.lineType) {
                                case 2: 
                                case 3: {
                                    g2.setColor(line.color);
                                    if (!this.Ch.continuousXAxis()) {
                                        if (delta == 0 && !line.subFrequency) {
                                            this.PlotLine(g2, sc, this.xval_int, this.xval_dbl, line, LineIndex, numBars);
                                            break;
                                        }
                                        this.PlotLine(g2, sc, this.xval_int_temp, this.xval_dbl_temp, line, LineIndex, numBars);
                                        break;
                                    }
                                    this.PlotLine(g2, sc, line.xval_cont_int, line.xval_cont_dbl, line, LineIndex, numBars);
                                    break;
                                }
                                default: {
                                    System.out.println(" Chart Error: lineType invalid " + line.lineType);
                                    break;
                                }
                            }
                        }
                    } else {
                        shadowOnly = false;
                        switch (line.lineType) {
                            case 4: 
                            case 5: {
                                if (numBarsStacked > 1) break;
                                if (delta == 0 && !line.subFrequency) {
                                    this.PlotBarHorizontal(g2, sc, this.xval_int, line, BarIndex, numBars, shadowOnly);
                                } else {
                                    this.PlotBarHorizontal(g2, sc, this.xval_int_temp, line, BarIndex, numBars, shadowOnly);
                                }
                                ++BarIndex;
                            }
                        }
                    }
                    ++s;
                }
                if (line_rendering_hints_mode) {
                    if (this.isSetRenderingHintsChart()) {
                        g2.setRenderingHints(super.getRenderingHintsChart());
                    } else {
                        g2.setRenderingHints(RHOriginal);
                    }
                }
                if (this.Ch.genImageMapCoords) {
                    this.processAreaImap(sc);
                }
            }
            ++k;
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
        return maxLines;
    }

    protected void drawYAxisLabels(Graphics2D g2) {
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_yaxis");
        }
        int max_string_width_left = this.getMaxStringWidth(true);
        int max_string_width_right = this.getMaxStringWidth(false);
        int k = 0;
        while (k < this.Ch.SC.size()) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(k);
            if (sc.YAxis1.yl.numAxisD.getLabelLocation() == 2 || sc.YAxis1.yl.numAxisD.getLabelLocation() == 0) {
                sc.YAxis1.yl.drawBuffer(g2, this.svgChartGraphics, this.Ch, this.AxisT, sc.XOrigin, sc.YAxis1.StretchY.vgrid_y_raster, sc.YAxis1.StretchY.vgrid_yString, max_string_width_left);
            }
            if (sc.YAxis1.yl.numAxisD.getLabelLocation() == 2 || sc.YAxis1.yl.numAxisD.getLabelLocation() == 1) {
                sc.YAxis1.yl.drawBuffer(g2, this.svgChartGraphics, this.Ch, this.AxisT, sc.XOrigin, sc.YAxis1.StretchY.vgrid_y_raster, sc.YAxis1.StretchY.vgrid_yString, max_string_width_right);
            }
            if (sc.dualAxis) {
                if (sc.YAxis2.yl.numAxisD.getLabelLocation() == 2 || sc.YAxis2.yl.numAxisD.getLabelLocation() == 0) {
                    sc.YAxis2.yl.drawBuffer(g2, this.svgChartGraphics, this.Ch, this.AxisT, sc.XOrigin, sc.YAxis2.StretchY.vgrid_y_raster, sc.YAxis2.StretchY.vgrid_yString, max_string_width_left);
                }
                if (sc.YAxis2.yl.numAxisD.getLabelLocation() == 2 || sc.YAxis2.yl.numAxisD.getLabelLocation() == 1) {
                    sc.YAxis2.yl.drawBuffer(g2, this.svgChartGraphics, this.Ch, this.AxisT, sc.XOrigin, sc.YAxis2.StretchY.vgrid_y_raster, sc.YAxis2.StretchY.vgrid_yString, max_string_width_right);
                }
            }
            ++k;
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
    }

    protected void drawNumXAxisLabels(Graphics2D g2) {
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_xlabels");
        }
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        this.Ch.NumXAxis.yl.drawBufferHorizontal(g2, this.svgChartGraphics, this.Ch, this.getYBaselineInt(sc), this.Ch.NumXAxis.StretchY.vgrid_y, this.Ch.NumXAxis.StretchY.vgrid_y_raster, this.Ch.NumXAxis.StretchY.vgrid_yString);
        if (this.PlotEdgeColor == Color.black || this.Ch.NumXAxis.yg.gridD.getColor() == this.PlotEdgeColor) {
            this.drawChartBackground(g2, false, true);
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
    }

    protected void drawYAxisLabelsHorizontal(Graphics2D g2) {
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_yaxis");
        }
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        sc.YAxis1.yl.drawBufferHorizontal(g2, this.svgChartGraphics, this.Ch, this.getYBaselineInt(sc), sc.YAxis1.StretchY.vgrid_y, sc.YAxis1.StretchY.vgrid_y_raster, sc.YAxis1.StretchY.vgrid_yString);
        if (this.PlotEdgeColor == Color.black || sc.YAxis1.yg.gridD.getColor() == this.PlotEdgeColor) {
            this.drawChartBackground(g2, false, true);
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
    }

    protected void drawPopups(Graphics2D g2) {
        int k = 0;
        while (k < this.Ch.SC.size()) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(k);
            int s = 0;
            while (s < sc.plotLineDes.size()) {
                LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
                if (line.popupIndex != -1) {
                    this.PopDat.paint(g2);
                }
                ++s;
            }
            ++k;
        }
    }

    protected void drawOutsideFrame(Graphics2D g2) {
        if (this.Ch.vertical) {
            int frameInner = 0;
            int frameOuter = 0;
            int frameOuter2 = frameOuter * 2;
            int chartLocationX = 0;
            int chartLocationY = 0;
            int rectX = chartLocationX + frameOuter;
            int rectY = chartLocationY + frameOuter;
            int rectWidth = this.Ch.displayWidth - frameOuter2;
            int rectHeight = this.Ch.displayHeight - frameOuter2;
            g2.setColor(super.getBackground());
            g2.fillRect(rectX, this.Ch.displayHeight - this.Ch.border_bottom + frameInner, rectWidth, this.Ch.border_bottom - frameOuter2);
            g2.fillRect(rectX, rectY, rectWidth, this.Ch.border_top - frameOuter);
            g2.fillRect(rectX, rectY, this.Ch.border_left - frameOuter2 + 1, rectHeight);
            g2.fillRect(this.Ch.displayWidth - this.Ch.border_right + frameInner, rectY, this.Ch.border_right - frameOuter2, rectHeight);
        }
    }

    protected void determineDrawOutsideLegend() {
        if (this.SubChZero.L2.getLegendDesc().getLegendInside()) {
            return;
        }
        if (this.SubChZero.L2.getLegendDesc().getLegendDisable()) {
            return;
        }
        int totalLines = 0;
        int k = 0;
        while (k < this.Ch.SC.size()) {
            this.SubCh = (SubChartDescription)this.Ch.SC.elementAt(k);
            totalLines += this.SubCh.plotLineDes.size();
            ++k;
        }
        if (totalLines > 1 || this.SubChZero.L2.getLegendDesc().getLegendDisplaySingleSeries()) {
            this.DrawOutsideLegend = true;
        }
    }

    protected LineDescription[] getStackedBars(SubChartDescription sc, int chartType, boolean errorcheck) throws ChartException {
        LineDescription line;
        int s;
        String fcn = "drawBuffer()";
        int numBarsStacked = 0;
        int numBarsStackedSubFreq = 0;
        if (this.reverseStackOrder) {
            s = 0;
            while (s < sc.plotLineDes.size()) {
                line = (LineDescription)sc.plotLineDes.elementAt(s);
                if (line.lineType == chartType) {
                    ++numBarsStacked;
                    if (errorcheck && chartType == 3 && line.subFrequency) {
                        ++numBarsStackedSubFreq;
                    }
                }
                ++s;
            }
        } else {
            s = sc.plotLineDes.size() - 1;
            while (s >= 0) {
                line = (LineDescription)sc.plotLineDes.elementAt(s);
                if (line.lineType == chartType) {
                    ++numBarsStacked;
                    if (errorcheck && chartType == 3 && line.subFrequency) {
                        ++numBarsStackedSubFreq;
                    }
                }
                --s;
            }
        }
        LineDescription[] stackedBarLineArray = new LineDescription[numBarsStacked];
        numBarsStacked = 0;
        s = 0;
        while (s < sc.plotLineDes.size()) {
            line = (LineDescription)sc.plotLineDes.elementAt(s);
            if (line.lineType == chartType) {
                stackedBarLineArray[numBarsStacked++] = line;
            }
            ++s;
        }
        if (errorcheck && chartType == 3 && numBarsStackedSubFreq > 0) {
            if (numBarsStackedSubFreq != numBarsStacked) {
                Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-260"));
            } else if (numBarsStackedSubFreq > 1) {
                int tsLength = stackedBarLineArray[0].timestampIndex.length;
                s = 1;
                while (s < stackedBarLineArray.length) {
                    if (tsLength != stackedBarLineArray[s].timestampIndex.length) {
                        Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-261"));
                    }
                    ++s;
                }
                int k = 0;
                while (k < stackedBarLineArray[0].timestampIndex.length) {
                    int baseIndex = stackedBarLineArray[0].timestampIndex[k];
                    s = 1;
                    while (s < stackedBarLineArray.length) {
                        int currentIndex = stackedBarLineArray[s].timestampIndex[k];
                        if (currentIndex != baseIndex) {
                            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-262"));
                        }
                        ++s;
                    }
                    ++k;
                }
            }
        }
        return stackedBarLineArray;
    }

    protected void setDefaultDescriptors() {
        if (this.UserTimeBandNeedsToBeCopied) {
            this.copyTimeBandDesc(this.UserTimeBand);
        }
        if (this.UserXGridNeedsToBeCopied) {
            this.copyXGridDesc(this.UserXGrid);
        }
    }

    public void paint(Graphics g) {
        if (this.BI == null || this.SizeChanged) {
            this.SizeChanged = false;
            this.Ch.displayWidth = this.getWidth();
            this.Ch.displayHeight = this.getHeight();
            if (this.Ch.displayWidth == 0 || this.Ch.displayHeight == 0) {
                System.out.println(MsgUtil.getMsg("CHT-104"));
                return;
            }
            this.BI = new BufferedImage(this.Ch.displayWidth, this.Ch.displayHeight, 1);
        }
        Graphics2D g2 = this.BI.createGraphics();
        try {
            this.drawBuffer(g2);
        }
        catch (ChartException e) {
            System.out.println(e.getMessage());
        }
        g.drawImage(this.BI, 0, 0, this);
    }

    private int getIntervals(double availableWidth, int minimumWidth) {
        double numIntervals = (double)minimumWidth / availableWidth;
        int numIntervals_int = (int)numIntervals + 1;
        return numIntervals_int;
    }

    /*
     * Unable to fully structure code
     */
    private void freqDimHeuristics() {
        white_space = 10;
        this.xl.containsDayLabels = false;
        test = false;
        testfreqDim = false;
        if (test) {
            System.out.println(" ");
            System.out.println("freqDimH:  TStampsCount = " + this.Ch.TStampsCount);
            System.out.println("freqDimH: " + this.xl.lastLevelField + ", " + this.xl.firstLevelField);
        }
        Cfirst = Calendar.getInstance();
        Cfirst.setTime(this.Ch.TStamps[0]);
        this.xl.firstLevelField = this.xl.firstLevelField_default;
        freq = this.xl.getTimeSpanFrequency();
        if (freq >= 0) {
            if (!this.minLabelDimensionSet) {
                this.xl.firstLevelField = freq;
            } else if (this.xl.firstLevelField_default < freq && this.xl.firstLevelField_default != -1) {
                this.xl.firstLevelField = freq;
            }
        }
        if (test) {
            System.out.println("Heuristics => " + this.xl.lastLevelField + ", " + this.xl.firstLevelField);
        }
        level = this.xl.lastLevelField = this.xl.lastLevelField_default;
        notFinished = true;
        lev = this.xl.firstLevelField;
        while (lev <= this.xl.lastLevelField) {
            e = (DimensionElement)this.FreqDim.elementAt(lev);
            e.period = 1;
            e.labelOn = true;
            e.chartLocale = this.ChartLocale;
            if (this.isMonths(e.label)) {
                e.label = XLabel.LABEL_MONTH_CHOICE;
                e.setChoiceFieldLabels();
            }
            switch (e.label) {
                case 8: 
                case 81: {
                    e.label = XLabel.LABEL_ANNUAL_CHOICE;
                }
            }
            ++lev;
        }
        if (this.xl.extendedLabels) {
            lev = this.xl.firstLevelField_extended;
            while (lev < this.xl.firstLevelField) {
                e = (DimensionElement)this.FreqDim.elementAt(lev);
                if (e.label == 2) {
                    labelWidth = this.xl.fontmet.stringWidth("12 AM");
                    this.xl.prependHoursToMinutes = true;
                } else if (e.label == 1) {
                    labelWidth = this.xl.fontmet.stringWidth("11:00:00");
                    this.xl.prependHoursMinutesToSeconds = true;
                }
                ++lev;
            }
        }
        testfreqDim = false;
        while (level >= this.xl.firstLevelField && notFinished) {
            block88: {
                block87: {
                    e = (DimensionElement)this.FreqDim.elementAt(level);
                    if (testfreqDim) {
                        System.out.println("** Examine Frequency " + e.name + " " + e.label);
                    }
                    if (testfreqDim) {
                        System.out.println("level is " + level);
                    }
                    labelstring = this.xl.labelToString(level, 1);
                    labelWidth = this.xl.fontmet.stringWidth(labelstring);
                    if (e.label == 6) {
                        if (test) {
                            System.out.println("freqDimHeuristics: months labelWidth " + labelWidth);
                        }
                        labelWidth = this.xl.fontmet.stringWidth(this.xl.longestMonthLabelToString());
                        if (test) {
                            System.out.println("freqDimHeuristics: months labelWidth " + labelWidth);
                        }
                    } else {
                        labelWidth = this.xl.fontmet.stringWidth(labelstring);
                    }
                    if (e.label == 3 || e.label == 1) {
                        if (labelstring.length() == 1) {
                            labelWidth *= 2;
                        }
                        if (test) {
                            System.out.println("freqDimHeuristics: doubled labelWidth " + labelWidth);
                        }
                    }
                    if (e.label == 3) {
                        labelWidth = this.xl.fontmet.stringWidth("12 AM");
                    } else if (e.label == 2) {
                        labelWidth = this.xl.fontmet.stringWidth("12 AM");
                        this.xl.prependHoursToMinutes = true;
                    } else if (e.label == 1) {
                        labelWidth = this.xl.fontmet.stringWidth("11:00:00");
                        this.xl.prependHoursMinutesToSeconds = true;
                    }
                    labelWidthMin = 0;
                    if (this.xl.extendedLabels && labelWidth < (labelWidthMin = this.xl.fontmet.stringWidth("11:00:00"))) {
                        labelWidth = labelWidthMin;
                    }
                    availableWidth = this.xl.estimateWidth(level);
                    availableWidth *= (double)e.period;
                    if ((this.xl.timeAxisD.getDayOfWeek() || this.xl.timeAxisD.getDayOfWeekOnly()) && e.label == 4) {
                        e.setOneCharWeekDays((int)Math.round(availableWidth) - white_space, this.xl.fontmet);
                        this.xl.containsDayLabels = true;
                    }
                    if (testfreqDim) {
                        System.out.println("Available space = " + availableWidth);
                    }
                    if (testfreqDim) {
                        System.out.println("Label Width = " + labelWidth + " min " + labelWidthMin);
                    }
                    if (!(availableWidth < (double)(labelWidth + white_space))) break block87;
                    if (test) {
                        System.out.println("*** Does not fit, Frequency " + e.name + " " + e.label);
                    }
                    if (test) {
                        System.out.println("Available space = " + availableWidth);
                    }
                    if (test) {
                        System.out.println("Label Width = " + labelWidth);
                    }
                    switch (e.label) {
                        case 8: {
                            e.label = 81;
                            ++level;
                            break;
                        }
                        case 81: {
                            if (test) {
                                System.out.println("LABEL_SHORT_ANNUAL");
                            }
                            if (e.period == 1) {
                                numIntervals_int = this.getIntervals(availableWidth, labelWidth + white_space);
                                if (numIntervals_int >= XLabel.relabelYear.length) {
                                    if (test) {
                                        System.out.println("**** numIntervals = " + numIntervals_int);
                                    }
                                    e.labelOn = false;
                                    break;
                                }
                                if (numIntervals_int > this.Ch.TStampsCount) {
                                    if (test) {
                                        System.out.println("**** does not fit");
                                    }
                                    e.labelOn = false;
                                    break;
                                }
                                if (test) {
                                    System.out.println("numIntervals = " + numIntervals_int);
                                }
                                e.period = numIntervals_int > 1 ? XLabel.relabelYear[numIntervals_int] : XLabel.relabelYear[2];
                            } else {
                                e.labelOn = false;
                                notFinished = false;
                                this.xl.firstLevelField = level + 1;
                                break;
                            }
                            ++level;
                            break;
                        }
                        case 6: {
                            e.label = 62;
                            dfs = new DateFormatSymbols(this.ChartLocale);
                            e.fieldLabels = dfs.getShortMonths();
                            ++level;
                            break;
                        }
                        case 62: {
                            e.label = 61;
                            e.setOneCharMonths();
                            ++level;
                            break;
                        }
                        case 61: {
                            e.labelOn = false;
                            notFinished = false;
                            this.xl.firstLevelField = level + 1;
                            break;
                        }
                        case 4: {
                            if (test) {
                                System.out.println("XLabel.LABEL_DAYS: period = " + e.period);
                            }
                            if (e.period == 1) {
                                numIntervals = (double)(labelWidth + white_space) / availableWidth;
                                numIntervals_int = (int)Math.ceil(numIntervals);
                                if (test) {
                                    System.out.println("XLabel.LABEL_DAYS: numIntervals = " + numIntervals_int);
                                }
                                if (numIntervals_int >= XLabel.relabelDays.length) {
                                    e.labelOn = false;
                                    notFinished = false;
                                    this.xl.firstLevelField = level + 1;
                                    break;
                                }
                                e.period = numIntervals_int > 1 ? XLabel.relabelDays[numIntervals_int] : XLabel.relabelDays[2];
                                if (test) {
                                    System.out.println("XLabel.LABEL_DAYS: e.period = " + e.period);
                                }
                                ++level;
                                break;
                            }
                            notFinished = false;
                            break;
                        }
                        case 3: {
                            if (e.period == 1) {
                                numIntervals = (double)(labelWidth + white_space) / availableWidth;
                                numIntervals_int = (int)Math.ceil(numIntervals);
                                if (test) {
                                    System.out.println("XLabel.LABEL_HOURS: numIntervals = " + numIntervals_int);
                                }
                                maxIntervals = numIntervals_int;
                                if (this.Ch.frequency == 10 && this.Ch.units != -1) {
                                    maxIntervals = numIntervals_int *= this.Ch.units;
                                }
                                if (maxIntervals >= XLabel.relabelHours.length) {
                                    e.labelOn = false;
                                    notFinished = false;
                                    this.xl.firstLevelField = level + 1;
                                    break;
                                }
                                e.period = numIntervals_int > 1 ? XLabel.relabelHours[numIntervals_int] : XLabel.relabelHours[2];
                                if (test) {
                                    System.out.println("XLabel.LABEL_HOURS: e.period = " + e.period);
                                }
                                ++level;
                                break;
                            }
                            notFinished = false;
                            break;
                        }
                        case 1: 
                        case 2: {
                            if (e.period != 1) ** GOTO lbl222
                            numIntervals = (double)(labelWidth + white_space) / availableWidth;
                            numIntervals_int = (int)Math.ceil(numIntervals);
                            if (test) {
                                System.out.println("LABEL_MINUTES: numIntervals = " + numIntervals_int);
                            }
                            intervalLength = this.xl.estimateTimestampDifference(level);
                            newperiod = 0;
                            maxIntervals = numIntervals_int;
                            if (this.Ch.units != -1 && e.label == 2 && this.Ch.frequency == 12 || e.label == 1 && this.Ch.frequency == 13) {
                                maxIntervals = numIntervals_int *= this.Ch.units;
                            }
                            if (maxIntervals < XLabel.relabelMinutes.length && intervalLength <= 2) {
                                newperiod = XLabel.relabelMinutes[numIntervals_int];
                            }
                            if (newperiod <= 0) {
                                e.labelOn = false;
                                notFinished = false;
                                this.xl.firstLevelField = level + 1;
                                if (e.label == 2) {
                                    this.xl.prependHoursToMinutes = false;
                                    break;
                                }
                                if (e.label == 1) {
                                    this.xl.prependHoursMinutesToSeconds = false;
                                    break;
                                }
                            } else {
                                e.period = newperiod;
                                if (test) {
                                    System.out.println("LABEL_MINUTES: e.period = " + e.period);
                                }
                                if (e.label == 2) {
                                    this.xl.prependHoursToMinutes = false;
                                } else if (e.label == 1) {
                                    this.xl.prependHoursMinutesToSeconds = false;
                                }
                                ++level;
                                break;
lbl222:
                                // 1 sources

                                e.labelOn = false;
                                notFinished = false;
                                this.xl.firstLevelField = level + 1;
                                if (e.label == 2) {
                                    this.xl.prependHoursToMinutes = false;
                                    break;
                                }
                                if (e.label == 1) {
                                    this.xl.prependHoursMinutesToSeconds = false;
                                    break;
                                }
                            }
                            break block88;
                        }
                        default: {
                            this.xl.firstLevelField = level + 1;
                            if (test) {
                                System.out.println("Highest freq level is " + this.xl.firstLevelField);
                            }
                            notFinished = false;
                            break;
                        }
                    }
                    break block88;
                }
                if (e.period > 1) {
                    this.xl.firstLevelField = level;
                    break;
                }
            }
            --level;
        }
        if (this.xl.firstLevelField >= this.FreqDim.size()) {
            this.xl.firstLevelField = this.FreqDim.size() - 1;
        }
        if (this.xl.extendedLabels) {
            lev = this.xl.firstLevelField_extended;
            while (lev < this.xl.firstLevelField) {
                e = (DimensionElement)this.FreqDim.elementAt(lev);
                if (e.label == 2) {
                    this.xl.prependHoursToMinutes = true;
                } else if (e.label == 1) {
                    this.xl.prependHoursMinutesToSeconds = true;
                }
                ++lev;
            }
        }
    }

    protected void getFMetrics(Graphics2D g2) {
        if (this.fontMetricsGot) {
            return;
        }
        int i = 0;
        while (i < this.Ch.SC.size()) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(i);
            sc.YAxis1.yl.fontmet = g2.getFontMetrics(sc.YAxis1.yl.numAxisD.getFont());
            if (sc.dualAxis) {
                sc.YAxis2.yl.fontmet = g2.getFontMetrics(sc.YAxis2.yl.numAxisD.getFont());
            }
            int s = 0;
            while (s < sc.plotLineDes.size()) {
                LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
                line.fontmet = g2.getFontMetrics(line.pointLabelFont);
                ++s;
            }
            int j = 0;
            while (j < sc.plotNumThresholdDesc.size()) {
                NumThresholdDesc threshold = (NumThresholdDesc)sc.plotNumThresholdDesc.elementAt(j);
                if (threshold.getLabelDesc() != null) {
                    threshold.getLabelDesc().fontmet = g2.getFontMetrics(threshold.getLabelDesc().getFont());
                }
                ++j;
            }
            ++i;
        }
        this.xl.fontmet = g2.getFontMetrics(this.xl.timeAxisD.getFont());
        this.sl.fontmet = g2.getFontMetrics(this.sl.stringAxisD.getFont());
        this.AxisT.XAxisTitleFontmet = g2.getFontMetrics(this.AxisT.titleDescX.getFont());
        this.AxisT.YAxisTitleFontmet = g2.getFontMetrics(this.AxisT.titleDescY.getFont());
        if (this.Ch.continuousNumXAxis) {
            this.Ch.NumXAxis.yl.fontmet = g2.getFontMetrics(this.Ch.NumXAxis.yl.numAxisD.getFont());
        }
        this.fontMetricsGot = true;
    }

    private double getXScaleConstant() {
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        this.IntervalWidth = (int)Math.round(this.getIntervalDC(sc));
        double x_constant = this.Ch.isContinuousBar() ? (double)(this.Ch.border_left + sc.XOrigin) + sc.halfBarPad : (this.Ch.vertical ? (double)(this.Ch.border_left + sc.XOrigin) : (double)(this.Ch.border_top + sc.YOrigin));
        return x_constant;
    }

    private double getXScaleFactor(double x_coordinate_spread) {
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        if (x_coordinate_spread == 0.0) {
            return 0.0;
        }
        double x_scaleFactor = this.Ch.isContinuousBar() ? sc.xAxisWidth / x_coordinate_spread : (this.Ch.vertical ? sc.xAxisWidth / x_coordinate_spread : sc.Displayheight / x_coordinate_spread);
        return x_scaleFactor;
    }

    protected void ScaleXAxisToPlotWindow(double[] x, int numpoints, double x_coordinate_spread) {
        double x_constant = this.getXScaleConstant();
        double x_scale = this.getXScaleFactor(x_coordinate_spread);
        int i = 0;
        while (i < numpoints) {
            double xtemp = x[i] * x_scale;
            this.xval_dbl[i] = xtemp += x_constant;
            this.xval_int[i] = (int)Math.round(xtemp);
            ++i;
        }
    }

    protected void ScaleXAxisContinuousToPlotWindow() {
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        double x_constant = this.getXScaleConstant();
        int i = 0;
        while (i < this.Ch.TStampsCount) {
            double x = this.TimeAxisCont.convertDateToDouble(this.Ch.TStamps[i]);
            double xtemp = x * sc.xAxisWidth;
            this.xval_int[i] = (int)Math.round(xtemp += x_constant);
            this.xval_dbl[i] = xtemp;
            ++i;
        }
    }

    private double getXScaleConstantTimeBand() {
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        double x_constant = this.Ch.isContinuousBar() ? (double)(this.Ch.border_left + sc.XOrigin) + sc.halfBarPad : (double)(this.Ch.border_left + sc.XOrigin);
        return x_constant;
    }

    protected void ScaleXAxisShadeToPlotWindow(Vector v) {
        double xtemp;
        double x;
        if (v == null) {
            return;
        }
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        double x_constant = this.getXScaleConstantTimeBand();
        double width = sc.xAxisWidth;
        if (this.Ch.containsEnabledBarType() && !this.Ch.continuousXAxis()) {
            x_constant += this.getHalfIntervalDC(sc);
            this.IntervalWidth = (int)Math.round(this.getIntervalDC(sc));
            width -= (double)this.IntervalWidth;
        }
        int i = 0;
        while (i < v.size()) {
            x = (Double)v.elementAt(i);
            xtemp = x * width;
            this.AxisTimeBandHolder.AxisTimebands_int[i] = (int)Math.round(xtemp += x_constant);
            ++i;
        }
        if (this.Ch.containsEnabledBarType() && sc.generateNaNTimebands) {
            LineDescription line = (LineDescription)sc.plotLineDes.elementAt(0);
            i = 0;
            while (i < v.size()) {
                x = (Double)v.elementAt(i);
                xtemp = x * width;
                xtemp += x_constant;
                xtemp = i % 2 == 0 ? (xtemp += this.getHalfIntervalDC(sc)) : (xtemp -= this.getHalfIntervalDC(sc));
                this.AxisTimeBandHolder.AxisTimebands_int[i] = (int)Math.round(xtemp);
                ++i;
            }
            if (v.size() > 0) {
                if (line.isFirstTimestampTimebandIndex()) {
                    xtemp = this.Ch.border_left;
                    this.AxisTimeBandHolder.AxisTimebands_int[0] = (int)Math.round(xtemp);
                }
                if (line.isLastTimestampTimebandIndex(this.Ch.TStamps.length - 1)) {
                    xtemp = (double)this.Ch.border_left + sc.displaywidth2;
                    this.AxisTimeBandHolder.AxisTimebands_int[v.size() - 1] = (int)Math.round(xtemp);
                }
            }
        }
    }

    protected int ScaleContinuousXPointToPlotWindow(double x) {
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        double x_constant = this.getXScaleConstant();
        double xtemp = x * sc.xAxisWidth;
        return (int)Math.round(xtemp += x_constant);
    }

    private int ScaleSingleXToPlotWindow(double x, double x_coordinate_spread) {
        double x_constant;
        double x_scale;
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        if (this.Ch.vertical) {
            x_scale = x * sc.xAxisWidth / x_coordinate_spread;
            x_constant = this.Ch.border_left + sc.XOrigin;
        } else {
            x_scale = x * sc.Displayheight / x_coordinate_spread;
            x_constant = this.Ch.border_top + sc.YOrigin;
        }
        return (int)Math.round(x_scale += x_constant);
    }

    private void ScaleXLineToPlotWindow(LineDescription line, double x_coordinate_spread) {
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        double x_constant = this.getXScaleConstant();
        double x_scale = this.getXScaleFactor(x_coordinate_spread);
        int numpoints = line.timestampIndex.length;
        int i = 0;
        while (i < numpoints) {
            double xtemp = (double)line.timestampIndex[i] * x_scale;
            line.xval_int[i] = (int)Math.round(xtemp += x_constant);
            line.xval_dbl[i] = xtemp;
            ++i;
        }
    }

    private void getExtraSpace(double barAdjustFactor) {
        if (this.Ch.isContinuousBar()) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
            double extra_space = (1.0 - barAdjustFactor) * sc.xAxisWidth;
            this.Ch.border_time_extra = (int)Math.round(extra_space);
            int barWidth = (int)Math.round(extra_space);
            sc.xAxisWidth = sc.displaywidth2 - (double)barWidth;
            sc.halfBarPad = barWidth / 2;
        }
    }

    private void ScaleContinuousXAxisToPlotWindow(LineDescription line) {
        int numpoints = line.xval_cont.length;
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        double borders = this.Ch.border_left + sc.XOrigin + this.Ch.border_right;
        int x_const = this.Ch.border_left + sc.XOrigin;
        x_const = (int)((double)x_const + sc.halfBarPad);
        double factor = sc.xAxisWidth;
        int i = 0;
        while (i < numpoints) {
            line.xval_cont_int[i] = x_const + (int)Math.round(line.xval_cont[i] * factor);
            line.xval_cont_dbl[i] = (double)x_const + line.xval_cont[i] * factor;
            ++i;
        }
    }

    protected int getRightMostXDC() {
        return (int)((double)(this.Ch.border_left + this.SubCh.XOrigin) + this.SubCh.Displaywidth);
    }

    protected SubChartDescription getSubchart(int y) {
        int k = 0;
        while (k < this.Ch.SC.size()) {
            this.SubCh = (SubChartDescription)this.Ch.SC.elementAt(k);
            if (y >= this.Ch.border_top + this.SubCh.YOrigin && (double)y <= (double)(this.Ch.border_top + this.SubCh.YOrigin) + this.SubCh.Displayheight) {
                return this.SubCh;
            }
            ++k;
        }
        return null;
    }

    private double getYConstant(double y_scale) {
        double y_constant = this.Ch.continuousNumXAxis ? (double)this.Ch.border_left : (double)(this.Ch.border_left + this.SubCh.HLayout.labelXSpaceLeft) - y_scale * this.SubCh.YAxis1.yAxisMet.Ymin;
        return y_constant;
    }

    private void ScaleYLineToPlotWindow(SubChartDescription sc, LineDescription line, double y_coordinate_spread, double ymax) {
        double y_scale;
        double y_constant;
        if (this.Ch.vertical) {
            if (this.isLogScale(sc)) {
                ymax = MathUtil.log10(ymax);
            }
            y_constant = this.Ch.border_top + sc.YOrigin;
            y_scale = sc.Displayheight / y_coordinate_spread;
        } else {
            y_scale = sc.HLayout.plotWidth / y_coordinate_spread;
            y_constant = this.getYConstant(y_scale);
        }
        switch (line.lineType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                int numpoints = line.yval.length;
                int i = 0;
                while (i < numpoints) {
                    double ytemp;
                    if (this.Ch.vertical) {
                        ytemp = ymax - line.yval[i];
                        if (this.isLogScale(sc)) {
                            ytemp = ymax - MathUtil.log10(line.yval[i]);
                        }
                    } else {
                        ytemp = line.yval[i];
                    }
                    ytemp *= y_scale;
                    line.yval_dbl[i] = ytemp += y_constant;
                    line.yval_int[i] = (int)Math.round(ytemp);
                    ++i;
                }
                break;
            }
            case 8: 
            case 9: {
                int numpoints = line.yhigh.length;
                int i = 0;
                while (i < numpoints) {
                    double ytemp = this.isLogScale(sc) ? MathUtil.log10(ymax) - MathUtil.log10(line.yopen[i]) : ymax - line.yopen[i];
                    ytemp *= y_scale;
                    line.yopen_int[i] = (int)Math.round(ytemp += y_constant);
                    ytemp = this.isLogScale(sc) ? ymax - MathUtil.log10(line.yhigh[i]) : ymax - line.yhigh[i];
                    ytemp *= y_scale;
                    line.yhigh_int[i] = (int)Math.round(ytemp += y_constant);
                    ytemp = this.isLogScale(sc) ? ymax - MathUtil.log10(line.ylow[i]) : ymax - line.ylow[i];
                    ytemp *= y_scale;
                    line.ylow_int[i] = (int)Math.round(ytemp += y_constant);
                    ytemp = this.isLogScale(sc) ? ymax - MathUtil.log10(line.yclose[i]) : ymax - line.yclose[i];
                    ytemp *= y_scale;
                    line.yclose_int[i] = (int)Math.round(ytemp += y_constant);
                    ++i;
                }
                break;
            }
            case 7: {
                int numpoints = line.yhigh.length;
                int i = 0;
                while (i < numpoints) {
                    double ytemp = this.isLogScale(sc) ? ymax - MathUtil.log10(line.yhigh[i]) : ymax - line.yhigh[i];
                    ytemp *= y_scale;
                    line.yhigh_int[i] = (int)Math.round(ytemp += y_constant);
                    ytemp = this.isLogScale(sc) ? ymax - MathUtil.log10(line.ylow[i]) : ymax - line.ylow[i];
                    ytemp *= y_scale;
                    line.ylow_int[i] = (int)Math.round(ytemp += y_constant);
                    ytemp = this.isLogScale(sc) ? ymax - MathUtil.log10(line.yclose[i]) : ymax - line.yclose[i];
                    ytemp *= y_scale;
                    line.yclose_int[i] = (int)Math.round(ytemp += y_constant);
                    ++i;
                }
                break;
            }
        }
    }

    private boolean isLogScale(SubChartDescription sc) {
        return sc.YAxis1.yl.numAxisD.getLogScale();
    }

    private NumAxisDesc getNumAxisD(SubChartDescription sc) {
        return sc.YAxis1.yl.numAxisD;
    }

    private void ScaleYToPlotWindow(SubChartDescription sc, boolean vertical, Vector y, int numpoints, NumAxisRenderer yAxis) {
        double y_scale;
        double y_constant;
        boolean test = false;
        if (test) {
            System.out.println("*** ScaleYToPlotWindow YMin, YMax, spread = " + yAxis.yAxisMet.Ymin + " " + yAxis.yAxisMet.Ymax + " " + yAxis.yAxisMet.y_coordinate_spread);
        }
        double ySpread = yAxis.yAxisMet.getCoordinateSpread(this.isLogScale(sc));
        if (vertical) {
            y_constant = this.Ch.border_top + sc.YOrigin;
            y_scale = sc.Displayheight / ySpread;
        } else {
            y_scale = sc.HLayout.plotWidth / ySpread;
            y_constant = this.getYConstant(y_scale);
        }
        if (vertical) {
            int i = 0;
            while (i < numpoints) {
                double yvalue = (Double)y.elementAt(i);
                yvalue = this.isLogScale(sc) ? MathUtil.log10(yAxis.yAxisMet.Ymax) - MathUtil.log10(yvalue) : yAxis.yAxisMet.Ymax - yvalue;
                yvalue *= y_scale;
                y.setElementAt(new Double(yvalue += y_constant), i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < numpoints) {
                double yvalue = (Double)y.elementAt(i);
                if (this.isLogScale(sc)) {
                    yvalue = MathUtil.log10(yvalue);
                }
                yvalue *= y_scale;
                y.setElementAt(new Double(yvalue += y_constant), i);
                ++i;
            }
        }
    }

    private void ScaleNumXAxisToPlotWindow(SubChartDescription sc, Vector y, int numpoints, NumAxisRenderer yAxis) {
        boolean test = false;
        if (test) {
            System.out.println("*** ScaleYToPlotWindow YMin, YMax, spread = " + yAxis.yAxisMet.Ymin + " " + yAxis.yAxisMet.Ymax + " " + yAxis.yAxisMet.y_coordinate_spread);
        }
        double y_scale = sc.HLayout.plotWidth / yAxis.yAxisMet.y_coordinate_spread;
        double y_constant = this.getYConstant(y_scale);
        int i = 0;
        while (i < numpoints) {
            double yvalue = (Double)y.elementAt(i);
            yvalue -= yAxis.yAxisMet.Ymin;
            yvalue *= y_scale;
            y.setElementAt(new Double(yvalue += y_constant), i);
            ++i;
        }
    }

    protected int ScaleYToPlotWindow(SubChartDescription sc, double y) {
        double y_scale;
        double y_constant;
        double ySpread = sc.YAxis1.yAxisMet.getCoordinateSpread(this.isLogScale(sc));
        if (this.Ch.vertical) {
            y_constant = this.Ch.border_top + sc.YOrigin;
            y_scale = sc.Displayheight / ySpread;
        } else {
            int width = (int)(sc.xAxisWidth - (double)sc.HLayout.labelXSpaceLeft - (double)sc.HLayout.labelXSpaceRight - (double)sc.HLayout.longestPosPointLabelWidth - (double)sc.HLayout.longestNegPointLabelWidth);
            y_scale = sc.HLayout.plotWidth / ySpread;
            y_constant = this.getYConstant(y_scale);
        }
        if (this.Ch.vertical) {
            y = this.isLogScale(sc) ? MathUtil.log10(sc.YAxis1.yAxisMet.Ymax) - MathUtil.log10(y) : sc.YAxis1.yAxisMet.Ymax - y;
        }
        y *= y_scale;
        return (int)Math.round(y += y_constant);
    }

    private void PlotLine(Graphics2D g2, SubChartDescription sc, int[] x, double[] xdbl, LineDescription line, int lineIndex, int numBars) {
        double[] x_temp_dbl;
        int[] x_temp;
        if (this.Ch.disableZeroSeries && line.containsAllZero) {
            return;
        }
        if (line.containsAllNaN) {
            return;
        }
        int numpoints = line.num_points;
        BasicStroke lineStroke = line.lineStroke;
        int markerType = line.markerType;
        double markerScale = line.markerScale;
        g2.setStroke(lineStroke);
        if (this.Ch.useIntervalMethod() && !this.Ch.continuousXAxis()) {
            int j;
            x_temp = new int[numpoints];
            x_temp_dbl = new double[numpoints];
            if (this.AlignClusterBarLineGraph) {
                double adjust_BarWidth = this.BarAdjustSaveForLine[lineIndex];
                adjust_BarWidth += (double)(this.PlotBarWidth / 2);
                j = 0;
                while (j < numpoints) {
                    x_temp[j] = x[j] + (int)Math.round(adjust_BarWidth);
                    x_temp_dbl[j] = xdbl[j] + adjust_BarWidth;
                    ++j;
                }
            } else {
                double x_scale = sc.xAxisWidth / sc.x_coordinate_spread;
                int x_offset = (int)Math.round(x_scale / 2.0);
                j = 0;
                while (j < numpoints) {
                    x_temp[j] = x[j] + x_offset;
                    x_temp_dbl[j] = xdbl[j] + x_scale / 2.0;
                    ++j;
                }
            }
        } else {
            x_temp = x;
            x_temp_dbl = xdbl;
        }
        if (line.lineType != 0) {
            if (this.svgChartGraphics.getEnableSVG() && line.svgSeriesScript != null) {
                RenderingHints newHints = g2.getRenderingHints();
                newHints.put(SVGGraphics.SVG_PRIMITIVE_ID, line.seriesName);
                newHints.put(SVGGraphics.USER_SCRIPT, line.svgSeriesScript);
                g2.setRenderingHints(newHints);
            }
            if (line.containsNaN) {
                this.DrawPolylineSegmented(g2, x_temp, line);
            } else {
                if (this.svgChartGraphics.getEnableSVG() && this.svgChartGraphics.getInteractiveSVG()) {
                    RenderingHints newHints = g2.getRenderingHints();
                    newHints.put(SVGGraphics.XCOORDS, x_temp_dbl);
                    g2.setRenderingHints(newHints);
                    newHints = g2.getRenderingHints();
                    newHints.put(SVGGraphics.YCOORDS, line.yval_dbl);
                    g2.setRenderingHints(newHints);
                }
                g2.drawPolyline(x_temp, line.yval_int, numpoints);
            }
        }
        if (markerType != 0) {
            g2.setStroke(this.LM.getLineMarkerStroke(markerType));
            g2.setColor(line.color3);
            int k = 0;
            while (k < numpoints) {
                this.LM.drawMarker(g2, markerType, markerScale, x_temp[k], line.yval_int[k]);
                ++k;
            }
        }
        if (line.hilightIndex != -1) {
            int hilightMarker = 1;
            if (markerType != 0) {
                hilightMarker = markerType;
            }
            int k = 0;
            while (k < numpoints) {
                if (line.hilightIndex == k) {
                    g2.setColor(line.hilightColor);
                    this.LM.drawMarker(g2, hilightMarker, markerScale, x_temp[k], line.yval_int[k]);
                }
                ++k;
            }
        }
        if (this.Ch.genImageMapCoords) {
            int k = 0;
            while (k < numpoints) {
                if (this.Ch.genImageMapCoords) {
                    this.copyImageMapCirc(line, k, x_temp[k], line.yval_int[k], this.LineDelta);
                }
                ++k;
            }
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.k_invisibleCircleSvgXLink(g2, numpoints, x_temp, line.yval_int, this.LineDelta * 2, line.svgSeriesD);
        }
        if (line.popupIndex != -1) {
            g2.setStroke(this.DefaultStroke);
            this.storePopUp(g2, line.popupIndex, line, x_temp[line.popupIndex], 0);
        }
        g2.setStroke(this.DefaultStroke);
    }

    private void DrawPolylineSegmented(Graphics2D g2, int[] x, LineDescription line) {
        int currentIndex = 0;
        int length_yval = line.yval.length;
        while (currentIndex < length_yval && Double.isNaN(line.yval[currentIndex])) {
            ++currentIndex;
        }
        int startIndex = currentIndex;
        while (currentIndex < length_yval) {
            if (Double.isNaN(line.yval[currentIndex]) || currentIndex == length_yval - 1) {
                int length = currentIndex + 1 - startIndex;
                if (Double.isNaN(line.yval[currentIndex])) {
                    --length;
                }
                if (length >= 2) {
                    int[] yCopy = new int[length];
                    int[] xCopy = new int[length];
                    System.arraycopy(line.yval_int, startIndex, yCopy, 0, length);
                    System.arraycopy(x, startIndex, xCopy, 0, length);
                    g2.drawPolyline(xCopy, yCopy, length);
                }
                ++currentIndex;
                while (currentIndex < length_yval && Double.isNaN(line.yval[currentIndex])) {
                    ++currentIndex;
                }
                startIndex = currentIndex;
                continue;
            }
            ++currentIndex;
        }
    }

    private void plotArea(Graphics2D g2, SubChartDescription sc, LineDescription line, int[] x, int[] y, int numpoints, float alphaArea) {
        int baseLine;
        if (this.Ch.disableZeroSeries && line.containsAllZero) {
            return;
        }
        if (line.containsAllNaN) {
            return;
        }
        if (numpoints <= 0) {
            return;
        }
        int segmentCountNaN = 0;
        if (line.containsNaN) {
            int[] mapCount = new int[]{0};
            segmentCountNaN = line.countNaNSegments(false, mapCount);
            line.countNaNSegments(true, mapCount);
        }
        int[] x_temp = new int[numpoints + 2 + segmentCountNaN];
        int[] y_temp = new int[numpoints + 2 + segmentCountNaN];
        int x_offset = 0;
        if (this.Ch.useIntervalMethod() && !this.Ch.continuousXAxis()) {
            double x_scale = sc.xAxisWidth / sc.x_coordinate_spread;
            x_offset = (int)Math.round(x_scale / 2.0);
        }
        x_temp[0] = x[0] + x_offset;
        x_temp[numpoints + segmentCountNaN + 1] = x[numpoints - 1] + x_offset + 1;
        y_temp[0] = baseLine = this.ScaleYToPlotWindow(sc, sc.YAxis1.yAxisMet.Ymin);
        y_temp[numpoints + segmentCountNaN + 1] = baseLine;
        if (this.Ch.useIntervalMethod() && !this.Ch.continuousXAxis()) {
            if (!line.containsNaN) {
                int j = 0;
                while (j < numpoints) {
                    x_temp[j + 1] = x[j] + x_offset;
                    y_temp[j + 1] = y[j];
                    ++j;
                }
            } else {
                this.constructArea(line, x_temp, y_temp, x, y, numpoints, baseLine, x_offset);
            }
        } else {
            if (!line.containsNaN) {
                int j = 0;
                while (j < numpoints) {
                    x_temp[j + 1] = x[j];
                    y_temp[j + 1] = y[j];
                    ++j;
                }
            } else {
                this.constructArea(line, x_temp, y_temp, x, y, numpoints, baseLine, 0);
            }
            int n = numpoints + segmentCountNaN;
            x_temp[n] = x_temp[n] + 1;
        }
        Composite CompositeDefault = null;
        if (alphaArea < 1.0f) {
            CompositeDefault = g2.getComposite();
            AlphaComposite c = AlphaComposite.getInstance(3, alphaArea);
            g2.setComposite(c);
        }
        if (this.svgChartGraphics.getEnableSVG() && line.svgSeriesScript != null) {
            RenderingHints newHints = g2.getRenderingHints();
            newHints.put(SVGGraphics.SVG_PRIMITIVE_ID, line.seriesName + "_area_fill_highlight");
            newHints.put(SVGGraphics.USER_SCRIPT, line.svgSeriesScript);
            g2.setRenderingHints(newHints);
        }
        g2.fillPolygon(x_temp, y_temp, x_temp.length);
        if (this.Ch.genImageMapCoords) {
            this.addAreaImap(sc, line, x_temp, y_temp);
        }
        if (alphaArea < 1.0f) {
            g2.setComposite(CompositeDefault);
        }
    }

    private void constructArea(LineDescription line, int[] x_temp, int[] y_temp, int[] x, int[] y, int numpoints, int baseLine, int x_offset) {
        if (line.yval.length <= 0) {
            return;
        }
        boolean lastPointIsNaN = false;
        if (Double.isNaN(line.yval[0])) {
            lastPointIsNaN = true;
        }
        int j = 0;
        int extra = 0;
        while (j < numpoints) {
            if (lastPointIsNaN && !Double.isNaN(line.yval[j])) {
                x_temp[j + 1 + extra] = x[j] + x_offset;
                y_temp[j + 1 + extra] = baseLine;
                ++extra;
            } else if (!lastPointIsNaN && Double.isNaN(line.yval[j])) {
                x_temp[j + 1 + extra] = x[j - 1];
                y_temp[j + 1 + extra] = baseLine;
                ++extra;
            }
            x_temp[j + 1 + extra] = x[j] + x_offset;
            y_temp[j + 1 + extra] = y[j];
            if (Double.isNaN(line.yval[j])) {
                y_temp[j + 1 + extra] = baseLine;
            }
            lastPointIsNaN = Double.isNaN(line.yval[j]);
            ++j;
        }
    }

    private int insertNaNSegments(boolean[] isNaN, boolean[] isNaNCrossover, boolean[] isNaNCrossover2, int[] x_temp, int[] y_temp, int[] x, int[] y, int[] yPrev, int numpoints, int baseLine, int x_offset) {
        if (isNaN.length <= 0) {
            return 0;
        }
        boolean lastPointIsNaN = false;
        if (isNaN[0]) {
            lastPointIsNaN = true;
        }
        int j = 0;
        int extra = 0;
        while (j < numpoints) {
            if (lastPointIsNaN && !isNaN[j]) {
                if (x_temp != null) {
                    x_temp[j + extra] = x[j] + x_offset;
                    y_temp[j + extra] = baseLine;
                }
                ++extra;
            } else if (!lastPointIsNaN && isNaN[j]) {
                if (x_temp != null) {
                    x_temp[j + extra] = x[j - 1];
                    y_temp[j + extra] = baseLine;
                }
                ++extra;
            } else if (!lastPointIsNaN && !isNaN[j] && isNaNCrossover != null && j > 0) {
                if (isNaNCrossover[j] && !isNaNCrossover2[j] && !isNaNCrossover[j - 1] && isNaNCrossover2[j - 1] || !isNaNCrossover[j] && isNaNCrossover2[j] && isNaNCrossover[j - 1] && !isNaNCrossover2[j - 1]) {
                    if (x_temp != null) {
                        x_temp[j + extra] = x[j - 1];
                        y_temp[j + extra] = baseLine;
                    }
                    ++extra;
                    if (x_temp != null) {
                        x_temp[j + extra] = x[j] + x_offset;
                        y_temp[j + extra] = baseLine;
                    }
                    ++extra;
                } else if (!isNaNCrossover[j] && !isNaNCrossover2[j] && !isNaNCrossover[j - 1] && isNaNCrossover2[j - 1]) {
                    if (x_temp != null) {
                        x_temp[j + extra] = x[j];
                        y_temp[j + extra] = yPrev[j];
                    }
                    ++extra;
                } else if (!isNaNCrossover[j - 1] && !isNaNCrossover2[j - 1] && !isNaNCrossover[j] && isNaNCrossover2[j]) {
                    if (x_temp != null) {
                        x_temp[j + extra] = x[j - 1];
                        y_temp[j + extra] = yPrev[j - 1];
                    }
                    ++extra;
                }
            }
            if (x_temp != null) {
                x_temp[j + extra] = x[j] + x_offset;
                y_temp[j + extra] = y[j];
                if (isNaN[j]) {
                    y_temp[j + extra] = baseLine;
                }
            }
            lastPointIsNaN = isNaN[j];
            ++j;
        }
        return extra;
    }

    private void addAreaImap(SubChartDescription sc, LineDescription line, int[] x, int[] y) {
        AreaChartIMap acimap = new AreaChartIMap();
        acimap.line = line;
        acimap.x = x;
        acimap.y = y;
        sc.areaImageMapV.addElement(acimap);
    }

    private void processAreaImap(SubChartDescription sc) {
        Object acimapPrev = null;
        int s = 0;
        while (s < sc.areaImageMapV.size()) {
            AreaChartIMap acimap = (AreaChartIMap)sc.areaImageMapV.elementAt(s);
            if (s == sc.areaImageMapV.size() - 1 || acimap.line.lineType == 3) {
                acimap.line.imageMapCoordsAreaC = new int[1][acimap.x.length * 2];
                acimap.line.imageMapShapeAreaC = 2;
                int i = 0;
                while (i < acimap.x.length) {
                    acimap.line.imageMapCoordsAreaC[0][i * 2] = acimap.x[i];
                    acimap.line.imageMapCoordsAreaC[0][i * 2 + 1] = acimap.y[i];
                    ++i;
                }
            } else {
                AreaChartIMap acimapNext = (AreaChartIMap)sc.areaImageMapV.elementAt(s + 1);
                acimap.line.imageMapCoordsAreaC = new int[1][(acimap.x.length - 2) * 2 + (acimapNext.x.length - 2) * 2];
                int i = 0;
                while (i < acimap.x.length - 2) {
                    int shiftIndex = i + 1;
                    acimap.line.imageMapCoordsAreaC[0][i * 2] = acimap.x[shiftIndex];
                    acimap.line.imageMapCoordsAreaC[0][i * 2 + 1] = acimap.y[shiftIndex];
                    ++i;
                }
                int nextIndex = (acimap.x.length - 2) * 2;
                int i2 = 0;
                while (i2 < acimapNext.x.length - 2) {
                    int revShiftIndex = acimapNext.x.length - 2 - i2;
                    acimap.line.imageMapCoordsAreaC[0][nextIndex + i2 * 2] = acimapNext.x[revShiftIndex];
                    acimap.line.imageMapCoordsAreaC[0][nextIndex + (i2 * 2 + 1)] = acimapNext.y[revShiftIndex];
                    ++i2;
                }
                acimap.line.imageMapShapeAreaC = 2;
            }
            ++s;
        }
    }

    private void computeCumeNaN(LineDescription[] lineArray, MultiLineNaN[] multiL, int baseLine) {
        int j = 0;
        while (j < lineArray[0].yval.length) {
            multiL[0].isNaNArrayCume[j] = multiL[0].isNaNArray[j];
            multiL[0].yCume[j] = lineArray[0].yval_int[j];
            ++j;
        }
        int k = 0;
        while (k < multiL.length - 1) {
            int j2 = 0;
            while (j2 < lineArray[k].yval.length) {
                if (!multiL[k].isNaNArrayCume[j2] && !multiL[k + 1].isNaNArray[j2]) {
                    multiL[k + 1].isNaNArrayCume[j2] = false;
                    multiL[k + 1].yCume[j2] = multiL[k].yCume[j2] + (lineArray[k + 1].yval_int[j2] - baseLine);
                } else if (multiL[k].isNaNArrayCume[j2] && multiL[k + 1].isNaNArray[j2]) {
                    multiL[k + 1].isNaNArrayCume[j2] = true;
                    multiL[k + 1].yCume[j2] = baseLine;
                } else if (!multiL[k].isNaNArrayCume[j2] && multiL[k + 1].isNaNArray[j2]) {
                    multiL[k + 1].isNaNArrayCume[j2] = false;
                    multiL[k + 1].yCume[j2] = multiL[k].yCume[j2];
                } else if (multiL[k].isNaNArrayCume[j2] && !multiL[k + 1].isNaNArray[j2]) {
                    multiL[k + 1].isNaNArrayCume[j2] = false;
                    multiL[k + 1].yCume[j2] = lineArray[k + 1].yval_int[j2];
                }
                ++j2;
            }
            ++k;
        }
    }

    private void combineArrayPairs(MultiLineNaN2[] m1, MultiLineNaN2[] multiLAreaPair) {
        int k = 0;
        while (k < m1.length) {
            multiLAreaPair[k] = new MultiLineNaN2();
            ++k;
        }
        int k2 = 1;
        while (k2 < m1.length) {
            multiLAreaPair[k2].x = new int[m1[k2 - 1].x.length + m1[k2].x.length];
            multiLAreaPair[k2].y = new int[m1[k2 - 1].y.length + m1[k2].y.length];
            ++k2;
        }
        int k3 = 1;
        while (k3 < m1.length) {
            int j = 0;
            while (j < m1[k3 - 1].x.length) {
                multiLAreaPair[k3].x[j] = m1[k3 - 1].x[j];
                multiLAreaPair[k3].y[j] = m1[k3 - 1].y[j];
                ++j;
            }
            int lastIndex = m1[k3 - 1].x.length;
            int j2 = 0;
            while (j2 < m1[k3].x.length) {
                multiLAreaPair[k3].x[lastIndex + (m1[k3].x.length - 1 - j2)] = m1[k3].x[j2];
                multiLAreaPair[k3].y[lastIndex + (m1[k3].y.length - 1 - j2)] = m1[k3].y[j2];
                ++j2;
            }
            ++k3;
        }
    }

    private int[] convertLineYToArea(LineDescription line, int baseLine) {
        int numpoints = line.yval_int.length;
        int[] y_cume = new int[numpoints + 2];
        if (line.containsNaN) {
            int j = 0;
            while (j < numpoints) {
                y_cume[j + 1] = Double.isNaN(line.yval[j]) ? baseLine : line.yval_int[j];
                ++j;
            }
        } else {
            System.arraycopy(line.yval_int, 0, y_cume, 1, numpoints);
        }
        y_cume[0] = baseLine;
        y_cume[numpoints + 1] = baseLine;
        return y_cume;
    }

    private int[] convertLineYToArea(LineDescription line1, LineDescription line2) {
        int numpoints = line1.yval_int.length;
        int[] y_cume = new int[numpoints * 2];
        System.arraycopy(line1.yval_int, 0, y_cume, 0, numpoints);
        int j = 0;
        while (j < numpoints) {
            y_cume[2 * numpoints - j - 1] = line2.yval_int[j];
            ++j;
        }
        return y_cume;
    }

    private int[] convertLineXToAreaSquare(int[] x, int yLength) {
        int numpoints = yLength;
        int[] x_temp = new int[numpoints + 2];
        x_temp[0] = x[0];
        x_temp[numpoints + 1] = x[numpoints - 1] + 1;
        System.arraycopy(x, 0, x_temp, 1, numpoints);
        int n = numpoints;
        x_temp[n] = x_temp[n] + 1;
        return x_temp;
    }

    private int[] convertLineYToAreaSquare(int[] y, int baseLine) {
        int numpoints = y.length;
        int[] y_temp = new int[numpoints + 2];
        y_temp[0] = baseLine;
        y_temp[numpoints + 1] = baseLine;
        System.arraycopy(y, 0, y_temp, 1, numpoints);
        return y_temp;
    }

    private int[] convertLineXToArea(SubChartDescription sc, int[] x) {
        if (this.Ch.useIntervalMethod()) {
            int numpoints = x.length;
            int[] x_temp = new int[numpoints];
            int x_offset = this.getXOffsetForLineBar(sc);
            int j = 0;
            while (j < numpoints) {
                x_temp[j] = x[j] + x_offset;
                ++j;
            }
            return x_temp;
        }
        return x;
    }

    private int[] convertLineXToArea2(int[] x, int numpoints) {
        int[] x_cume = new int[numpoints * 2];
        int j = 0;
        while (j < numpoints) {
            System.arraycopy(x, 0, x_cume, 0, numpoints);
            x_cume[numpoints * 2 - j - 1] = x_cume[j];
            ++j;
        }
        return x_cume;
    }

    private int getXOffsetForLineBar(SubChartDescription sc) {
        int x_offset = 0;
        if (this.Ch.useIntervalMethod()) {
            double x_scale = sc.xAxisWidth / sc.x_coordinate_spread;
            x_offset = (int)Math.round(x_scale / 2.0);
        }
        return x_offset;
    }

    public void plotTemp(Graphics2D g2, Color c, int[] x, int[] y) {
        g2.setColor(c);
        int delta = 2;
        if (x == null) {
            System.out.println("x is null");
        }
        if (y == null) {
            System.out.println("y is null");
        }
        int i = 0;
        while (i < x.length) {
            System.out.println("x: " + x[i] + " " + y[i]);
            g2.fillRect(x[i] - delta, y[i] - delta, 5, 5);
            ++i;
        }
    }

    private MultiLineNaN2[] createMultiLineAreaPairs(LineDescription[] lineArray, int[] x, int baseLine) {
        MultiLineNaN2[] multiLAreaPair = new MultiLineNaN2[lineArray.length];
        MultiLineNaN[] multiL = new MultiLineNaN[lineArray.length];
        MultiLineNaN2[] multiLInserted = new MultiLineNaN2[lineArray.length];
        int numpoints = lineArray[0].yval.length;
        int k = 0;
        while (k < lineArray.length) {
            multiL[k] = new MultiLineNaN();
            multiL[k].isNaNArray = new boolean[numpoints];
            multiL[k].isNaNArrayCume = new boolean[numpoints];
            multiL[k].computeIsNaNArray(lineArray[k].yval);
            multiL[k].yCume = new int[numpoints];
            ++k;
        }
        this.computeCumeNaN(lineArray, multiL, baseLine);
        int k2 = 0;
        while (k2 < lineArray.length) {
            int[] prevMultiCume;
            boolean[] isNaNCrossover2;
            boolean[] isNaNCrossover;
            multiLInserted[k2] = new MultiLineNaN2();
            if (k2 == 0) {
                isNaNCrossover = null;
                isNaNCrossover2 = null;
                prevMultiCume = null;
            } else {
                isNaNCrossover = multiL[k2 - 1].isNaNArrayCume;
                isNaNCrossover2 = multiL[k2].isNaNArray;
                prevMultiCume = multiL[k2 - 1].yCume;
            }
            int extra = this.insertNaNSegments(multiL[k2].isNaNArrayCume, isNaNCrossover, isNaNCrossover2, null, null, x, multiL[k2].yCume, prevMultiCume, numpoints, baseLine, 0);
            multiLInserted[k2].x = new int[numpoints + extra];
            multiLInserted[k2].y = new int[numpoints + extra];
            this.insertNaNSegments(multiL[k2].isNaNArrayCume, isNaNCrossover, isNaNCrossover2, multiLInserted[k2].x, multiLInserted[k2].y, x, multiL[k2].yCume, prevMultiCume, numpoints, baseLine, 0);
            ++k2;
        }
        this.combineArrayPairs(multiLInserted, multiLAreaPair);
        multiLAreaPair[0].x = this.convertLineXToAreaSquare(multiLInserted[0].x, multiLInserted[0].y.length);
        multiLAreaPair[0].y = this.convertLineYToAreaSquare(multiLInserted[0].y, baseLine);
        return multiLAreaPair;
    }

    private void plotAreaCume(Graphics2D g2, SubChartDescription sc, int[] x, double[] xdbl, LineDescription[] lineArray) {
        boolean containsNaN = false;
        int k = 0;
        while (k < lineArray.length) {
            if (lineArray[k].containsNaN) {
                containsNaN = true;
            }
            ++k;
        }
        if (lineArray == null) {
            return;
        }
        if (lineArray.length < 1) {
            return;
        }
        int numpoints = lineArray[0].yval.length;
        if (numpoints <= 0) {
            return;
        }
        int[] x_bottom = null;
        Object y_bottom = null;
        int[][] y_cume = new int[lineArray.length][];
        int[] x_cume = null;
        int baseLine = this.ScaleYToPlotWindow(sc, sc.YAxis1.yAxisMet.Ymin);
        MultiLineNaN2[] multiLAreaPair = null;
        if (containsNaN) {
            multiLAreaPair = this.createMultiLineAreaPairs(lineArray, x, baseLine);
        }
        if (!containsNaN) {
            int[] x_temp = this.convertLineXToArea(sc, x);
            x_cume = this.convertLineXToArea2(x_temp, numpoints);
            x_bottom = this.convertLineXToAreaSquare(x, numpoints);
        }
        Composite CompositeDefault = null;
        g2.setRenderingHints(this.RHLine);
        int k2 = 0;
        while (k2 < lineArray.length) {
            RenderingHints newHints;
            if (this.svgChartGraphics.getEnableSVG()) {
                this.svgChartGraphics.startGroup("cb_series_" + lineArray[k2].seriesName);
            }
            g2.setColor(lineArray[k2].color2);
            if (lineArray[k2].alphaArea < 1.0f) {
                CompositeDefault = g2.getComposite();
                AlphaComposite c = AlphaComposite.getInstance(3, lineArray[k2].alphaArea);
                g2.setComposite(c);
            }
            numpoints = lineArray[k2].yval.length;
            if (k2 == 0) {
                if (this.svgChartGraphics.getEnableSVG() && lineArray[k2].svgSeriesScript != null) {
                    newHints = g2.getRenderingHints();
                    newHints.put(SVGGraphics.SVG_PRIMITIVE_ID, lineArray[k2].seriesName + "_area_fill_highlight");
                    newHints.put(SVGGraphics.USER_SCRIPT, lineArray[k2].svgSeriesScript);
                    g2.setRenderingHints(newHints);
                }
                if (!containsNaN) {
                    y_cume[0] = this.convertLineYToArea(lineArray[0], baseLine);
                    g2.fillPolygon(x_bottom, y_cume[0], y_cume[0].length);
                    if (this.Ch.genImageMapCoords) {
                        this.addAreaImap(sc, lineArray[k2], x_bottom, y_cume[k2]);
                    }
                } else {
                    g2.fillPolygon(multiLAreaPair[0].x, multiLAreaPair[0].y, multiLAreaPair[0].x.length);
                    if (this.Ch.genImageMapCoords) {
                        this.addAreaImap(sc, lineArray[k2], multiLAreaPair[0].x, multiLAreaPair[0].y);
                    }
                }
            } else {
                int j = 0;
                while (j < numpoints) {
                    if (!Double.isNaN(lineArray[k2].yval[j])) {
                        if (!Double.isNaN(lineArray[k2 - 1].yval[j])) {
                            int n = j;
                            lineArray[k2].yval_int[n] = lineArray[k2].yval_int[n] + (lineArray[k2 - 1].yval_int[j] - baseLine);
                        }
                    } else {
                        lineArray[k2].yval_int[j] = lineArray[k2 - 1].yval_int[j];
                    }
                    ++j;
                }
                g2.setColor(lineArray[k2].color2);
                if (this.svgChartGraphics.getEnableSVG() && lineArray[k2].svgSeriesScript != null) {
                    newHints = g2.getRenderingHints();
                    newHints.put(SVGGraphics.SVG_PRIMITIVE_ID, lineArray[k2].seriesName + "_area_fill_highlight");
                    newHints.put(SVGGraphics.USER_SCRIPT, lineArray[k2].svgSeriesScript);
                    g2.setRenderingHints(newHints);
                }
                if (containsNaN) {
                    g2.fillPolygon(multiLAreaPair[k2].x, multiLAreaPair[k2].y, multiLAreaPair[k2].x.length);
                    if (this.Ch.genImageMapCoords) {
                        this.addAreaImap(sc, lineArray[k2], multiLAreaPair[k2].x, multiLAreaPair[k2].y);
                    }
                } else {
                    y_cume[k2] = this.convertLineYToArea(lineArray[k2 - 1], lineArray[k2]);
                    g2.fillPolygon(x_cume, y_cume[k2], numpoints * 2);
                    if (this.Ch.genImageMapCoords) {
                        this.addAreaImap(sc, lineArray[k2], x_cume, y_cume[k2]);
                    }
                }
            }
            if (lineArray[k2].alphaArea < 1.0f) {
                g2.setComposite(CompositeDefault);
            }
            g2.setColor(lineArray[k2].color);
            this.PlotLine(g2, sc, x, xdbl, lineArray[k2], 0, 1);
            if (this.svgChartGraphics.getEnableSVG()) {
                this.svgChartGraphics.endGroup();
            }
            ++k2;
        }
    }

    private void plotAreaCumeContinuous(Graphics2D g2, SubChartDescription sc, LineDescription[] lineArray) {
        int numpoints = lineArray[0].yval.length;
        if (numpoints <= 0) {
            return;
        }
        int[] xPosPrev = new int[lineArray.length];
        int[] prevIndex = new int[lineArray.length];
        int[] prevLengthX = new int[lineArray.length];
        int[] prevLengthY = new int[lineArray.length];
        int baseLine = this.ScaleYToPlotWindow(sc, sc.YAxis1.yAxisMet.Ymin);
        Composite CompositeDefault = null;
        g2.setRenderingHints(this.RHLine);
        int k = 0;
        while (k < lineArray.length) {
            int j;
            numpoints = lineArray[k].yval_int.length;
            g2.setColor(lineArray[k].color2);
            if (lineArray[k].alphaArea < 1.0f) {
                CompositeDefault = g2.getComposite();
                AlphaComposite c = AlphaComposite.getInstance(3, lineArray[k].alphaArea);
                g2.setComposite(c);
            }
            if (k == 0) {
                int[] xbottomSeries = new int[numpoints + 2];
                int[] ybottomSeries = new int[numpoints + 2];
                ybottomSeries[0] = baseLine;
                ybottomSeries[numpoints + 1] = baseLine;
                xbottomSeries[0] = lineArray[0].xval_cont_int[0];
                xbottomSeries[numpoints + 1] = lineArray[0].xval_cont_int[numpoints - 1] + 1;
                j = 0;
                while (j < numpoints) {
                    ybottomSeries[j + 1] = lineArray[0].yval_int[j];
                    xbottomSeries[j + 1] = lineArray[0].xval_cont_int[j];
                    ++j;
                }
                if (this.svgChartGraphics.getEnableSVG() && lineArray[k].svgSeriesScript != null) {
                    RenderingHints newHints = g2.getRenderingHints();
                    newHints.put(SVGGraphics.SVG_PRIMITIVE_ID, lineArray[k].seriesName + "_area_fill_highlight");
                    newHints.put(SVGGraphics.USER_SCRIPT, lineArray[k].svgSeriesScript);
                    g2.setRenderingHints(newHints);
                }
                g2.fillPolygon(xbottomSeries, ybottomSeries, numpoints + 2);
                if (this.Ch.genImageMapCoords) {
                    this.addAreaImap(sc, lineArray[0], xbottomSeries, ybottomSeries);
                }
            } else {
                int s = k - 1;
                while (s >= 0) {
                    prevIndex[s] = 0;
                    prevLengthX[s] = lineArray[s].xval_cont_int.length;
                    prevLengthY[s] = lineArray[s].yval_int.length;
                    --s;
                }
                j = 0;
                while (j < numpoints) {
                    int xPosCurr = lineArray[k].xval_cont_int[j];
                    int s2 = k - 1;
                    while (s2 >= 0) {
                        xPosPrev[k - 1] = lineArray[k - 1].xval_cont_int[prevIndex[s2]];
                        while (xPosPrev[k - 1] < xPosCurr && prevIndex[s2] + 1 < prevLengthX[s2]) {
                            int n = s2;
                            int n2 = prevIndex[n];
                            prevIndex[n] = n2 + 1;
                            xPosPrev[k - 1] = lineArray[k - 1].xval_cont_int[n2];
                        }
                        if (xPosPrev[k - 1] == xPosCurr) {
                            if (prevIndex[s2] < prevLengthY[s2]) {
                                int n = j;
                                lineArray[k].yval_int[n] = lineArray[k].yval_int[n] + (lineArray[k - 1].yval_int[prevIndex[s2]] - baseLine);
                                int n3 = j;
                                lineArray[k].yval_dbl[n3] = lineArray[k].yval_dbl[n3] + (lineArray[k - 1].yval_dbl[prevIndex[s2]] - (double)baseLine);
                            }
                            int n = s2;
                            prevIndex[n] = prevIndex[n] + 1;
                            break;
                        }
                        --s2;
                    }
                    ++j;
                }
                int currLengthX = lineArray[k].xval_cont_int.length;
                int currLengthY = lineArray[k].yval_int.length;
                int[] xval_int_wrapped = new int[prevLengthY[k - 1] + currLengthY + 1];
                int[] yval_int_wrapped = new int[prevLengthY[k - 1] + currLengthY + 1];
                j = 0;
                while (j < currLengthY) {
                    xval_int_wrapped[j] = lineArray[k].xval_cont_int[j];
                    yval_int_wrapped[j] = lineArray[k].yval_int[j];
                    ++j;
                }
                int inc = 0;
                j = prevLengthY[k - 1] - 1;
                while (j >= 0) {
                    xval_int_wrapped[currLengthY + inc] = lineArray[k - 1].xval_cont_int[j];
                    yval_int_wrapped[currLengthY + inc] = lineArray[k - 1].yval_int[j];
                    ++inc;
                    --j;
                }
                xval_int_wrapped[currLengthY + prevLengthY[k - 1]] = xval_int_wrapped[0];
                yval_int_wrapped[currLengthY + prevLengthY[k - 1]] = yval_int_wrapped[0];
                g2.setColor(lineArray[k].color2);
                if (this.svgChartGraphics.getEnableSVG() && lineArray[k].svgSeriesScript != null) {
                    RenderingHints newHints = g2.getRenderingHints();
                    newHints.put(SVGGraphics.SVG_PRIMITIVE_ID, lineArray[k].seriesName + "_area_fill_highlight");
                    newHints.put(SVGGraphics.USER_SCRIPT, lineArray[k].svgSeriesScript);
                    g2.setRenderingHints(newHints);
                }
                g2.fillPolygon(xval_int_wrapped, yval_int_wrapped, xval_int_wrapped.length);
                if (this.Ch.genImageMapCoords) {
                    this.addAreaImap(sc, lineArray[k], xval_int_wrapped, yval_int_wrapped);
                }
            }
            if (lineArray[k].alphaArea < 1.0f) {
                g2.setComposite(CompositeDefault);
            }
            g2.setColor(lineArray[k].color);
            this.PlotLine(g2, sc, lineArray[k].xval_cont_int, lineArray[k].xval_cont_dbl, lineArray[k], 0, 1);
            ++k;
        }
    }

    private void PlotHILOCLOSE(Graphics2D g2, SubChartDescription sc, int[] x, int[] yhigh, int[] ylow, int[] yclose, LineDescription line) {
        if (this.Ch.disableZeroSeries && line.containsAllZero) {
            return;
        }
        if (line.containsAllNaN) {
            return;
        }
        double barWidth = line.width;
        int numpoints = line.num_points;
        int closeMarkerWidth = line.length;
        int closeMarkerHeight = (int)line.width;
        int interval_width = 0;
        int adjust_x = 0;
        if (!line.subFrequency && !this.Ch.continuousXAxis()) {
            if (x.length >= 2) {
                interval_width = x[1] - x[0];
            }
            adjust_x = (interval_width - (int)barWidth) / 2;
        }
        int i = 0;
        while (i < numpoints) {
            int yheight = ylow[i] - yhigh[i];
            if (line.hilightIndex == i) {
                g2.setColor(line.hilightColor);
            }
            if (line.hilightIndex == i - 1) {
                g2.setColor(line.color);
            }
            g2.fillRect(x[i] + adjust_x, yhigh[i], (int)barWidth, yheight);
            g2.fillRect(x[i] + adjust_x, yclose[i], (int)barWidth + closeMarkerWidth, closeMarkerHeight);
            ++i;
        }
        if (this.Ch.genImageMapCoords) {
            int halfCloseMarkerHeight = closeMarkerHeight / 2;
            int delta = 2;
            if ((double)interval_width < barWidth + (double)(2 * delta)) {
                delta = 0;
            }
            int i2 = 0;
            while (i2 < numpoints) {
                int xLeft = x[i2] + adjust_x - delta;
                int xRight = xLeft + (int)barWidth + delta;
                int xCloseRight = xRight + closeMarkerWidth;
                int yCloseBottom = yclose[i2] - halfCloseMarkerHeight;
                int yCloseTop = yclose[i2] + halfCloseMarkerHeight;
                double[] polyX = new double[9];
                double[] polyY = new double[9];
                polyX[0] = xLeft;
                polyY[0] = ylow[i2];
                polyX[1] = xLeft;
                polyY[1] = yhigh[i2];
                polyX[2] = xRight;
                polyY[2] = yhigh[i2];
                polyX[3] = xRight;
                polyY[3] = yCloseTop;
                polyX[4] = xCloseRight;
                polyY[4] = yCloseTop;
                polyX[5] = xCloseRight;
                polyY[5] = yCloseBottom;
                polyX[6] = xRight;
                polyY[6] = yCloseBottom;
                polyX[7] = xRight;
                polyY[7] = ylow[i2];
                polyX[8] = xLeft;
                polyY[8] = ylow[i2];
                if (this.Ch.genImageMapCoords) {
                    this.copyImageMapPoly(line, i2, polyX, polyY);
                }
                ++i2;
            }
        }
        if (line.popupIndex != -1) {
            int barXCenter = x[line.popupIndex] + adjust_x + (int)(barWidth / 2.0);
            this.storePopUpSide(g2, line.popupIndex, line, barXCenter);
        }
    }

    private void PlotOPENHILOCLOSE(Graphics2D g2, SubChartDescription sc, int[] x, int[] yopen, int[] yhigh, int[] ylow, int[] yclose, LineDescription line) {
        if (this.Ch.disableZeroSeries && line.containsAllZero) {
            return;
        }
        if (line.containsAllNaN) {
            return;
        }
        double barWidth = line.width;
        int numpoints = line.num_points;
        int interval_width = 0;
        int adjust_x = 0;
        if (!line.subFrequency && !this.Ch.continuousXAxis()) {
            if (x.length >= 2) {
                interval_width = x[1] - x[0];
            }
            adjust_x = (interval_width - (int)barWidth) / 2;
        }
        int closeMarkerWidth = line.length;
        int closeMarkerHeight = (int)line.width;
        int halfCloseMarkerHeight = closeMarkerHeight / 2;
        int i = 0;
        while (i < numpoints) {
            if (line.hilightIndex == i) {
                g2.setColor(line.hilightColor);
            }
            if (line.hilightIndex == i - 1) {
                g2.setColor(line.color);
            }
            int yheight = ylow[i] - yhigh[i];
            g2.fillRect(x[i] + adjust_x, yhigh[i], (int)barWidth, yheight);
            g2.fillRect(x[i] + adjust_x, yclose[i] - halfCloseMarkerHeight, (int)barWidth + closeMarkerWidth, closeMarkerHeight);
            g2.fillRect(x[i] + adjust_x - closeMarkerWidth, yopen[i] - halfCloseMarkerHeight, (int)barWidth + closeMarkerWidth, closeMarkerHeight);
            ++i;
        }
        if (this.Ch.genImageMapCoords) {
            int delta = 2;
            if ((double)interval_width < barWidth + (double)(2 * delta)) {
                delta = 0;
            }
            int i2 = 0;
            while (i2 < numpoints) {
                int xLeft = x[i2] + adjust_x - delta;
                int xRight = xLeft + (int)barWidth + delta;
                int xOpenLeft = xLeft - closeMarkerWidth;
                int yOpenBottom = yopen[i2] - halfCloseMarkerHeight;
                int yOpenTop = yopen[i2] + halfCloseMarkerHeight;
                int xCloseRight = xRight + closeMarkerWidth;
                int yCloseBottom = yclose[i2] - halfCloseMarkerHeight;
                int yCloseTop = yclose[i2] + halfCloseMarkerHeight;
                double[] polyX = new double[12];
                double[] polyY = new double[12];
                polyX[0] = xLeft;
                polyY[0] = ylow[i2];
                polyX[1] = xLeft;
                polyY[1] = yOpenBottom;
                polyX[2] = xOpenLeft;
                polyY[2] = yOpenBottom;
                polyX[3] = xOpenLeft;
                polyY[3] = yOpenTop;
                polyX[4] = xLeft;
                polyY[4] = yOpenTop;
                polyX[5] = xLeft;
                polyY[5] = yhigh[i2];
                polyX[6] = xRight;
                polyY[6] = yhigh[i2];
                polyX[7] = xRight;
                polyY[7] = yCloseTop;
                polyX[8] = xCloseRight;
                polyY[8] = yCloseTop;
                polyX[9] = xCloseRight;
                polyY[9] = yCloseBottom;
                polyX[10] = xRight;
                polyY[10] = yCloseBottom;
                polyX[10] = xRight;
                polyY[10] = ylow[i2];
                polyX[11] = xLeft;
                polyY[11] = ylow[i2];
                if (this.Ch.genImageMapCoords) {
                    this.copyImageMapPoly(line, i2, polyX, polyY);
                }
                ++i2;
            }
        }
        if (line.popupIndex != -1) {
            int barXCenter = x[line.popupIndex] + adjust_x + (int)(barWidth / 2.0);
            this.storePopUpSide(g2, line.popupIndex, line, barXCenter);
        }
    }

    private void PlotCandleStick(Graphics2D g2, SubChartDescription sc, int[] x, int[] yopen, int[] yhigh, int[] ylow, int[] yclose, LineDescription line) {
        int xAdj;
        if (this.Ch.disableZeroSeries && line.containsAllZero) {
            return;
        }
        if (line.containsAllNaN) {
            return;
        }
        int shadowWidth = line.width2;
        int shadowHalfWidth = shadowWidth / 2;
        int realBodyWidth = (int)line.width;
        int realBodyHalfWidth = realBodyWidth / 2;
        int interval_width = 0;
        int adjustBodyWidth = 0;
        if (!line.subFrequency && !this.Ch.continuousXAxis()) {
            if (x.length >= 2) {
                interval_width = x[1] - x[0];
            }
            adjustBodyWidth = interval_width / 2;
        }
        int numpoints = line.num_points;
        int stemWidth = 2;
        if (realBodyWidth < 4) {
            stemWidth = 1;
        }
        int i = 0;
        while (i < numpoints) {
            int realBodyY;
            Color tempBodyColor;
            int realBodyHeight;
            xAdj = x[i] + adjustBodyWidth;
            int realBodyX = xAdj - realBodyHalfWidth;
            int shadowX = xAdj - shadowHalfWidth;
            if (yclose[i] > yopen[i]) {
                realBodyHeight = yclose[i] - yopen[i];
                tempBodyColor = line.color2;
                realBodyY = yopen[i];
            } else {
                realBodyHeight = yopen[i] - yclose[i];
                tempBodyColor = line.color3;
                realBodyY = yclose[i];
            }
            g2.setColor(line.color);
            g2.fillRect(shadowX, yhigh[i], shadowWidth, yclose[i] - yhigh[i]);
            g2.fillRect(shadowX, yopen[i], shadowWidth, ylow[i] - yopen[i]);
            if (line.hilightIndex == i) {
                g2.setColor(line.hilightColor);
            } else {
                g2.setColor(tempBodyColor);
            }
            g2.fillRect(realBodyX, realBodyY, realBodyWidth, realBodyHeight);
            g2.setColor(line.color);
            g2.drawRect(realBodyX, realBodyY, realBodyWidth, realBodyHeight);
            if (this.Ch.genImageMapCoords) {
                int shadowXLeft = shadowX - stemWidth;
                int shadowXRight = shadowX + stemWidth;
                double[] polyX = new double[13];
                double[] polyY = new double[13];
                polyX[0] = shadowXLeft;
                polyY[0] = ylow[i];
                polyX[1] = shadowXRight;
                polyY[1] = ylow[i];
                polyX[2] = shadowXRight;
                polyY[2] = realBodyY;
                polyX[3] = realBodyX + realBodyWidth;
                polyY[3] = realBodyY;
                polyX[4] = realBodyX + realBodyWidth;
                polyY[4] = realBodyY + realBodyHeight;
                polyX[5] = shadowXRight;
                polyY[5] = realBodyY + realBodyHeight;
                polyX[6] = shadowXRight;
                polyY[6] = yhigh[i];
                polyX[7] = shadowXLeft;
                polyY[7] = yhigh[i];
                polyX[8] = shadowXLeft;
                polyY[8] = realBodyY + realBodyHeight;
                polyX[9] = realBodyX;
                polyY[9] = realBodyY + realBodyHeight;
                polyX[10] = realBodyX;
                polyY[10] = realBodyY;
                polyX[11] = shadowXLeft;
                polyY[11] = realBodyY;
                polyX[12] = shadowXLeft;
                polyY[12] = ylow[i];
                if (this.Ch.genImageMapCoords) {
                    this.copyImageMapPoly(line, i, polyX, polyY);
                }
            }
            ++i;
        }
        if (line.popupIndex != -1) {
            xAdj = x[line.popupIndex] + adjustBodyWidth;
            this.storePopUpSide(g2, line.popupIndex, line, xAdj);
        }
    }

    private Color invertColor(Color c) {
        int b;
        int g;
        int brightLimit = 210;
        int r = c.getRed();
        if (r + (g = c.getGreen()) + (b = c.getBlue()) > 384 || r > brightLimit || g > brightLimit || r > brightLimit) {
            return Color.black;
        }
        return Color.white;
    }

    private void smartSetTextColor(Graphics2D g2) {
        g2.setColor(Color.red);
    }

    private void smartSetSeriesColor(Graphics2D g2, LineDescription line) {
        if (line.negativeColor) {
            g2.setColor(line.color2);
        } else {
            g2.setColor(line.color);
        }
    }

    private int rightJustify(SubChartDescription sc, String str, int intervalWidth) {
        int labelWidth = this.sl.fontmet.stringWidth(str);
        if (intervalWidth > (labelWidth = (int)((double)labelWidth + (double)this.sl.fontmet.stringWidth("@") * 0.5))) {
            return intervalWidth - labelWidth;
        }
        return 0;
    }

    private int getTextYOffset(Graphics2D g2, SubChartDescription sc) {
        double halfInterval = this.getHalfIntervalDC(sc);
        FontRenderContext frc = g2.getFontRenderContext();
        int labelAscent = LabelUtil.getStringLabelHeight("Template", this.sl.stringAxisD, frc, this.sl.fontmet);
        int labelAscentCenter = (int)((double)labelAscent / 2.7);
        int textYOffset = (int)Math.round(halfInterval) + labelAscentCenter;
        return textYOffset;
    }

    private void drawLeftBarLabel(Graphics2D g2, SubChartDescription sc, int[] x, int indexBase, int textYOffset, int baseline) {
        AttributedString attrStr;
        int index = indexBase;
        if (!this.Ch.vertical) {
            index = x.length - indexBase - 1;
        }
        String s = this.Ch.XStringLabel[indexBase];
        int xcoord = 0;
        if (this.Ch.containsMultiplePosNegHBars) {
            baseline = sc.HLayout.labelXSpaceLeft + this.Ch.border_left;
        }
        switch (this.sl.stringAxisD.getLabelJustify()) {
            case 0: {
                xcoord = baseline - sc.HLayout.maxPosLabelWidth;
                break;
            }
            case 1: {
                xcoord = this.rightJustify(sc, s, baseline);
            }
        }
        if (this.svgChartGraphics.getEnableSVG() && this.Ch.svgXLinksStringLabel != null && this.Ch.svgXLinksStringLabel.getHRef().length > indexBase) {
            this.svgChartGraphics.setStartATagLink(this.Ch.svgXLinksStringLabel.getHRef()[indexBase]);
        }
        if ((attrStr = LabelUtil.getStringLabelAttributedString(s, this.sl.stringAxisD)) != null) {
            TextLayout layout = new TextLayout(attrStr.getIterator(), g2.getFontRenderContext());
            layout.draw(g2, xcoord, x[index] + textYOffset);
        } else {
            g2.setColor(this.sl.stringAxisD.getColor());
            g2.setFont(this.sl.stringAxisD.getFont());
            g2.drawString(s, xcoord, x[index] + textYOffset);
        }
        if (this.svgChartGraphics.getEnableSVG() && this.Ch.svgXLinksStringLabel != null && this.Ch.svgXLinksStringLabel.getHRef().length > indexBase) {
            this.svgChartGraphics.setEndATag();
        }
        if (this.Ch.genImageMapCoords) {
            int xCorner0 = xcoord;
            int xCorner1 = xcoord + this.sl.fontmet.stringWidth(s);
            int yCorner0 = x[index] + textYOffset - this.sl.fontmet.getAscent();
            int yCorner1 = x[index] + textYOffset;
            this.copyImageMapRectAxis(indexBase, xCorner0, yCorner0, xCorner1, yCorner1);
        }
    }

    private void copyImageMapRectAxis(int index, int xCorner0, int yCorner0, int xCorner1, int yCorner1) {
        this.Ch.imageMapShape = 0;
        this.Ch.imageMapCoords[index] = new int[4];
        this.Ch.imageMapCoords[index][0] = xCorner0;
        this.Ch.imageMapCoords[index][1] = yCorner0;
        this.Ch.imageMapCoords[index][2] = xCorner1;
        this.Ch.imageMapCoords[index][3] = yCorner1;
    }

    private void drawRightBarLabel(Graphics2D g2, SubChartDescription sc, int[] x, int indexBase, int textYOffset, int baseline) {
        AttributedString attrStr;
        int index = indexBase;
        if (!this.Ch.vertical) {
            index = x.length - indexBase - 1;
        }
        String s = this.Ch.XStringLabel[indexBase];
        int xcoord = 0;
        int halfCharWidth = (int)((double)this.sl.fontmet.stringWidth("@") * 0.5);
        switch (this.sl.stringAxisD.getLabelJustify()) {
            case 0: {
                xcoord = baseline + halfCharWidth;
                break;
            }
            case 1: {
                xcoord = baseline + sc.HLayout.maxNegLabelWidth - this.sl.fontmet.stringWidth(s);
            }
        }
        if (this.svgChartGraphics.getEnableSVG() && this.Ch.svgXLinksStringLabel != null && this.Ch.svgXLinksStringLabel.getHRef().length > indexBase) {
            this.svgChartGraphics.setStartATagLink(this.Ch.svgXLinksStringLabel.getHRef()[indexBase]);
        }
        if ((attrStr = LabelUtil.getStringLabelAttributedString(s, this.sl.stringAxisD)) != null) {
            TextLayout layout = new TextLayout(attrStr.getIterator(), g2.getFontRenderContext());
            layout.draw(g2, xcoord, x[index] + textYOffset);
        } else {
            g2.setColor(this.sl.stringAxisD.getColor());
            g2.setFont(this.sl.stringAxisD.getFont());
            g2.drawString(s, xcoord, x[index] + textYOffset);
        }
        if (this.svgChartGraphics.getEnableSVG() && this.Ch.svgXLinksStringLabel != null && this.Ch.svgXLinksStringLabel.getHRef().length > indexBase) {
            this.svgChartGraphics.setEndATag();
        }
        if (this.Ch.genImageMapCoords) {
            int xCorner0 = xcoord;
            int xCorner1 = xcoord + this.sl.fontmet.stringWidth(s);
            int yCorner0 = x[index] + textYOffset - this.sl.fontmet.getAscent();
            int yCorner1 = x[index] + textYOffset;
            this.copyImageMapRectAxis(indexBase, xCorner0, yCorner0, xCorner1, yCorner1);
        }
    }

    private void fillRectSvgXLink(Graphics2D g2, int x, int y, int width, int height, SVGXLinkArrayDesc svgSeriesD, int index) {
        boolean writeSvgHref = SvgUtil.writeHref(svgSeriesD, index);
        if (writeSvgHref) {
            this.svgChartGraphics.setStartATagLink(svgSeriesD.getHRef()[index]);
        }
        g2.fillRect(x, y, width, height);
        if (writeSvgHref) {
            this.svgChartGraphics.setEndATag();
        }
    }

    private void invisibleCircleSvgXLink(Graphics2D g2, int centerX, int centerY, int diameter, SVGXLinkArrayDesc svgSeriesD, int index) {
        boolean writeSvgHref = SvgUtil.writeHref(svgSeriesD, index);
        if (writeSvgHref) {
            this.svgChartGraphics.setStartATagLink(svgSeriesD.getHRef()[index]);
        }
        double dd = diameter;
        int radius = (int)Math.round(dd / 2.0);
        int radiusHalf = (int)Math.round(dd / 4.0);
        this.svgChartGraphics.drawOvalSVG(centerX - radiusHalf, centerY - radiusHalf, radius, radius);
        if (writeSvgHref) {
            this.svgChartGraphics.setEndATag();
        }
    }

    private void k_invisibleCircleSvgXLink(Graphics2D g2, int numpoints, int[] x, int[] y, int diameter, SVGXLinkArrayDesc svgSeriesD) {
        if (svgSeriesD == null) {
            return;
        }
        int count = numpoints;
        if (svgSeriesD.getHRef().length < numpoints) {
            count = svgSeriesD.getHRef().length;
        }
        double dd = diameter;
        int radius = (int)Math.round(dd / 2.0);
        int radiusHalf = (int)Math.round(dd / 4.0);
        g2.setStroke(this.EmptyStroke);
        int k = 0;
        while (k < count) {
            this.svgChartGraphics.setStartATagLink(svgSeriesD.getHRef()[k]);
            int centerX = x[k];
            int centerY = y[k];
            this.svgChartGraphics.drawOvalSVG(centerX - radiusHalf, centerY - radiusHalf, radius, radius);
            this.svgChartGraphics.setEndATag();
            ++k;
        }
        g2.setStroke(this.LineStroke);
    }

    private void DrawPosBar(Graphics2D g2, SubChartDescription sc, Effect3D shadowColors, int[] x, LineDescription line, int indexBase, double barWidth, double adjust_barWidth, int blankAdjust, int textYOffset, int textYOffset2, int baseline, boolean shadowOnly, int barIndex) {
        int index = x.length - indexBase - 1;
        int barLength = line.yval_int[indexBase] - baseline;
        Color c = line.color;
        if (line.multiColor != null && line.multiColor.length > indexBase) {
            c = line.multiColor[indexBase];
            if (line.barStyle != 0) {
                shadowColors.deriveColors(c, line.barShadowColorDerived, line.barShadowColor);
            }
        }
        g2.setColor(c);
        if (line.hilightIndex == index) {
            g2.setColor(line.hilightColor);
        }
        if (!shadowOnly) {
            this.fillRectSvgXLink(g2, baseline, x[index] + (int)Math.round(adjust_barWidth), barLength, (int)barWidth, line.svgSeriesD, index);
        }
        if (line.barStyle != 0 && (line.barStyle == 2 || line.barStyle == 1 && shadowOnly)) {
            boolean topBar = true;
            boolean bottomBar = true;
            this.DropShade.drawShadowHorizontal(g2, c, shadowColors, baseline, x[index] + (int)Math.round(adjust_barWidth), barLength, (int)barWidth, true, topBar, bottomBar);
        }
        if (shadowOnly) {
            return;
        }
        if (this.Ch.genImageMapCoords) {
            int xCorner0 = baseline;
            int yCorner0 = x[index] + (int)Math.round(adjust_barWidth);
            int xCorner1 = xCorner0 + barLength;
            int yCorner1 = yCorner0 + (int)barWidth;
            if (this.Ch.genImageMapCoords) {
                this.copyImageMapRect(line, indexBase, xCorner0, yCorner0, xCorner1, yCorner1);
            }
        }
        if (barIndex == 0) {
            this.drawLeftBarLabel(g2, sc, x, indexBase, textYOffset + blankAdjust, baseline);
        }
        if (line.pointLabelsOn) {
            this.drawEndBarPosLabel(g2, sc, x, line, indexBase, textYOffset2, baseline);
        }
        if (line.containsBarIcons && line.barIcons[indexBase] != null) {
            barLength = line.yval_int[indexBase] + 3;
            int imageWidth = line.barIcons[indexBase].getWidth();
            int imageHeight = line.barIcons[indexBase].getHeight();
            int heightAdjust = ((int)barWidth - imageHeight) / 2;
            int xloc = barLength;
            int yloc = x[index] + (int)Math.round(adjust_barWidth) + heightAdjust;
            g2.drawImage(line.barIcons[indexBase], null, xloc, yloc);
            if (this.Ch.genImageMapCoords) {
                this.copyImageMapRectBarIcon(line, indexBase, xloc, yloc, xloc + imageWidth, yloc + imageHeight);
            }
        }
    }

    private void drawEndBarPosLabel(Graphics2D g2, SubChartDescription sc, int[] x, LineDescription line, int indexBase, int textYOffset2, int baseline) {
        int index = x.length - indexBase - 1;
        String s2 = line.pointLabels[indexBase];
        if (s2 != null) {
            int label2_x;
            g2.setFont(line.pointLabelFont);
            int label2Width = line.fontmet.stringWidth(s2);
            int barLength = line.yval_int[indexBase] - baseline;
            if (line.pointLabelsInterior && barLength > label2Width + 2 * sc.HLayout.padCharWidthPointLabels) {
                label2_x = baseline + barLength - label2Width;
                label2_x -= sc.HLayout.padCharWidthPointLabels;
                g2.setColor(this.invertColor(line.color));
            } else {
                label2_x = baseline + barLength;
                label2_x += sc.HLayout.padCharWidthPointLabels;
                g2.setColor(line.pointLabelColor);
            }
            if (line.barStyle == 2) {
                this.DropShade.getClass();
                textYOffset2 -= 3 / 2;
                this.DropShade.getClass();
                label2_x += 3;
            }
            g2.drawString(s2, label2_x, x[index] + textYOffset2);
        }
    }

    private void drawEndBarNegLabel(Graphics2D g2, SubChartDescription sc, int[] x, LineDescription line, int indexBase, int textYOffset2, int baseline) {
        int index = x.length - indexBase - 1;
        String s2 = line.pointLabels[indexBase];
        if (s2 != null) {
            int label2_x;
            g2.setFont(line.pointLabelFont);
            int label2Width = line.fontmet.stringWidth(s2);
            int barLength = line.yval_int[indexBase] - baseline;
            if (line.pointLabelsInterior && Math.abs(barLength) > label2Width + 2 * sc.HLayout.padCharWidthPointLabels) {
                label2_x = baseline + barLength;
                label2_x += sc.HLayout.padCharWidthPointLabels;
                if (line.negativeColor) {
                    g2.setColor(this.invertColor(line.color2));
                } else {
                    g2.setColor(this.invertColor(line.color));
                }
            } else {
                label2_x = baseline + barLength - label2Width;
                label2_x -= sc.HLayout.padCharWidthPointLabels;
                g2.setColor(line.pointLabelColor);
            }
            g2.drawString(s2, label2_x, x[index] + textYOffset2);
        }
    }

    private void DrawNegBar(Graphics2D g2, SubChartDescription sc, Effect3D shadowColors, int[] x, LineDescription line, int indexBase, double barWidth, double adjust_barWidth, int blankAdjust, int textYOffset, int textYOffset2, int baseline, boolean shadowOnly, int barIndex) {
        int index = x.length - indexBase - 1;
        int barLength = baseline - line.yval_int[indexBase];
        Color barColor = line.color;
        if (line.negativeColor) {
            barColor = line.color2;
        }
        if (line.hilightIndex == index) {
            g2.setColor(line.hilightColor);
        } else {
            if (line.multiColor != null && line.multiColor.length > indexBase) {
                barColor = line.multiColor[indexBase];
                if (line.barStyle != 0) {
                    shadowColors.deriveColors(barColor, line.barShadowColorDerived, line.barShadowColor);
                }
            }
            g2.setColor(barColor);
        }
        if (!shadowOnly) {
            this.fillRectSvgXLink(g2, line.yval_int[indexBase], x[index] + (int)Math.round(adjust_barWidth), barLength, (int)barWidth, line.svgSeriesD, indexBase);
        }
        if (line.barStyle != 0 && (line.barStyle == 2 || line.barStyle == 1 && shadowOnly)) {
            boolean topBar = true;
            boolean bottomBar = true;
            this.DropShade.drawShadowHorizontal(g2, barColor, shadowColors, line.yval_int[indexBase], x[index] + (int)Math.round(adjust_barWidth), barLength, (int)barWidth, false, topBar, bottomBar);
        }
        if (shadowOnly) {
            return;
        }
        if (this.Ch.genImageMapCoords) {
            int xCorner0 = line.yval_int[indexBase];
            int yCorner0 = x[index] + (int)Math.round(adjust_barWidth);
            int xCorner1 = xCorner0 + barLength;
            int yCorner1 = yCorner0 + (int)barWidth;
            if (this.Ch.genImageMapCoords) {
                this.copyImageMapRect(line, indexBase, xCorner0, yCorner0, xCorner1, yCorner1);
            }
        }
        if (barIndex == 0) {
            if (this.Ch.containsMultiplePosNegHBars) {
                this.drawLeftBarLabel(g2, sc, x, indexBase, textYOffset + blankAdjust, baseline);
            } else {
                this.drawRightBarLabel(g2, sc, x, indexBase, textYOffset + blankAdjust, baseline);
            }
        }
        if (line.pointLabelsOn) {
            this.drawEndBarNegLabel(g2, sc, x, line, indexBase, textYOffset2, baseline);
        }
    }

    protected int getYBaselineInt(SubChartDescription sc) {
        double y_zero = 0.0;
        if (sc.YAxis1.yAxisMet.Ymin > 0.0) {
            y_zero = sc.YAxis1.yAxisMet.Ymin;
        } else if (sc.YAxis1.yAxisMet.Ymax < 0.0) {
            y_zero = sc.YAxis1.yAxisMet.Ymax;
        }
        int y_zero_int = this.ScaleYToPlotWindow(sc, y_zero);
        return y_zero_int;
    }

    private int getYDeviceCoordinates(SubChartDescription sc, double y) {
        int y_dc = this.ScaleYToPlotWindow(sc, y);
        return y_dc;
    }

    private int getBlankIntervalAdjust(SubChartDescription sc) {
        double blankIntervals = this.Ch.XAxisCount - this.Ch.labelXCount;
        if (blankIntervals == 0.0) {
            return 0;
        }
        double intervalWidth = this.getIntervalDC(sc);
        int blankAdjust = (int)Math.round(blankIntervals * intervalWidth);
        return blankAdjust;
    }

    private void PlotBarHorizontal(Graphics2D g2, SubChartDescription sc, int[] x, LineDescription line, int BarIndex, int numBars, boolean shadowOnly) {
        if (this.Ch.disableZeroSeries && line.containsAllZero) {
            return;
        }
        if (line.containsAllNaN) {
            return;
        }
        boolean test = false;
        g2.setStroke(this.DefaultStroke);
        this.DropShade.effect3D = line.barStyle == 2;
        if (test) {
            System.out.println("PlotBarHoriz index " + BarIndex + " numBars " + numBars);
        }
        double barWidth = this.getBarWidth(line.width, line.widthMax, numBars);
        double halfInterval = this.getHalfIntervalDC(sc);
        if (test) {
            System.out.println("PlotBarHoriz halfInterval " + halfInterval);
        }
        double adjust_BarWidth = this.getBarAdjust(line, numBars - BarIndex - 1, numBars, halfInterval, this.BarWidth);
        if (sc.containsBarType3D) {
            adjust_BarWidth += (double)this.DropShade.Side3DDeltaAdjust;
        }
        if (sc.containsBarTypeDropShadow) {
            adjust_BarWidth += (double)this.DropShade.SideShadowDeltaAdjust;
        }
        int blankIntervals = this.Ch.XAxisCount - this.Ch.labelXCount;
        int blankAdjust = this.getBlankIntervalAdjust(sc);
        if (blankIntervals != 0) {
            adjust_BarWidth += (double)blankAdjust;
        }
        int labelAscent = sc.YAxis1.yl.fontmet.getAscent();
        int labelAscentCenter = (int)((double)labelAscent / 2.7);
        int pointlabelAscent = line.fontmet.getAscent();
        int pointlabelAscentCenter = (int)((double)pointlabelAscent / 2.4);
        int textYOffset = (int)Math.round(halfInterval) + labelAscentCenter;
        int textYOffset2 = (int)Math.round(adjust_BarWidth) + (int)Math.round(this.BarWidth / 2.0) + pointlabelAscentCenter;
        g2.setFont(sc.YAxis1.yl.numAxisD.getFont());
        int baseline = this.getYBaselineInt(sc);
        Effect3D effect3DPos = new Effect3D();
        if (line.barStyle != 0) {
            effect3DPos.deriveColors(line.color, line.barShadowColorDerived, line.barShadowColor);
        }
        Effect3D effect3DNeg = new Effect3D();
        Color barColor = line.color;
        if (line.negativeColor) {
            barColor = line.color2;
            if (line.barStyle != 0) {
                effect3DNeg.deriveColors(line.color2, line.barShadowColorDerived, line.barShadowColor);
            }
        } else if (line.barStyle != 0) {
            effect3DNeg.deriveColors(line.color, line.barShadowColorDerived, line.barShadowColor);
        }
        if (sc.YAxis1.yAxisMet.Ymin < 0.0 && sc.YAxis1.yAxisMet.Ymax > 0.0) {
            int i = 0;
            while (i < line.num_points) {
                if (line.yval[i] >= 0.0) {
                    this.DrawPosBar(g2, sc, effect3DPos, x, line, i, this.BarWidth, adjust_BarWidth, blankAdjust, textYOffset, textYOffset2, baseline, shadowOnly, BarIndex);
                } else {
                    this.DrawNegBar(g2, sc, effect3DNeg, x, line, i, this.BarWidth, adjust_BarWidth, blankAdjust, textYOffset, textYOffset2, baseline, shadowOnly, BarIndex);
                }
                ++i;
            }
        } else if (sc.YAxis1.yAxisMet.Ymax > 0.0) {
            if (sc.YAxis1.yAxisMet.Ymin != 0.0) {
                baseline = this.getYDeviceCoordinates(sc, sc.YAxis1.yAxisMet.Ymin);
            }
            g2.setColor(line.color);
            int i = 0;
            while (i < line.num_points) {
                this.DrawPosBar(g2, sc, effect3DPos, x, line, i, this.BarWidth, adjust_BarWidth, blankAdjust, textYOffset, textYOffset2, baseline, shadowOnly, BarIndex);
                ++i;
            }
        } else {
            if (sc.YAxis1.yAxisMet.Ymax != 0.0) {
                baseline = this.getYDeviceCoordinates(sc, sc.YAxis1.yAxisMet.Ymax);
            }
            int i = 0;
            while (i < line.num_points) {
                this.DrawNegBar(g2, sc, effect3DNeg, x, line, i, this.BarWidth, adjust_BarWidth, blankAdjust, textYOffset, textYOffset2, baseline, shadowOnly, BarIndex);
                ++i;
            }
        }
        if (line.popupIndex != -1) {
            int popIndex = line.popupIndex;
            if (!line.subFrequency) {
                popIndex = this.Ch.labelXCount - line.popupIndex - 1;
            }
            int barXCenter = x[popIndex] + (int)Math.round(adjust_BarWidth) + (int)Math.round(this.BarWidth / 2.0);
            this.storePopUpSideHorizontal(g2, line.popupIndex, line, barXCenter);
        }
    }

    private double getBarWidth(double lineWidth, double lineWidthMax, int numBars) {
        if (numBars >= 1) {
            this.BarWidth = lineWidth / (double)numBars;
            if (this.BarWidth < 1.0) {
                this.BarWidth = 2.0;
            }
            if (lineWidthMax > 0.0 && this.BarWidth > lineWidthMax) {
                return lineWidthMax;
            }
            return this.BarWidth;
        }
        return lineWidth;
    }

    private double getHalfIntervalDC(SubChartDescription sc) {
        double intervalWidth = this.getIntervalDC(sc);
        double halfInterval = intervalWidth / 2.0;
        return halfInterval;
    }

    private double getIntervalDC(SubChartDescription sc) {
        double intervalWidth = this.Ch.vertical ? sc.xAxisWidth / sc.x_coordinate_spread : sc.Displayheight / sc.x_coordinate_spread;
        return intervalWidth;
    }

    private double getHalfIntervalDC(SubChartDescription sc, LineDescription line) {
        double intervalWidth;
        if (!this.Ch.continuousXAxis()) {
            intervalWidth = this.Ch.vertical ? sc.xAxisWidth / sc.x_coordinate_spread : sc.Displayheight / sc.x_coordinate_spread;
        } else {
            intervalWidth = line.minXInterval * sc.xAxisWidth;
            intervalWidth = 0.0;
        }
        double halfInterval = intervalWidth / 2.0;
        return halfInterval;
    }

    private double getBarAdjust(LineDescription line, int BarIndex, int numBars, double halfInterval, double barWidth) {
        double totalHBarWidth = line.width;
        if (line.widthMax > 0.0 && line.width > line.widthMax) {
            totalHBarWidth = line.widthMax;
        }
        double adjust_BarWidth = halfInterval - totalHBarWidth / 2.0;
        if (numBars > 1) {
            adjust_BarWidth = halfInterval - totalHBarWidth / 2.0 + (double)BarIndex * this.BarWidth;
        }
        if (BarIndex >= 0 && BarIndex < 30) {
            this.BarAdjustSaveForLine[BarIndex] = adjust_BarWidth;
        }
        return adjust_BarWidth;
    }

    private void PlotBar(Graphics2D g2, SubChartDescription sc, int[] x, double[] xdbl, LineDescription line, int BarIndex, int numBars) {
        if (this.Ch.disableZeroSeries && line.containsAllZero) {
            return;
        }
        if (line.containsAllNaN) {
            return;
        }
        boolean test = false;
        if (test) {
            System.out.println("");
            System.out.println("PlotBar: barindex " + BarIndex + " numBars " + numBars);
        }
        double barWidth = this.getBarWidth(line.width, line.widthMax, numBars);
        this.BarWidth = (int)barWidth;
        this.PlotBarWidth = (int)barWidth;
        if (line.barStyle != 0) {
            this.DropShade.setShadowWidthThreshold(this.BarWidth);
        }
        this.DropShade.effect3D = line.barStyle == 2;
        if (test) {
            System.out.println("bar width is " + this.BarWidth);
        }
        double halfInterval = this.getHalfIntervalDC(sc, line);
        if (!this.Ch.useIntervalMethod()) {
            halfInterval = 0.0;
        }
        double adjust_BarWidth = this.getBarAdjust(line, BarIndex, numBars, halfInterval, this.BarWidth);
        if (test) {
            System.out.println("adjusted ");
        }
        if (sc.containsBarType3D) {
            adjust_BarWidth -= (double)this.DropShade.Side3DDeltaAdjust;
        }
        if (sc.containsBarTypeDropShadow) {
            adjust_BarWidth -= (double)this.DropShade.SideShadowDeltaAdjust;
        }
        int y_zero_int = this.getYBaselineInt(sc);
        if (test) {
            System.out.println("got baseline ");
        }
        double pointLabelHeightWC = 0.0;
        if (line.pointLabelsOn) {
            if (test) {
                System.out.println("point labels on ");
            }
            if (line == null) {
                return;
            }
            if (sc == null) {
                return;
            }
            pointLabelHeightWC = (double)line.fontmet.getAscent() * (sc.YAxis1.yAxisMet.y_coordinate_spread / sc.Displayheight);
        }
        if (test) {
            System.out.println("numpoints " + line.num_points);
        }
        Effect3D effect3DPos = new Effect3D();
        if (line.barStyle != 0) {
            effect3DPos.deriveColors(line.color, line.barShadowColorDerived, line.barShadowColor);
        }
        Effect3D effect3DNeg = new Effect3D();
        Color negColor = line.color;
        Color posColor = line.color;
        if (line.negativeColor && numBars == 1) {
            negColor = line.color2;
            if (line.barStyle != 0) {
                effect3DNeg.deriveColors(negColor, line.barShadowColorDerived, line.barShadowColor);
            }
        } else if (line.barStyle != 0) {
            effect3DNeg.deriveColors(posColor, line.barShadowColorDerived, line.barShadowColor);
        }
        Color originalBarColor = posColor;
        int i = 0;
        while (i < line.num_points) {
            if (!line.containsNaN || !Double.isNaN(line.yval[i])) {
                int yCorner1;
                int xCorner1;
                int yCorner0;
                int xCorner0;
                int yheight;
                if (test) {
                    System.out.println("i = " + i + " yval_int " + line.yval_int[i]);
                }
                if (!this.Ch.continuousXAxis() && numBars == 1 && i + 1 < x.length && x[i + 1] - x[i] != this.IntervalWidth) {
                    this.BarWidth = this.PlotBarWidth + (x[i + 1] - x[i]) - this.IntervalWidth;
                }
                if (line.multiColor != null) {
                    if (line.multiColor.length > i) {
                        negColor = line.multiColor[i];
                        posColor = line.multiColor[i];
                        if (line.barStyle != 0) {
                            if (line.yval_int[i] >= y_zero_int) {
                                effect3DNeg.deriveColors(negColor, line.barShadowColorDerived, line.barShadowColor);
                            } else {
                                effect3DPos.deriveColors(posColor, line.barShadowColorDerived, line.barShadowColor);
                            }
                        }
                        g2.setColor(posColor);
                    } else {
                        g2.setColor(originalBarColor);
                    }
                }
                if (line.yval_int[i] >= y_zero_int) {
                    if (test) {
                        System.out.println("neg ");
                    }
                    yheight = line.yval_int[i] - y_zero_int;
                    if (line.barStyle != 0) {
                        this.DropShade.drawShadow(g2, negColor, effect3DNeg, x[i] + (int)Math.round(adjust_BarWidth), y_zero_int, this.BarWidth, yheight, false, true, true, true, 0);
                    }
                    g2.setColor(negColor);
                    if (line.hilightIndex == i) {
                        g2.setColor(line.hilightColor);
                    }
                    this.fillRectSvgXLink(g2, x[i] + (int)Math.round(adjust_BarWidth), y_zero_int, (int)Math.round(this.BarWidth), yheight, line.svgSeriesD, i);
                    if (this.Ch.genImageMapCoords) {
                        xCorner0 = x[i] + (int)Math.round(adjust_BarWidth);
                        yCorner0 = y_zero_int;
                        xCorner1 = xCorner0 + (int)Math.round(this.BarWidth);
                        yCorner1 = yCorner0 + yheight;
                        if (this.Ch.genImageMapCoords) {
                            this.copyImageMapRect(line, i, xCorner0, yCorner0, xCorner1, yCorner1);
                        }
                    }
                } else {
                    if (test) {
                        System.out.println("pos ");
                    }
                    yheight = y_zero_int - line.yval_int[i];
                    if (line.barStyle != 0) {
                        this.DropShade.drawShadow(g2, line.color, effect3DPos, x[i] + (int)Math.round(adjust_BarWidth), line.yval_int[i], this.BarWidth, yheight, true, true, true, true, 0);
                    }
                    g2.setColor(posColor);
                    if (line.hilightIndex == i) {
                        g2.setColor(line.hilightColor);
                    }
                    this.fillRectSvgXLink(g2, x[i] + (int)Math.round(adjust_BarWidth), line.yval_int[i], (int)Math.round(this.BarWidth), yheight, line.svgSeriesD, i);
                    if (this.Ch.genImageMapCoords) {
                        xCorner0 = x[i] + (int)Math.round(adjust_BarWidth);
                        yCorner0 = line.yval_int[i];
                        xCorner1 = xCorner0 + (int)Math.round(this.BarWidth);
                        yCorner1 = yCorner0 + yheight;
                        if (this.Ch.genImageMapCoords) {
                            this.copyImageMapRect(line, i, xCorner0, yCorner0, xCorner1, yCorner1);
                        }
                    }
                }
                if (line.pointLabelsOn) {
                    if (test) {
                        System.out.println("point ");
                    }
                    g2.setColor(line.pointLabelColor);
                    g2.setFont(line.pointLabelFont);
                    int stringYOffset = -1;
                    int stringXOffset = (int)Math.round(adjust_BarWidth) + (int)this.BarWidth / 2 - line.fontmet.stringWidth(line.pointLabels[i]) / 2;
                    if (line.yval_int[i] > y_zero_int) {
                        stringYOffset = line.fontmet.getAscent();
                    } else if (line.barStyle == 2) {
                        this.DropShade.getClass();
                        stringYOffset -= 3;
                        this.DropShade.getClass();
                        stringXOffset += 3;
                    }
                    if (line.pointLabelsInterior && Math.abs(line.yval[i]) > pointLabelHeightWC) {
                        if (line.yval_int[i] < y_zero_int) {
                            stringYOffset = line.fontmet.getAscent();
                            g2.setColor(this.invertColor(line.color));
                        } else {
                            stringYOffset = -line.fontmet.getDescent();
                            if (line.negativeColor) {
                                g2.setColor(this.invertColor(line.color2));
                            } else {
                                g2.setColor(this.invertColor(line.color));
                            }
                        }
                    }
                    g2.drawString(line.pointLabels[i], x[i] + stringXOffset, line.yval_int[i] + stringYOffset);
                    g2.setColor(line.color);
                }
            }
            ++i;
        }
        if (line.popupIndex != -1) {
            int barXCenter = x[line.popupIndex] + (int)Math.round(adjust_BarWidth) + (int)(this.BarWidth / 2.0);
            this.storePopUp(g2, line.popupIndex, line, barXCenter, 0);
        }
        if (test) {
            System.out.println("PlotBar: End");
        }
    }

    private void storePopUp(Graphics2D g2, int popupIndex, LineDescription line, int barXCenter, int stackY) {
        if (popupIndex != -1) {
            int i = popupIndex;
            int y_zero_int = this.getYBaselineInt(this.SubCh);
            Annotation b = this.PopDat.b;
            b.setFont(this.AnnoDesc.getFont());
            b.getFMetrics(g2);
            int stem = -10;
            String text = "";
            int mouth_x = barXCenter;
            int corner_x = barXCenter;
            int mouth_y = 0;
            int corner_y = 0;
            switch (line.lineType) {
                case 0: 
                case 1: 
                case 4: 
                case 5: {
                    text = Double.toString(line.yval[i]);
                    b.setText(g2, text);
                    if (line.yval_int[i] >= y_zero_int) {
                        stem = -stem;
                    }
                    mouth_y = line.lineType == 5 ? stackY : line.yval_int[i];
                    corner_y = mouth_y + stem;
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    text = Double.toString(line.yhigh[i]);
                    b.setText(g2, text);
                    mouth_y = line.yhigh_int[i];
                    corner_y = line.yhigh_int[i] + stem;
                }
            }
            int plotMaxY = this.Ch.displayHeight;
            int PlotMinY = 0;
            int rectHeight = b.getRectHeight();
            int ymin = b.getYMin2(text, mouth_x, mouth_y, corner_x, corner_y);
            int ymax = b.getYMax2(text, mouth_x, mouth_y, corner_x, corner_y);
            int plotMaxX = this.Ch.displayWidth;
            int PlotMinX = 0;
            int rectWidth = b.getRectWidth();
            int balloonOrientation = 2;
            if (mouth_x + rectWidth / 2 >= plotMaxX) {
                balloonOrientation = 0;
            }
            if (mouth_x - rectWidth / 2 <= PlotMinX) {
                balloonOrientation = 1;
            }
            if (mouth_y + stem + rectHeight >= plotMaxY || mouth_y + stem - rectHeight <= PlotMinY) {
                switch (line.lineType) {
                    case 0: 
                    case 1: 
                    case 4: 
                    case 5: {
                        stem = -stem;
                        corner_y = line.yval_int[i] + stem;
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        stem = -stem;
                        corner_y = line.yhigh_int[i] + stem;
                    }
                }
            }
            this.PopDat.text = text;
            this.PopDat.mouth_x = mouth_x;
            this.PopDat.mouth_y = mouth_y;
            this.PopDat.corner_x = corner_x;
            this.PopDat.corner_y = corner_y;
            this.PopDat.orientation = (short)balloonOrientation;
        }
    }

    private void storePopUpSide(Graphics2D g2, int popupIndex, LineDescription line, int barXCenter) {
        if (popupIndex != -1) {
            int i = popupIndex;
            Annotation b = this.PopDat.b;
            b.setFont(this.AnnoDesc.getFont());
            b.getFMetrics(g2);
            int stem = 10;
            String text = Double.toString(line.yclose[i]);
            b.setText(g2, text);
            int rectHeight = b.getRectHeight();
            int mouth_x = barXCenter;
            int corner_x = barXCenter + stem;
            int mouth_y = line.yclose_int[i];
            int corner_y = line.yclose_int[i] + rectHeight / 2;
            int plotMaxY = this.Ch.displayHeight;
            boolean PlotMinY = false;
            int plotMaxX = this.Ch.displayWidth;
            boolean PlotMinX = false;
            int balloonOrientation = 4;
            int rectWidth = b.getRectWidth();
            if (mouth_x + stem + rectWidth >= plotMaxX) {
                balloonOrientation = 3;
                corner_x = barXCenter - stem;
            }
            this.PopDat.text = text;
            this.PopDat.mouth_x = mouth_x;
            this.PopDat.mouth_y = mouth_y;
            this.PopDat.corner_x = corner_x;
            this.PopDat.corner_y = corner_y;
            this.PopDat.orientation = (short)balloonOrientation;
        }
    }

    private void storePopUpSideHorizontal(Graphics2D g2, int popupIndex, LineDescription line, int barXCenter) {
        if (popupIndex != -1) {
            int i = popupIndex;
            Annotation b = this.PopDat.b;
            b.setFont(this.AnnoDesc.getFont());
            b.getFMetrics(g2);
            int stem = 10;
            String text = "";
            text = Double.toString(line.yval[i]);
            b.setText(g2, text);
            int balloonOrientation = 4;
            int rectHeight = b.getRectHeight();
            int mouth_y = barXCenter;
            int corner_y = barXCenter + rectHeight / 2;
            int mouth_x = 0;
            int corner_x = 0;
            if (line.yval[i] <= 0.0) {
                stem = -stem;
                balloonOrientation = 3;
            }
            mouth_x = line.yval_int[i];
            corner_x = line.yval_int[i] + stem;
            int plotMaxY = this.Ch.displayHeight;
            boolean PlotMinY = false;
            int plotMaxX = this.Ch.displayWidth;
            int PlotMinX = 0;
            int rectWidth = b.getRectWidth();
            if (mouth_x + stem + rectWidth >= plotMaxX || mouth_x + stem - rectWidth <= PlotMinX) {
                stem = -stem;
                corner_x = line.yval_int[i] + stem;
                balloonOrientation = balloonOrientation == 4 ? 3 : 4;
            }
            this.PopDat.text = text;
            this.PopDat.mouth_x = mouth_x;
            this.PopDat.mouth_y = mouth_y;
            this.PopDat.corner_x = corner_x;
            this.PopDat.corner_y = corner_y;
            this.PopDat.orientation = (short)balloonOrientation;
        }
    }

    private void copyImageMapRect(LineDescription line, int index, int xCorner0, int yCorner0, int xCorner1, int yCorner1) {
        line.imageMapShape = 0;
        line.imageMapCoords[index] = new int[4];
        line.imageMapCoords[index][0] = xCorner0;
        line.imageMapCoords[index][1] = yCorner0;
        line.imageMapCoords[index][2] = xCorner1;
        line.imageMapCoords[index][3] = yCorner1;
    }

    private void copyImageMapRectBarIcon(LineDescription line, int index, int xCorner0, int yCorner0, int xCorner1, int yCorner1) {
        line.imageMapShapeBarIcon = 0;
        line.imageMapCoordsBarIcon[index] = new int[4];
        line.imageMapCoordsBarIcon[index][0] = xCorner0;
        line.imageMapCoordsBarIcon[index][1] = yCorner0;
        line.imageMapCoordsBarIcon[index][2] = xCorner1;
        line.imageMapCoordsBarIcon[index][3] = yCorner1;
    }

    private void copyImageMapCirc(LineDescription line, int index, int centerX, int centerY, int diameter) {
        line.imageMapShape = 1;
        int radius = diameter / 2;
        line.imageMapCoords[index] = new int[3];
        line.imageMapCoords[index][0] = centerX;
        line.imageMapCoords[index][1] = centerY;
        line.imageMapCoords[index][2] = radius;
    }

    private void copyImageMapPoly(LineDescription line, int index, double[] x, double[] y) {
        line.imageMapCoords[index] = new int[x.length + y.length];
        line.imageMapShape = 2;
        int i = 0;
        while (i < x.length) {
            line.imageMapCoords[index][i * 2] = (int)x[i];
            line.imageMapCoords[index][i * 2 + 1] = (int)y[i];
            ++i;
        }
    }

    private double getAdjustStackBarWidth(LineDescription line, int[] x, SubChartDescription sc, int BarIndex, int numBars) {
        double barWidth = line.width;
        if (line.widthMax > 0.0 && line.width > line.widthMax) {
            barWidth = line.widthMax;
        }
        if (line.barStyle != 0) {
            this.DropShade.setShadowWidthThreshold(this.BarWidth);
        }
        this.DropShade.effect3D = line.barStyle == 2;
        double halfInterval = this.getHalfIntervalDC(sc, line);
        if (!this.Ch.useIntervalMethod()) {
            halfInterval = 0.0;
        }
        double adjust_BarWidth = this.getBarAdjust(line, BarIndex, numBars, halfInterval, barWidth);
        if (!this.Ch.vertical) {
            int blankAdjust = this.getBlankIntervalAdjust(sc);
            adjust_BarWidth += (double)blankAdjust;
        }
        if (sc.containsBarType3D) {
            adjust_BarWidth = this.Ch.vertical ? (adjust_BarWidth -= (double)this.DropShade.Side3DDeltaAdjust) : (adjust_BarWidth += (double)this.DropShade.Side3DDeltaAdjust);
        }
        if (sc.containsBarTypeDropShadow) {
            adjust_BarWidth = this.Ch.vertical ? (adjust_BarWidth -= (double)this.DropShade.SideShadowDeltaAdjust) : (adjust_BarWidth += (double)this.DropShade.SideShadowDeltaAdjust);
        }
        return adjust_BarWidth;
    }

    private void PlotStackedBARContinuous(Graphics2D g2, SubChartDescription sc, LineDescription[] lineArray, int BarIndex, int numBars) {
        LineDescription line = lineArray[0];
        int blankAdjust = 0;
        if (!this.Ch.vertical) {
            blankAdjust = this.getBlankIntervalAdjust(sc);
        }
        double adjust_BarWidth = this.getAdjustStackBarWidth(line, lineArray[0].xval_cont_int, sc, BarIndex, numBars);
        int y_zero_int = this.getYBaselineInt(sc);
        StackedBarContinuous sbc = new StackedBarContinuous(lineArray);
        boolean moreStuff = true;
        while (moreStuff) {
            moreStuff = sbc.next();
            if (sbc.index_pos <= 0) continue;
            int s = sbc.yposLineIndex[sbc.yposLineIndex[0]];
            this.drawPositiveStackedBAR(g2, sc, lineArray[s].xval_cont_int, lineArray, sbc.index_pos, sbc.ypos, sbc.yposLineIndex, sbc.first_index_pos, y_zero_int, adjust_BarWidth);
        }
    }

    private void PlotStackedBAR(Graphics2D g2, SubChartDescription sc, int[] x, LineDescription[] lineArray, int BarIndex, int numBars) {
        int textYOffset;
        int startDateIndex;
        int index;
        int s;
        int i;
        LineDescription line = lineArray[0];
        int blankAdjust = 0;
        if (!this.Ch.vertical) {
            blankAdjust = this.getBlankIntervalAdjust(sc);
        }
        double adjust_BarWidth = this.getAdjustStackBarWidth(line, x, sc, BarIndex, numBars);
        int[] ypos = new int[lineArray.length];
        int[] yposLineIndex = new int[lineArray.length];
        int[] yneg = new int[lineArray.length];
        int[] ynegLineIndex = new int[lineArray.length];
        int y_zero_int = this.getYBaselineInt(sc);
        int index_neg = 0;
        int index_pos = 0;
        int numXAxisPoints = this.Ch.TStampsCount;
        if (numXAxisPoints == 0) {
            numXAxisPoints = this.Ch.labelXCount;
        }
        if (sc.YAxis1.yAxisMet.Ymax > 0.0) {
            i = 0;
            while (i < numXAxisPoints) {
                index_pos = 0;
                s = 0;
                while (s < lineArray.length) {
                    index = i;
                    startDateIndex = lineArray[s].startDateIndex;
                    if (startDateIndex > 0) {
                        index = startDateIndex > i ? -1 : i - startDateIndex;
                    }
                    if (lineArray[s].subFrequency) {
                        index = lineArray[s].getSparseIndex(i);
                    } else if (lineArray[s].yval.length + startDateIndex <= i) {
                        index = -1;
                    }
                    if (index != -1 && lineArray[s].yval[index] >= 0.0) {
                        ypos[index_pos] = lineArray[s].yval_int[index];
                        yposLineIndex[index_pos] = s;
                        ++index_pos;
                    }
                    ++s;
                }
                this.drawPositiveStackedBAR(g2, sc, x, lineArray, index_pos, ypos, yposLineIndex, i, y_zero_int, adjust_BarWidth);
                if (!this.Ch.vertical) {
                    textYOffset = this.getTextYOffset(g2, sc) + blankAdjust;
                    this.drawLeftBarLabel(g2, sc, x, i, textYOffset, y_zero_int);
                }
                ++i;
            }
        }
        if (sc.YAxis1.yAxisMet.Ymin < 0.0) {
            i = 0;
            while (i < numXAxisPoints) {
                index_neg = 0;
                s = 0;
                while (s < lineArray.length) {
                    index = i;
                    startDateIndex = lineArray[s].startDateIndex;
                    if (startDateIndex > 0) {
                        index = startDateIndex > i ? -1 : i - startDateIndex;
                    }
                    if (lineArray[s].subFrequency) {
                        index = lineArray[s].getSparseIndex(i);
                    } else if (lineArray[s].yval.length + startDateIndex <= i) {
                        index = -1;
                    }
                    if (index != -1 && lineArray[s].yval[index] < 0.0) {
                        yneg[index_neg] = lineArray[s].yval_int[index];
                        ynegLineIndex[index_neg] = s;
                        ++index_neg;
                    }
                    ++s;
                }
                this.drawNegativeStackedBAR(g2, sc, x, lineArray, index_neg, yneg, ynegLineIndex, i, y_zero_int, adjust_BarWidth);
                if (!this.Ch.vertical) {
                    textYOffset = this.getTextYOffset(g2, sc) + blankAdjust;
                    if (this.Ch.containsMultiplePosNegHBars) {
                        this.drawLeftBarLabel(g2, sc, x, i, textYOffset, y_zero_int);
                    } else {
                        this.drawRightBarLabel(g2, sc, x, i, textYOffset, y_zero_int);
                    }
                }
                ++i;
            }
        }
    }

    private void drawNegativeStackedBAR(Graphics2D g2, SubChartDescription sc, int[] x, LineDescription[] lineArray, int index_neg, int[] yneg, int[] ynegLineIndex, int indexBase, int y_zero_int, double adjust_BarWidth) {
        int s;
        if (index_neg <= 0) {
            return;
        }
        int index = indexBase;
        if (!this.Ch.vertical) {
            index = x.length - indexBase - 1;
        }
        LineDescription line = lineArray[0];
        double barWidth = line.width;
        if (line.widthMax > 0.0 && line.width > line.widthMax) {
            barWidth = line.widthMax;
        }
        if (!this.Ch.continuousXAxis() && index + 1 < x.length && x[index + 1] - x[index] != this.IntervalWidth) {
            barWidth += (double)(x[index + 1] - x[index] - this.IntervalWidth);
        }
        int yHigh = y_zero_int;
        int yLow = y_zero_int;
        int yheight = 0;
        boolean topBar = false;
        boolean bottomBar = false;
        boolean positive = false;
        Effect3D effect3DBar = new Effect3D();
        int stackHeight = 0;
        int stackTopIndex = 0;
        int stackBottomIndex = -1;
        if (line.barStyle != 0) {
            s = 0;
            while (s < index_neg) {
                yheight = this.Ch.vertical ? yneg[s] - y_zero_int : y_zero_int - yneg[s];
                stackHeight += yheight;
                if (yheight > 0) {
                    stackTopIndex = s;
                }
                if (stackBottomIndex == -1 && yheight > 0) {
                    stackBottomIndex = s;
                }
                ++s;
            }
        }
        s = 0;
        while (s < index_neg) {
            int h;
            int w;
            int y;
            int xx;
            int negLineIndex = ynegLineIndex[s];
            line = lineArray[negLineIndex];
            yheight = this.Ch.vertical ? yneg[s] - y_zero_int : y_zero_int - yneg[s];
            if (this.Ch.vertical) {
                yLow = yHigh;
                yHigh = yLow + yheight;
            } else {
                yHigh = yLow;
                yLow -= yheight;
            }
            topBar = s == stackTopIndex;
            bottomBar = s == stackBottomIndex;
            if (this.Ch.vertical) {
                xx = x[index] + (int)Math.round(adjust_BarWidth);
                y = yLow;
                w = (int)barWidth;
                h = yheight;
            } else {
                xx = yLow;
                y = x[index] + (int)Math.round(adjust_BarWidth);
                w = yheight;
                h = (int)barWidth;
            }
            if (line.barStyle != 0) {
                effect3DBar.deriveColors(line.color, line.barShadowColorDerived, line.barShadowColor);
                if (this.Ch.vertical) {
                    this.DropShade.drawShadow(g2, line.color, effect3DBar, xx, y, w, h, positive, true, topBar, bottomBar, stackHeight);
                } else {
                    this.DropShade.drawShadowHorizontal(g2, line.color, effect3DBar, xx, y, w, h, false, topBar, bottomBar);
                }
            }
            g2.setColor(line.color);
            if (line.hilightIndex != -1 || line.popupIndex != -1) {
                int tempSeriesIndex = index;
                if (line.subFrequency) {
                    tempSeriesIndex = line.getSparseIndex(index);
                }
                if (line.popupIndex == tempSeriesIndex) {
                    int barXCenter = x[index] + (int)Math.round(adjust_BarWidth) + (int)(barWidth / 2.0);
                    this.storePopUp(g2, line.popupIndex, line, barXCenter, yHigh);
                }
                if (line.hilightIndex == tempSeriesIndex) {
                    g2.setColor(line.hilightColor);
                }
            }
            if (yheight > 0) {
                this.fillRectSvgXLink(g2, xx, y, w, h, line.svgSeriesD, indexBase);
            }
            if (this.Ch.genImageMapCoords) {
                int xCorner0 = xx;
                int yCorner0 = y;
                int xCorner1 = xCorner0 + w;
                int yCorner1 = yCorner0 + h;
                if (this.Ch.genImageMapCoords) {
                    this.copyImageMapRect(line, index, xCorner0, yCorner0, xCorner1, yCorner1);
                }
            }
            ++s;
        }
    }

    private void drawPositiveStackedBAR(Graphics2D g2, SubChartDescription sc, int[] x, LineDescription[] lineArray, int index_pos, int[] ypos, int[] yposLineIndex, int indexBase, int y_zero_int, double adjust_BarWidth) {
        int s;
        if (index_pos <= 0) {
            return;
        }
        int index = indexBase;
        if (!this.Ch.vertical) {
            index = x.length - indexBase - 1;
        }
        LineDescription line = lineArray[0];
        double barWidth = line.width;
        if (line.widthMax > 0.0 && line.width > line.widthMax) {
            barWidth = line.widthMax;
        }
        if (!this.Ch.continuousXAxis() && index + 1 < x.length && x[index + 1] - x[index] != this.IntervalWidth) {
            barWidth += (double)(x[index + 1] - x[index] - this.IntervalWidth);
        }
        int yLow = y_zero_int;
        int yHigh = y_zero_int;
        int yheight = 0;
        boolean topBar = false;
        boolean bottomBar = false;
        boolean positive = true;
        Effect3D effect3DBar = new Effect3D();
        int stackHeight = 0;
        int stackTopIndex = 0;
        int stackBottomIndex = -1;
        if (line.barStyle != 0) {
            s = 0;
            while (s < index_pos) {
                yheight = this.Ch.vertical ? y_zero_int - ypos[s] : ypos[s] - y_zero_int;
                stackHeight += yheight;
                if (yheight > 0) {
                    stackTopIndex = s;
                }
                if (stackBottomIndex == -1 && yheight > 0) {
                    stackBottomIndex = s;
                }
                ++s;
            }
        }
        s = 0;
        while (s < index_pos) {
            int h;
            int w;
            int y;
            int xx;
            int posLineIndex = yposLineIndex[s];
            line = lineArray[posLineIndex];
            if (this.Ch.vertical) {
                yheight = y_zero_int - ypos[s];
                yHigh = yLow = yHigh - yheight;
            } else {
                yLow = yHigh;
                yheight = ypos[s] - y_zero_int;
                yHigh = yLow + yheight;
            }
            if (this.Ch.vertical) {
                xx = x[index] + (int)Math.round(adjust_BarWidth);
                y = yHigh;
                w = (int)barWidth;
                h = yheight;
            } else {
                xx = yLow;
                y = x[index] + (int)Math.round(adjust_BarWidth);
                w = yheight;
                h = (int)barWidth;
            }
            topBar = s == stackTopIndex;
            bottomBar = s == stackBottomIndex;
            if (line.barStyle != 0 && yheight > 0) {
                effect3DBar.deriveColors(line.color, line.barShadowColorDerived, line.barShadowColor);
                if (this.Ch.vertical) {
                    this.DropShade.drawShadow(g2, line.color, effect3DBar, xx, y, w, h, positive, true, topBar, bottomBar, stackHeight);
                } else {
                    this.DropShade.drawShadowHorizontal(g2, line.color, effect3DBar, xx, y, w, h, true, topBar, bottomBar);
                }
            }
            g2.setColor(line.color);
            if (line.hilightIndex != -1 || line.popupIndex != -1) {
                int tempSeriesIndex = index;
                if (line.subFrequency) {
                    tempSeriesIndex = line.getSparseIndex(index);
                }
                if (line.popupIndex == tempSeriesIndex) {
                    int barXCenter = x[index] + (int)Math.round(adjust_BarWidth) + (int)(barWidth / 2.0);
                    this.storePopUp(g2, line.popupIndex, line, barXCenter, yHigh);
                }
                if (line.hilightIndex == tempSeriesIndex) {
                    g2.setColor(line.hilightColor);
                }
            }
            if (yheight > 0) {
                this.fillRectSvgXLink(g2, xx, y, w, h, line.svgSeriesD, indexBase);
            }
            if (this.Ch.genImageMapCoords) {
                int xCorner0 = xx;
                int yCorner0 = y;
                int xCorner1 = xCorner0 + w;
                int yCorner1 = yCorner0 + h;
                if (this.Ch.genImageMapCoords) {
                    this.copyImageMapRect(line, index, xCorner0, yCorner0, xCorner1, yCorner1);
                }
            }
            ++s;
        }
    }

    protected void setPlotWidthHBar(SubChartDescription sc) {
        sc.HLayout.plotWidth = this.Ch.displayWidth - this.Ch.border_left - this.Ch.border_right - sc.HLayout.labelXSpaceRight - sc.HLayout.labelXSpaceLeft;
    }

    int getBarLengthDC(SubChartDescription sc, double xcoord) {
        double xcoord_abs = Math.abs(xcoord);
        int width = (int)Math.round(xcoord_abs * sc.HLayout.plotWidth / sc.YAxis1.yAxisMet.y_coordinate_spread);
        return width;
    }

    private int getHorizontalBarCount(SubChartDescription sc) {
        int numBars = 0;
        int s = 0;
        while (s < sc.plotLineDes.size()) {
            LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
            switch (line.lineType) {
                case 4: 
                case 5: {
                    ++numBars;
                }
            }
            ++s;
        }
        return numBars;
    }

    private void assignLabelXSpaceLeftHBar() {
        int barCount;
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        boolean allPositive = false;
        boolean allNegative = false;
        if (sc.YAxis1.yAxisMet.Ymax > 0.0 && sc.YAxis1.yAxisMet.Ymin >= 0.0) {
            allPositive = true;
        }
        if (sc.YAxis1.yAxisMet.Ymin < 0.0 && sc.YAxis1.yAxisMet.Ymax <= 0.0) {
            allNegative = true;
        }
        if (!allPositive && !allNegative && (barCount = this.getHorizontalBarCount(sc)) >= 2) {
            allPositive = true;
            this.Ch.containsMultiplePosNegHBars = true;
        }
        if (allPositive) {
            sc.HLayout.labelXSpaceLeft = sc.HLayout.maxPosLabelWidth;
            sc.HLayout.labelXSpaceRight = 0;
            sc.HLayout.longestPosPointLabelWidth = this.getLongestBarPointLabel(true);
            sc.HLayout.longestPosBarIconWidth = this.getLongestBarIcon(true);
            return;
        }
        if (allNegative) {
            sc.HLayout.labelXSpaceRight = sc.HLayout.maxNegLabelWidth;
            sc.HLayout.labelXSpaceLeft = 0;
            sc.HLayout.longestNegPointLabelWidth = this.getLongestBarPointLabel(false);
            sc.HLayout.longestNegBarIconWidth = this.getLongestBarIcon(false);
            return;
        }
        if (sc.YAxis1.yAxisMet.Ymin < 0.0) {
            sc.HLayout.longestNegPointLabelWidth = this.getLongestBarPointLabel(false);
            sc.HLayout.longestNegBarIconWidth = this.getLongestBarIcon(false);
            sc.HLayout.labelXSpaceLeft = 0;
            this.setPlotWidthHBar(sc);
            int longestNegativeBar = this.getBarLengthDC(sc, sc.YAxis1.yAxisMet.Ymin);
            if (sc.HLayout.maxPosLabelWidth > longestNegativeBar) {
                longestNegativeBar = this.Ch.displayWidth - sc.HLayout.maxPosLabelWidth - sc.HLayout.labelXSpaceRight - super.getBorderRight() - super.getBorderLeft();
                double longestPosBar = (double)longestNegativeBar * Math.abs(sc.YAxis1.yAxisMet.Ymin) / sc.YAxis1.yAxisMet.Ymax;
                sc.HLayout.labelXSpaceLeft = sc.HLayout.maxPosLabelWidth - (int)longestPosBar;
            } else {
                sc.HLayout.labelXSpaceLeft = 0;
            }
        }
        if (sc.YAxis1.yAxisMet.Ymax > 0.0) {
            sc.HLayout.longestPosPointLabelWidth = this.getLongestBarPointLabel(true);
            sc.HLayout.longestPosBarIconWidth = this.getLongestBarIcon(true);
            sc.HLayout.labelXSpaceRight = 0;
            this.setPlotWidthHBar(sc);
            int longestPositiveBar = this.getBarLengthDC(sc, sc.YAxis1.yAxisMet.Ymax);
            if (sc.HLayout.maxNegLabelWidth > longestPositiveBar) {
                longestPositiveBar = this.Ch.displayWidth - sc.HLayout.maxNegLabelWidth - sc.HLayout.labelXSpaceLeft - super.getBorderRight() - super.getBorderLeft();
                double longestNegBar = (double)longestPositiveBar * sc.YAxis1.yAxisMet.Ymax / Math.abs(sc.YAxis1.yAxisMet.Ymin);
                sc.HLayout.labelXSpaceRight = sc.HLayout.maxNegLabelWidth - (int)longestNegBar;
            } else {
                sc.HLayout.labelXSpaceRight = 0;
            }
        }
    }

    private int getLongestBarPointLabel(boolean positive) {
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        int labelWidth = 0;
        double chosen_y = 0.0;
        int chosen_index = 0;
        chosen_y = positive ? -1.0 : 1.0;
        int s = 0;
        while (s < sc.plotLineDes.size()) {
            LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
            if (line.pointLabelsOn) {
                int i = 0;
                while (i < line.num_points) {
                    if (positive) {
                        if (line.yval[i] > chosen_y) {
                            chosen_y = line.yval[i];
                            chosen_index = i;
                        }
                    } else if (line.yval[i] < chosen_y) {
                        chosen_y = line.yval[i];
                        chosen_index = i;
                    }
                    ++i;
                }
                int baseline = this.getYBaselineInt(sc);
                int barLength = 0;
                if (positive && chosen_y >= 0.0 || !positive && chosen_y < 0.0) {
                    if (line.pointLabelsInterior) {
                        int tempLabelWidth = line.fontmet.stringWidth(line.pointLabels[chosen_index]);
                        this.setPlotWidthHBar(sc);
                        barLength = this.getBarLengthDC(sc, line.yval[chosen_index]);
                        if ((tempLabelWidth += sc.HLayout.padCharWidthPointLabels) > barLength) {
                            labelWidth = tempLabelWidth;
                        }
                    } else {
                        labelWidth = line.fontmet.stringWidth(line.pointLabels[chosen_index]);
                        labelWidth += 2 * sc.HLayout.padCharWidthPointLabels;
                    }
                }
            }
            ++s;
        }
        return labelWidth;
    }

    private int getLongestBarIcon(boolean positive) {
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        int imageWidth = 0;
        double chosen_y = 0.0;
        int chosen_index = 0;
        chosen_y = positive ? -1.0 : 1.0;
        int s = 0;
        while (s < sc.plotLineDes.size()) {
            LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
            if (line.containsBarIcons) {
                int i = 0;
                while (i < line.num_points) {
                    if (positive) {
                        if (line.yval[i] > chosen_y) {
                            chosen_y = line.yval[i];
                            chosen_index = i;
                        }
                    } else if (line.yval[i] < chosen_y) {
                        chosen_y = line.yval[i];
                        chosen_index = i;
                    }
                    ++i;
                }
                int baseline = this.getYBaselineInt(sc);
                boolean barLength = false;
                if (positive && chosen_y >= 0.0 || !positive && chosen_y < 0.0) {
                    imageWidth = line.barIcons.length > chosen_index ? (line.barIcons[chosen_index] != null ? line.barIcons[chosen_index].getWidth() : 0) : 0;
                }
            }
            ++s;
        }
        return imageWidth;
    }

    private void computeMaxLabelWidthHBar(Graphics2D g2) {
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        int maxPosLabelWidth = 0;
        int maxNegLabelWidth = 0;
        int currentLabelWidth = 0;
        String labelString = this.Ch.XStringLabel[0];
        FontRenderContext frc = g2.getFontRenderContext();
        currentLabelWidth = LabelUtil.getStringLabelWidth(labelString, this.sl.stringAxisD, frc, this.sl.fontmet);
        int s = 0;
        while (s < sc.plotLineDes.size()) {
            LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
            int maxElements = Math.min(this.Ch.labelXCount, line.yval.length);
            int k = 0;
            while (k < maxElements) {
                labelString = this.Ch.XStringLabel[k];
                currentLabelWidth = LabelUtil.getStringLabelWidth(labelString, this.sl.stringAxisD, frc, this.sl.fontmet);
                if (line.yval[k] < 0.0) {
                    if (currentLabelWidth > maxNegLabelWidth) {
                        maxNegLabelWidth = currentLabelWidth;
                    }
                } else if (currentLabelWidth > maxPosLabelWidth) {
                    maxPosLabelWidth = currentLabelWidth;
                }
                ++k;
            }
            ++s;
        }
        sc.HLayout.maxPosLabelWidth = maxPosLabelWidth;
        sc.HLayout.maxNegLabelWidth = maxNegLabelWidth;
        if (sc.HLayout.maxPosLabelWidth > 0) {
            sc.HLayout.maxPosLabelWidth += sc.HLayout.padCharWidthBaseLabels;
        }
        if (sc.HLayout.maxNegLabelWidth > 0) {
            sc.HLayout.maxNegLabelWidth += sc.HLayout.padCharWidthBaseLabels;
        }
    }

    private void deriveBorderBottomXL(Graphics2D g2, boolean countLegend) {
        int labelHeight;
        int labelAscent;
        if (!this.xl.timeAxisD.getDrawLabel()) {
            return;
        }
        g2.setFont(this.xl.timeAxisD.getFont());
        if (this.Ch.labelXCount > 0) {
            labelAscent = this.sl.fontmet.getAscent();
            labelHeight = this.sl.stringAxisD.getTextRotation() != 0.0 ? (int)StringLabel.getRotatedTextHeight(g2, this.Ch, this.sl.fontmet, this.sl.stringAxisD) + this.sl.fontmet.getHeight() : LabelUtil.getStringLabelHeight("Template", this.sl.stringAxisD, g2.getFontRenderContext(), this.sl.fontmet);
        } else {
            labelAscent = this.xl.fontmet.getAscent();
            labelHeight = this.xl.fontmet.getHeight();
        }
        int border_whitespace = labelAscent;
        this.Ch.border_xaxis_spacer = border_whitespace / 2;
        if (this.Ch.UserXLabelSet || this.Ch.labelXCount > 0 || this.Ch.continuousNumXAxis) {
            if (this.Ch.vertical) {
                this.Ch.border_bottom = labelHeight;
                if (this.AxisT.titleDescX.getTitle() != "") {
                    this.Ch.border_bottom += this.AxisT.XAxisTitleFontmet.getHeight();
                    this.AxisT.yOffset = labelHeight;
                }
                if (this.DrawOutsideLegend && this.SubChZero.L2.getLegendDesc().getLegendAlignment() == 4) {
                    this.Ch.border_bottom += 3;
                }
                this.Ch.border_xaxis = this.Ch.border_bottom;
            } else {
                if (AxisCore.super.getFootnote().getText() == null) {
                    return;
                }
                this.Ch.border_bottom = 0;
            }
        } else if (this.xl.timeAxisD.getAxisAlignment() == 1) {
            int numLevels = this.getNumXLLevels();
            this.Ch.border_bottom = numLevels * labelHeight;
            if (this.AxisT.titleDescX.getTitle() != "") {
                int axisTitleHeight = this.AxisT.XAxisTitleFontmet.getHeight();
                this.Ch.border_bottom += axisTitleHeight;
                this.AxisT.yOffset = numLevels * labelHeight;
            }
            this.Ch.border_xaxis = this.Ch.border_bottom;
        }
        int ySpaceForLegend = 0;
        if (countLegend) {
            int XPositionOfBottomInvariantLabel = -1;
            if (this.DrawOutsideLegend && this.SubChZero.L2.getLegendDesc().getLegendAlignment() == 4) {
                boolean optimize = true;
                if (this.Ch.UserXLabelSet || this.Ch.labelXCount > 0) {
                    optimize = false;
                }
                XPositionOfBottomInvariantLabel = this.xl.getLastLevelXPosition(g2, this.getXScaleConstant());
                int availableWidth = this.Ch.displayWidth - XPositionOfBottomInvariantLabel - this.InvPad;
                if (this.myGetLegendWidth(g2) > availableWidth) {
                    optimize = false;
                }
                if (optimize && XPositionOfBottomInvariantLabel != -1 && this.AxisT.titleDescX.getTitle() == "") {
                    ySpaceForLegend = this.myGetLegendHeight() + 5 - labelHeight;
                    this.Ch.border_bottom += ySpaceForLegend;
                } else {
                    ySpaceForLegend = this.myGetLegendHeight() + 3;
                    this.Ch.border_bottom += ySpaceForLegend;
                }
            } else {
                this.Ch.border_bottom += border_whitespace;
            }
        }
        if (AxisCore.super.getFootnote().getText() != "") {
            int additionalSpace = 0;
            if (this.DrawOutsideLegend && this.SubChZero.L2.getLegendDesc().getLegendAlignment() == 4) {
                if (this.Ch.southLegendRows > 0) {
                    this.positionLegendAboveFootnote(g2);
                } else {
                    additionalSpace = AxisCore.super.getFootnote().getHeight() + border_whitespace - ySpaceForLegend;
                    if (additionalSpace > 0) {
                        this.Ch.border_bottom += additionalSpace;
                    }
                }
            } else {
                this.Ch.border_bottom += AxisCore.super.getFootnote().getHeight();
            }
        }
        this.setBorderBottomInternal(this.Ch.border_bottom);
        this.resetDisplaySize();
    }

    private int getNumXLLevels() {
        int numLevels = this.xl.XLabelDimension.size();
        if (numLevels < this.xl.minNumLabelingLines) {
            numLevels = this.xl.minNumLabelingLines;
        }
        if (this.xl.timeAxisD.getDayOfWeek() && this.xl.containsDayLabels) {
            ++numLevels;
        }
        return numLevels;
    }

    protected void deriveBARWidth(LineDescription line) {
        double bar_width;
        double deviceMeasure = 0.0;
        SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(0);
        deviceMeasure = this.Ch.vertical ? sc.xAxisWidth : sc.Displayheight;
        if (!this.Ch.continuousXAxis()) {
            double denominator = this.Ch.XAxisCount;
            bar_width = deviceMeasure / denominator * line.BarThicknessPct;
        } else {
            deviceMeasure = sc.xAxisWidth - (double)this.Ch.border_time_extra;
            bar_width = deviceMeasure * line.minXInterval * line.BarThicknessPct;
        }
        if (bar_width < 2.0) {
            bar_width = 2.0;
        }
        line.width = bar_width;
    }

    private boolean isChanged(int firstLevelField, int lastLevelField) {
        System.out.println("isChanged " + firstLevelField + " " + lastLevelField);
        int lev = firstLevelField;
        while (lev <= lastLevelField) {
            DimensionElement current = (DimensionElement)this.FreqDim.elementAt(lev);
            int current_field_modulus = this.C.get(current.field);
            if (current_field_modulus != current.field_modulus) {
                return true;
            }
            ++lev;
        }
        System.out.println("not changed ");
        return false;
    }

    private void test(myfcn f) {
    }

    private int LookupSeriesCurrentSubchart(String seriesName) {
        int s = 0;
        while (s < this.SubCh.plotLineDes.size()) {
            LineDescription line = (LineDescription)this.SubCh.plotLineDes.elementAt(s);
            if (line.seriesName.equals(seriesName)) {
                return s;
            }
            ++s;
        }
        return -1;
    }

    protected int LookupSeries(String seriesName) {
        int i = 0;
        while (i < this.Ch.SC.size()) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(i);
            int s = 0;
            while (s < sc.plotLineDes.size()) {
                LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
                if (line.seriesName.equals(seriesName)) {
                    this.SubCh = sc;
                    return s;
                }
                ++s;
            }
            ++i;
        }
        return -1;
    }

    protected void assignSeriesColorPalette() {
        int seriesNumber = 0;
        int i = 0;
        while (i < this.Ch.SC.size()) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(i);
            int s = 0;
            while (s < sc.plotLineDes.size()) {
                LineDescription line = (LineDescription)sc.plotLineDes.elementAt(s);
                if (!line.colorSelectivelySet) {
                    line.color = this.Ch.seriesColors[seriesNumber];
                }
                this.SubChZero.L2.setLegendItemColor(line.seriesName, line.color);
                ++seriesNumber;
                seriesNumber %= this.Ch.seriesColors.length;
                ++s;
            }
            ++i;
        }
    }

    private void displayLine() {
        int s = 0;
        while (s < this.Ch.SC.size()) {
            SubChartDescription subchart = (SubChartDescription)this.Ch.SC.elementAt(s);
            s = 0;
            while (s < subchart.plotLineDes.size()) {
                LineDescription line = (LineDescription)subchart.plotLineDes.elementAt(s);
                System.out.println(line.seriesName);
                ++s;
            }
            ++s;
        }
    }

    private int LookupFreqDim(String dimensionName) {
        int i = 0;
        while (i < this.FreqDim.size()) {
            DimensionElement e = (DimensionElement)this.FreqDim.elementAt(i);
            if (e.name.equals(dimensionName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void setField(String dimensionName, int field) {
        int index = this.LookupFreqDim(dimensionName);
        if (index == -1) {
            return;
        }
        DimensionElement e = (DimensionElement)this.FreqDim.elementAt(index);
        e.field = field;
    }

    private void reInitFreqDim() {
        if (this.Ch.TStamps[0] != null) {
            this.C.setTime(this.Ch.TStamps[0]);
        }
        int i = 0;
        while (i < this.FreqDim.size()) {
            int hour_of_day;
            DimensionElement e = (DimensionElement)this.FreqDim.elementAt(i);
            e.field_modulus = this.C.get(e.field);
            e.field_modulus2 = this.C.get(e.field2);
            if (e.field == 10 && (hour_of_day = this.C.get(11)) >= 12) {
                e.ampmIndex = 1;
            }
            ++i;
        }
    }

    private boolean isAMPMLabels() {
        Timestamp startDate = Timestamp.valueOf("2005-05-23 14:00:00.000000000");
        DateFormat df = DateFormat.getTimeInstance(3, this.ChartLocale);
        String mystring = df.format(startDate);
        return mystring.length() >= 7;
    }

    protected void InitFreqDimPre() {
        this.FreqDim = new Vector();
        this.FreqDim.addElement(new DimensionElement("SECOND", 13, 1));
        this.FreqDim.addElement(new DimensionElement("MINUTE", 12, 2));
        int field = 0;
        field = this.isAMPMLabels() ? 10 : 11;
        this.FreqDim.addElement(new DimensionElement("HOUR", field, 3));
        this.FreqDim.addElement(new DimensionElement("DAY_OF_MONTH", 5, 4));
        this.FreqDim.addElement(new DimensionElement("MONTH", 2, XLabel.LABEL_MONTH_CHOICE));
        this.FreqDim.addElement(new DimensionElement("YEAR", 1, XLabel.LABEL_ANNUAL_CHOICE));
    }

    private void InitFreqDim() {
        DimensionElement e;
        Date initDate = java.sql.Date.valueOf("1996-01-01");
        if (this.Ch.TStamps.length > 0) {
            initDate = this.Ch.TStamps[0];
        }
        int i = 0;
        while (i < this.FreqDim.size()) {
            e = (DimensionElement)this.FreqDim.elementAt(i);
            e.chartLocale = this.ChartLocale;
            this.C.setTime(initDate);
            e.field_modulus = this.C.get(e.field);
            e.field_modulus2 = this.C.get(e.field2);
            e.setChoiceFieldLabels();
            ++i;
        }
        e = (DimensionElement)this.FreqDim.elementAt(2);
        e.setAmPm();
        e = (DimensionElement)this.FreqDim.elementAt(3);
        e.field2 = 7;
    }

    private void positionLegendAboveFootnote(Graphics2D g2) {
        int footHeight = AxisCore.super.getFootnote().getHeight();
        int yPad = 2 * this.SubChZero.L2.getLegendLabelHeight(g2) / 3;
        this.Ch.border_bottom += footHeight + yPad;
        this.SubChZero.L2.setLegendOffsetYInternal(-footHeight - yPad);
    }

    private Double getTempYMax(NumAxisRenderer yAxis) {
        Double tempymax = yAxis.yl.numAxisD.getFixedColumnWidthYMax() != Double.MIN_VALUE ? new Double(yAxis.yl.numAxisD.getFixedColumnWidthYMax()) : new Double(yAxis.yAxisMet.Ymax_non_adjusted);
        return tempymax;
    }

    private Double getTempYMin(NumAxisRenderer yAxis) {
        Double tempymin = yAxis.yl.numAxisD.getFixedColumnWidthYMin() != Double.MAX_VALUE ? new Double(yAxis.yl.numAxisD.getFixedColumnWidthYMin()) : new Double(yAxis.yAxisMet.Ymin_non_adjusted);
        return tempymin;
    }

    private int estimateMaxStringWidth(boolean leftSide) {
        boolean test = false;
        if (test) {
            System.out.println("");
        }
        if (test) {
            System.out.println("estimateMaxStringWidth " + leftSide);
        }
        String max_ylabel = "";
        String min_ylabel = "";
        int string_width_max_ylabel = 0;
        int string_width_min_ylabel = 0;
        int max_string_width = 0;
        int k = 0;
        while (k < this.Ch.SC.size()) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(k);
            NumAxisRenderer yAxis = sc.YAxis1;
            if (sc.dualAxis && !leftSide) {
                yAxis = sc.YAxis2;
            }
            if (yAxis.yl.numAxisD.getLabelLocation() == 2 || yAxis.yl.numAxisD.getLabelLocation() == 0 && leftSide || yAxis.yl.numAxisD.getLabelLocation() == 1 && !leftSide) {
                if (test) {
                    System.out.println("estimatemaxstringwidth " + sc.subchart_name);
                }
                if (yAxis.yl.numAxisD.getFixedColumnWidthPixels() > -1) {
                    string_width_max_ylabel = yAxis.yl.numAxisD.getFixedColumnWidthPixels();
                    string_width_min_ylabel = 0;
                } else {
                    Double tempymax = this.getTempYMax(yAxis);
                    Double tempymin = this.getTempYMin(yAxis);
                    max_ylabel = Double.toString(tempymax.intValue());
                    min_ylabel = Double.toString(tempymin.intValue());
                    max_ylabel = yAxis.yl.numAxisD.getPrefix() + max_ylabel + yAxis.yl.numAxisD.getSuffix();
                    string_width_max_ylabel = yAxis.yl.fontmet.stringWidth(max_ylabel);
                    string_width_min_ylabel = yAxis.yl.fontmet.stringWidth(min_ylabel);
                }
                if (max_string_width < string_width_max_ylabel) {
                    max_string_width = string_width_max_ylabel;
                }
                if (max_string_width < string_width_min_ylabel) {
                    max_string_width = string_width_min_ylabel;
                }
            }
            ++k;
        }
        if (test) {
            System.out.println("estimatemaxstringwidth return max_string_width " + max_string_width);
        }
        if (test) {
            System.out.println("estimatemaxstringwidth labels " + min_ylabel + " " + max_ylabel);
        }
        return max_string_width;
    }

    private int getMaxStringWidth(boolean leftside) {
        boolean test = false;
        String yLabel = "";
        String save_yLabel = "";
        int max_string_width = 0;
        int k = 0;
        while (k < this.Ch.SC.size()) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(k);
            NumAxisRenderer yAxis = sc.YAxis1;
            if (sc.dualAxis && !leftside) {
                yAxis = sc.YAxis2;
            }
            NumAxisStretch ys = yAxis.StretchY;
            if (yAxis.yl.numAxisD.getFixedColumnWidthPixels() > -1) {
                return yAxis.yl.numAxisD.getFixedColumnWidthPixels();
            }
            if (yAxis.yl.numAxisD.getFixedColumnWidthYMin() != Double.MAX_VALUE || yAxis.yl.numAxisD.getFixedColumnWidthYMax() != Double.MIN_VALUE) {
                Double tempymax = this.getTempYMax(yAxis);
                Double tempymin = this.getTempYMin(yAxis);
                String max_ylabel = NumericalFormat.formatNumber2(this.ChartLocale, yAxis.yl.numAxisD, tempymax);
                String min_ylabel = NumericalFormat.formatNumber2(this.ChartLocale, yAxis.yl.numAxisD, tempymin);
                max_string_width = Math.max(yAxis.yl.fontmet.stringWidth(max_ylabel), yAxis.yl.fontmet.stringWidth(min_ylabel));
            } else if (yAxis.yl.numAxisD.getDrawLabel() && (yAxis.yl.numAxisD.getLabelLocation() == 2 || yAxis.yl.numAxisD.getLabelLocation() == 0 && leftside || yAxis.yl.numAxisD.getLabelLocation() == 1 && !leftside)) {
                int i = 0;
                while (i < ys.vgrid_y.size()) {
                    int string_width;
                    Double tempdouble = (Double)ys.vgrid_y.elementAt(i);
                    yLabel = (String)ys.vgrid_yString.elementAt(i);
                    if (i == ys.vgrid_y.size() - 1) {
                        yLabel = yAxis.yl.numAxisD.getPrefix() + yLabel + yAxis.yl.numAxisD.getSuffix();
                    }
                    if ((string_width = yAxis.yl.fontmet.stringWidth(yLabel)) > max_string_width) {
                        max_string_width = string_width;
                        save_yLabel = yLabel;
                    }
                    ++i;
                }
            }
            ++k;
        }
        if (test) {
            System.out.println("getmaxstringwidth labels " + yLabel);
        }
        return max_string_width;
    }

    private void deriveBorderRight(Graphics2D g2, boolean exact, int labelHeight) {
        SubChartDescription sc;
        boolean test = false;
        if (!this.Ch.vertical) {
            return;
        }
        if (AxisCore.super.isBorderRightSet()) {
            return;
        }
        int max_string_width = 0;
        int border_whitespace = labelHeight;
        boolean has_right_label = false;
        int k = 0;
        while (k < this.Ch.SC.size()) {
            sc = (SubChartDescription)this.Ch.SC.elementAt(k);
            if (sc.dualAxis || sc.YAxis1.yl.numAxisD.getLabelLocation() == 1 || sc.YAxis1.yl.numAxisD.getLabelLocation() == 2) {
                has_right_label = true;
                break;
            }
            ++k;
        }
        if (AxisCore.super.isBorderRightSet()) {
            // empty if block
        }
        if (!AxisCore.super.isBorderRightSet()) {
            if (has_right_label) {
                max_string_width = exact ? this.getMaxStringWidth(false) : this.estimateMaxStringWidth(false);
                this.Ch.border_right = max_string_width + border_whitespace;
                if (this.DrawOutsideLegend) {
                    if (this.SubChZero.L2.getLegendDesc().getLegendAlignment() == 3 || this.SubChZero.L2.getLegendDesc().getLegendAlignment() == 10) {
                        this.Ch.border_right += this.myGetLegendWidth(g2);
                        this.Ch.legendWidth = this.SubChZero.L2.getLegendWidth(g2);
                    } else if (this.SubChZero.L2.getLegendDesc().getLegendAlignment() == 11) {
                        this.Ch.legendWidth = this.getLegendWidthAllSubcharts(g2);
                        this.Ch.border_right += this.Ch.legendWidth;
                    }
                }
            } else {
                if (this.Ch.continuousNumXAxis) {
                    sc = (SubChartDescription)this.Ch.SC.elementAt(0);
                    int maxLabelWidth = this.estimateMaxStringWidthHorizontalNumerical(this.Ch.NumXAxis, sc.YAxis1.yl.numAxisD, 1);
                    int halfWidth = (maxLabelWidth + 3) / 2;
                    if (this.Ch.border_right < halfWidth) {
                        this.Ch.border_right = halfWidth;
                        AxisCore.super.setBorderRightInternal(this.Ch.border_right);
                    }
                } else if (this.xl.prependHoursToMinutes || this.xl.prependHoursMinutesToSeconds) {
                    int labelWidth = 0;
                    if (this.xl.prependHoursMinutesToSeconds) {
                        labelWidth = this.xl.fontmet.stringWidth("00:00:00") / 2 + 5;
                    } else if (this.xl.prependHoursToMinutes) {
                        labelWidth = this.xl.fontmet.stringWidth("00:00") / 2 + 5;
                    }
                    this.Ch.border_right = border_whitespace < labelWidth ? labelWidth : border_whitespace;
                } else {
                    this.Ch.border_right = border_whitespace;
                }
                if (!this.SubChZero.L2.getLegendDisableInternal() && this.DrawOutsideLegend) {
                    if (this.SubChZero.L2.getLegendDesc().getLegendAlignment() == 3 || this.SubChZero.L2.getLegendDesc().getLegendAlignment() == 10) {
                        this.Ch.border_right = this.myGetLegendWidth(g2) + 3;
                    } else if (this.SubChZero.L2.getLegendDesc().getLegendAlignment() == 11) {
                        this.Ch.legendWidth = this.Ch.border_right = this.getLegendWidthAllSubcharts(g2);
                    }
                }
                if (this.Ch.labelXCount > 0) {
                    int lastLabelWidth = (int)StringLabel.getRotatedTextWidthLastLabel(g2, this.Ch, this.sl.fontmet, this.sl.stringAxisD);
                    double llw = lastLabelWidth;
                    lastLabelWidth = (int)Math.round(llw *= 1.2);
                    boolean pad_space = false;
                    SubChartDescription sc2 = (SubChartDescription)this.Ch.SC.elementAt(0);
                    double overflow = (double)this.xval_int[this.Ch.labelXCount - 1] + this.getHalfIntervalDC(sc2) + (double)lastLabelWidth + (double)pad_space - (double)this.Ch.displayWidth;
                    if (overflow > 0.0 && overflow < (double)this.Ch.displayWidth) {
                        this.Ch.border_right = (int)((double)this.Ch.border_right + overflow);
                    }
                }
            }
            if (exact) {
                AxisCore.super.setBorderRightInternal(this.Ch.border_right);
            }
        }
        this.resetDisplaySize();
    }

    private void deriveBorderLeft(boolean exact, int labelHeight) {
        if (!this.Ch.vertical) {
            this.resetDisplaySize();
            return;
        }
        if (AxisCore.super.isBorderLeftSet()) {
            return;
        }
        boolean test = false;
        if (test) {
            System.out.println();
        }
        if (test) {
            System.out.println("deriveBorderLeft ");
        }
        if (test) {
            System.out.println("deriveBorderLeft drawLabel ");
        }
        int max_string_width = 0;
        int border_whitespace = labelHeight;
        boolean has_left_label = false;
        int k = 0;
        while (k < this.Ch.SC.size()) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(k);
            if (sc.dualAxis || sc.YAxis1.yl.numAxisD.getLabelLocation() == 0 || sc.YAxis1.yl.numAxisD.getLabelLocation() == 2) {
                has_left_label = true;
                break;
            }
            ++k;
        }
        if (!AxisCore.super.isBorderLeftSet()) {
            if (has_left_label) {
                if (exact) {
                    max_string_width = this.getMaxStringWidth(true);
                    if (test) {
                        System.out.println("EXACT: " + max_string_width);
                    }
                } else {
                    max_string_width = this.estimateMaxStringWidth(true);
                    if (test) {
                        System.out.println("ESTIMATE: " + max_string_width);
                    }
                }
                this.Ch.border_left = max_string_width + border_whitespace;
                if (this.AxisT.titleDescY.getTitle() != "") {
                    this.Ch.border_left += this.AxisT.YAxisTitleFontmet.getHeight();
                }
            } else {
                this.Ch.border_left = border_whitespace;
            }
            if (exact) {
                AxisCore.super.setBorderLeftInternal(this.Ch.border_left);
            }
        }
        this.resetDisplaySize();
    }

    private int estimateMaxStringWidthHorizontalNumerical(NumAxisRenderer yaxis, NumAxisDesc numAxisD, int calculate) {
        boolean test = false;
        String max_ylabel = "";
        String min_ylabel = "";
        int string_width_max_ylabel = 0;
        int string_width_min_ylabel = 0;
        int max_string_width = 0;
        NumAxisLabel yl = yaxis.yl;
        if (!yl.numAxisD.getDrawLabel()) {
            return 0;
        }
        if (yl.numAxisD.getDrawLabel()) {
            Double tempYmax = new Double(yaxis.yAxisMet.Ymax_non_adjusted);
            Double tempYmin = new Double(yaxis.yAxisMet.Ymin_non_adjusted);
            if (this.Ch.numXAxisNF != null) {
                if (calculate == 0 || calculate == 1) {
                    max_ylabel = this.Ch.numXAxisNF.format(tempYmax);
                }
                if (calculate == 0 || calculate == 2) {
                    min_ylabel = this.Ch.numXAxisNF.format(tempYmin);
                }
            } else {
                if (calculate == 0 || calculate == 1) {
                    max_ylabel = NumericalFormat.formatNumber2(this.ChartLocale, numAxisD, tempYmax);
                }
                if (calculate == 0 || calculate == 2) {
                    min_ylabel = NumericalFormat.formatNumber2(this.ChartLocale, numAxisD, tempYmin);
                }
            }
            if ((calculate == 0 || calculate == 1) && max_string_width < (string_width_max_ylabel = yaxis.yl.fontmet.stringWidth(max_ylabel))) {
                max_string_width = string_width_max_ylabel;
            }
            if ((calculate == 0 || calculate == 2) && max_string_width < (string_width_min_ylabel = yaxis.yl.fontmet.stringWidth(min_ylabel))) {
                max_string_width = string_width_min_ylabel;
            }
        }
        return max_string_width;
    }

    private int estimateMaxStringWidthHorizontal(boolean pos, NumAxisRenderer yaxis) {
        String max_ylabel = "";
        String min_ylabel = "";
        int string_width_max_ylabel = 0;
        int string_width_min_ylabel = 0;
        boolean max_string_width = false;
        NumAxisLabel yl = yaxis.yl;
        if (!yl.numAxisD.getDrawLabel()) {
            return 0;
        }
        Double tempYmax = new Double(yaxis.yAxisMet.Ymax_non_adjusted);
        Double tempYmin = new Double(yaxis.yAxisMet.Ymin_non_adjusted);
        min_ylabel = NumericalFormat.formatNumber2(this.ChartLocale, yaxis.yl.numAxisD, tempYmin);
        max_ylabel = NumericalFormat.formatNumber2(this.ChartLocale, yaxis.yl.numAxisD, tempYmax);
        max_ylabel = yl.numAxisD.getPrefix() + max_ylabel + yl.numAxisD.getSuffix();
        string_width_max_ylabel = yl.fontmet.stringWidth(max_ylabel);
        string_width_min_ylabel = yl.fontmet.stringWidth(min_ylabel);
        if (pos) {
            return string_width_max_ylabel;
        }
        return string_width_min_ylabel;
    }

    private void deriveBorderRightHorizontal(Graphics2D g2, SubChartDescription sc, NumAxisRenderer yaxis) {
        if (!this.Ch.vertical) {
            int rightMostLabelWidth = this.estimateMaxStringWidthHorizontal(true, yaxis);
            int halfWidth = (rightMostLabelWidth + 3) / 2;
            if (this.Ch.border_right < halfWidth) {
                this.Ch.border_right = halfWidth;
                AxisCore.super.setBorderRightInternal(this.Ch.border_right);
            }
            if (this.DrawOutsideLegend) {
                if (this.SubChZero.L2.getLegendDesc().getLegendAlignment() == 3 || this.SubChZero.L2.getLegendDesc().getLegendAlignment() == 10) {
                    this.Ch.border_right = this.myGetLegendWidth(g2) + 3;
                    AxisCore.super.setBorderRightInternal(this.Ch.border_right);
                } else if (this.SubChZero.L2.getLegendDesc().getLegendAlignment() == 11) {
                    this.Ch.border_right = this.getLegendWidthAllSubcharts(g2) + 3;
                    AxisCore.super.setBorderRightInternal(this.Ch.border_right);
                }
            }
            this.setPlotWidthHBar(sc);
            return;
        }
    }

    private void deriveBorderLeftHorizontal(SubChartDescription sc, NumAxisRenderer yaxis) {
        if (!this.Ch.vertical) {
            int leftMostLabelWidth = this.estimateMaxStringWidthHorizontal(false, yaxis);
            if (this.Ch.border_left < leftMostLabelWidth / 2) {
                this.Ch.border_left = leftMostLabelWidth / 2;
                if (this.AxisT.titleDescY.getTitle() != "") {
                    this.Ch.border_left += this.AxisT.YAxisTitleFontmet.getHeight() / 2;
                }
                AxisCore.super.setBorderLeftInternal(this.Ch.border_left);
            }
            this.setPlotWidthHBar(sc);
            return;
        }
    }

    private void deriveBorderBottom(Graphics2D g2, int labelHeight, boolean drawLabel) {
        if (AxisCore.super.isBorderBottomSet()) {
            return;
        }
        int labelWhiteSpace = labelHeight / 2;
        if (drawLabel) {
            int spaceForAxis = labelHeight + labelWhiteSpace;
            this.Ch.border_bottom = this.DrawOutsideLegend && this.SubChZero.L2.getLegendDesc().getLegendAlignment() == 4 ? this.myGetLegendHeight() + spaceForAxis : spaceForAxis;
            this.Ch.border_xaxis = spaceForAxis;
        } else {
            this.Ch.border_bottom = labelHeight;
            this.Ch.border_xaxis = labelHeight;
            if (this.DrawOutsideLegend && this.SubChZero.L2.getLegendDesc().getLegendAlignment() == 4) {
                this.Ch.border_bottom = this.myGetLegendHeight() + labelHeight;
            }
        }
        if (this.AxisT.titleDescX.getTitle() != "") {
            this.Ch.border_bottom += this.AxisT.XAxisTitleFontmet.getHeight();
            this.Ch.border_xaxis += this.AxisT.XAxisTitleFontmet.getHeight();
            this.AxisT.yOffset = labelHeight;
        }
        if (AxisCore.super.getFootnote().getText() != "") {
            if (this.DrawOutsideLegend && this.SubChZero.L2.getLegendDesc().getLegendAlignment() == 4) {
                if (this.Ch.southLegendRows > 0) {
                    this.positionLegendAboveFootnote(g2);
                }
                this.Ch.border_bottom -= labelHeight;
            }
            this.Ch.border_bottom += AxisCore.super.getFootnote().getHeight();
        }
        AxisCore.super.setBorderBottomInternal(this.Ch.border_bottom);
        this.resetDisplaySize();
    }

    private int myGetLegendHeight() {
        return this.SubChZero.L2.getLegendHeight();
    }

    private int myGetLegendWidth(Graphics2D g2) {
        return this.SubChZero.L2.getLegendWidth(g2);
    }

    private void mySetBorderBottomInternal(int bottom) {
        this.setBorderBottomInternal(bottom);
    }

    private int getLegendWidthAllSubcharts(Graphics2D g2) {
        int legendWidth = 0;
        int k = 0;
        while (k < this.Ch.SC.size()) {
            SubChartDescription sc = (SubChartDescription)this.Ch.SC.elementAt(k);
            if (sc.L2.getLegendWidth(g2) > legendWidth) {
                // empty if block
            }
            legendWidth = sc.L2.getLegendWidth(g2);
            ++k;
        }
        return legendWidth;
    }

    private void printSub(SubChartDescription sc) {
        System.out.println(" lwidth " + sc.L2.getLegendWidth());
        System.out.println(" legend x,y (" + sc.L2.getLegendX() + "," + sc.L2.getLegendY() + ")");
    }

    protected final class SubChartDescription {
        String subchart_name;
        protected Legend2 L2 = new Legend2();
        int XOrigin = 0;
        int YOrigin = 0;
        double Displayheight;
        double Displaywidth;
        double xAxisWidth;
        double halfBarPad = 0.0;
        double displaywidth2;
        double heightFraction = 1.0;
        double ymin_adjust = 5.0;
        double ymax_adjust = 5.0;
        double bottom_white_space_fract = 0.05;
        double top_white_space_fract = 0.05;
        double x_coordinate_spread = 0.0;
        double last_x_coordinate_spread = 0.0;
        Vector plotLineDes = new Vector();
        boolean emptyYSeries = false;
        Vector plotNumBandDesc = new Vector();
        Vector plotNumThresholdDesc = new Vector();
        Vector areaImageMapV = new Vector();
        boolean dualAxis = false;
        NumAxisRenderer YAxis1 = new NumAxisRenderer();
        NumAxisRenderer YAxis2 = new NumAxisRenderer();
        boolean containsBarType = false;
        boolean containsBarType3D = false;
        boolean containsBarTypeDropShadow = false;
        boolean containsStackedBar = false;
        boolean containsAreaCume = false;
        int stackedBarCount = 0;
        int areaCumeCount = 0;
        boolean generateNaNTimebands = false;
        HorizontalLayout HLayout = new HorizontalLayout();
        boolean containsPointLabels = false;
        boolean containsBarIcons = false;
    }

    private class myfcn
    extends LineDescription {
        int i;
        double[] newyval;

        private myfcn() {
            this.newyval = new double[this.num_points];
        }

        public void momentum(int k) {
            this.i = 0;
            while (this.i < k) {
                this.newyval[this.i] = 0.0;
                ++this.i;
            }
            this.i = k;
            while (this.i < this.num_points) {
                this.newyval[this.i] = this.yval[this.i] - this.yval[this.i - k];
                ++this.i;
            }
        }
    }

    private final class StackedBarContinuous {
        int numLines = 0;
        public int[] ypos;
        public int[] yneg;
        public int[] yposLineIndex;
        public int[] ynegLineIndex;
        int[] pointIndex;
        public int first_index_pos = -1;
        public int first_index_neg = -1;
        public int index_pos = 0;
        public int index_neg = 0;
        boolean[] done;
        LineDescription[] lineArray;

        public StackedBarContinuous(LineDescription[] lineArray) {
            this.lineArray = lineArray;
            this.numLines = lineArray.length;
            this.pointIndex = new int[this.numLines];
            this.done = new boolean[this.numLines];
            this.ypos = new int[this.numLines];
            this.yposLineIndex = new int[this.numLines];
            this.yneg = new int[this.numLines];
            this.ynegLineIndex = new int[this.numLines];
            int s = 0;
            while (s < this.numLines) {
                this.pointIndex[s] = 0;
                this.done[s] = false;
                ++s;
            }
        }

        public boolean next() {
            int p;
            int min = 100000;
            int s = 0;
            while (s < this.numLines) {
                if (this.pointIndex[s] < this.lineArray[s].xval_cont_int.length) {
                    p = this.lineArray[s].xval_cont_int[this.pointIndex[s]];
                    if (p < min) {
                        min = p;
                    }
                } else {
                    this.done[s] = true;
                }
                ++s;
            }
            boolean finished = true;
            int s2 = 0;
            while (s2 < this.numLines) {
                if (!this.done[s2]) {
                    finished = false;
                    break;
                }
                ++s2;
            }
            if (finished) {
                return false;
            }
            this.index_pos = 0;
            this.index_neg = 0;
            this.first_index_pos = -1;
            this.first_index_neg = -1;
            int s3 = 0;
            while (s3 < this.numLines) {
                if (!this.done[s3] && (p = this.lineArray[s3].xval_cont_int[this.pointIndex[s3]]) == min) {
                    if (this.lineArray[s3].yval[this.pointIndex[s3]] >= 0.0) {
                        if (this.first_index_pos == -1) {
                            this.first_index_pos = this.pointIndex[s3];
                        }
                        this.ypos[this.index_pos] = this.lineArray[s3].yval_int[this.pointIndex[s3]];
                        this.yposLineIndex[this.index_pos] = s3;
                        ++this.index_pos;
                    } else {
                        if (this.first_index_neg == -1) {
                            this.first_index_neg = this.pointIndex[s3];
                        }
                        this.yneg[this.index_neg] = this.lineArray[s3].yval_int[this.pointIndex[s3]];
                        this.ynegLineIndex[this.index_neg] = s3;
                        ++this.index_neg;
                    }
                    int n = s3;
                    this.pointIndex[n] = this.pointIndex[n] + 1;
                }
                ++s3;
            }
            return true;
        }
    }

    private final class PopUpData {
        public static final int STEM = 10;
        String text;
        int mouth_x;
        int mouth_y;
        int corner_x;
        int corner_y;
        short orientation;
        Annotation b = new Annotation();

        private PopUpData() {
        }

        public void PopUpData() {
        }

        public void paint(Graphics2D g2) {
            if (this.text != null) {
                this.b.setFont(AxisCore.this.AnnoDesc.getFont());
                this.b.getFMetrics(g2);
                this.b.drawballoon(g2, this.text, this.mouth_x, this.mouth_y, this.corner_x, this.corner_y, AxisCore.this.AnnoDesc.getForeground(), AxisCore.this.AnnoDesc.getBackground(), this.orientation);
            }
        }
    }

    protected final class StringLabelInternal {
        public StringAxisDesc stringAxisD = new StringAxisDesc();
        FontMetrics fontmet;

        protected StringLabelInternal() {
        }
    }

    private class MultiLineNaN {
        public boolean[] isNaNArray;
        public int[] yCume;
        public boolean[] isNaNArrayCume;

        private MultiLineNaN() {
        }

        public void print() {
            System.out.print(" cume (y) []: ");
            int i = 0;
            while (i < this.yCume.length) {
                System.out.print(" " + this.yCume[i]);
                ++i;
            }
            System.out.println("");
        }

        public void computeIsNaNArray(double[] yval) {
            int i = 0;
            while (i < yval.length) {
                this.isNaNArray[i] = Double.isNaN(yval[i]);
                ++i;
            }
        }

        public void printIsNaNArray() {
            System.out.print("isNaN[]: ");
            int i = 0;
            while (i < this.isNaNArray.length) {
                if (this.isNaNArray[i]) {
                    System.out.print("t ");
                } else {
                    System.out.print("f ");
                }
                ++i;
            }
            System.out.println("");
        }

        public void printIsNaNArrayCume() {
            System.out.print("isNaNCume[]: ");
            int i = 0;
            while (i < this.isNaNArrayCume.length) {
                if (this.isNaNArrayCume[i]) {
                    System.out.print("t ");
                } else {
                    System.out.print("f ");
                }
                ++i;
            }
            System.out.println("");
        }
    }

    private class MultiLineNaN2 {
        public int[] x;
        public int[] y;

        private MultiLineNaN2() {
        }

        public void print() {
            System.out.print(" inserted (x,y) []: ");
            int i = 0;
            while (i < this.x.length) {
                System.out.print("(" + this.x[i] + "," + this.y[i] + ") ");
                ++i;
            }
            System.out.println("");
        }

        public void plot(Graphics2D g2, Color c) {
            g2.setColor(c);
            int delta = 2;
            int i = 0;
            while (i < this.x.length) {
                g2.fillRect(this.x[i] - delta, this.y[i] - delta, 5, 5);
                ++i;
            }
        }
    }

    private static final class AreaChartIMap {
        public LineDescription line;
        public int[] x;
        public int[] y;
    }

    protected final class AnnoElement {
        String text = "";
        Date tstamp = null;
        int index = -1;
        double xval = -1.0;
        int rectXMin = 0;
        int rectYMin = 0;
        int rectXMax = 0;
        int rectYMax = 0;
        int xmouth = 0;
        int ymouth = 0;
        int x = 0;
        int y = 0;
        LineDescription lineD;
        public static final int PLACE_NORTH = 0;
        public static final int PLACE_SOUTH = 1;
        public static final int PLACE_EITHER = 2;
        public int YAboveBelow = 2;

        protected AnnoElement() {
        }
    }

    private final class StackedBarExtents {
        double ymin = Double.MAX_VALUE;
        double ymax = Double.NEGATIVE_INFINITY;
        int chartType = 5;

        private void initSpreads() {
            double ymin = Double.MAX_VALUE;
            double d = Double.NEGATIVE_INFINITY;
        }

        public StackedBarExtents(int chartType) {
            if (chartType != 5 && chartType != 3) {
                System.out.println("Internal Error - StackedBarExtents invoked with wrong chartType.");
            }
            this.chartType = chartType;
        }

        private void computeSpreads(SubChartDescription sc) throws ChartException {
            LineDescription[] stackedBarLineArray = AxisCore.this.getStackedBars(sc, this.chartType, false);
            int numXAxisPoints = AxisCore.this.Ch.TStampsCount;
            if (numXAxisPoints == 0) {
                numXAxisPoints = AxisCore.this.Ch.labelXCount;
            }
            int i = 0;
            while (i < numXAxisPoints) {
                double posSum = 0.0;
                double negSum = 0.0;
                int s = 0;
                while (s < stackedBarLineArray.length) {
                    int index = i;
                    if (stackedBarLineArray[s].subFrequency) {
                        index = stackedBarLineArray[s].getSparseIndex(i);
                    } else if (stackedBarLineArray[s].yval.length <= i) break;
                    if (index != -1) {
                        if (stackedBarLineArray[s].yval[index] >= 0.0) {
                            posSum += stackedBarLineArray[s].yval[index];
                        } else {
                            negSum += stackedBarLineArray[s].yval[index];
                        }
                    }
                    ++s;
                }
                if (posSum > this.ymax) {
                    this.ymax = posSum;
                }
                if (negSum < this.ymin) {
                    this.ymin = negSum;
                }
                ++i;
            }
        }

        private void computeSpreadsContinuous(SubChartDescription sc) throws ChartException {
            LineDescription[] stackedBarLineArray = AxisCore.this.getStackedBars(sc, this.chartType, false);
            int i = 0;
            while (i < stackedBarLineArray[0].contDates.length) {
                double posSum = 0.0;
                double negSum = 0.0;
                int s = 0;
                while (s < stackedBarLineArray.length) {
                    if (stackedBarLineArray[s].yval.length <= i) break;
                    if (stackedBarLineArray[s].yval[i] >= 0.0) {
                        posSum += stackedBarLineArray[s].yval[i];
                    } else {
                        negSum += stackedBarLineArray[s].yval[i];
                    }
                    if (posSum > this.ymax) {
                        this.ymax = posSum;
                    }
                    if (negSum < this.ymin) {
                        this.ymin = negSum;
                    }
                    ++s;
                }
                ++i;
            }
        }
    }

    private final class AdjustTime {
        Date startDate;
        Date[] extraDates = new Date[1];

        public AdjustTime(Date startDate) {
            this.startDate = startDate;
            this.extraDates[0] = startDate;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public Date[] getExtraDates() {
            return this.extraDates;
        }

        public boolean adjustTime() {
            int extraHours;
            double ratio;
            int extraMinutes;
            double ratio2;
            long spanSeconds = AxisCore.this.getSpanSeconds();
            long spanMinutes = AxisCore.this.getSpanMinutes();
            long spanHours = AxisCore.this.getSpanHours();
            AxisCore.this.C.setTime(this.startDate);
            boolean extra = false;
            int extraSeconds = AxisCore.this.C.get(13);
            int spanCutoffHours = 120;
            if (extraSeconds != 0 && (ratio2 = (double)spanSeconds / (60.0 - (double)extraSeconds)) > 10.0) {
                extra = true;
                AxisCore.this.C.add(13, 60 - extraSeconds);
                this.startDate = AxisCore.this.C.getTime();
            }
            if ((extraMinutes = AxisCore.this.C.get(12)) != 0 && (ratio = (double)spanMinutes / (60.0 - (double)extraMinutes)) > 10.0) {
                extra = true;
                AxisCore.this.C.add(12, 60 - extraMinutes);
                this.startDate = AxisCore.this.C.getTime();
            }
            if ((extraHours = AxisCore.this.C.get(10)) != 0 && spanHours > 120L) {
                extra = true;
                if (extraHours > 12) {
                    AxisCore.this.C.add(10, 24 - extraHours);
                } else {
                    AxisCore.this.C.add(10, 12 - extraHours);
                }
                this.startDate = AxisCore.this.C.getTime();
            }
            return extra;
        }
    }
}

