/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.quickdiff;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.hover.Hover;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.quickdiff.QuickDiffContextMenuListener;
import oracle.ide.quickdiff.QuickDiffMargin;
import oracle.ide.util.Assert;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorOverview;
import oracle.javatools.editor.BasicEditorOverviewMark;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.ui.overview.OverviewListener;
import oracle.javatools.ui.overview.OverviewMark;
import oracle.javatools.ui.overview.OverviewMarkRenderingHints;
import oracle.javatools.ui.overview.OverviewTipProvider;

final class QuickDiffOverview {
    private BasicEditorOverview overview;
    private QuickDiffOverviewTipProvider provider;
    private BasicEditorPane editor;
    private CodeEditor codeEditor;
    private Listener listener = new Listener();
    private final String markKey = "QuickDiffMarkKey";

    QuickDiffOverview(CodeEditor codeEditor) {
        this.editor = codeEditor.getFocusedEditorPane();
        this.overview = new BasicEditorOverview(this.editor, false);
        this.provider = new QuickDiffOverviewTipProvider();
        this.overview.setInfoTipProvider((OverviewTipProvider)this.provider);
        this.codeEditor = codeEditor;
        this.overview.setThin(true);
        JComponent rightMargin = (JComponent)codeEditor.getFixedRightMargin();
        JPanel panel = new JPanel(new BorderLayout());
        JComponent overviewComponent = this.overview.getGUI();
        panel.add((Component)overviewComponent, "Center");
        panel.setOpaque(false);
        panel.add(Box.createVerticalStrut(12), "North");
        rightMargin.add((Component)panel, "grow, dock east");
        this.overview.addOverviewListener((OverviewListener)this.listener);
        codeEditor.addViewListener((ViewListener)this.listener);
    }

    void dispose() {
        this.provider.editor.dispose();
        this.overview.removeMarks((Object)"QuickDiffMarkKey");
        this.overview.removeOverviewListener((OverviewListener)this.listener);
        this.overview.dispose();
        this.codeEditor.removeViewListener((ViewListener)this.listener);
        this.overview = null;
        this.editor = null;
        this.codeEditor = null;
    }

    void update(SequenceCompareModel model) {
        this.overview.removeMarks((Object)"QuickDiffMarkKey");
        for (SequenceCompareDifference diff : model.getDifferenceBlocks()) {
            int start = this.editor.getLineStartOffset(diff.getSecondStart());
            int end = this.editor.getLineStartOffset(diff.getSecondStart() + diff.getSecondLength());
            Color color = QuickDiffMargin.getDifferenceColor(diff);
            QuickDiffOverviewMark mark = new QuickDiffOverviewMark(model, diff, this.editor, start, end, color);
            this.overview.addMark((OverviewMark)mark, (Object)"QuickDiffMarkKey");
        }
    }

    void setVisible(boolean visible) {
        this.overview.getGUI().setVisible(visible);
    }

    private class QuickDiffOverviewTipProvider
    implements OverviewTipProvider<QuickDiffOverviewMark> {
        private BasicEditorPane editor = new BasicEditorPane();
        private JScrollPane sp = new JScrollPane();

        private QuickDiffOverviewTipProvider() {
            LanguageSupport support = ((BasicDocument)QuickDiffOverview.this.editor.getDocument()).getLanguageSupport();
            LanguageSupport popupSupport = LanguageModule.createSupportForFileType(support.getClass());
            ((BasicDocument)this.editor.getDocument()).setLanguageSupport(popupSupport);
            this.editor.setBorder(BorderFactory.createEmptyBorder());
            this.editor.setOpaque(false);
            Border outerBorder = UIManager.getBorder("ToolTip.border");
            this.sp = new JScrollPane((Component)this.editor);
            this.sp.setBorder(outerBorder);
            this.sp.setBackground(UIManager.getColor("ToolTip.background"));
            Insets editorInsets = this.editor.getInsets();
            Border innerBorder = BorderFactory.createEmptyBorder(0, editorInsets.left, 0, editorInsets.right);
            this.sp.setViewportBorder(innerBorder);
            this.sp.getViewport().setOpaque(false);
        }

        public JComponent getTipContent(Collection<QuickDiffOverviewMark> marks, Hover hover) {
            if (marks.isEmpty()) {
                return null;
            }
            QuickDiffOverviewMark mark = marks.iterator().next();
            String text = null;
            text = mark.diff.isAddition(ContributorKind.FIRST, ContributorKind.SECOND) ? QuickDiffMargin.getPopupText(mark.model, mark.diff, ContributorKind.SECOND) : (mark.diff.isRemoval(ContributorKind.FIRST, ContributorKind.SECOND) ? QuickDiffMargin.getPopupText(mark.model, mark.diff, ContributorKind.FIRST) : QuickDiffMargin.getPopupText(mark.model, mark.diff, ContributorKind.FIRST));
            if (text == null) {
                return null;
            }
            BasicDocument document = (BasicDocument)this.editor.getDocument();
            try {
                if (document.getLength() > 0) {
                    document.remove(0, document.getLength());
                }
                document.insertString(0, text, null);
            }
            catch (BadLocationException e) {
                return null;
            }
            this.sp.setBackground(QuickDiffMargin.getDifferenceColor(mark.diff));
            this.sp.setPreferredSize(null);
            Dimension prefSize = this.sp.getPreferredSize();
            prefSize.width = Math.min(500, prefSize.width);
            prefSize.height = Math.min(300, prefSize.height);
            this.sp.setPreferredSize(prefSize);
            return this.sp;
        }

        public OverviewTipProvider.Orientation getOrientation() {
            return OverviewTipProvider.Orientation.LEFT_RIGHT;
        }
    }

    private class Listener
    implements ViewListener,
    OverviewListener<BasicEditorOverviewMark> {
        private ContextMenu menu = new ContextMenu();

        private Listener() {
            this.menu.addContextMenuListener((ContextMenuListener)new QuickDiffContextMenuListener());
        }

        public void viewActivated(ViewEvent e) {
            QuickDiffOverview.this.overview.rebuild();
        }

        public void viewDeactivated(ViewEvent e) {
        }

        public void viewClosed(ViewEvent e) {
        }

        public void markAdded(BasicEditorOverviewMark overviewMark) {
        }

        public void markRemoved(BasicEditorOverviewMark overviewMark) {
        }

        public void markClicked(BasicEditorOverviewMark overviewMark) {
            try {
                int selectionStart = overviewMark.getStartOffset();
                if (selectionStart < 0) {
                    return;
                }
                int selectionLength = overviewMark.getEndOffset() - selectionStart;
                OffsetNavigationPoint point = new OffsetNavigationPoint(QuickDiffOverview.this.codeEditor.getContext(), selectionStart, selectionLength);
                NavigationManager.getNavigationManager().navigateTo((NavigationPoint)point);
                return;
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
                return;
            }
        }

        public void overviewClicked(float relativeLocation) {
            int line = QuickDiffOverview.this.editor.getLineCount();
            int row = QuickDiffOverview.this.editor.getRowForLine(line) - 1;
            int navRow = Math.round((float)row * relativeLocation) + 1;
            line = QuickDiffOverview.this.editor.getLineFromRow(navRow) - 1;
            int offset = QuickDiffOverview.this.editor.getLineStartOffset(line);
            QuickDiffOverview.this.editor.setCaretPositionCenter(offset);
        }

        public void overviewPopup(float relativeLocation, MouseEvent me) {
            Context context = QuickDiffOverview.this.codeEditor.getContext();
            context.setEvent((EventObject)me);
            this.menu.show(context);
        }
    }

    private static class QuickDiffOverviewMark
    extends BasicEditorOverviewMark
    implements OverviewMarkRenderingHints {
        private final SequenceCompareModel model;
        private final SequenceCompareDifference diff;

        public QuickDiffOverviewMark(SequenceCompareModel model, SequenceCompareDifference diff, BasicEditorPane editor, Integer startOffset, Integer endOffset, Color color) {
            super(editor, startOffset, endOffset, 100.0f, color);
            this.model = model;
            this.diff = diff;
        }

        public Object getValue(OverviewMarkRenderingHints.Hint hint) {
            if (hint == OverviewMarkRenderingHints.Hint.BORDERLESS) {
                return Boolean.FALSE;
            }
            if (hint == OverviewMarkRenderingHints.Hint.THIN) {
                return Boolean.TRUE;
            }
            return null;
        }
    }
}

