/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.util;

import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdevimpl.vcs.svn.SVNProfile;

public final class TimingUtil {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(TimingUtil.class.getName());
    private static final Level sLevel = Level.FINE;
    private static final Stack _stack = new Stack();

    public static boolean canTime() {
        return sLogger.isLoggable(sLevel);
    }

    public static void beginTiming(Class caller, String context) {
        String key = TimingUtil.createKey(caller, context);
        sLogger.log(sLevel, "[BEGIN TIMING, " + key + "]");
        Object[] keyTimePair = new Object[]{key, new long[]{System.currentTimeMillis()}};
        _stack.push(keyTimePair);
    }

    public static void endTiming(Class caller, String context) {
        long endTime = System.currentTimeMillis();
        String key = TimingUtil.createKey(caller, context);
        Object[] keyTimePair = (Object[])_stack.pop();
        String stackKey = (String)keyTimePair[0];
        if (stackKey.equals(key)) {
            long duration = endTime - ((long[])keyTimePair[1])[0];
            sLogger.log(sLevel, "[END TIMING, " + key + ", " + duration + "ms]");
        } else {
            sLogger.log(sLevel, "[END TIMING, key mismatch: " + stackKey + ", " + key + "]");
        }
    }

    private static String createKey(Class caller, String context) {
        return caller.getName() + "." + context;
    }
}

