/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Observable;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRepositoryBrowsePanel;
import oracle.jdevimpl.vcs.svn.res.Resource;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNRepositoryBrowser
extends Observable {
    private SVNRepositoryBrowsePanel _panel;
    private JEWTDialog _dialog;
    private SVNRepositoryInfo _repoInfo;

    public SVNRepositoryBrowser(SVNRepositoryInfo repoInfo) {
        this._repoInfo = repoInfo;
        this._dialog = this.createDialog();
    }

    public SVNRepositoryBrowser(SVNRepositoryInfo repoInfo, SVNUrl svnurl) {
        this(repoInfo);
        this.setSelectedSVNUrl(svnurl);
    }

    public void showBrowser() {
        if (this._dialog != null) {
            this._dialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                        SVNRepositoryBrowser.this.setChanged();
                        SVNRepositoryBrowser.this.notifyObservers(SVNRepositoryBrowser.this.getSelectedSVNUrl());
                    }
                }
            });
            this._dialog.runDialog();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SVNRepositoryBrowser.this._dialog.dispose();
                }
            });
        }
    }

    private JEWTDialog createDialog() {
        boolean repoCreated = true;
        JEWTDialog dialog = null;
        if (repoCreated) {
            this._panel = new SVNRepositoryBrowsePanel(this._repoInfo);
            String title = Resource.get("ACTION_BRANCH_REPOSITORY_BROWSER_TITLE");
            dialog = new JEWTDialog((Frame)Ide.getMainWindow(), title, 7);
            dialog.setDefaultButton(1);
            dialog.setContent((Component)((Object)this._panel));
            dialog.setResizable(true);
            HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this._panel), "f1_svnrepositorybrowser_html");
        }
        return dialog;
    }

    public SVNUrl getSelectedSVNUrl() {
        return this._panel.getSelectedPathURL();
    }

    public void setSelectedSVNUrl(SVNUrl svnurl) {
        this._panel.setSelectedPath(svnurl);
    }
}

