/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.vhv.VHVCommand;
import oracle.ide.vhv.VHVCustomizer;
import oracle.ide.vhv.VHVQuery;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.versiontree.VersionTreeCommand;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.op.SVNOperationVHVCompareOther;
import oracle.jdevimpl.vcs.svn.op.SVNOperationVHVComparePrevious;
import oracle.jdevimpl.vcs.svn.util.WorkingCopyURLFilter;
import oracle.jdevimpl.vcs.svn.versiontree.SVNVHVQuery;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNOperationVersionTree
extends VersionTreeCommand {
    public static final String COMMAND_ID = SVNOperationVersionTree.class.getName();

    public SVNOperationVersionTree() {
        super(Ide.findOrCreateCmdID((String)COMMAND_ID));
    }

    public boolean isAvailable() {
        if (!super.isAvailable()) {
            return false;
        }
        Locatable[] locatables = this.getContextLocatables();
        if (locatables.length != 1) {
            return false;
        }
        WorkingCopyURLFilter wcfilter = new WorkingCopyURLFilter();
        URL url = locatables[0].getURL();
        if (wcfilter.accept(url)) {
            VCSStatus status;
            VCSStatusFilter rmFilter = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion").getStatusFilter("oracle.jdeveloper.subversion.filter.status.EXISTS_REMOTELY");
            try {
                status = (VCSStatus)this.getPolicyStatusCache().get(url);
            }
            catch (Exception e) {
                return false;
            }
            return rmFilter.accept(status);
        }
        return false;
    }

    public int doitImpl() throws Exception {
        Context context;
        Locatable[] locatables = this.getContextLocatables();
        if (locatables.length > 0) {
            URL url = locatables[0].getURL();
            VHVCommand.show((URL)url, (VHVQuery)this.createQuery(), (VHVCustomizer)this.createCustomizer(), (String)this.getVersionPath(url));
        }
        if ((context = this.getContext()).getElement() instanceof SVNRemoteNode) {
            SVNRemoteNode remoteNode = (SVNRemoteNode)context.getElement();
            SVNUrl svnurl = remoteNode.getSVNUrl();
            URL navURL = URLFactory.newURL((String)"file", (String)svnurl.getLastPathSegment());
            VHVCommand.show((URL)navURL, (VHVQuery)new SVNVHVQuery(svnurl), (VHVCustomizer)this.createCustomizer(), null);
        }
        return 0;
    }

    protected VHVQuery createQuery() {
        return new SVNVHVQuery();
    }

    protected String getVersionPath(URL url) {
        return url == null ? "" : url.toExternalForm();
    }

    protected VHVCustomizer createCustomizer() {
        VHVCustomizer customizer = new VHVCustomizer();
        customizer.setComparePreviousCommand(SVNOperationVHVComparePrevious.COMMAND_ID);
        customizer.setCompareOtherCommand(SVNOperationVHVCompareOther.COMMAND_ID);
        customizer.setCommandExtensionId("oracle.jdeveloper.subversion");
        return customizer;
    }
}

