/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Locatable;
import oracle.ide.view.View;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.changelist.SVNIncomingChangeList;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.UpdateCustomizer;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNException;

public class SVNOperationUpdate
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.update";

    public SVNOperationUpdate() {
        super(COMMAND_ID);
    }

    SVNOperationUpdate(String commandId) {
        super(commandId);
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        CommandState state = this.getCommandState();
        SVNUrl reposUrl = null;
        try {
            Locatable[] locatables = state.getLocatables();
            URL url = locatables.length > 1 ? SVNUtil.resolveWorkingCopy(locatables[0].getURL()) : state.getLocatables()[0].getURL();
            reposUrl = SVNURLInfoCache.getInstance().getURL(url);
        }
        catch (SVNException locatables) {
        }
        catch (IOException locatables) {
            // empty catch block
        }
        UpdateCustomizer customizer = new UpdateCustomizer();
        HashMap<String, Object> defaultOpts = new HashMap<String, Object>(7);
        defaultOpts.put("oracle.jdeveloper.subversion.REVISION", SVNRevision.HEAD);
        defaultOpts.put("oracle.jdeveloper.subversion.IGNORE_EXTERNALS", Boolean.FALSE);
        defaultOpts.put("oracle.jdeveloper.subversion.DEPTH", 3);
        defaultOpts.put("oracle.jdeveloper.subversion.FORCE_UPDATE", Boolean.FALSE);
        defaultOpts.put("oracle.jdeveloper.subversion.LIST_REVISION_URL", reposUrl);
        customizer.setOptions(defaultOpts);
        return customizer;
    }

    protected String getProgressTitle() {
        return Resource.get("ACTION_UPDATE_PROGRESS_TITLE");
    }

    protected String getProgressMessage() {
        return Resource.get("ACTION_UPDATE_PROGRESS_MESSAGE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        Locatable[] locatables = commandState.getLocatables();
        if (locatables == null || locatables.length == 0) {
            return true;
        }
        DeterminateProgressMonitor progress = new DeterminateProgressMonitor(parentUi, this.getProgressTitle(), (Object)this.getProgressMessage(), "", 0, -1);
        progress.setCancellable(true);
        progress.setCloseOnFinish(true);
        SVNRevision revision = (SVNRevision)options.get("oracle.jdeveloper.subversion.REVISION");
        boolean ignoreExternals = (Boolean)options.get("oracle.jdeveloper.subversion.IGNORE_EXTERNALS");
        boolean forceupdate = (Boolean)options.get("oracle.jdeveloper.subversion.FORCE_UPDATE");
        int depth = (Integer)options.get("oracle.jdeveloper.subversion.DEPTH");
        URL[] resources = VCSModelUtils.convertNodesToURLs((Locatable[])locatables);
        URL[] operands = this.sortForRecursive(resources);
        SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository(operands);
        SVNOperationLogger svnLogger = SVNOperationLogger.getInstance();
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            svnLogger.beginOperation(client, repos);
            progress.setMaximum(operands.length + 1);
            progress.setProgress(0);
            Collection processed = this.getProcessedUrlsNotifier(commandState);
            for (int i = 0; i < operands.length && !progress.isCancelled(); ++i) {
                client.update(new File[]{SVNUtil.toFile(operands[i])}, revision, depth, false, ignoreExternals, forceupdate);
                progress.setProgress(processed.size());
            }
            Collection<File> changeSet = svnLogger.getChangeSet();
            URL[] changeSetUrls = SVNUtil.toURLs(changeSet.toArray(new File[changeSet.size()]));
            processed.addAll(Arrays.asList(changeSetUrls));
            commandState.setProperty(AbstractSVNOperation.PROPERTY_RESOURCES_STRUCTURE_CHANGED, (Object)changeSetUrls);
            svnLogger.successFinish(this.getOperation());
        }
        finally {
            svnLogger.endOperation();
            progress.finish();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        Locatable[] locatables = commandState.getLocatables();
        if (locatables == null || locatables.length == 0) {
            return true;
        }
        SVNRevision revision = SVNRevision.HEAD;
        boolean ignoreExternals = true;
        boolean recursive = true;
        URL[] resources = VCSModelUtils.convertNodesToURLs((Locatable[])commandState.getLocatables());
        URL[] operands = recursive ? this.sortForRecursive(resources) : this.sortForNonRecursive(resources);
        SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository(operands);
        SVNOperationLogger svnLogger = SVNOperationLogger.getInstance();
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            svnLogger.beginOperation(client, repos);
            Collection processed = this.getProcessedUrlsNotifier(commandState);
            for (int i = 0; i < operands.length; ++i) {
                client.update(new File[]{SVNUtil.toFile(operands[i])}, revision, recursive, ignoreExternals);
                processed.add(operands[i]);
            }
            Collection<File> changeSet = svnLogger.getChangeSet();
            URL[] changeSetUrls = SVNUtil.toURLs(changeSet.toArray(new File[changeSet.size()]));
            processed.addAll(Arrays.asList(changeSetUrls));
            commandState.setProperty(AbstractSVNOperation.PROPERTY_RESOURCES_STRUCTURE_CHANGED, (Object)changeSetUrls);
            svnLogger.successFinish(this.getOperation());
        }
        finally {
            svnLogger.endOperation();
        }
        return true;
    }

    @Override
    protected void postInvoke(VCSProfile profile, CommandState commandState) throws Exception {
        super.postInvoke(profile, commandState);
        this.refreshIncomingChanges(profile);
    }

    protected String getOperation() {
        return Resource.get("OP_UPDATE");
    }

    private void refreshIncomingChanges(VCSProfile profile) {
        View view = this.getContext().getView();
        if (view instanceof ChangeListWindow && ((ChangeListWindow)view).getContextChangeList() instanceof SVNIncomingChangeList) {
            SVNIncomingChangeList incoming = (SVNIncomingChangeList)((ChangeListWindow)view).getContextChangeList();
            incoming.refresh();
        } else {
            String viewId = profile.getChangeListViewID();
            ViewId viewIdObj = new ViewId(viewId);
            Dockable dockable = DockStation.getDockStation().findDockable(viewIdObj);
            if (dockable != null) {
                ((ChangeListWindow)dockable).refresh();
            }
        }
    }

    private URL[] sortForRecursive(URL[] resources) {
        return VCSFileSystemUtils.coalesceURLs((URL[])resources);
    }

    private URL[] sortForNonRecursive(URL[] resources) {
        return new URL[0];
    }
}

