/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.jdeveloper.vcs.cache.StatusCacheBridge;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizard;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.MergePanel;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNInfo;

public class SVNOperationMerge
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.merge";
    private MergePanel _mergePanel;
    private JEWTDialog _dialog;
    private ISVNInfo _wcInfo;

    public SVNOperationMerge() {
        super(COMMAND_ID);
    }

    public SVNOperationMerge(String commandID) {
        super(commandID);
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        Locatable[] locatables = this.getVersionedLocatables(profile, VCSContextUtils.getContextLocatables((Context)this.getContext()));
        if (locatables.length > 1 && ((locatables = this.getMergeLocatables(locatables)) == null || locatables.length == 0)) {
            return 1;
        }
        for (Locatable locatable : locatables) {
            if (!(locatable instanceof Element)) continue;
            this.getContext().setSelection(new Element[]{(Element)locatable});
            SVNMergeWizard wizard = new SVNMergeWizard();
            if (wizard.runWizard(VCSWindowUtils.getCurrentWindow(), this.getContext())) continue;
            return 1;
        }
        return 0;
    }

    protected String getOperation() {
        return Resource.get("OP_MERGE");
    }

    private Locatable[] getMergeLocatables(Locatable[] locatables) {
        ArrayList<Locatable> loc = new ArrayList<Locatable>();
        for (Locatable locatable : locatables) {
            loc.add(locatable);
        }
        this.setSVNVersionOperationPanel(VCSComponents.createSelectFileListerComponent(loc));
        JEWTDialog dialog = this.createOperationDialogImpl(null, null, null);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(Resource.get("MERGE_FILE_HINT"));
        dialog.setDialogHeader((Component)header);
        if (dialog.runDialog()) {
            return this.getSVNVersionOperationPanel().getSelectedLocatables();
        }
        return null;
    }

    @Override
    protected String getDialogTitle() {
        return Resource.get("MERGE_FILE_TITLE");
    }

    private String getFromURLString() {
        return SVNUtil.canonicalizeSVNUrl(this._wcInfo.getUrl()).toString();
    }

    private Locatable[] getVersionedLocatables(VCSProfile profile, Locatable[] locatables) throws Exception {
        VCSStatusFilter filter = profile.getStatusFilter("oracle.jdeveloper.vcs.filter.status.VERSIONED");
        Collection versioned = VCSCommandUtils.getFilteredSelection((Locatable[])locatables, (StatusCacheBridge)profile.getStatusCacheBridge(), (VCSStatusFilter)filter);
        return versioned.toArray(new Locatable[0]);
    }
}

