/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.op.SVNOperationAddProperty;
import oracle.jdevimpl.vcs.svn.op.ui.PropertyEditorPanel;
import oracle.jdevimpl.vcs.svn.res.Resource;

public class SVNOperationEditProperty
extends SVNOperationAddProperty {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.editproperty";
    protected PropertyEditorPanel _panel;
    protected JEWTDialog _dialog;
    protected File _resource;

    public SVNOperationEditProperty() {
        super(COMMAND_ID);
    }

    public SVNOperationEditProperty(String commandID) {
        super(commandID);
    }

    @Override
    protected boolean isAvailableImpl() throws Exception {
        JTable table = this.getTable();
        return table != null && table.getSelectedRowCount() == 1;
    }

    @Override
    protected boolean invokeCommand(VCSProfile profile, CommandState commandState) throws Exception {
        return super.invokeCommandImpl(profile, commandState, VCSWindowUtils.getCurrentWindow(), null);
    }

    @Override
    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        return this.invokeCommandImpl(profile, commandState, null, options);
    }

    @Override
    protected JEWTDialog createDialog() {
        String title = Resource.get("ACTION_EDITPROPERTY_DIALOG_TITLE");
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), title, 7);
        dialog.setDefaultButton(1);
        dialog.setContent((Component)this.getPanel());
        dialog.setResizable(true);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.getPanel(), "f1_svneditproperty_html");
        return dialog;
    }

    @Override
    protected PropertyEditorPanel createPanel() {
        PropertyEditorPanel panel = super.createPanel();
        TableModel model = this.getTable().getModel();
        if (model.getRowCount() == 0) {
            return null;
        }
        int row = 0;
        if (this.getTable().getSelectedRow() > 0) {
            row = this.getTable().getSelectedRow();
        }
        String propName = (String)model.getValueAt(row, 0);
        String propValue = (String)model.getValueAt(row, 1);
        File resource = new File((String)model.getValueAt(row, 2));
        panel.setResourceFieldEditable(false);
        panel.setNameComboBoxEditable(false);
        panel.setResourceField(resource);
        panel.setPropertyName(propName);
        panel.setStringRadioSelected(true);
        panel.setStringPropertyValue(propValue);
        return panel;
    }
}

