/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSDetailException;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.PatchOptionsCustomizer;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNChangelistHandler;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNChangelistClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc2.SvnDiff;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SVNOperationCreatePatch
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.create-patch";
    private VCSOptionsCustomizer _customizer;
    private URL _root;

    public SVNOperationCreatePatch() {
        super(COMMAND_ID);
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        Locatable[] locatables;
        if (this.isSilent(this.getContext(), profile) && (locatables = this.getFromChangeset(profile)).length > 0) {
            return locatables;
        }
        locatables = VCSContextUtils.getContextLocatables((Context)this.getContext());
        if (locatables.length == 0) {
            return locatables;
        }
        URL root = this.getReposRoot(locatables[0].getURL());
        SVNStatusClient client = SVNUtil.getStatusClient();
        final ArrayList changed = new ArrayList();
        try {
            client.doStatus(new File(root.getPath()), SVNRevision.HEAD, SVNDepth.INFINITY, false, false, true, false, new ISVNStatusHandler(){

                public void handleStatus(SVNStatus status) throws SVNException {
                    if (!status.getFile().isDirectory() && status.isVersioned()) {
                        URL url = URLFactory.newFileURL((File)status.getFile());
                        try {
                            changed.add(NodeFactory.findOrCreate((URL)url));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }, Collections.emptyList());
        }
        catch (SVNException svne) {
            svne.printStackTrace();
        }
        return changed.toArray(new Locatable[0]);
    }

    @Override
    protected DialogHeader createOperationDialogHeader(Collection nodes, CommandState commandState) {
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(this.getDialogHint());
        return header;
    }

    protected int doitImplInvoke(VCSProfile profile, Locatable[] locatables) throws Exception {
        if (locatables.length == 0) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Resource.get("CREATE_PATCH_NO_FILES"), (String)Resource.get("CREATE_PATCH_NO_FILES_TITLE"), null);
            return 1;
        }
        return super.doitImplInvoke(profile, locatables);
    }

    protected VCSOptionsCustomizer createOptionsCustomizer(Collection<Locatable> locs) {
        if (this._customizer == null) {
            this._customizer = new PatchOptionsCustomizer();
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        URL root = SVNUtil.resolveWorkingCopy(locs.toArray(new Locatable[0])[0].getURL());
        URL patchURL = this.getDestination(root);
        options.put("svn-patch-path", URLFileSystem.getPlatformPathName((URL)patchURL));
        options.put("svn-patch-open", Boolean.TRUE);
        options.put("svn-patch-git", Boolean.FALSE);
        this._customizer.setOptions(options);
        return this._customizer;
    }

    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        Locatable[] locs = commandState.getLocatables();
        if (locs.length == 0) {
            return false;
        }
        ArrayList<File> files = new ArrayList<File>();
        String destination = (String)options.get("svn-patch-path");
        Boolean open = (Boolean)options.get("svn-patch-open");
        Boolean git = (Boolean)options.get("svn-patch-git");
        SvnDiffGenerator diffGen = new SvnDiffGenerator();
        SvnOperationFactory svnOperationFactory = new SvnOperationFactory();
        SvnDiff diff = svnOperationFactory.createDiff();
        URL root = SVNUtil.getWorkingCopyLocator().getRootContaining(locs[0].getURL());
        if (root == null) {
            return false;
        }
        diffGen.setBasePath(new File(root.getPath()));
        diffGen.setUseGitFormat(git.booleanValue());
        FileOutputStream output = null;
        try {
            this.createDirectory(destination);
            output = new FileOutputStream(destination);
            for (Locatable loc : locs) {
                files.add(new File(loc.getURL().getPath()));
            }
            for (File path : files) {
                diff.setDiffGenerator((ISvnDiffGenerator)diffGen);
                diff.setSource(SvnTarget.fromFile((File)path), SVNRevision.BASE, SVNRevision.WORKING);
                diff.setDepth(SVNDepth.IMMEDIATES);
                diff.setIgnoreAncestry(true);
                diff.setOutput((OutputStream)output);
                diff.setShowCopiesAsAdds(false);
                diff.setUseGitDiffFormat(git.booleanValue());
                diff.run();
            }
            if (open.booleanValue()) {
                this.openDefaultEditorInFrame(URLFactory.newFileURL((String)destination));
            }
        }
        catch (SVNException ex) {
            profile.getLogger().log(Level.SEVERE, "Create patch failed : invoke command " + ex.getMessage());
            throw new VCSDetailException(Resource.get("CREATE_PATCH_DEST_TITLE"), Resource.get("CREATE_PATCH_FAILED"), ex.getLocalizedMessage());
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    protected boolean invokeCommandSilently(VCSProfile profile, CommandState commandState) throws Exception {
        return this.invokeCommand(profile, commandState);
    }

    private URL getReposRoot(URL url) {
        if (this._root == null) {
            this._root = SVNUtil.resolveWorkingCopy(url);
        }
        return this._root;
    }

    private URL getDestination(URL root) {
        String filename = "svn";
        String suffix = ".patch";
        URL patchURL = URLFactory.newURL((URL)root, (String)"svn.patch");
        int num = 1;
        while (URLFileSystem.exists((URL)patchURL)) {
            patchURL = URLFactory.newURL((URL)root, (String)(filename + num + suffix));
            ++num;
        }
        return patchURL;
    }

    private void openDefaultEditorInFrame(final URL url) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                EditorManager.getEditorManager().openDefaultEditorInFrame(url);
            }
        });
    }

    private void createDirectory(String destination) {
        URL destUrl = URLFactory.newFileURL((String)destination);
        URL parentUrl = URLFileSystem.getParent((URL)destUrl);
        if (!URLFileSystem.exists((URL)parentUrl)) {
            URLFileSystem.mkdirs((URL)parentUrl);
        }
    }

    private Locatable[] getFromChangeset(VCSProfile profile) throws VCSException {
        Locatable[] locatables = VCSContextUtils.getContextLocatables((Context)this.getContext());
        ArrayList<File> targets = new ArrayList<File>();
        final ArrayList changeListNames = new ArrayList();
        final ArrayList changelistLoc = new ArrayList();
        try {
            for (Locatable loc : locatables) {
                targets.add(new File(loc.getURL().getPath()));
            }
            SVNChangelistClient client = SVNUtil.getChangeClient();
            client.doGetChangeListPaths(null, targets, SVNDepth.FILES, new ISVNChangelistHandler(){

                public void handle(File path, String changelistName) {
                    changeListNames.add(changelistName);
                }
            });
            URL root = this.getReposRoot(locatables[0].getURL());
            client.doGetChangeLists(new File(root.getPath()), changeListNames.size() == 0 ? Collections.emptyList() : changeListNames, SVNDepth.INFINITY, new ISVNChangelistHandler(){

                public void handle(File path, String changelistName) {
                    URL url = URLFactory.newFileURL((File)path);
                    try {
                        Node node = NodeFactory.findOrCreate((URL)url);
                        changelistLoc.add(node);
                    }
                    catch (InstantiationException e) {
                        SVNProfile.getQualifiedLogger(SVNOperationCreatePatch.class.getName()).log(Level.SEVERE, "Failed to get files for changelist " + e.getMessage());
                    }
                    catch (IllegalAccessException e) {
                        SVNProfile.getQualifiedLogger(SVNOperationCreatePatch.class.getName()).log(Level.SEVERE, "Failed to get files for changelist " + e.getMessage());
                    }
                }
            });
        }
        catch (Exception ex) {
            profile.getLogger().log(Level.SEVERE, "Create patch failed : failed to find files from changelist " + ex.getMessage());
            throw new VCSDetailException(Resource.get("CREATE_PATCH_DEST_TITLE"), Resource.get("CREATE_PATCH_FAILED"), ex.getLocalizedMessage());
        }
        return changelistLoc.toArray(new Locatable[0]);
    }
}

