/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.merge;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdeveloper.merge.BaseTextMergeEditor;
import oracle.jdeveloper.merge.MergeContext;
import oracle.jdeveloper.merge.MergeEngine;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.prefs.SVNVersionToolsPreferences;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public final class SVNMergeEditor
extends BaseTextMergeEditor {
    protected void initializeMergeContextCS(Context context) throws IOException, SVNClientException {
        URL url = this.getRealURL();
        final String fileName = URLFileSystem.getFileName((URL)url);
        URL parentUrl = URLFileSystem.getParent((URL)url);
        URL edit1Url = null;
        URL[] revisionUrls = null;
        edit1Url = URLFactory.newURL((URL)parentUrl, (String)(fileName + ".mine"));
        if (URLFileSystem.exists((URL)edit1Url)) {
            revisionUrls = URLFileSystem.list((URL)parentUrl, (URLFilter)new URLFilter(){

                public boolean accept(URL url) {
                    return URLFileSystem.getFileName((URL)url).matches(fileName + "\\.r[\\.\\d]+$");
                }
            });
        } else {
            edit1Url = URLFactory.newURL((URL)parentUrl, (String)(fileName + ".working"));
            if (URLFileSystem.exists((URL)edit1Url)) {
                revisionUrls = URLFileSystem.list((URL)parentUrl, (URLFilter)new URLFilter(){

                    public boolean accept(URL url) {
                        return URLFileSystem.getFileName((URL)url).matches(fileName + "\\.merge-left\\.r[\\.\\d]+$") || URLFileSystem.getFileName((URL)url).matches(fileName + "\\.merge-right\\.r[\\.\\d]+$");
                    }
                });
            }
        }
        if (revisionUrls == null || revisionUrls.length < 2) {
            MergeContext.setClientSideMerge((Context)context, (boolean)false);
            return;
        }
        Arrays.sort(revisionUrls, new Comparator<URL>(){

            @Override
            public int compare(URL url1, URL url2) {
                return this.parseRevision(url1) - this.parseRevision(url2);
            }

            private int parseRevision(URL url) {
                Matcher matcher = Pattern.compile("\\.r(.*)").matcher(URLFileSystem.getSuffix((URL)url));
                try {
                    return matcher.matches() ? Integer.parseInt(matcher.group(1)) : 0;
                }
                catch (NumberFormatException nfe) {
                    return 0;
                }
            }
        });
        String type = this.getSuffixAsType(url);
        URLContributor contributor = new URLContributor(edit1Url);
        contributor.setType(type);
        MergeContext.setFirstContributor((Context)context, (CompareContributor)contributor);
        contributor = new URLContributor(revisionUrls[1]);
        contributor.setType(type);
        MergeContext.setSecondContributor((Context)context, (CompareContributor)contributor);
        contributor = new URLContributor(revisionUrls[0]);
        contributor.setType(type);
        MergeContext.setAncestorContributor((Context)context, (CompareContributor)contributor);
        MergeContext.setMergeEngine((Context)context, (MergeEngine)MergeEngine.getInstance());
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_svnmergetool_html");
    }

    protected void resolveMergeStatus(URL url) {
        block5: {
            ISVNClientAdapter client = null;
            try {
                if (SVNUtil.isTreeConflicted(url)) {
                    return;
                }
                if (SVNUtil.isPropertiesConflicted(url)) break block5;
                client = SVNUtil.getIDEClientAdapter();
                SVNOperationLogger.getInstance().beginOperation(client, null);
                try {
                    client.resolved(SVNUtil.toFile(url));
                    SVNOperationLogger.getInstance().endOperation();
                }
                catch (Throwable throwable) {
                    SVNOperationLogger.getInstance().endOperation();
                    VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion").getPolicyStatusCache().clear(url);
                    VCSFileEventSender.fireFileStructureChanged((URL[])new URL[]{URLFileSystem.getParent((URL)url)});
                    throw throwable;
                }
                VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion").getPolicyStatusCache().clear(url);
                VCSFileEventSender.fireFileStructureChanged((URL[])new URL[]{URLFileSystem.getParent((URL)url)});
            }
            catch (Exception ce) {
                FeedbackManager.reportException((Throwable)ce);
            }
        }
    }

    protected String createFirstContributorLabelSS() {
        HashSet annotations = new HashSet(this.getDiff3Model().getSourceAnnotations().values());
        Iterator it = annotations.iterator();
        if (it.hasNext()) {
            return it.next().toString();
        }
        return Resource.get("MERGE_LABEL_UNKNOWN_REVISION");
    }

    protected boolean getClientSideMergeSetting() {
        return SVNVersionToolsPreferences.getInstance((PropertyStorage)Preferences.getPreferences()).getMergeEditor() == 0;
    }
}

