/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.client;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.jdevimpl.vcs.svn.SVNAuthenticationManager;
import oracle.jdevimpl.vcs.svn.client.SVNClient;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public abstract class AbstractSVNClient
implements SVNClient {
    protected final Map _adapters = new HashMap(10);
    private URL _configUrl;

    @Override
    public synchronized ISVNClientAdapter getManagedAdapter(Object id) throws SVNClientException {
        ISVNClientAdapter adapter = (ISVNClientAdapter)this._adapters.get(id);
        if (adapter == null) {
            adapter = SVNClientAdapterFactory.createSVNClient((String)this.getAdapterType());
            URL url = this.getConfigUrl();
            if (url != null) {
                adapter.setConfigDirectory(new File(url.getPath()));
            }
            this._adapters.put(id, adapter);
        }
        return adapter;
    }

    @Override
    public URL getConfigUrl() {
        return SVNAuthenticationManager.getInstance().getConfigUrl();
    }

    protected abstract String getAdapterType();
}

