/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.changelist;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ideri.util.Product;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEvent;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.svn.util.WorkingCopyURLFilter;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;

public final class SVNOutgoingEventQueue
extends ChangeListEventQueue {
    private final VCSProfile _profile;
    private final URLFilter _workingCopyFilter = new WorkingCopyURLFilter();

    public SVNOutgoingEventQueue(ChangeList changeList) {
        super(changeList);
        this._profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
    }

    protected final boolean supportsRemovedEntries() {
        return true;
    }

    protected void filterByStatus(Collection<VCSHashURL> urls, boolean applyScope) throws Exception {
        Iterator<VCSHashURL> it = urls.iterator();
        while (it.hasNext()) {
            VCSHashURL url = it.next();
            if (this._workingCopyFilter.accept(url.getURL())) continue;
            it.remove();
        }
        super.filterByStatus(urls, applyScope);
    }

    protected boolean useVCSStatusURLS() {
        return !Product.isJDeveloper();
    }

    protected Collection<? extends VCSHashURL> getVCSStatusURLS(ChangeListEvent cle) {
        URL[] roots = SVNUtil.getSVNRootUrls();
        HashSet<VCSHashURL> urls = new HashSet<VCSHashURL>();
        for (URL root : roots) {
            urls.addAll(this.getFileUrls(root));
        }
        return urls;
    }

    private Collection<VCSHashURL> getFileUrls(URL root) {
        SVNStatusClient client = SVNUtil.getStatusClient();
        final HashSet<VCSHashURL> urls = new HashSet<VCSHashURL>();
        ISVNStatusHandler handler = new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) {
                if (status.isVersioned() && status.getKind() != SVNNodeKind.DIR) {
                    urls.add(new VCSHashURL(URLFactory.newFileURL((File)status.getFile())));
                }
            }
        };
        ArrayList changelist = new ArrayList();
        try {
            client.doStatus(SVNUtil.toFile(root), null, SVNDepth.INFINITY, false, false, true, false, handler, changelist);
        }
        catch (SVNException e) {
            SVNProfile.getQualifiedLogger(SVNOutgoingEventQueue.class.getName()).log(Level.WARNING, e.getMessage());
        }
        return urls;
    }
}

