/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.changelist;

import java.awt.Component;
import java.net.URL;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.JMenu;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.net.URLFilter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.changelist.AsynchronousChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListContextMenuListener;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.changelist.ChangeListStatus;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSThreadPool;
import oracle.jdeveloper.vcs.util.VCSMenuUtils;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdeveloper.vcs.vop.MutableVersionOperationModel;
import oracle.jdevimpl.vcs.svn.SVNOverlayProducer;
import oracle.jdevimpl.vcs.svn.changelist.SVNIncomingChangesTask;
import oracle.jdevimpl.vcs.svn.changelist.SVNIncomingEventQueue;
import oracle.jdevimpl.vcs.svn.changelist.SVNRemoteStatus;
import oracle.jdevimpl.vcs.svn.changelist.SVNRemoteStatusCache;
import oracle.jdevimpl.vcs.svn.prefs.SVNVersionToolsPreferences;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.vop.ClientDisplayProperty;

public final class SVNIncomingChangeList
extends AsynchronousChangeList {
    private static final DisplayProperty sTextDisplayProp = new ClientDisplayProperty(Resource.get("CHANGE_LIST_INCOMING_TEXTSTATUS_LABEL"), (Object)"XXXXXXXXXXXXXXX", ChangeListStatus.class);
    private static final DisplayProperty sPropDisplayProp = new ClientDisplayProperty(Resource.get("CHANGE_LIST_INCOMING_PROPSTATUS_LABEL"), (Object)"XXXXXXXXXXXXXXX", ChangeListStatus.class);
    private static VCSThreadPool _threadPool = null;
    private static String _changelistID = "oracle.jdevimpl.vcs.svn.changelist.INCOMING";
    private ContextMenuListener _incomingContextMenuListener;
    private static final String INCOMING_VISIBLE_PERSISTENCE_KEY = "SVN.PendingChangesWindow.IncomingVisible";

    public SVNIncomingChangeList() {
        super((Object)_changelistID);
        this.setExcludeDirectories(false);
    }

    protected ChangeListEventQueue createEventQueue() {
        return new SVNIncomingEventQueue(this);
    }

    protected Icon getModeIcon() {
        return null;
    }

    protected String getModeLabel() {
        return Resource.get("CHANGE_LIST_INCOMING_LABEL");
    }

    protected String getBusyStatusMessage() {
        return Resource.get("CHANGE_LIST_INCOMING_BUSY");
    }

    protected void initializeChangeList() {
        SVNRemoteStatusCache cache = new SVNRemoteStatusCache();
        this.setPolicyStatusCache((StatusCache)new SVNRemoteStatusCache());
        this.setOverlayItemProducer(new SVNOverlayProducer((StatusCache<VCSStatus>)cache));
        this.setVisibleStatuses(new ChangeListStatus[]{SVNRemoteStatus.TEXT_MODIFIED, SVNRemoteStatus.PROP_MODIFIED, SVNRemoteStatus.TEXT_PROP_MODIFIED, SVNRemoteStatus.ADDED, SVNRemoteStatus.DELETED});
        this.refresh();
    }

    protected DisplayProperty[] createDisplayProperties() {
        return new DisplayProperty[]{sTextDisplayProp, sPropDisplayProp};
    }

    protected Object getModelValue(URL url, DisplayProperty prop) throws Exception {
        SVNRemoteStatus status = (SVNRemoteStatus)this.getPolicyStatusCache().get(url);
        if (prop == sTextDisplayProp) {
            if (SVNRemoteStatus.PROP_MODIFIED == status) {
                return SVNRemoteStatus.UNMODIFIED;
            }
            return status;
        }
        if (prop == sPropDisplayProp) {
            if (SVNRemoteStatus.PROP_MODIFIED == status || SVNRemoteStatus.TEXT_PROP_MODIFIED == status) {
                return status;
            }
            return SVNRemoteStatus.UNMODIFIED;
        }
        return super.getModelValue(url, prop);
    }

    protected void addToolbarActions(ChangeListWindow window, Toolbar toolbar) {
        toolbar.add((ToggleAction)window.createLocalAction(Ide.findOrCreateCmdID((String)"oracle.jdeveloper.subversion.update")));
    }

    protected TimerTask createStatusTask(VCSThreadPool threadPool) {
        return new SVNIncomingChangesTask(this, _threadPool, this.getScopeFilter());
    }

    protected Integer getTimerIntervalImpl() {
        SVNVersionToolsPreferences prefs = SVNVersionToolsPreferences.getInstance((PropertyStorage)Preferences.getPreferences());
        Integer interval = prefs.getIncomingInterval();
        String unit = prefs.getIncomingIntervalUnit();
        Integer timer = unit.equals("MINUTES") ? new Integer(interval * 60) : new Integer(interval * 60 * 60);
        long timerMillis = timer * 1000;
        if (timerMillis <= 0L) {
            timerMillis = Integer.MAX_VALUE;
        }
        return new Integer((int)timerMillis);
    }

    protected void clearPerformanceCache() {
    }

    public void refresh() {
        this.getPolicyStatusCache().clear();
        super.refresh();
    }

    protected VCSThreadPool getThreadPool() {
        return super.getThreadPool();
    }

    public void setScopeFilter(URLFilter scopeFilter) {
        this.refresh();
        super.setScopeFilter(scopeFilter);
    }

    protected void addContextMenuListeners(ContextMenu contextMenu) {
        this._incomingContextMenuListener = new IncomingContextMenuListener((ChangeList)this);
        contextMenu.addContextMenuListener(this._incomingContextMenuListener);
    }

    protected void removeContextMenuListeners(ContextMenu contextMenu) {
        contextMenu.removeContextMenuListener(this._incomingContextMenuListener);
        this._incomingContextMenuListener = null;
    }

    protected String getTabToggleKey() {
        return INCOMING_VISIBLE_PERSISTENCE_KEY;
    }

    protected MutableVersionOperationModel getModel() {
        return super.getModel();
    }

    private static class IncomingContextMenuListener
    extends ChangeListContextMenuListener {
        IncomingContextMenuListener(ChangeList changeList) {
            super(changeList);
        }

        public void menuWillShowImpl(ContextMenu popup) {
            if (popup.getContext().getSelection().length > 0) {
                popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)ChangeListWindow.OPEN_CMD_ID)), 1.9f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, Ide.findOrCreateCmdID((String)"oracle.jdeveloper.subversion.update"))), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, Ide.findOrCreateCmdID((String)"oracle.jdeveloper.subversion.update-workingcopy"))), 2.0f);
                JMenu menu = this.addMenuItemBaseCompare(popup);
                if (menu != null) {
                    int latest = Ide.findCmdID((String)"oracle.jdeveloper.subversion.compare-latest");
                    int other = Ide.findCmdID((String)"oracle.jdeveloper.subversion.compare-other");
                    Ide.getMenubar().add((Component)VCSMenuUtils.createMenuItem((int)latest), menu, 0.5f);
                    Ide.getMenubar().add((Component)VCSMenuUtils.createMenuItem((int)other), menu, 0.5f);
                }
            }
            this.addMenuItemCopyFileList(popup);
            this.addMenuItemRefresh(popup);
            if (popup.getContext().getSelection().length == 1) {
                this.addMenuItemSelectInNavigator(popup);
            }
            this.addMenuItemPreferences(popup);
        }
    }
}

