/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.patch.PatchAssistance;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SVNPatchAssistance
extends PatchAssistance {
    private static String NONEXISTENT = "(nonexistent)";
    private static String REVISION0 = "(revision 0)";
    private static Pattern pattern = Pattern.compile("Index:(?i)");
    private static Pattern filepattern = Pattern.compile("(---|\\+\\+\\+)([\\s]+)([^\\t]+)([\\s]+)([^\\t]+)");
    private static Pattern newfile = Pattern.compile("new file (?i)");
    private static String COPYFROM = "copy from ";
    private static String COPYTO = "copy to ";
    private String _toFile;
    private String _fromFile;
    private boolean _newFile = false;
    private String _fromSVNPath;
    private String _toSVNPath;
    private String _lastSegment;
    private boolean _newEntry = false;

    public boolean isRecognised(byte[] source) {
        Matcher matcher = pattern.matcher(new String(source));
        boolean rec = matcher.find();
        if (rec) {
            this.clearDetails();
        }
        return rec;
    }

    public Date getFromModificationTime() {
        return null;
    }

    public String getFromRevision() {
        return null;
    }

    public String toFile() {
        return this._toFile;
    }

    public String fromFile() {
        return this._fromFile;
    }

    public Date getToModificationTime() {
        return null;
    }

    public String getToRevision() {
        return null;
    }

    public void process(String line) {
        String sLine = line.trim();
        this._newEntry = false;
        if (!this.newSection(line) && !this.copyFromTo(line)) {
            this.extractFilename(sLine);
        }
    }

    public boolean isNew() {
        return this._newFile;
    }

    public void fixUpFilenames() {
        if (this.isNewFile(this._toFile)) {
            this._toFile = this.newFilename(this._fromFile);
        } else if (this.isNewFile(this._fromFile)) {
            this._fromFile = this.newFilename(this._toFile);
        } else if (this._toSVNPath != null) {
            this._fromFile = this._toFile;
        }
    }

    public void updated(URL[] urls) {
        if (urls != null) {
            VCSFileEventSender.fireFileStructureChanged((URL[])urls);
            VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion").getPolicyStatusCache().clear(urls);
        }
    }

    public boolean isCopy() {
        return this._toSVNPath != null;
    }

    public boolean isNewEntry() {
        return this._newEntry;
    }

    private String newFilename(String path) {
        if (path.contains(this.lastPathSegment())) {
            int pos = path.indexOf(this.lastPathSegment());
            return path.substring(pos + 1 + this.lastPathSegment().length());
        }
        if (path.startsWith("b/")) {
            return path.substring("b/".length());
        }
        if (path.startsWith("a/")) {
            return path.substring("a/".length());
        }
        return path;
    }

    private boolean isNewFile(String fileName) {
        return fileName.equals("nul") || fileName.equals("/dev/null");
    }

    private void clearDetails() {
        this._toFile = null;
        this._fromFile = null;
        this._newFile = false;
        this._toSVNPath = null;
        this._fromSVNPath = null;
    }

    private void newFile(Matcher matcher) {
        if (matcher.groupCount() >= 5) {
            String g1 = matcher.group(1).trim();
            if (!g1.equals("---")) {
                return;
            }
            String g3 = matcher.group(3);
            if (g3.equals("/dev/null")) {
                return;
            }
            String revision = matcher.group(5);
            if (revision.equals(NONEXISTENT) || revision.equals(REVISION0)) {
                this._newFile = true;
            }
        }
    }

    private void extractFilename(String sLine) {
        Matcher matcher = filepattern.matcher(sLine);
        if (matcher.matches()) {
            String fileName = matcher.group(3);
            if (this._toSVNPath == null) {
                this.newFile(matcher);
            }
            if (matcher.group(1).startsWith("-")) {
                this._fromFile = fileName;
                this._newEntry = true;
            } else {
                this._toFile = fileName;
            }
        } else {
            Matcher newMatcher = newfile.matcher(sLine);
            if (newMatcher.find()) {
                this._newFile = true;
            }
        }
    }

    private boolean newSection(String line) {
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            this.clearDetails();
            return true;
        }
        return false;
    }

    private boolean copyFromTo(String line) {
        if (line.startsWith(COPYFROM)) {
            this._fromSVNPath = line.substring(COPYFROM.length()).trim();
            return true;
        }
        if (line.startsWith(COPYTO)) {
            this._toSVNPath = line.substring(COPYTO.length()).trim();
            this.getFileFromServer(this._fromSVNPath, this._toSVNPath);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFileFromServer(String fromPath, String toPath) {
        URL from;
        SVNRevision rev = SVNRevision.HEAD;
        URL to = this.getTrueURL(this.lastPathSegment(), toPath);
        int at = fromPath.lastIndexOf(64);
        if (at > -1) {
            from = this.getTrueURL(this.lastPathSegment(), fromPath.substring(0, at));
            rev = SVNRevision.parse((String)fromPath.substring(at + 1));
        } else {
            from = this.getTrueURL(this.lastPathSegment(), fromPath);
        }
        URLFileSystem.mkdirs((URL)URLFileSystem.getParent((URL)to));
        BufferedOutputStream io = null;
        try {
            io = new BufferedOutputStream(URLFileSystem.openOutputStream((URL)to));
            SVNRepositoryInfo svnInfo = SVNUtil.getFirstAssociatedRepository(this.getRoot());
            SVNWCClient client = SVNUtil.getWCClient(svnInfo);
            SVNOperationLogger.getInstance().beginOperation((SVNBasicClient)client, svnInfo);
            client.doGetFileContents(new File(from.getPath()), SVNRevision.UNDEFINED, rev, false, (OutputStream)io);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
            if (io != null) {
                try {
                    io.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private URL getTrueURL(String segment, String path) {
        int pos = path.indexOf(segment);
        if (pos < 0) {
            return URLFactory.newURL((URL)this.getRoot(), (String)path);
        }
        return URLFactory.newURL((URL)this.getRoot(), (String)path.substring(pos + segment.length()));
    }

    private String lastPathSegment() {
        if (this._lastSegment == null) {
            String[] segments = this.getRoot().getPath().split("/");
            this._lastSegment = segments[segments.length - 1];
        }
        return this._lastSegment;
    }
}

