/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.ide.config.Preferences;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPrintWriter;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.jndi.Names;
import oracle.jdeveloper.vcs.changeset.cmd.CommentTemplatesConfiguration;
import oracle.jdeveloper.vcs.generic.VCSAddin;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.util.VCSConfigUtils;
import oracle.jdevimpl.vcs.svn.SVNClientSelector;
import oracle.jdevimpl.vcs.svn.SVNExecutorService;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.client.SVNClientRegistry;
import oracle.jdevimpl.vcs.svn.history.SVNHistoryEntryProducer;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoriesObservable;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryExplorer;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.SVNOperationCommit;
import oracle.jdevimpl.vcs.svn.prefs.SVNClientsPreferences;
import oracle.jdevimpl.vcs.svn.prefs.SVNEnvironmentPrefs;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.res.Resource;

final class SVNAddin
extends VCSAddin {
    SVNAddin() {
    }

    protected void initializeImpl() {
        final VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
        this.bindSystemDir(profile);
        ExplorerManager.getExplorerManager().register(SVNRepositoryInfo.class, SVNRepositoryExplorer.class, null, Resource.get("NAV_REPOS_EXPLORER_CAPTION"), null);
        SVNHistoryEntryProducer.CLIENT_CONTEXT = SVNProfile.IDE_CLIENT_CONTEXT_ID;
        AbstractSVNOperation.CLIENT_CONTEXT = SVNProfile.IDE_CLIENT_CONTEXT_ID;
        SVNRepositoryNavigatorAPI.CLIENT_CONTEXT = SVNProfile.IDE_CLIENT_CONTEXT_ID;
        SVNClientSelector clientSelector = new SVNClientSelector();
        SVNClientsPreferences prefs = SVNClientsPreferences.getInstance((PropertyStorage)Preferences.getPreferences());
        prefs.addStructureChangeListener(clientSelector);
        if (SVNClientRegistry.getInstance().getContextClient(SVNProfile.IDE_CLIENT_CONTEXT_ID) == null) {
            prefs.removeStructureChangeListener(clientSelector);
            LogPrintWriter logWriter = new LogPrintWriter(LogManager.getLogManager().getMsgPage());
            logWriter.println(Resource.get("ERROR_NO_AVAILABLE_SUBVERSION_CLIENT"));
            return;
        }
        SVNEnvironmentPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent sce) {
                if (!VCSConfigUtils.isSignificantStructureChange((StructureChangeEvent)sce)) {
                    return;
                }
                VCSOverlayItemProducer overlayItemProducer = profile.getOverlayItemProducer();
                if (overlayItemProducer != null) {
                    overlayItemProducer.preferencesChanged();
                }
                if (profile.getOverlayTracker() != null) {
                    profile.getOverlayTracker().validateOverlays();
                    profile.getOverlayTracker().repaintOverlays();
                }
            }
        });
        SVNExecutorService.getInstance().activate();
        CommentTemplatesConfiguration templatesConfiguration = new CommentTemplatesConfiguration();
        templatesConfiguration.setRecentCommentsModel(SVNOperationCommit.getRecentCommentsModel());
        templatesConfiguration.setTemplatesSettingsPathParams(Resource.get("SVN_SHORT_NAME"), new String[]{VCSCommentsCustomizer.COMMENT_TEMPLATES_NAVIGABLE_LABEL});
        CommentTemplatesConfiguration.register((String)"oracle.jdeveloper.subversion", (CommentTemplatesConfiguration)templatesConfiguration);
        SVNRepositoriesObservable.getObservable().addObserver(new SVNRepoObserver(profile));
    }

    private void bindSystemDir(VCSProfile profile) {
        try {
            String systemDir = URLFileSystem.getPlatformPathName((URL)profile.getSystemDirectory());
            Names.bind((Context)new InitialContext(), (String)SVNRepositoryManager.STORE_URL_BINDING_NAME, (Object)systemDir);
        }
        catch (NamingException ne) {
            profile.getLogger().log(Level.WARNING, "problem with jndi environment", ne);
        }
        catch (IllegalStateException ise) {
            profile.getLogger().log(Level.WARNING, ise.getMessage(), ise.getCause());
        }
    }

    public static class SVNRepoObserver
    implements Observer {
        private VCSProfile _profile;

        SVNRepoObserver(VCSProfile profile) {
            this._profile = profile;
        }

        @Override
        public final void update(Observable o, Object arg) {
            VCSControlCache.getInstance().fireControlStateChanged(this._profile.getID());
            this._profile.getPolicyStatusCache().clear();
        }
    }
}

