/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.token;

import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.TokenPattern;

abstract class TokenClause {
    private String m_knownAs;

    TokenClause() {
    }

    abstract ClauseResult matches(TokenPattern.PatternResult var1, Token var2);

    abstract void addChildClause(TokenClause var1);

    final void setKnownAs(String name) {
        this.m_knownAs = name;
    }

    final String getKnownAs() {
        return this.m_knownAs;
    }

    protected void setLastOKToken(TokenPattern.PatternResult matchResult, Token lastOKToken) {
        matchResult.setLastOKToken(lastOKToken);
    }

    protected void recordResult(TokenPattern.PatternResult matchResult, ClauseResult clauseResult) {
        String name = this.getKnownAs();
        if (name != null && clauseResult.isMatch() && matchResult.isWithinRange(clauseResult.getStartToken()) && matchResult.isWithinRange(clauseResult.getEndToken())) {
            matchResult.recordResult(name, clauseResult);
        }
    }

    protected boolean isWithinRange(TokenPattern.PatternResult matchResult, Token token) {
        return matchResult.isWithinRange(token);
    }

    protected static class ClauseResult {
        private boolean m_match;
        private Token m_startToken;
        private Token m_endToken;

        protected ClauseResult() {
        }

        public void setMatch(boolean match) {
            this.m_match = match;
        }

        public boolean isMatch() {
            return this.m_match;
        }

        public void setStartToken(Token startToken) {
            this.m_startToken = startToken;
        }

        public Token getStartToken() {
            return this.m_startToken;
        }

        public void setEndToken(Token endToken) {
            this.m_endToken = endToken;
        }

        public Token getEndToken() {
            return this.m_endToken;
        }
    }
}

