/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.token;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.util.ModelUtil;

public class Token<T extends Token> {
    private Type m_type;
    private int m_start;
    private int m_end;
    private Token m_startToken;
    private Token m_nextToken;
    private Token m_prevToken;
    private String m_source;
    private List<Token> m_index;
    private static final int INDEX_WIDTH = 1000;

    protected Token(Type type, int start, Token prev) {
        if (prev != null) {
            int idx;
            this.m_startToken = prev.m_startToken;
            if (type != Type.END_MARKER && (idx = start / 1000) >= this.m_startToken.m_index.size()) {
                this.m_startToken.m_index.add(this);
            }
        } else {
            this.m_startToken = this;
            this.m_index = new ArrayList<Token>();
        }
        this.m_type = type;
        this.m_start = start;
        this.m_end = -1;
        if (prev == null) {
            this.m_prevToken = null;
            this.m_nextToken = null;
        } else {
            this.m_nextToken = prev.getNextToken();
            this.m_prevToken = prev;
            if (this.m_nextToken != null) {
                this.m_nextToken.setPrevToken(this);
            }
            this.m_prevToken.setNextToken(this);
        }
    }

    protected void setHeaderSourceImpl(String source) {
        if (this.m_prevToken != null) {
            throw new IllegalStateException("Can only set source on start token");
        }
        this.m_source = source;
    }

    public Type getType() {
        return this.m_type;
    }

    protected final void setType(Type type) {
        this.m_type = type;
    }

    public int getStart() {
        return this.m_start;
    }

    public int getEnd() {
        return this.m_end;
    }

    public void setEnd(int end) {
        this.m_end = end;
    }

    public T getNextToken() {
        return (T)this.m_nextToken;
    }

    public void setNextToken(Token nextToken) {
        this.m_nextToken = nextToken;
    }

    public T getPrevToken() {
        return (T)this.m_prevToken;
    }

    public void setPrevToken(Token prevToken) {
        this.m_prevToken = prevToken;
    }

    public boolean isCode() {
        return this.isCode(false);
    }

    public boolean isWord() {
        return this.isCode(true);
    }

    public boolean isPunctuation() {
        return this.m_type == Type.PUNCTUATION;
    }

    public boolean isWhiteSpace() {
        return this.m_type == Type.WHITESPACE;
    }

    public boolean isComment() {
        return this.m_type == Type.SINGLE_LINE_COMMENT || this.m_type == Type.MULTI_LINE_COMMENT;
    }

    public boolean isEndMarker() {
        return this.m_type == Type.END_MARKER;
    }

    public boolean isCode(boolean ignorePuncAndLiterals) {
        if (ignorePuncAndLiterals) {
            if (this.m_type == Type.SINGLE_QUOTED_STRING || this.m_type == Type.PUNCTUATION || this.m_type == Type.USER_TOKEN) {
                return false;
            }
            if (this.m_type == Type.DOUBLE_QUOTED_STRING) {
                return true;
            }
            if (this.m_type == Type.ALPHANUMERIC) {
                return !this.isNumber();
            }
            return false;
        }
        return this.m_type == Type.SINGLE_QUOTED_STRING || this.m_type == Type.DOUBLE_QUOTED_STRING || this.m_type == Type.ALPHANUMERIC || this.m_type == Type.PUNCTUATION || this.m_type == Type.USER_TOKEN;
    }

    public boolean isNumber() {
        char c = this.getFullSource().charAt(this.m_start);
        return c >= '0' && c <= '9';
    }

    public T getPrevCodeToken() {
        T tk;
        for (tk = this.getPrevToken(); tk != null && ((Token)tk).getType() != Type.END_MARKER && !((Token)tk).isCode(); tk = ((Token)tk).getPrevToken()) {
        }
        return tk;
    }

    public T getNextCodeToken() {
        return this.getNextCodeToken(1);
    }

    public T getNextCodeToken(int numAhead) {
        T tk;
        int counter = 0;
        for (tk = this.getNextToken(); tk != null && ((Token)tk).getType() != Type.END_MARKER; tk = ((Token)tk).getNextToken()) {
            if (((Token)tk).isCode()) {
                ++counter;
            }
            if (counter >= numAhead) break;
        }
        return tk;
    }

    public String getSource() {
        return this.getSource(false, null);
    }

    public String getSource(boolean format) {
        return this.getSource(format, null);
    }

    public String getSource(boolean format, Token toToken) {
        String fullSource;
        if (format) {
            if (toToken == null || toToken == this) {
                return this.formattedSource();
            }
            StringBuffer sb = new StringBuffer(this.formattedSource());
            T tk = this.getNextCodeToken();
            while (((Token)tk).getType() != Type.END_MARKER) {
                if (((Token)tk).getType() != Type.PUNCTUATION && (((Token)((Token)tk).getPrevCodeToken()).getType() != Type.PUNCTUATION || ((Token)((Token)tk).getPrevCodeToken()).matches(")"))) {
                    sb.append(" ");
                }
                sb.append(super.formattedSource());
                if (tk == toToken) break;
                tk = ((Token)tk).getNextCodeToken();
            }
            return sb.toString();
        }
        int start = this.getStart();
        int end = toToken == null ? this.getEnd() : toToken.getEnd();
        if (end > (fullSource = this.getFullSource()).length() - 1) {
            end = fullSource.length() - 1;
        }
        if (end < start || start < 0) {
            return "";
        }
        return fullSource.substring(start, end + 1);
    }

    protected String getFullSource() {
        return this.m_startToken.m_source;
    }

    private String formattedSource() {
        if (this.getType() == Type.END_MARKER) {
            return "";
        }
        if (this.getType() == Type.ALPHANUMERIC) {
            return this.getSource().toUpperCase();
        }
        return this.getSource();
    }

    public boolean matches(String str) {
        String content = this.getSource();
        return content.equals(str) || ModelUtil.hasLength((String)content) && content.charAt(0) != '\"' && content.equalsIgnoreCase(str);
    }

    @Deprecated
    public boolean firstCodeTokenOnLine() {
        T tk = this.getPrevToken();
        while (((Token)tk).getType() != Type.END_MARKER) {
            if (((Token)tk).getType() == Type.WHITESPACE && ((Token)tk).getSource().contains("\n")) {
                return true;
            }
            if (((Token)tk).isCode()) {
                return false;
            }
            tk = ((Token)tk).getPrevToken();
        }
        return true;
    }

    public T getTokenAt(int pos) {
        Token ret = null;
        if (this.m_startToken != null) {
            int idx = pos / 1000;
            Token<T> start = this.m_startToken;
            if (start != null && start.m_index != null && start.m_index.size() > idx) {
                start = start.m_index.get(idx);
                start = start.getPrevToken();
            }
            while (start.getEnd() < pos && (start = start.getNextToken()).getType() != Type.END_MARKER) {
            }
            ret = start;
        }
        if (ret != null && ret.isEndMarker()) {
            ret = null;
        }
        return (T)ret;
    }

    public static enum Type {
        WHITESPACE,
        SINGLE_LINE_COMMENT,
        MULTI_LINE_COMMENT,
        SINGLE_QUOTED_STRING,
        DOUBLE_QUOTED_STRING,
        ALPHANUMERIC,
        USER_TOKEN,
        PUNCTUATION,
        END_MARKER,
        UNKNOWN;

    }
}

