/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UpdateUtil {
    private UpdateUtil() {
    }

    public static String readExtensionXML(ZipInputStream zis) throws IOException {
        if (zis != null) {
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (ze.getName().toLowerCase().equals("meta-inf/extension.xml")) {
                    int bytesRead;
                    byte[] buff = new byte[8192];
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    while ((bytesRead = zis.read(buff)) != -1) {
                        outputStream.write(buff, 0, bytesRead);
                    }
                    return outputStream.toString();
                }
                ze = zis.getNextEntry();
            }
        }
        return null;
    }

    public static LinkedHashMap<String, List<String>> readProperties(File updateFile) throws IOException {
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(updateFile));
        return UpdateUtil.readProperties(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap<String, List<String>> readProperties(BufferedReader reader) throws IOException {
        LinkedHashMap<String, List<String>> properties = new LinkedHashMap<String, List<String>>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                int index = line.indexOf(61);
                if (index <= 0) continue;
                String propertyName = line.substring(0, index);
                List<String> details = properties.get(propertyName);
                if (details == null) {
                    details = new ArrayList<String>();
                    properties.put(propertyName, details);
                }
                details.add(line.substring(index + 1));
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return properties;
    }

    public static InputStream openConnectionCheckRedirects(URLConnection c) throws IOException {
        boolean redir;
        int redirects = 0;
        InputStream in = null;
        do {
            HttpURLConnection http;
            int stat;
            if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).setInstanceFollowRedirects(false);
            }
            in = c.getInputStream();
            redir = false;
            if (!(c instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)c).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || !target.getProtocol().equals("http") && !target.getProtocol().equals("https") || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            c = target.openConnection();
            ++redirects;
        } while (redir);
        return in;
    }
}

