/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.Version;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Timer;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.ideimpl.webupdate.CheckForUpdatesPreferences;
import oracle.ideimpl.webupdate.CheckMasterListRunnable;
import oracle.ideimpl.webupdate.CheckUpdatesRunnable;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateHook;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateLrb;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.WebUpdateAddin;
import oracle.javatools.data.HashStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.infotip.InfoTip;
import oracle.javatools.ui.infotip.templates.BalloonTemplate;
import oracle.javatools.ui.infotip.templates.Template;

public final class AutomaticCheckForUpdates {
    public static final String CONTEXT_KEY_MASTER_LIST = "autoCfuMasterList";
    private static final int HIDE_ACTION_ID = Ide.findOrCreateCmdID((String)"AutoUpdateHide");
    private static final int PREFS_ACTION_ID = Ide.findOrCreateCmdID((String)"AutoUpdatePrefs");
    private Collection _masterList = null;
    private boolean balloonInvoked = false;
    private JComponent _notificationIcon = null;
    private JCheckBox _skipCheckbox = null;
    private Controller _controller = null;
    private ContextMenu _contextMenu = null;
    private MouseListener _mouseListener = null;

    AutomaticCheckForUpdates() {
    }

    public void check() {
        if (Boolean.valueOf(System.getProperty("ide.cfu.autoskip")).booleanValue()) {
            return;
        }
        if (Ide.getIdeArgs().hasArg("-nonag")) {
            return;
        }
        if (Boolean.valueOf(System.getProperty("ide.cfu.autoforce")).booleanValue()) {
            this.delayInstallOfBalloonUntilWindowReady(false);
        }
        Runnable cfuRunnable = new Runnable(){

            @Override
            public void run() {
                if (WebUpdateAddin.getPreferences().getCheckOnStartup()) {
                    AutomaticCheckForUpdates.this.checkMasterList();
                }
            }
        };
        Thread t = new Thread(cfuRunnable, "Automatic check for updates");
        t.setPriority(1);
        t.start();
    }

    private void checkMasterList() {
        CheckMasterListRunnable masterListCheck = new CheckMasterListRunnable(UpdateManager.getInstance().getMasterServerURL(), true){

            @Override
            protected void failed(Throwable exception) {
                CheckForUpdatesPreferences prefs = WebUpdateAddin.getPreferences();
                prefs.setLastErrorType("generic");
                prefs.setLastError(exception.getMessage());
            }

            protected void finished(List masterList) {
                ArrayList<UpdateCenter> centers = new ArrayList<UpdateCenter>(masterList);
                UpdateHook updateHook = (UpdateHook)ExtensionRegistry.getExtensionRegistry().getHook(UpdateHook.ELEMENT);
                centers.addAll(updateHook.getUpdateCenters());
                for (UpdateCenter c : centers) {
                    c.setEnabled(c.isSelectedByDefault());
                }
                AutomaticCheckForUpdates.this.checkForUpdates(masterList);
            }
        };
        masterListCheck.setAutomaticUpdateMode(true);
        masterListCheck.run();
    }

    private void checkForUpdates(List masterList) {
        this._masterList = masterList;
        CheckUpdatesRunnable r = new CheckUpdatesRunnable(masterList){

            @Override
            protected void updateCenterError(UpdateCenter center, Throwable exception) {
                CheckForUpdatesPreferences prefs = WebUpdateAddin.getPreferences();
                prefs.setLastErrorType("generic");
                prefs.setLastError(exception.getMessage());
            }

            protected void finished(Collection updates) {
                CheckForUpdatesPreferences prefs = WebUpdateAddin.getPreferences();
                prefs.setLastErrorType("none");
                boolean foundNewUpdates = false;
                HashStructure oldUpdates = prefs.getPreviousUpdates();
                if (oldUpdates == null) {
                    oldUpdates = HashStructure.newInstance();
                }
                HashStructure newUpdates = HashStructure.newInstance();
                for (UpdateInfo update : updates) {
                    String id = update.getID();
                    String oldVersionString = oldUpdates.getString(id);
                    newUpdates.putString(id, update.getVersion().toCanonicalString());
                    if (oldVersionString == null) {
                        foundNewUpdates = true;
                        continue;
                    }
                    Version oldVersion = new Version(oldVersionString);
                    if (update.getVersion().compareTo(oldVersion) <= 0) continue;
                    foundNewUpdates = true;
                }
                boolean havePatches = false;
                for (UpdateInfo update : updates) {
                    if (update.getType() != UpdateInfo.Type.PATCH) continue;
                    havePatches = true;
                    break;
                }
                if (havePatches || foundNewUpdates) {
                    AutomaticCheckForUpdates.this.delayInstallOfBalloonUntilWindowReady(havePatches);
                } else {
                    AutomaticCheckForUpdates.this._masterList = null;
                    UpdateManager.getInstance().clearAutomaticCheckForUpdates();
                }
                prefs.setPreviousUpdates(newUpdates);
            }

            @Override
            protected void stopped() {
            }
        };
        r.setAutomaticUpdatesMode(true);
        r.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayInstallOfBalloonUntilWindowReady(final boolean havePatches) {
        if (this.canInstallBalloon()) {
            AutomaticCheckForUpdates automaticCheckForUpdates = this;
            synchronized (automaticCheckForUpdates) {
                if (this.balloonInvoked) {
                    return;
                }
                this.balloonInvoked = true;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AutomaticCheckForUpdates.this.installBalloon(havePatches);
                }
            });
        } else {
            int delay = 1000;
            ActionListener taskPerformer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AutomaticCheckForUpdates.this.delayInstallOfBalloonUntilWindowReady(havePatches);
                }
            };
            Timer timer = new Timer(delay, taskPerformer);
            timer.setRepeats(false);
            timer.start();
        }
    }

    private boolean canInstallBalloon() {
        Toolbar toolbar = Ide.getStatusBar().getToolbar();
        return toolbar != null && toolbar.isShowing();
    }

    private String _getBundleString(String s) {
        return UpdateLrb.getBundle().getString(s);
    }

    private void installBalloon(boolean havePatches) {
        final BalloonTemplate b = new BalloonTemplate();
        JLabel header = new JLabel();
        header.setFont(header.getFont().deriveFont(1));
        header.setIcon(havePatches ? UpdateArb.getIcon(196) : OracleIcons.getIcon((String)"update2.png"));
        header.setText(havePatches ? this._getBundleString("SERVICE_UPDATES_AVAILABLE") : this._getBundleString("UPDATES_AVAILABLE"));
        MultiLineLabel mll = new MultiLineLabel();
        mll.setTextWrapper(WordWrapper.getTextWrapper());
        mll.setPreferredColumns(40);
        mll.setText(havePatches ? this._getBundleString("CRITICAL_UPDATE") : this._getBundleString("REGULAR_UPDATE"));
        b.setTitle((JComponent)header);
        b.setContent((JComponent)mll);
        final JCheckBox cbSkipNextTime = new JCheckBox(this._getBundleString("SKIP_CHECK"));
        cbSkipNextTime.setOpaque(false);
        b.setFooter((JComponent)cbSkipNextTime);
        this._skipCheckbox = cbSkipNextTime;
        final ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if ("actionClick".equals(ae.getActionCommand())) {
                    IdeAction cfuAction = IdeAction.find((int)WebUpdateAddin.CFU_ACTION_ID);
                    Context context = Context.newIdeContext();
                    context.setProperty(AutomaticCheckForUpdates.CONTEXT_KEY_MASTER_LIST, (Object)AutomaticCheckForUpdates.this._masterList);
                    try {
                        cfuAction.performAction(context);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        b.addActionListener(al);
        final InfoTip infoTip = new InfoTip((Template)b);
        this.installNotificationIcon();
        infoTip.setDisplayTime(25000);
        infoTip.show(this._notificationIcon);
        infoTip.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if ("visible".equals(pce.getPropertyName()) && pce.getNewValue() == Boolean.FALSE) {
                    infoTip.removePropertyChangeListener((PropertyChangeListener)this);
                    b.removeActionListener(al);
                    WebUpdateAddin.getPreferences().setCheckOnStartup(!cbSkipNextTime.isSelected());
                    if (cbSkipNextTime.isSelected()) {
                        AutomaticCheckForUpdates.this.uninstallNotificationIcon();
                    }
                    AutomaticCheckForUpdates.this._skipCheckbox = null;
                }
            }
        });
    }

    private void installNotificationIcon() {
        if (this._notificationIcon == null) {
            JLabel icon = new JLabel();
            icon.setIcon(OracleIcons.getIcon((String)"update2.png"));
            Ide.getStatusBar().getToolbar().add((Component)icon, 0);
            Ide.getStatusBar().getToolbar().revalidate();
            this._mouseListener = new MouseAdapter(){

                private Context createContext(MouseEvent me) {
                    Context context = Context.newIdeContext((View)Ide.getMainWindow().getIdeMainWindowView(), (EventObject)me);
                    context.setProperty(AutomaticCheckForUpdates.CONTEXT_KEY_MASTER_LIST, (Object)AutomaticCheckForUpdates.this._masterList);
                    return context;
                }

                private ContextMenu createContextMenu() {
                    ContextMenu contextMenu = AutomaticCheckForUpdates.this.getOrCreateContextMenu();
                    ContextMenuListener cml = new ContextMenuListener(){

                        public void menuWillShow(ContextMenu contextMenu) {
                            float section = 0.0f;
                            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)WebUpdateAddin.CFU_ACTION_ID)), section);
                            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)HIDE_ACTION_ID)), section += 0.1f);
                            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)PREFS_ACTION_ID)), section);
                        }

                        public void menuWillHide(ContextMenu contextMenu) {
                            contextMenu.removeContextMenuListener((ContextMenuListener)this);
                        }

                        public boolean handleDefaultAction(Context context) {
                            try {
                                IdeAction.find((int)WebUpdateAddin.CFU_ACTION_ID).performAction(context);
                                return true;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                return false;
                            }
                        }
                    };
                    contextMenu.addContextMenuListener(cml);
                    return contextMenu;
                }

                private void showContextMenu(MouseEvent me) {
                    this.createContextMenu().show(this.createContext(me));
                }

                @Override
                public void mousePressed(MouseEvent me) {
                    if (me.isPopupTrigger()) {
                        this.showContextMenu(me);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent me) {
                    if (me.isPopupTrigger()) {
                        this.showContextMenu(me);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (me.getClickCount() == 2) {
                        this.createContextMenu().fireDefaultAction(this.createContext(me));
                    }
                }
            };
            icon.addMouseListener(this._mouseListener);
            this._notificationIcon = icon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallNotificationIcon() {
        JComponent icon = null;
        AutomaticCheckForUpdates automaticCheckForUpdates = this;
        synchronized (automaticCheckForUpdates) {
            if (this._notificationIcon == null) {
                return;
            }
            icon = this._notificationIcon;
            this._notificationIcon = null;
        }
        Ide.getStatusBar().getToolbar().remove((Component)icon);
        Ide.getStatusBar().getToolbar().invalidate();
        icon.removeMouseListener(this._mouseListener);
        UpdateManager.getInstance().clearAutomaticCheckForUpdates();
        this.unregisterActions();
        this._contextMenu = null;
    }

    public void updateSkipCheckbox() {
        if (this._skipCheckbox != null) {
            boolean autoCheck = WebUpdateAddin.getPreferences().getCheckOnStartup();
            this._skipCheckbox.setSelected(!autoCheck);
        }
    }

    private ContextMenu getOrCreateContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            this.registerActions();
        }
        return this._contextMenu;
    }

    private void registerActions() {
        this._controller = new MyController();
        IdeAction hide = IdeAction.find((int)HIDE_ACTION_ID);
        if (hide == null) {
            hide = IdeAction.get((int)HIDE_ACTION_ID, null, (String)this._getBundleString("HIDE"));
        }
        hide.addController(this._controller);
        IdeAction prefs = IdeAction.find((int)PREFS_ACTION_ID);
        if (prefs == null) {
            prefs = IdeAction.get((int)PREFS_ACTION_ID, null, (String)this._getBundleString("PREFERENCES"));
        }
        prefs.addController(this._controller);
    }

    private void unregisterActions() {
        IdeAction prefs;
        IdeAction hide = IdeAction.find((int)HIDE_ACTION_ID);
        if (hide != null) {
            hide.removeController(this._controller);
        }
        if ((prefs = IdeAction.find((int)PREFS_ACTION_ID)) != null) {
            prefs.removeController(this._controller);
        }
        this._controller = null;
    }

    private final class MyController
    implements Controller {
        private MyController() {
        }

        public boolean handleEvent(IdeAction action, Context context) {
            if (action.getCommandId() == HIDE_ACTION_ID) {
                AutomaticCheckForUpdates.this.uninstallNotificationIcon();
                return true;
            }
            if (action.getCommandId() == PREFS_ACTION_ID) {
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), new String[]{"Extensions"});
                return true;
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            return action.getCommandId() == HIDE_ACTION_ID || action.getCommandId() == PREFS_ACTION_ID;
        }
    }
}

