/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.mongodb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.thirdparty.mongodb.Messages;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class MongoBasicPanel
extends JPanel
implements CDComponentView {
    public static final String KEY_ZERODATE_BEHAVIOUR = "zeroDateTimeBehavior";
    public static final String ZERODATE_BEHAVIOUR_NULL = "convertToNull";
    public static final String PARAM_DATABASE = "DATABASE";
    public static final String PARAM_PORT = "PORT";
    public static final String PREFIX = "jdbc:mongodb://";
    private Map<String, Object> parameterDefaults = new TreeMap<String, Object>(){
        {
            this.put(MongoBasicPanel.PARAM_DATABASE, "");
            this.put(MongoBasicPanel.PARAM_PORT, 27017);
        }
    };
    private Map<String, JComponent> parameterEditors = new TreeMap<String, JComponent>(){
        {
            JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(27017, 1, Integer.MAX_VALUE, 1));
            jSpinner.setEditor(new JSpinner.NumberEditor(jSpinner, "#0"));
            this.put(MongoBasicPanel.PARAM_PORT, jSpinner);
            this.put(MongoBasicPanel.PARAM_DATABASE, new JTextField());
        }
    };
    private List<String> usedParameters = new Vector<String>(){
        {
            this.add(MongoBasicPanel.PARAM_DATABASE);
        }
    };
    private Set<String> availableParameters = new TreeSet<String>(){
        {
            this.add(MongoBasicPanel.PARAM_PORT);
        }
    };
    private JLabel hostNameLabel = new JLabel();
    private JTextField hostNameTextField = new JTextField();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel connectionParametersPanel = new JPanel();
    private JPanel jPanel1 = new JPanel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JLabel connectionParametersLabel = new JLabel();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JPanel fillerPanel = new JPanel();

    public MongoBasicPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        ResourceUtils.resLabel((JLabel)this.hostNameLabel, (Component)this.hostNameTextField, (String)Messages.getString("MongoBasicPanel.hostNameLabel"));
        ResourceUtils.resLabel((JLabel)this.connectionParametersLabel, (Component)this.connectionParametersPanel, (String)Messages.getString("MongoBasicPanel.connectionParametersLabel"));
        this.connectionParametersPanel.setLayout(this.gridBagLayout3);
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.add((Component)this.hostNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.hostNameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.connectionParametersPanel.add((Component)this.fillerPanel, new GridBagConstraints(0, 200, 2, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.connectionParametersPanel, null);
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.jPanel1, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.connectionParametersLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
    }

    private String getValue(JComponent jComponent) {
        if (jComponent instanceof JComboBox) {
            return ((JComboBox)jComponent).getSelectedItem().toString().trim();
        }
        if (jComponent instanceof JTextField) {
            return ((JTextField)jComponent).getText().trim();
        }
        if (jComponent instanceof JSpinner) {
            return ((JSpinner)jComponent).getValue().toString().trim();
        }
        return null;
    }

    private void setValue(JComponent jComponent, String string) {
        if (jComponent == null || string == null) {
            return;
        }
        if (jComponent instanceof JComboBox) {
            ((JComboBox)jComponent).setSelectedItem(string);
        }
        if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).setText(string);
        }
        if (jComponent instanceof JSpinner) {
            ((JSpinner)jComponent).setValue(Integer.valueOf(string));
        }
    }

    private void refreshPanel() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MongoBasicPanel.this.connectionParametersPanel.removeAll();
                for (int i = 0; i < MongoBasicPanel.this.usedParameters.size(); ++i) {
                    String string = (String)MongoBasicPanel.this.usedParameters.get(i);
                    JComponent jComponent = (JComponent)MongoBasicPanel.this.parameterEditors.get(string);
                    JLabel jLabel = new JLabel(string);
                    int n = 0;
                    if (jComponent instanceof JTextField) {
                        n = 2;
                    }
                    MongoBasicPanel.this.connectionParametersPanel.add((Component)jLabel, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
                    MongoBasicPanel.this.connectionParametersPanel.add((Component)jComponent, new GridBagConstraints(1, i, 1, 1, 1.0, 0.0, 17, n, new Insets(4, 4, 4, 4), 0, 0));
                }
                MongoBasicPanel.this.connectionParametersPanel.add((Component)MongoBasicPanel.this.fillerPanel, new GridBagConstraints(0, MongoBasicPanel.this.usedParameters.size(), 2, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                MongoBasicPanel.this.connectionParametersPanel.validate();
                MongoBasicPanel.this.jScrollPane1.validate();
                MongoBasicPanel.this.connectionParametersPanel.repaint();
            }
        };
        try {
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addParameter(String string, Object object) {
        if (this.parameterEditors.get(string) == null) {
            return;
        }
        this.setValue(this.parameterEditors.get(string), object == null ? null : object.toString());
        if (this.usedParameters.contains(string) || !this.availableParameters.contains(string)) {
            return;
        }
        this.availableParameters.remove(string);
        this.usedParameters.add(string);
        this.refreshPanel();
    }

    private void deleteParameter(String string) {
        if (!this.usedParameters.contains(string) || this.availableParameters.contains(string)) {
            return;
        }
        this.availableParameters.add(string);
        this.usedParameters.remove(string);
        this.refreshPanel();
    }

    public void generateProperties(Properties properties) {
        String string;
        String string2;
        properties.setProperty("hostname", this.hostNameTextField.getText().trim());
        for (int i = 0; i < this.usedParameters.size(); ++i) {
            string2 = this.usedParameters.get(i);
            string = this.getValue(this.parameterEditors.get(string2));
            if (string == null || string.length() == 0) continue;
            properties.setProperty(string2, string);
        }
        String string3 = PREFIX + this.hostNameTextField.getText().trim();
        if (this.usedParameters.size() > 0) {
            string2 = null;
            string = null;
            for (int i = 0; i < this.usedParameters.size(); ++i) {
                String string4 = this.usedParameters.get(i);
                String string5 = this.getValue(this.parameterEditors.get(string4));
                if (string5.length() == 0) continue;
                if (string5.contains(",")) {
                    string5 = "'" + string5 + "'";
                }
                if (string4.equals(PARAM_DATABASE)) {
                    string2 = string5;
                }
                if (!string4.equals(PARAM_PORT)) continue;
                string = string5;
            }
            if (string != null) {
                string3 = string3 + ":" + string;
            }
            if (string2 != null) {
                string3 = string3 + "/" + string2;
            }
        }
        properties.setProperty("customUrl", string3);
    }

    public void clear() {
        this.hostNameTextField.setText("");
        this.availableParameters.addAll(this.usedParameters);
        this.usedParameters.clear();
        this.refreshPanel();
    }

    public void setDefaultPrompts() {
        this.clear();
        this.addParameter(PARAM_DATABASE, this.parameterDefaults.get(PARAM_DATABASE));
        this.addParameter(PARAM_PORT, this.parameterDefaults.get(PARAM_PORT));
    }

    public void updatePrompts(Properties properties) {
        this.clear();
        if (properties.containsKey("hostname")) {
            this.hostNameTextField.setText(properties.getProperty("hostname"));
        }
        if (properties.containsKey("port")) {
            this.addParameter(PARAM_DATABASE, this.parameterDefaults.get(PARAM_DATABASE));
            this.addParameter(PARAM_PORT, properties.getProperty("port"));
        }
        for (String string : properties.stringPropertyNames()) {
            if (this.availableParameters.contains(string)) {
                this.addParameter(string, properties.getProperty(string));
                continue;
            }
            if (!this.usedParameters.contains(string)) continue;
            this.addParameter(string, properties.getProperty(string));
        }
    }

    private void addButton_actionPerformed(ActionEvent actionEvent) {
        actionEvent.getSource();
        AddDeletePanel addDeletePanel = new AddDeletePanel(Messages.getString("MongoBasicPanel.addParametersMessage"), this.availableParameters.toArray(new String[this.availableParameters.size()]));
        boolean bl = MessageDialog.confirm((Component)this, (Object)addDeletePanel, (String)Messages.getString("MongoBasicPanel.addParametersTitle"), (String)"f1_adddeletemongoparam_html", (boolean)false, (String)Messages.getString("MongoBasicPanel.OK"), (String)Messages.getString("MongoBasicPanel.Cancel"));
        if (bl) {
            String[] stringArray;
            for (String string : stringArray = addDeletePanel.getSelection()) {
                this.addParameter(string, null);
            }
        }
    }

    private void deleteButton_actionPerformed(ActionEvent actionEvent) {
        actionEvent.getSource();
        AddDeletePanel addDeletePanel = new AddDeletePanel(Messages.getString("MongoBasicPanel.deleteParametersMessage"), this.usedParameters.toArray(new String[this.usedParameters.size()]));
        boolean bl = MessageDialog.confirm((Component)this, (Object)addDeletePanel, (String)Messages.getString("MongoBasicPanel.deleteParametersTitle"), (String)"f1_adddeletemongoparam_html", (boolean)false, (String)Messages.getString("MongoBasicPanel.OK"), (String)Messages.getString("MongoBasicPanel.Cancel"));
        if (bl) {
            String[] stringArray;
            for (String string : stringArray = addDeletePanel.getSelection()) {
                this.deleteParameter(string);
            }
        }
    }

    private static class AddDeletePanel
    extends JPanel {
        private BorderLayout borderLayout1 = new BorderLayout();
        private JLabel messageLabel = new JLabel();
        private JScrollPane scrollPane = new JScrollPane();
        private JList propertyList = new JList();
        private String[] propertyValues;
        private String message;
        private DefaultListModel propertyModel = new DefaultListModel();

        public AddDeletePanel(String string, String[] stringArray) {
            try {
                this.propertyValues = stringArray;
                this.message = string;
                this.jbInit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void jbInit() throws Exception {
            this.setLayout(this.borderLayout1);
            this.messageLabel.setText(this.message);
            this.add((Component)this.messageLabel, "North");
            for (String string : this.propertyValues) {
                this.propertyModel.addElement(string);
            }
            this.propertyList.setModel(this.propertyModel);
            this.scrollPane.getViewport().add((Component)this.propertyList, null);
            this.add((Component)this.scrollPane, "Center");
        }

        public String[] getSelection() {
            int[] nArray = this.propertyList.getSelectedIndices();
            if (nArray == null) {
                return new String[0];
            }
            String[] stringArray = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                stringArray[i] = this.propertyValues[nArray[i]];
            }
            return stringArray;
        }
    }
}

