/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.xspi;

import java.awt.Component;
import java.net.URL;
import java.util.Collection;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.tracking.VCSBugTracking;
import oracle.jdeveloper.vcs.tracking.VCSBugTrackingContext;
import oracle.jdeveloper.vcs.tracking.VCSBugTrackingProvider;

public class VCSBugTrackingManager {
    private static final VCSBugTrackingManager _instance = new VCSBugTrackingManager();
    private VCSExceptionHandler _error;

    private VCSBugTrackingManager() {
    }

    public static final VCSBugTrackingManager getInstance() {
        return _instance;
    }

    Component getCommitUI(VCSBugTrackingContext context) {
        VCSBugTracking tracking = this.getTracking(context.getType());
        if (tracking != null) {
            return tracking.getBugComponent(context);
        }
        return null;
    }

    Component getPatchUI(VCSBugTrackingContext context) {
        VCSBugTracking tracking = this.getTracking(context.getType());
        if (tracking != null) {
            return tracking.getPatchComponent(context);
        }
        return null;
    }

    public boolean attachPatch(VCSBugTrackingContext context, URL patch) {
        VCSBugTracking tracking = this.getTracking(context.getType());
        if (tracking != null) {
            return tracking.attachPatch(context, patch);
        }
        return false;
    }

    public boolean validatePatch(VCSBugTrackingContext context) throws Exception {
        VCSBugTracking tracking = this.getTracking(context.getType());
        if (tracking != null) {
            tracking.validatePatch(context);
        }
        return true;
    }

    public boolean updateOnCommit(VCSBugTrackingContext context, Collection<URL> commitUrls, String message, String commitId, String author, long time) {
        if (commitUrls.isEmpty()) {
            return false;
        }
        VCSBugTracking tracking = this.getTracking(context.getType());
        if (tracking != null) {
            return tracking.updateOnCommit(context, commitUrls, message, commitId, author, time);
        }
        return false;
    }

    public boolean updateOnPush(Collection<String> commitIds, String type) {
        VCSBugTracking tracking = null;
        try {
            tracking = VCSBugTrackingProvider.lookup(type);
        }
        catch (VCSException e) {
            this.getErrorHandler().handleException(e);
            return false;
        }
        if (tracking != null) {
            return tracking.updateOnPush(commitIds);
        }
        return false;
    }

    public boolean removeCommits(Collection<String> revisions, String type) {
        VCSBugTracking tracking = this.getTracking(type);
        if (tracking != null) {
            return tracking.removeCommits(revisions);
        }
        return false;
    }

    private VCSExceptionHandler getErrorHandler() {
        if (this._error == null) {
            this._error = new VCSExceptionHandler();
        }
        return this._error;
    }

    private VCSBugTracking getTracking(String type) {
        try {
            return VCSBugTrackingProvider.lookup(type);
        }
        catch (Exception e) {
            this.getErrorHandler().handleException(e);
            return null;
        }
    }
}

