/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic;

import java.lang.reflect.InvocationTargetException;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.navigator.ProjectNavigatorWindow;
import oracle.javatools.util.Executors;
import oracle.jdeveloper.vcs.generic.ActionCommand;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSController;
import oracle.jdevimpl.vcs.ClassUtil;
import oracle.jdevimpl.vcs.generic.profile.ProfileInfo;
import oracle.jdevimpl.vcs.generic.profile.RefreshActionInfo;

public class GenericController
extends VCSController {
    private final VCSProfile _profile;
    private final ProfileInfo _profileInfo;
    private VCSController _delegateController;
    private boolean _noDelegate;

    public GenericController(VCSProfile profile, ProfileInfo profileInfo) {
        super(null);
        this._profile = profile;
        this._profileInfo = profileInfo;
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        VCSController delegate = this.getDelegateController();
        if (delegate != null && delegate.handleEvent(action, context)) {
            return true;
        }
        if (action.getCommandId() == 51) {
            RefreshActionInfo ri = this._profileInfo.getActions().getRefreshAction();
            if (ri != null && context.getView() instanceof ProjectNavigatorWindow) {
                if (ri.getRefreshStatuses()) {
                    java.util.concurrent.Executors.newSingleThreadExecutor(Executors.namedThreadFactory((String)"GenericController")).execute(new Runnable(){

                        @Override
                        public final void run() {
                            GenericController.this._profile.getStatusCacheBridge().clear();
                        }
                    });
                }
                return false;
            }
            return false;
        }
        return super.handleEvent(action, context);
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        VCSController delegate = this.getDelegateController();
        if (delegate != null && delegate.update(action, context)) {
            return true;
        }
        if (action.getCommandId() == 51) {
            RefreshActionInfo ri = this._profileInfo.getActions().getRefreshAction();
            if (ri != null && context.getView() instanceof ProjectNavigatorWindow) {
                action.setEnabled(true);
                return true;
            }
            return false;
        }
        return super.update(action, context);
    }

    @Override
    protected boolean isHandledAction(IdeAction action) {
        String actionId = Ide.findCmdName((int)action.getCommandId());
        if (actionId != null && actionId.endsWith(".oracle.jdeveloper.vcs.action.HISTORY")) {
            return false;
        }
        if (actionId != null && actionId.endsWith(".oracle.jdeveloper.vcs.action.VIEW_PENDING_CHANGES")) {
            return false;
        }
        VCSActionInfo actionInfo = this._profile.getActionInfo(actionId);
        return actionInfo != null;
    }

    @Override
    protected void preUpdate(IdeAction action, Command command) {
        if (command instanceof ActionCommand) {
            ((ActionCommand)command).setProfile(this._profile);
        }
    }

    @Override
    protected void preInvoke(IdeAction action, Command command) {
        if (command instanceof ActionCommand) {
            ((ActionCommand)command).setProfile(this._profile);
        }
    }

    private synchronized VCSController getDelegateController() {
        if (this._delegateController == null && !this._noDelegate) {
            try {
                Class<Controller> theClass = this._profileInfo.getActions().getControllerClass();
                if (theClass == null) {
                    this._noDelegate = true;
                    return null;
                }
                this._delegateController = (VCSController)ClassUtil.newInstance(theClass);
            }
            catch (ClassNotFoundException cnfe) {
                this._profile.getLogger().severe("Unable to load operation controller class: " + cnfe.getMessage());
            }
            catch (Exception e) {
                Throwable cause = e;
                if (e instanceof InvocationTargetException) {
                    cause = ((InvocationTargetException)e).getTargetException();
                }
                this._profile.getLogger().severe("Error instantiating operation controller class: " + cause.getMessage());
            }
        }
        return this._delegateController;
    }
}

