/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.vop;

import java.awt.EventQueue;
import java.net.URL;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.model.Displayable;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.vop.Category;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdeveloper.vcs.vop.VersionOperationCategorizer;
import oracle.jdeveloper.vcs.vop.VersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationModelEvent;
import oracle.jdeveloper.vcs.vop.VersionOperationModelListener;
import oracle.jdeveloper.vcs.vop.VersionOperationStatus;
import oracle.jdeveloper.vcs.vop.VersionOperationTreeItemNode;
import oracle.jdeveloper.vcs.vop.VersionOperationTreeNode;

class VersionOperationTreeModel
extends DefaultTreeModel
implements VersionOperationModelListener {
    private final VersionOperationModel _baseModel;
    private final DisplayProperty[] _properties;
    private DisplayProperty _statusProperty;
    private Map<DirectoryKey, VersionOperationTreeNode> _nodesByDirectoryUrl = new HashMap<DirectoryKey, VersionOperationTreeNode>();
    private Map<Integer, Collection<VersionOperationTreeNode>> _nodesByModelIndex = new HashMap<Integer, Collection<VersionOperationTreeNode>>();
    private Map<String, VersionOperationTreeNode> _nodesByCategory = new HashMap<String, VersionOperationTreeNode>();
    private VersionOperationCategorizer _categorizer;
    private Map<VCSHashURL, String> _categoryCache;
    private Comparator _siblingComparator;
    private final Observable _expansionObservable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };
    private Icon _categoryIcon = OracleIcons.getIcon((String)"group.png");

    VersionOperationTreeModel(VersionOperationModel baseModel) {
        super(new VersionOperationTreeNode());
        this._baseModel = baseModel;
        this._baseModel.addVersionOperationModelListener(this);
        this._properties = baseModel.getProperties();
        if (this._properties != null) {
            for (DisplayProperty property : this._properties) {
                if (!VCSStatus.class.isAssignableFrom(property.getType()) && !VersionOperationStatus.class.isAssignableFrom(property.getType())) continue;
                this._statusProperty = property;
                break;
            }
        }
    }

    final Observable getExpansionObservable() {
        return this._expansionObservable;
    }

    void setSiblingComparator(Comparator comparator) {
        this._siblingComparator = comparator;
    }

    @Override
    public void itemsChanged(final VersionOperationModelEvent vome) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Collection nodes = VersionOperationTreeModel.this.getNodesForIndices(vome.getStart(), vome.getEnd());
                if (nodes.contains(null)) {
                    return;
                }
                Map nodesByParent = VersionOperationTreeModel.this.mapNodesByParent(nodes);
                for (Map.Entry entry : nodesByParent.entrySet()) {
                    VersionOperationTreeModel.this.fireTreeNodesChanged(entry.getKey(), ((DefaultMutableTreeNode)entry.getKey()).getPath(), VersionOperationTreeModel.this.getIndicesInParent((Collection)entry.getValue()), ((List)entry.getValue()).toArray());
                }
            }
        });
    }

    @Override
    public void itemsInserted(VersionOperationModelEvent vome) {
        this.buildModel(vome.getStart(), vome.getEnd());
    }

    private final void buildModel(int start, int end) {
        ArrayList<VersionOperationTreeNode> nodes = new ArrayList<VersionOperationTreeNode>();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        for (int i = start; i <= end; ++i) {
            Displayable item = this._baseModel.getItem(i);
            URL uRL = VCSModelUtils.getLocatableURL(item);
            if (!this._baseModel.allowDirectories() && URLFileSystem.isDirectoryPath((URL)uRL)) continue;
            VersionOperationTreeNode node = new VersionOperationTreeItemNode(item){

                @Override
                public String getLabel() {
                    if (VersionOperationTreeModel.this._statusProperty == null) {
                        return super.getLabel();
                    }
                    int row = this.getIndexOfItem(this.getUserObject());
                    if (row < 0) {
                        return super.getLabel();
                    }
                    Object status = VersionOperationTreeModel.this._baseModel.getPropertyValue(VersionOperationTreeModel.this._statusProperty, row);
                    String overlay = null;
                    if (overlay == null && status instanceof VersionOperationStatus) {
                        overlay = ((VersionOperationStatus)status).getChangeListLabel();
                    }
                    if (overlay == null && status instanceof VCSStatus) {
                        overlay = status.toString();
                    }
                    if (overlay != null) {
                        return MessageFormat.format("{0}  ({1})", super.getLabel(), overlay);
                    }
                    return super.getLabel();
                }

                private int getIndexOfItem(Object o) {
                    for (int i = 0; i < VersionOperationTreeModel.this._baseModel.getCount(); ++i) {
                        if (VersionOperationTreeModel.this._baseModel.getItem(i) != o) continue;
                        return i;
                    }
                    return -1;
                }
            };
            nodes.add(node);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (VersionOperationTreeNode versionOperationTreeNode : nodes) {
            URL url = versionOperationTreeNode.getURL();
            if (url == null) continue;
            urls.add(url);
        }
        Map<VCSHashURL, String> categoriesByUrl = null;
        if (categoriesByUrl == null && this._categoryCache != null) {
            categoriesByUrl = this._categoryCache;
        }
        if (categoriesByUrl == null && this._categorizer != null) {
            categoriesByUrl = this._categorizer.mapURLsToCategory(urls);
        }
        for (VersionOperationTreeNode node : new ArrayList(nodes)) {
            URL url = node.getURL();
            if (url != null) {
                URL parentUrl;
                DirectoryKey directoryKey;
                VersionOperationTreeNode parentNode;
                String category = categoriesByUrl != null ? categoriesByUrl.get(new VCSHashURL(node.getURL())) : null;
                VersionOperationTreeNode categoryNode = this._nodesByCategory.get(category);
                if (categoryNode == null) {
                    categoryNode = category != null ? new VersionOperationTreeNode(new Category(category), category, this._categoryIcon) : new VersionOperationTreeNode(new Category(null), VCSArb.get("CHANGE_SET_DEFAULT_CATEGORY"), this._categoryIcon);
                    nodes.add(categoryNode);
                    this.insertNode(root, categoryNode);
                    this._nodesByCategory.put(category, categoryNode);
                }
                if ((parentNode = this._nodesByDirectoryUrl.get(directoryKey = new DirectoryKey(category, (parentUrl = URLFileSystem.getParent((URL)url)).toExternalForm()))) == null) {
                    parentNode = new VersionOperationTreeNode(parentUrl);
                    nodes.add(parentNode);
                    if (categoryNode != null) {
                        this.insertNode(categoryNode, parentNode);
                    } else {
                        this.insertNode(root, parentNode);
                    }
                    parentNode.setCategory(category);
                    this.cacheNode(parentNode);
                }
                this.insertNode(parentNode, node);
                node.setCategory(category);
                this.cacheNode(node);
                continue;
            }
            this.insertNode(root, node);
            this.cacheNode(node);
        }
        Map<DefaultMutableTreeNode, List<VersionOperationTreeNode>> map = this.mapNodesByParent(nodes);
        for (Map.Entry<DefaultMutableTreeNode, List<VersionOperationTreeNode>> entry : map.entrySet()) {
            this.fireTreeNodesInserted(entry.getKey(), entry.getKey().getPath(), this.getIndicesInParent((Collection<? extends DefaultMutableTreeNode>)entry.getValue()), entry.getValue().toArray());
        }
        this.updateIndexCache();
        this._expansionObservable.notifyObservers(new TreePath(root.getPath()));
        for (VersionOperationTreeNode node : nodes) {
            if (node.isLeaf()) continue;
            this._expansionObservable.notifyObservers(new TreePath(node.getPath()));
        }
    }

    private final void insertNode(DefaultMutableTreeNode parentNode, VersionOperationTreeNode node) {
        parentNode.insert(node, this.findInsertionIndex(parentNode, node));
    }

    private final int findInsertionIndex(DefaultMutableTreeNode parentNode, VersionOperationTreeNode node) {
        ArrayList<TreeNode> children;
        if (parentNode instanceof VersionOperationTreeNode) {
            children = ((VersionOperationTreeNode)parentNode).getChildrenDirectly();
        } else {
            children = new ArrayList<TreeNode>();
            Enumeration<TreeNode> e = parentNode.children();
            while (e.hasMoreElements()) {
                children.add(e.nextElement());
            }
        }
        int index = Collections.binarySearch(children, node, this._siblingComparator == null ? new NodeSiblingComparator() : this._siblingComparator);
        return index < 0 ? Math.abs(index + 1) : index;
    }

    private final void updateIndexCache() {
        this._nodesByModelIndex = new HashMap<Integer, Collection<VersionOperationTreeNode>>();
        List<Displayable> items = Arrays.asList(this._baseModel.getItems());
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)this.getRoot()).preorderEnumeration();
        while (e.hasMoreElements()) {
            VersionOperationTreeNode node;
            TreeNode o = e.nextElement();
            if (!(o instanceof VersionOperationTreeNode) || (node = (VersionOperationTreeNode)o).getUserObject() == null) continue;
            int index = items.indexOf(node.getUserObject());
            Collection<VersionOperationTreeNode> nodes = this._nodesByModelIndex.get(index);
            if (nodes == null) {
                nodes = new ArrayList<VersionOperationTreeNode>(1);
                this._nodesByModelIndex.put(index, nodes);
            }
            nodes.add(node);
        }
    }

    private final void updateDirectoryCache() {
        this._nodesByDirectoryUrl = new HashMap<DirectoryKey, VersionOperationTreeNode>();
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)this.getRoot()).preorderEnumeration();
        while (e.hasMoreElements()) {
            TreeNode o = e.nextElement();
            if (!(o instanceof VersionOperationTreeNode)) continue;
            this.cacheNode((VersionOperationTreeNode)o);
        }
    }

    private final void cacheNode(VersionOperationTreeNode node) {
        if (node.getURL() != null && URLFileSystem.isDirectoryPath((URL)node.getURL())) {
            this._nodesByDirectoryUrl.put(new DirectoryKey(node.getCategory(), node.getURL().toExternalForm()), node);
        }
    }

    @Override
    public void itemsRemoved(VersionOperationModelEvent vome) {
        Collection<VersionOperationTreeNode> nodes = this.getNodesForIndices(vome.getStart(), vome.getEnd());
        Map<DefaultMutableTreeNode, List<VersionOperationTreeNode>> nodesByParent = this.mapNodesByParent(nodes);
        ArrayList<DefaultMutableTreeNode> removed = new ArrayList<DefaultMutableTreeNode>();
        for (Map.Entry<DefaultMutableTreeNode, List<VersionOperationTreeNode>> entry : nodesByParent.entrySet()) {
            DefaultMutableTreeNode child;
            DefaultMutableTreeNode parent = entry.getKey();
            if (parent.getChildCount() > entry.getValue().size()) {
                int[] indices = this.getIndicesInParent((Collection<? extends DefaultMutableTreeNode>)entry.getValue());
                for (VersionOperationTreeNode node : entry.getValue()) {
                    parent.remove(node);
                    removed.add(node);
                }
                this.fireTreeNodesRemoved(parent, parent.getPath(), indices, entry.getValue().toArray());
                continue;
            }
            do {
                child = parent;
            } while (!(parent = (DefaultMutableTreeNode)parent.getParent()).isRoot() && parent.getChildCount() <= 1);
            int[] indices = this.getIndicesInParent(Collections.singleton(child));
            parent.remove(child);
            removed.add(child);
            this.fireTreeNodesRemoved(parent, parent.getPath(), indices, new Object[]{child});
        }
        this.updateIndexCache();
        this.updateDirectoryCache();
        Iterator<Map.Entry<String, VersionOperationTreeNode>> itr = this._nodesByCategory.entrySet().iterator();
        while (itr.hasNext()) {
            if (!removed.contains(itr.next().getValue())) continue;
            itr.remove();
        }
    }

    private final Iterator<DefaultMutableTreeNode> createParentIterator(DefaultMutableTreeNode node) {
        ArrayList<DefaultMutableTreeNode> parents = new ArrayList<DefaultMutableTreeNode>();
        while (true) {
            parents.add(node);
            if (node == this.getRoot()) {
                return parents.iterator();
            }
            node = (DefaultMutableTreeNode)node.getParent();
        }
    }

    @Override
    public void completenessChanged(VersionOperationModelEvent event) {
    }

    private final Collection<VersionOperationTreeNode> getNodesForIndices(int start, int end) {
        ArrayList<VersionOperationTreeNode> nodes = new ArrayList<VersionOperationTreeNode>();
        if (end < start || end < 0) {
            return nodes;
        }
        for (int i = start; i <= end; ++i) {
            if (!this._nodesByModelIndex.containsKey(i)) continue;
            nodes.addAll(this._nodesByModelIndex.get(i));
        }
        return nodes;
    }

    private final Map<DefaultMutableTreeNode, List<VersionOperationTreeNode>> mapNodesByParent(Collection<VersionOperationTreeNode> nodes) {
        DefaultMutableTreeNode parent;
        LinkedHashMap<DefaultMutableTreeNode, List<VersionOperationTreeNode>> nodesByParent = new LinkedHashMap<DefaultMutableTreeNode, List<VersionOperationTreeNode>>();
        ArrayList<VersionOperationTreeNode> nodesList = new ArrayList<VersionOperationTreeNode>(nodes);
        Collections.sort(nodesList, new Comparator<VersionOperationTreeNode>(){

            @Override
            public final int compare(VersionOperationTreeNode n1, VersionOperationTreeNode n2) {
                return new TreePath(n1.getPath()).getPathCount() - new TreePath(n2.getPath()).getPathCount();
            }
        });
        for (VersionOperationTreeNode versionOperationTreeNode : nodesList) {
            parent = (DefaultMutableTreeNode)versionOperationTreeNode.getParent();
            if (parent == null) continue;
            ArrayList<VersionOperationTreeNode> childNodes = (ArrayList<VersionOperationTreeNode>)nodesByParent.get(parent);
            if (childNodes == null) {
                childNodes = new ArrayList<VersionOperationTreeNode>();
                nodesByParent.put(parent, childNodes);
            }
            childNodes.add(versionOperationTreeNode);
        }
        for (Map.Entry entry : nodesByParent.entrySet()) {
            parent = (DefaultMutableTreeNode)entry.getKey();
            Collections.sort((List)entry.getValue(), new Comparator<VersionOperationTreeNode>(){

                @Override
                public int compare(VersionOperationTreeNode o1, VersionOperationTreeNode o2) {
                    return parent.getIndex(o1) - parent.getIndex(o2);
                }
            });
        }
        return nodesByParent;
    }

    private final int[] getIndicesInParent(Collection<? extends DefaultMutableTreeNode> nodes) {
        int[] indices = new int[nodes.size()];
        int i = 0;
        for (DefaultMutableTreeNode defaultMutableTreeNode : nodes) {
            indices[i++] = defaultMutableTreeNode.getParent().getIndex(defaultMutableTreeNode);
        }
        return indices;
    }

    final void fireCategoriesChanged() {
        this._nodesByDirectoryUrl.clear();
        this._nodesByModelIndex.clear();
        this._nodesByCategory.clear();
        ((DefaultMutableTreeNode)this.getRoot()).removeAllChildren();
        this.buildModel(0, this._baseModel.getCount() - 1);
        this.nodeStructureChanged((DefaultMutableTreeNode)this.getRoot());
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)this.getRoot()).preorderEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (node.isLeaf()) continue;
            this._expansionObservable.notifyObservers(new TreePath(node.getPath()));
        }
    }

    final void fireCategoryNodesChanged() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                for (DefaultMutableTreeNode node : VersionOperationTreeModel.this._nodesByCategory.values()) {
                    VersionOperationTreeModel.this.nodeChanged(node);
                }
            }
        });
    }

    final void setCategorizer(VersionOperationCategorizer categorizer) {
        this._categorizer = categorizer;
    }

    final void setCategoryCache(Map<VCSHashURL, String> categoryCache) {
        this._categoryCache = categoryCache;
    }

    final VersionOperationTreeNode getCategoryNode(String category) {
        return this._nodesByCategory.get(category);
    }

    final void setCategoryIcon(Icon categoryIcon) {
        this._categoryIcon = categoryIcon;
    }

    private class DirectoryKey {
        private final String _category;
        private final String _urlExternal;

        DirectoryKey(String category, String urlExternal) {
            this._category = category != null ? category : "";
            this._urlExternal = urlExternal;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof DirectoryKey)) {
                return false;
            }
            DirectoryKey otherKey = (DirectoryKey)o;
            return this._category.equals(otherKey._category) && this._urlExternal.equals(otherKey._urlExternal);
        }

        public final int hashCode() {
            return this._category.hashCode() + this._urlExternal.hashCode();
        }
    }

    private class NodeSiblingComparator
    implements Comparator<VersionOperationTreeNode> {
        private NodeSiblingComparator() {
        }

        @Override
        public final int compare(VersionOperationTreeNode o1, VersionOperationTreeNode o2) {
            if (o1.getUserObject() instanceof Category && o2.getUserObject() instanceof Category) {
                Category c1 = (Category)((Object)o1.getUserObject());
                Category c2 = (Category)((Object)o2.getUserObject());
                if (c1.getName() == null && c2.getName() == null) {
                    return 0;
                }
                if (c1.getName() == null) {
                    return 1;
                }
                if (c2.getName() == null) {
                    return -1;
                }
                return Collator.getInstance().compare(c1.getName(), c2.getName());
            }
            return Collator.getInstance().compare(o1.getLabel(), o2.getLabel());
        }
    }
}

