/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.versiontree;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.util.IdeUtil;
import oracle.ide.vhv.VHVContext;
import oracle.ide.vhv.VHVInContextResource;
import oracle.ide.vhv.VHVURLHelper;
import oracle.javatools.compare.CompareContributor;
import oracle.jdeveloper.compare.BinaryCompareContributor;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdeveloper.compare.TextNodeContributor;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdeveloper.vcs.res.Bundle;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public abstract class VersionTreeCompareCommand
extends Command {
    protected VersionTreeCompareCommand(int cmdId) {
        super(cmdId);
    }

    public int doit() throws Exception {
        if (!VHVContext.isVHVContext((Context)this.context)) {
            return -1;
        }
        RequestProcessor processor = new RequestProcessor(Bundle.get("TREE_COMPARE"), 1, true);
        RequestProcessor.Task task = processor.post(new Runnable(){
            private CompareContributor _left;
            private CompareContributor _right;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TreeCancellable cancel = new TreeCancellable();
                ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.get("TREE_COMPARE"), (Cancellable)cancel);
                try {
                    handle.start();
                    URL url = VHVURLHelper.getRealURL((URL)VersionTreeCompareCommand.this.context.getNode().getURL());
                    VHVInContextResource rightResource = VHVContext.getSelectedResource((Context)VersionTreeCompareCommand.this.context);
                    VHVInContextResource leftResource = VersionTreeCompareCommand.this.getLeftResource();
                    if (cancel.hasCancelled()) {
                        return;
                    }
                    this._right = VersionTreeCompareCommand.this.createContributor(url, rightResource);
                    if (cancel.hasCancelled()) {
                        return;
                    }
                    this._left = VersionTreeCompareCommand.this.createContributor(url, leftResource);
                    if (cancel.hasCancelled()) {
                        return;
                    }
                    CompareViewer.get().show(this._left, this._right, (Element)VHVContext.getRealNode((Context)VersionTreeCompareCommand.this.context));
                }
                catch (Exception e) {
                    VHVContext.getVHVControl((Context)VersionTreeCompareCommand.this.context).getCustomizer().getExceptionHandler().handleException(e, (Component)IdeUtil.getMainWindow());
                }
                finally {
                    handle.finish();
                }
            }
        });
        return 0;
    }

    protected abstract VHVInContextResource getLeftResource();

    protected abstract CompareContributor createContributor(URL var1, VHVInContextResource var2) throws Exception;

    protected CompareContributor createURLContributor(URL url) throws IOException {
        if (VCSFileSystemUtils.isContentTypeBinary(url)) {
            return new BinaryCompareContributor(url);
        }
        Node node = NodeFactory.find((URL)url);
        return node != null ? this.createNodeContributor((Locatable)node) : new URLContributor(url);
    }

    private CompareContributor createNodeContributor(Locatable node) throws IOException {
        if (node instanceof TextNode && ((TextNode)node).isDirty()) {
            return new TextNodeContributor((TextNode)node);
        }
        return new URLContributor(node.getURL());
    }

    private class TreeCancellable
    implements Cancellable {
        private boolean _cancelled;

        private TreeCancellable() {
        }

        public boolean cancel() {
            this._cancelled = true;
            return this._cancelled;
        }

        public boolean hasCancelled() {
            return this._cancelled;
        }
    }
}

